/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.util.SWTUtil;
import org.eclipse.jpt.ui.internal.widgets.FormPane;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.widgets.Hyperlink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetEntityComposite
extends FormPane<RelationshipMapping> {
    private JavaTypeCompletionProcessor javaTypeCompletionProcessor;
    private Combo combo;

    public TargetEntityComposite(FormPane<? extends RelationshipMapping> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    public TargetEntityComposite(PropertyValueModel<? extends RelationshipMapping> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    @Override
    protected void addPropertyNames(Collection<String> propertyNames) {
        super.addPropertyNames(propertyNames);
        propertyNames.add("defaultTargetEntity");
        propertyNames.add("specifiedTargetEntity");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.javaTypeCompletionProcessor = new JavaTypeCompletionProcessor(false, false);
    }

    @Override
    protected void initializeLayout(Composite container) {
        Composite comboPane = this.addSubPane(container);
        this.combo = this.addEditableCombo(comboPane);
        this.combo.add(JptUiMappingsMessages.DefaultEmpty);
        this.combo.addModifyListener(this.buildTargetEntityModifyListener());
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage();
        GridData data = new GridData(768);
        data.horizontalIndent = image.getBounds().width;
        this.combo.setLayoutData((Object)data);
        ControlContentAssistHelper.createComboContentAssistant((Combo)this.combo, (IContentAssistProcessor)this.javaTypeCompletionProcessor);
        SWTUtil.attachDefaultValueHandler(this.combo);
        Hyperlink labelLink = this.addHyperlink(container, JptUiMappingsMessages.TargetEntityChooser_label, this.buildOpenTargetEntityAction());
        this.addLabeledComposite(container, (Control)labelLink, (Control)comboPane, (Control)this.addTargetEntitySelectionButton(container), "org.eclipse.jpt.ui.mapping_targetEntity");
    }

    private void openEditor() {
        String targetEntity = ((RelationshipMapping)this.getSubject()).getTargetEntity();
        if (targetEntity != null) {
            try {
                IType type = ((RelationshipMapping)this.getSubject()).getJpaProject().getJavaProject().findType(targetEntity.replace('$', '.'));
                if (type != null) {
                    IJavaElement javaElement = type.getParent();
                    JavaUI.openInEditor((IJavaElement)javaElement, (boolean)true, (boolean)true);
                }
            }
            catch (JavaModelException e) {
                JptUiPlugin.log(e);
            }
            catch (PartInitException e) {
                JptUiPlugin.log(e);
            }
        }
    }

    private Runnable buildOpenTargetEntityAction() {
        return new Runnable(){

            public void run() {
                TargetEntityComposite.this.openEditor();
            }
        };
    }

    private Runnable buildOpenTypeAction() {
        return new Runnable(){

            public void run() {
                BusyIndicator.showWhile((Display)TargetEntityComposite.this.combo.getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        TargetEntityComposite.this.doOpenSelectionDialog();
                    }
                });
            }
        };
    }

    private ModifyListener buildTargetEntityModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!TargetEntityComposite.this.isPopulating()) {
                    Combo combo = (Combo)e.widget;
                    TargetEntityComposite.this.valueChanged(combo.getText());
                }
            }
        };
    }

    private Button addTargetEntitySelectionButton(Composite parent) {
        return this.addPushButton(parent, JptUiMappingsMessages.TargetEntityChooser_browse, this.buildOpenTypeAction());
    }

    private void doOpenSelectionDialog() {
        SelectionDialog dialog;
        try {
            dialog = JavaUI.createTypeDialog((Shell)this.getControl().getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)256, (boolean)false);
        }
        catch (JavaModelException e) {
            JptUiPlugin.log(e);
            return;
        }
        dialog.setTitle(JptUiMappingsMessages.TargetEntityChooser_selectTypeTitle);
        if (dialog.open() == 0) {
            IType type = (IType)dialog.getResult()[0];
            this.combo.setText(type.getFullyQualifiedName(((RelationshipMapping)this.getSubject()).getTargetEntityEnclosingTypeSeparator()));
        }
    }

    @Override
    protected void doPopulate() {
        super.doPopulate();
        this.populateCombo();
        this.updatePackageFragment();
    }

    private void updatePackageFragment() {
        IPackageFragmentRoot root;
        if (this.getSubject() != null && (root = this.getPackageFragmentRoot()) != null) {
            this.javaTypeCompletionProcessor.setPackageFragment(root.getPackageFragment(""));
            return;
        }
        this.javaTypeCompletionProcessor.setPackageFragment(null);
    }

    protected IPackageFragmentRoot getPackageFragmentRoot() {
        IProject project = ((RelationshipMapping)this.getSubject()).getJpaProject().getProject();
        IJavaProject root = JavaCore.create((IProject)project);
        try {
            return root.getAllPackageFragmentRoots()[0];
        }
        catch (JavaModelException e) {
            JptUiPlugin.log(e);
            return null;
        }
    }

    private void populateCombo() {
        this.combo.removeAll();
        this.populateDefaultValue();
        this.updateSelectedItem();
    }

    private void populateDefaultValue() {
        String defaultValue;
        RelationshipMapping entity = (RelationshipMapping)this.getSubject();
        String string = defaultValue = entity != null ? entity.getDefaultTargetEntity() : null;
        if (defaultValue != null) {
            this.combo.add(NLS.bind((String)JptUiMappingsMessages.DefaultWithOneParam, (Object)defaultValue));
        } else {
            this.combo.add(JptUiMappingsMessages.DefaultEmpty);
        }
    }

    @Override
    protected void propertyChanged(String propertyName) {
        super.propertyChanged(propertyName);
        if (propertyName == "defaultTargetEntity" || propertyName == "specifiedTargetEntity") {
            this.populateCombo();
        }
    }

    private void updateSelectedItem() {
        String value;
        RelationshipMapping subject = (RelationshipMapping)this.getSubject();
        String string = value = subject != null ? subject.getSpecifiedTargetEntity() : null;
        if (value != null) {
            this.combo.setText(value);
            this.combo.setSelection(new Point(0, 0));
        } else {
            String defaultValue = subject != null ? subject.getDefaultTargetEntity() : null;
            String displayString = JptUiMappingsMessages.DefaultEmpty;
            if (defaultValue != null) {
                displayString = NLS.bind((String)JptUiMappingsMessages.DefaultWithOneParam, (Object)defaultValue);
            }
            if (displayString != null) {
                this.combo.select(0);
                this.combo.setSelection(new Point(0, 0));
            } else {
                this.combo.select(-1);
            }
        }
    }

    private void valueChanged(String value) {
        String oldValue;
        RelationshipMapping subject = (RelationshipMapping)this.getSubject();
        String string = oldValue = subject != null ? subject.getSpecifiedTargetEntity() : null;
        if (StringTools.stringIsEmpty((String)value)) {
            value = null;
            if (StringTools.stringIsEmpty((String)oldValue)) {
                return;
            }
        }
        if (value != null && this.combo.getItemCount() > 0 && value.equals(this.combo.getItem(0))) {
            value = null;
        }
        if (oldValue == value && value == null) {
            return;
        }
        if (value != null && oldValue == null || oldValue != null && !oldValue.equals(value)) {
            this.setPopulating(true);
            try {
                subject.setSpecifiedTargetEntity(value);
            }
            finally {
                this.setPopulating(false);
            }
        }
    }
}

