/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.db.ColumnCombo;
import org.eclipse.jpt.ui.internal.mappings.db.DatabaseObjectCombo;
import org.eclipse.jpt.ui.internal.widgets.FormPane;
import org.eclipse.jpt.ui.internal.widgets.IntegerCombo;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnComposite
extends FormPane<Column> {
    public ColumnComposite(FormPane<?> parentPane, PropertyValueModel<? extends Column> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent, false);
    }

    public ColumnComposite(FormPane<?> parentPane, PropertyValueModel<? extends Column> subjectHolder, Composite parent, boolean automaticallyAlignWidgets) {
        super(parentPane, subjectHolder, parent, automaticallyAlignWidgets);
    }

    public ColumnComposite(FormPane<?> parentPane, PropertyValueModel<? extends Column> subjectHolder, Composite parent, boolean automaticallyAlignWidgets, boolean parentManagePane) {
        super(parentPane, subjectHolder, parent, automaticallyAlignWidgets, parentManagePane);
    }

    private ColumnCombo<Column> addColumnCombo(Composite container) {
        return new ColumnCombo<Column>((Pane)this, container){

            @Override
            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultName");
                propertyNames.add("specifiedName");
                propertyNames.add("defaultTable");
                propertyNames.add("specifiedTable");
            }

            @Override
            protected void propertyChanged(String propertyName) {
                if (propertyName == "defaultTable" || propertyName == "specifiedTable") {
                    this.doPopulate();
                } else {
                    super.propertyChanged(propertyName);
                }
            }

            @Override
            protected String getDefaultValue() {
                return ((Column)this.getSubject()).getDefaultName();
            }

            @Override
            protected void setValue(String value) {
                ((Column)this.getSubject()).setSpecifiedName(value);
            }

            @Override
            protected Table getDbTable_() {
                return ((Column)this.getSubject()).getDbTable();
            }

            @Override
            protected String getValue() {
                return ((Column)this.getSubject()).getSpecifiedName();
            }

            public String toString() {
                return "ColumnComposite.columnCombo";
            }
        };
    }

    private WritablePropertyValueModel<String> buildColumnDefinitionHolder() {
        return new PropertyAspectAdapter<Column, String>(this.getSubjectHolder(), new String[]{"columnDefinition"}){

            protected String buildValue_() {
                return ((Column)this.subject).getColumnDefinition();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((Column)this.subject).setColumnDefinition(value);
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildInsertableHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"specifiedInsertable"}){

            protected Boolean buildValue_() {
                return ((Column)this.subject).getSpecifiedInsertable();
            }

            protected void setValue_(Boolean value) {
                ((Column)this.subject).setSpecifiedInsertable(value);
            }
        };
    }

    private PropertyValueModel<String> buildInsertableStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildInsertableHolder()){

            protected String transform(Boolean value) {
                if (ColumnComposite.this.getSubject() != null && value == null) {
                    boolean defaultValue = ((Column)ColumnComposite.this.getSubject()).isDefaultInsertable();
                    String defaultStringValue = defaultValue ? JptUiMappingsMessages.Boolean_True : JptUiMappingsMessages.Boolean_False;
                    return NLS.bind((String)JptUiMappingsMessages.ColumnComposite_insertableWithDefault, (Object)defaultStringValue);
                }
                return JptUiMappingsMessages.ColumnComposite_insertable;
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildNullableHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"defaultNullable", "specifiedNullable"}){

            protected Boolean buildValue_() {
                return ((Column)this.subject).getSpecifiedNullable();
            }

            protected void setValue_(Boolean value) {
                ((Column)this.subject).setSpecifiedNullable(value);
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Boolean.TRUE, newValue);
                }
            }
        };
    }

    private PropertyValueModel<String> buildNullableStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildNullableHolder()){

            protected String transform(Boolean value) {
                if (ColumnComposite.this.getSubject() != null && value == null) {
                    boolean defaultValue = ((Column)ColumnComposite.this.getSubject()).isDefaultNullable();
                    String defaultStringValue = defaultValue ? JptUiMappingsMessages.Boolean_True : JptUiMappingsMessages.Boolean_False;
                    return NLS.bind((String)JptUiMappingsMessages.ColumnComposite_nullableWithDefault, (Object)defaultStringValue);
                }
                return JptUiMappingsMessages.ColumnComposite_nullable;
            }
        };
    }

    private Pane<Column> addTableCombo(Composite container) {
        return new DatabaseObjectCombo<Column>((Pane)this, container){

            @Override
            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultTable");
                propertyNames.add("specifiedTable");
            }

            @Override
            protected String getDefaultValue() {
                return ((Column)this.getSubject()).getDefaultTable();
            }

            @Override
            protected void setValue(String value) {
                ((Column)this.getSubject()).setSpecifiedTable(value);
            }

            @Override
            protected String getValue() {
                return ((Column)this.getSubject()).getSpecifiedTable();
            }

            @Override
            protected Iterator<String> values() {
                return ((Column)this.getSubject()).getOwner().getTypeMapping().associatedTableNamesIncludingInherited();
            }

            public String toString() {
                return "ColumnComposite.tableCombo";
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildUniqueHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"defaultUnique", "specifiedUnique"}){

            protected Boolean buildValue_() {
                return ((Column)this.subject).getSpecifiedUnique();
            }

            protected void setValue_(Boolean value) {
                ((Column)this.subject).setSpecifiedUnique(value);
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Boolean.TRUE, newValue);
                }
            }
        };
    }

    private PropertyValueModel<String> buildUniqueStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildUniqueHolder()){

            protected String transform(Boolean value) {
                if (ColumnComposite.this.getSubject() != null && value == null) {
                    boolean defaultValue = ((Column)ColumnComposite.this.getSubject()).isDefaultUnique();
                    String defaultStringValue = defaultValue ? JptUiMappingsMessages.Boolean_True : JptUiMappingsMessages.Boolean_False;
                    return NLS.bind((String)JptUiMappingsMessages.ColumnComposite_uniqueWithDefault, (Object)defaultStringValue);
                }
                return JptUiMappingsMessages.ColumnComposite_unique;
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildUpdatableHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"defaulUpdatable", "specifiedUpdatable"}){

            protected Boolean buildValue_() {
                return ((Column)this.subject).getSpecifiedUpdatable();
            }

            protected void setValue_(Boolean value) {
                ((Column)this.subject).setSpecifiedUpdatable(value);
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Boolean.TRUE, newValue);
                }
            }
        };
    }

    private PropertyValueModel<String> buildUpdatableStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildUpdatableHolder()){

            protected String transform(Boolean value) {
                if (ColumnComposite.this.getSubject() != null && value == null) {
                    boolean defaultValue = ((Column)ColumnComposite.this.getSubject()).isDefaultUpdatable();
                    String defaultStringValue = defaultValue ? JptUiMappingsMessages.Boolean_True : JptUiMappingsMessages.Boolean_False;
                    return NLS.bind((String)JptUiMappingsMessages.ColumnComposite_updatableWithDefault, (Object)defaultStringValue);
                }
                return JptUiMappingsMessages.ColumnComposite_updatable;
            }
        };
    }

    @Override
    protected void initializeLayout(Composite container) {
        container = this.addTitledGroup(container, JptUiMappingsMessages.ColumnComposite_columnSection);
        this.addLabeledComposite(container, JptUiMappingsMessages.ColumnComposite_name, this.addColumnCombo(container), "org.eclipse.jpt.ui.mapping_column");
        this.addLabeledComposite(container, JptUiMappingsMessages.ColumnComposite_table, this.addTableCombo(container), "org.eclipse.jpt.ui.mapping_columnTable");
        container = this.addCollapsableSubSection(container, JptUiMappingsMessages.ColumnComposite_details, (PropertyValueModel<Boolean>)new SimplePropertyValueModel((Object)Boolean.FALSE));
        new DetailsComposite(this, this.getSubjectHolder(), this.addSubPane(container, 0, 16));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DetailsComposite
    extends FormPane<Column> {
        public DetailsComposite(FormPane<?> parentPane, PropertyValueModel<? extends Column> subjectHolder, Composite parent) {
            super(parentPane, subjectHolder, parent, false);
        }

        @Override
        protected void initializeLayout(Composite container) {
            this.addTriStateCheckBoxWithDefault(this.addSubPane(container, 4), JptUiMappingsMessages.ColumnComposite_insertable, (WritablePropertyValueModel<Boolean>)ColumnComposite.this.buildInsertableHolder(), (PropertyValueModel<String>)ColumnComposite.this.buildInsertableStringHolder(), "org.eclipse.jpt.ui.mapping_columnInsertable");
            this.addTriStateCheckBoxWithDefault(container, JptUiMappingsMessages.ColumnComposite_updatable, (WritablePropertyValueModel<Boolean>)ColumnComposite.this.buildUpdatableHolder(), (PropertyValueModel<String>)ColumnComposite.this.buildUpdatableStringHolder(), "org.eclipse.jpt.ui.mapping_columnUpdatable");
            this.addTriStateCheckBoxWithDefault(container, JptUiMappingsMessages.ColumnComposite_unique, (WritablePropertyValueModel<Boolean>)ColumnComposite.this.buildUniqueHolder(), (PropertyValueModel<String>)ColumnComposite.this.buildUniqueStringHolder(), "org.eclipse.jpt.ui.mapping_columnUnique");
            this.addTriStateCheckBoxWithDefault(container, JptUiMappingsMessages.ColumnComposite_nullable, (WritablePropertyValueModel<Boolean>)ColumnComposite.this.buildNullableHolder(), (PropertyValueModel<String>)ColumnComposite.this.buildNullableStringHolder(), "org.eclipse.jpt.ui.mapping_columnNullable");
            this.addLengthCombo(container);
            this.addPrecisionCombo(container);
            this.addScaleCombo(container);
            this.addLabeledText(container, JptUiMappingsMessages.ColumnComposite_columnDefinition, (WritablePropertyValueModel<String>)ColumnComposite.this.buildColumnDefinitionHolder());
        }

        private void addLengthCombo(Composite container) {
            new IntegerCombo<Column>((Pane)this, container){

                @Override
                protected String getLabelText() {
                    return JptUiMappingsMessages.ColumnComposite_length;
                }

                @Override
                protected String getHelpId() {
                    return "org.eclipse.jpt.ui.mapping_columnLength";
                }

                @Override
                protected PropertyValueModel<Integer> buildDefaultHolder() {
                    return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"defaultLength"}){

                        protected Integer buildValue_() {
                            return ((Column)this.subject).getDefaultLength();
                        }
                    };
                }

                @Override
                protected WritablePropertyValueModel<Integer> buildSelectedItemHolder() {
                    return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"specifiedLength"}){

                        protected Integer buildValue_() {
                            return ((Column)this.subject).getSpecifiedLength();
                        }

                        protected void setValue_(Integer value) {
                            ((Column)this.subject).setSpecifiedLength(value);
                        }
                    };
                }
            };
        }

        private void addPrecisionCombo(Composite container) {
            new IntegerCombo<Column>((Pane)this, container){

                @Override
                protected String getLabelText() {
                    return JptUiMappingsMessages.ColumnComposite_precision;
                }

                @Override
                protected String getHelpId() {
                    return "org.eclipse.jpt.ui.mapping_columnPrecision";
                }

                @Override
                protected PropertyValueModel<Integer> buildDefaultHolder() {
                    return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"defaultPrecision"}){

                        protected Integer buildValue_() {
                            return ((Column)this.subject).getDefaultPrecision();
                        }
                    };
                }

                @Override
                protected WritablePropertyValueModel<Integer> buildSelectedItemHolder() {
                    return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"specifiedPrecision"}){

                        protected Integer buildValue_() {
                            return ((Column)this.subject).getSpecifiedPrecision();
                        }

                        protected void setValue_(Integer value) {
                            ((Column)this.subject).setSpecifiedPrecision(value);
                        }
                    };
                }
            };
        }

        private void addScaleCombo(Composite container) {
            new IntegerCombo<Column>((Pane)this, container){

                @Override
                protected String getLabelText() {
                    return JptUiMappingsMessages.ColumnComposite_scale;
                }

                @Override
                protected String getHelpId() {
                    return "org.eclipse.jpt.ui.mapping_columnScale";
                }

                @Override
                protected PropertyValueModel<Integer> buildDefaultHolder() {
                    return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"defaultScale"}){

                        protected Integer buildValue_() {
                            return ((Column)this.subject).getDefaultScale();
                        }
                    };
                }

                @Override
                protected WritablePropertyValueModel<Integer> buildSelectedItemHolder() {
                    return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"specifiedScale"}){

                        protected Integer buildValue_() {
                            return ((Column)this.subject).getSpecifiedScale();
                        }

                        protected void setValue_(Integer value) {
                            ((Column)this.subject).setSpecifiedScale(value);
                        }
                    };
                }
            };
        }
    }
}

