/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.persistence.customization;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.customization.Customization;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.customization.Profiler;
import org.eclipse.jpt.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.ui.internal.widgets.ClassChooserComboPane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringConverter;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.SortedListValueModelAdapter;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfilerComposite
extends ClassChooserComboPane<Customization> {
    public ProfilerComposite(Pane<? extends Customization> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    protected String getClassName() {
        return Profiler.getProfilerClassName((String)((Customization)this.getSubject()).getProfiler());
    }

    protected String getLabelText() {
        return EclipseLinkUiMessages.PersistenceXmlCustomizationTab_profilerLabel;
    }

    protected JpaProject getJpaProject() {
        return ((Customization)this.getSubject()).getJpaProject();
    }

    protected WritablePropertyValueModel<String> buildTextHolder() {
        return new PropertyAspectAdapter<Customization, String>(this.getSubjectHolder(), new String[]{"profiler"}){

            protected String buildValue_() {
                String name = ((Customization)this.subject).getProfiler();
                if (name == null) {
                    name = ProfilerComposite.this.getDefaultValue((Customization)this.subject);
                }
                return name;
            }

            protected void setValue_(String value) {
                if (ProfilerComposite.this.getDefaultValue((Customization)this.subject).equals(value)) {
                    value = null;
                }
                ((Customization)this.subject).setProfiler(value);
            }
        };
    }

    private PropertyValueModel<String> buildDefaultProfilerHolder() {
        return new PropertyAspectAdapter<Customization, String>(this.getSubjectHolder(), new String[]{Customization.DEFAULT_PROFILER}){

            protected String buildValue_() {
                return ProfilerComposite.this.getDefaultValue((Customization)this.subject);
            }
        };
    }

    private ListValueModel<String> buildDefaultProfilerListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultProfilerHolder());
    }

    private String buildDisplayString(String profilerName) {
        switch (Profiler.valueOf((String)profilerName)) {
            case no_profiler: {
                return EclipseLinkUiMessages.ProfilerComposite_no_profiler;
            }
            case performance_profiler: {
                return EclipseLinkUiMessages.ProfilerComposite_performance_profiler;
            }
            case query_monitor: {
                return EclipseLinkUiMessages.ProfilerComposite_query_monitor;
            }
        }
        return null;
    }

    private Comparator<String> buildProfilerComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String profiler1, String profiler2) {
                profiler1 = ProfilerComposite.this.buildDisplayString(profiler1);
                profiler2 = ProfilerComposite.this.buildDisplayString(profiler2);
                return Collator.getInstance().compare(profiler1, profiler2);
            }
        };
    }

    protected StringConverter<String> buildClassConverter() {
        return new StringConverter<String>(){

            public String convertToString(String value) {
                try {
                    Profiler.valueOf((String)value);
                    value = ProfilerComposite.this.buildDisplayString(value);
                }
                catch (Exception exception) {}
                return value;
            }
        };
    }

    protected ListValueModel<String> buildClassListHolder() {
        ArrayList<ListValueModel<String>> holders = new ArrayList<ListValueModel<String>>(2);
        holders.add(this.buildDefaultProfilerListHolder());
        holders.add(this.buildProfilersListHolder());
        return new CompositeListValueModel(holders);
    }

    private Iterator<String> buildProfilers() {
        return new TransformationIterator<Profiler, String>(CollectionTools.iterator((Object[])Profiler.values())){

            protected String transform(Profiler next) {
                return next.name();
            }
        };
    }

    private CollectionValueModel<String> buildProfilersCollectionHolder() {
        return new SimpleCollectionValueModel((Collection)CollectionTools.collection(this.buildProfilers()));
    }

    private ListValueModel<String> buildProfilersListHolder() {
        return new SortedListValueModelAdapter(this.buildProfilersCollectionHolder(), this.buildProfilerComparator());
    }

    private String getDefaultValue(Customization subject) {
        String defaultValue = subject.getDefaultProfiler();
        if (defaultValue != null) {
            return NLS.bind((String)EclipseLinkUiMessages.PersistenceXmlCustomizationTab_defaultWithOneParam, (Object)defaultValue);
        }
        return EclipseLinkUiMessages.PersistenceXmlCustomizationTab_defaultEmpty;
    }

    protected void setClassName(String className) {
        ((Customization)this.getSubject()).setProfiler(className);
    }

    protected String getSuperInterfaceName() {
        return "org.eclipse.persistence.sessions.SessionProfiler";
    }
}

