/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.mappings.details;

import java.util.ListIterator;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.eclipselink.core.context.ConversionValue;
import org.eclipse.jpt.eclipselink.core.context.ObjectTypeConverter;
import org.eclipse.jpt.eclipselink.ui.internal.mappings.EclipseLinkUiMappingsMessages;
import org.eclipse.jpt.eclipselink.ui.internal.mappings.details.ConversionValueDialog;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.internal.swt.ColumnAdapter;
import org.eclipse.jpt.ui.internal.util.PaneEnabler;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.ui.internal.widgets.AddRemoveTablePane;
import org.eclipse.jpt.ui.internal.widgets.ClassChooserPane;
import org.eclipse.jpt.ui.internal.widgets.FormPane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.StringConverter;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectTypeConverterComposite
extends FormPane<ObjectTypeConverter> {
    public ObjectTypeConverterComposite(PropertyValueModel<? extends ObjectTypeConverter> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    protected void initializeLayout(Composite container) {
        this.addLabeledText(container, EclipseLinkUiMappingsMessages.ConverterComposite_nameTextLabel, this.buildNameTextHolder());
        this.addDataTypeChooser(container);
        this.addObjectTypeChooser(container);
        this.addConversionValuesTable(container);
        this.addLabeledEditableCCombo(container, EclipseLinkUiMappingsMessages.ObjectTypeConverterComposite_defaultObjectValueLabel, this.buildDefaultObjectValueListHolder(), this.buildDefaultObjectValueHolder(), this.buildStringConverter(), null);
        new PaneEnabler(this.buildBooleanHolder(), (Pane)this);
    }

    protected WritablePropertyValueModel<String> buildNameTextHolder() {
        return new PropertyAspectAdapter<ObjectTypeConverter, String>(this.getSubjectHolder(), new String[]{"name"}){

            protected String buildValue_() {
                return ((ObjectTypeConverter)this.subject).getName();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((ObjectTypeConverter)this.subject).setName(value);
            }
        };
    }

    private ClassChooserPane<ObjectTypeConverter> addDataTypeChooser(Composite container) {
        return new ClassChooserPane<ObjectTypeConverter>((Pane)this, container){

            protected WritablePropertyValueModel<String> buildTextHolder() {
                return new PropertyAspectAdapter<ObjectTypeConverter, String>(this.getSubjectHolder(), new String[]{"dataType"}){

                    protected String buildValue_() {
                        return ((ObjectTypeConverter)this.subject).getDataType();
                    }

                    protected void setValue_(String value) {
                        if (value.length() == 0) {
                            value = null;
                        }
                        ((ObjectTypeConverter)this.subject).setDataType(value);
                    }
                };
            }

            protected String getClassName() {
                return ((ObjectTypeConverter)this.getSubject()).getDataType();
            }

            protected String getLabelText() {
                return EclipseLinkUiMappingsMessages.ObjectTypeConverterComposite_dataTypeLabel;
            }

            protected JpaProject getJpaProject() {
                return ((ObjectTypeConverter)this.getSubject()).getJpaProject();
            }

            protected void setClassName(String className) {
                ((ObjectTypeConverter)this.getSubject()).setDataType(className);
            }

            protected char getEnclosingTypeSeparator() {
                return ((ObjectTypeConverter)this.getSubject()).getEnclosingTypeSeparator();
            }
        };
    }

    private ClassChooserPane<ObjectTypeConverter> addObjectTypeChooser(Composite container) {
        return new ClassChooserPane<ObjectTypeConverter>((Pane)this, container){

            protected WritablePropertyValueModel<String> buildTextHolder() {
                return new PropertyAspectAdapter<ObjectTypeConverter, String>(this.getSubjectHolder(), new String[]{"objectType"}){

                    protected String buildValue_() {
                        return ((ObjectTypeConverter)this.subject).getObjectType();
                    }

                    protected void setValue_(String value) {
                        if (value.length() == 0) {
                            value = null;
                        }
                        ((ObjectTypeConverter)this.subject).setObjectType(value);
                    }
                };
            }

            protected String getClassName() {
                return ((ObjectTypeConverter)this.getSubject()).getObjectType();
            }

            protected String getLabelText() {
                return EclipseLinkUiMappingsMessages.ObjectTypeConverterComposite_objectTypeLabel;
            }

            protected JpaProject getJpaProject() {
                return ((ObjectTypeConverter)this.getSubject()).getJpaProject();
            }

            protected void setClassName(String className) {
                ((ObjectTypeConverter)this.getSubject()).setObjectType(className);
            }

            protected int getTypeDialogStyle() {
                return 1024;
            }

            protected char getEnclosingTypeSeparator() {
                return ((ObjectTypeConverter)this.getSubject()).getEnclosingTypeSeparator();
            }
        };
    }

    protected void addConversionValuesTable(Composite container) {
        Group conversionValuesGroupPane = this.addTitledGroup(container, EclipseLinkUiMappingsMessages.ObjectTypeConverterComposite_conversionValuesGroupTitle);
        WritablePropertyValueModel<ConversionValue> conversionValueHolder = this.buildConversionValueHolder();
        new AddRemoveTablePane<ObjectTypeConverter>((Pane)this, (Composite)conversionValuesGroupPane, this.buildConversionValuesAdapter(), this.buildConversionValuesListModel(), conversionValueHolder, this.buildConversionValuesLabelProvider(), null){

            protected ColumnAdapter<ConversionValue> buildColumnAdapter() {
                return new ConversionValueColumnAdapter();
            }
        };
    }

    protected WritablePropertyValueModel<ConversionValue> buildConversionValueHolder() {
        return new SimplePropertyValueModel();
    }

    protected AddRemovePane.Adapter buildConversionValuesAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                ConversionValueDialog dialog = ObjectTypeConverterComposite.this.buildConversionValueDialogForAdd();
                ObjectTypeConverterComposite.this.addConversionValueFromDialog(dialog, listSelectionModel);
            }

            public boolean hasOptionalButton() {
                return true;
            }

            public String optionalButtonText() {
                return EclipseLinkUiMappingsMessages.ObjectTypeConverterComposite_conversionValueEdit;
            }

            public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
                ConversionValue conversionValue = (ConversionValue)listSelectionModel.selectedValue();
                ConversionValueDialog dialog = new ConversionValueDialog(ObjectTypeConverterComposite.this.getControl().getShell(), (ObjectTypeConverter)ObjectTypeConverterComposite.this.getSubject(), conversionValue);
                ObjectTypeConverterComposite.this.editConversionValueFromDialog(dialog, conversionValue);
            }

            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                ObjectTypeConverter converter = (ObjectTypeConverter)ObjectTypeConverterComposite.this.getSubject();
                int[] selectedIndices = listSelectionModel.selectedIndices();
                int index = selectedIndices.length;
                while (--index >= 0) {
                    converter.removeConversionValue(selectedIndices[index]);
                }
            }
        };
    }

    protected ConversionValueDialog buildConversionValueDialogForAdd() {
        return new ConversionValueDialog(this.getControl().getShell(), (ObjectTypeConverter)this.getSubject());
    }

    protected void addConversionValueFromDialog(ConversionValueDialog dialog, ObjectListSelectionModel listSelectionModel) {
        if (dialog.open() != 0) {
            return;
        }
        ConversionValue conversionValue = ((ObjectTypeConverter)this.getSubject()).addConversionValue();
        conversionValue.setDataValue(dialog.getDataValue());
        conversionValue.setObjectValue(dialog.getObjectValue());
        listSelectionModel.setSelectedValue((Object)conversionValue);
    }

    protected void editConversionValueFromDialog(ConversionValueDialog dialog, ConversionValue conversionValue) {
        if (dialog.open() != 0) {
            return;
        }
        conversionValue.setDataValue(dialog.getDataValue());
        conversionValue.setObjectValue(dialog.getObjectValue());
    }

    private ListValueModel<ConversionValue> buildConversionValuesListModel() {
        return new ItemPropertyListValueModelAdapter(this.buildConversionValuesListHolder(), new String[]{"dataValue", "objectValue"});
    }

    private ListValueModel<ConversionValue> buildConversionValuesListHolder() {
        return new ListAspectAdapter<ObjectTypeConverter, ConversionValue>(this.getSubjectHolder(), new String[]{"conversionValues"}){

            protected ListIterator<ConversionValue> listIterator_() {
                return ((ObjectTypeConverter)this.subject).conversionValues();
            }

            protected int size_() {
                return ((ObjectTypeConverter)this.subject).conversionValuesSize();
            }
        };
    }

    private ITableLabelProvider buildConversionValuesLabelProvider() {
        return new TableLabelProvider();
    }

    protected ListValueModel<String> buildDefaultObjectValueListHolder() {
        return new TransformationListValueModelAdapter<ConversionValue, String>(this.buildConversionValuesListModel()){

            protected String transformItem(ConversionValue conversionValue) {
                return conversionValue.getObjectValue();
            }
        };
    }

    protected WritablePropertyValueModel<String> buildDefaultObjectValueHolder() {
        return new PropertyAspectAdapter<ObjectTypeConverter, String>(this.getSubjectHolder(), new String[]{"defaultObjectValue"}){

            protected String buildValue_() {
                return ((ObjectTypeConverter)this.subject).getDefaultObjectValue();
            }

            protected void setValue_(String value) {
                if (value != null && value.length() == 0) {
                    value = null;
                }
                ((ObjectTypeConverter)this.subject).setDefaultObjectValue(value);
            }
        };
    }

    protected final StringConverter<String> buildStringConverter() {
        return new StringConverter<String>(){

            public String convertToString(String value) {
                return value == null ? "" : value;
            }
        };
    }

    protected PropertyValueModel<Boolean> buildBooleanHolder() {
        return new TransformationPropertyValueModel<ObjectTypeConverter, Boolean>(this.getSubjectHolder()){

            protected Boolean transform(ObjectTypeConverter value) {
                return value != null;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConversionValueColumnAdapter
    implements ColumnAdapter<ConversionValue> {
        public static final int COLUMN_COUNT = 2;
        public static final int DATA_VALUE_COLUMN = 0;
        public static final int OBJECT_VALUE_COLUMN = 1;

        private ConversionValueColumnAdapter() {
        }

        private WritablePropertyValueModel<String> buildDataValueHolder(ConversionValue subject) {
            return new PropertyAspectAdapter<ConversionValue, String>("dataValue", subject){

                protected String buildValue_() {
                    return ((ConversionValue)this.subject).getDataValue();
                }

                protected void setValue_(String value) {
                    ((ConversionValue)this.subject).setDataValue(value);
                }
            };
        }

        private WritablePropertyValueModel<String> buildObjectValueHolder(ConversionValue subject) {
            return new PropertyAspectAdapter<ConversionValue, String>("objectValue", subject){

                protected String buildValue_() {
                    return ((ConversionValue)this.subject).getObjectValue();
                }

                protected void setValue_(String value) {
                    ((ConversionValue)this.subject).setObjectValue(value);
                }
            };
        }

        public WritablePropertyValueModel<?>[] cellModels(ConversionValue subject) {
            WritablePropertyValueModel[] holders = new WritablePropertyValueModel[]{this.buildDataValueHolder(subject), this.buildObjectValueHolder(subject)};
            return holders;
        }

        public int columnCount() {
            return 2;
        }

        public String columnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return EclipseLinkUiMappingsMessages.ObjectTypeConverterComposite_conversionValuesDataValueColumn;
                }
                case 1: {
                    return EclipseLinkUiMappingsMessages.ObjectTypeConverterComposite_conversionValuesObjectValueColumn;
                }
            }
            return null;
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ConversionValue conversionValue = (ConversionValue)element;
            String value = null;
            switch (columnIndex) {
                case 0: {
                    value = conversionValue.getDataValue();
                    break;
                }
                case 1: {
                    value = conversionValue.getObjectValue();
                }
            }
            if (value == null) {
                value = "";
            }
            return value;
        }
    }
}

