/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.persistence;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.model.AbstractModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EclipseLinkPersistenceUnitProperties
extends AbstractModel
implements PersistenceUnitProperties {
    private PersistenceUnit persistenceUnit;
    private Map<String, String> propertyNames;
    private static final long serialVersionUID = 1L;

    protected EclipseLinkPersistenceUnitProperties(PersistenceUnit parent) {
        this.initialize(parent);
    }

    protected void initialize(PersistenceUnit parent) {
        this.persistenceUnit = parent;
        this.initializePropertyNames();
        this.initializeProperties();
    }

    protected void initializePropertyNames() {
        this.propertyNames = new HashMap<String, String>();
        this.addPropertyNames(this.propertyNames);
    }

    protected abstract void initializeProperties();

    @Override
    public PersistenceUnit getPersistenceUnit() {
        return this.persistenceUnit;
    }

    @Override
    public JpaProject getJpaProject() {
        return this.persistenceUnit.getJpaProject();
    }

    private Map<String, String> propertyNames() {
        return this.propertyNames;
    }

    protected abstract void addPropertyNames(Map<String, String> var1);

    @Override
    public boolean itemIsProperty(PersistenceUnit.Property item) {
        if (item == null) {
            throw new NullPointerException();
        }
        return this.propertyNames().keySet().contains(item.getName());
    }

    @Override
    public String propertyIdFor(PersistenceUnit.Property property) {
        String propertyId = this.propertyNames().get(property.getName());
        if (propertyId == null) {
            throw new IllegalArgumentException("Illegal property: " + property);
        }
        return propertyId;
    }

    protected String eclipseLinkKeyFor(String propertyId) {
        for (String eclipseLinkKey : this.propertyNames().keySet()) {
            if (!this.propertyNames().get(eclipseLinkKey).equals(propertyId)) continue;
            return eclipseLinkKey;
        }
        throw new IllegalArgumentException("Illegal property ID: " + propertyId);
    }

    protected String getStringValue(String elKey) {
        PersistenceUnit.Property p = this.getPersistenceUnit().getProperty(elKey);
        return p == null ? null : p.getValue();
    }

    protected String getStringValue(String key, String keySuffix) {
        return this.getStringValue(keySuffix == null ? key : String.valueOf(key) + keySuffix);
    }

    protected void putStringValue(String key, String newValue) {
        this.putStringValue(key, null, newValue, false);
    }

    protected void putStringValue(String key, String newValue, boolean allowDuplicate) {
        this.putStringValue(key, null, newValue, allowDuplicate);
    }

    protected void putStringValue(String key, String keySuffix, String newValue, boolean allowDuplicate) {
        String elKey = keySuffix == null ? key : String.valueOf(key) + keySuffix;
        this.getPersistenceUnit().setProperty(elKey, newValue, allowDuplicate);
    }

    protected Integer getIntegerValue(String elKey) {
        PersistenceUnit.Property p = this.getPersistenceUnit().getProperty(elKey);
        return p == null ? null : EclipseLinkPersistenceUnitProperties.getIntegerValueOf(p.getValue());
    }

    protected Integer getIntegerValue(String key, String keySuffix) {
        return this.getIntegerValue(keySuffix == null ? key : String.valueOf(key) + keySuffix);
    }

    protected void putIntegerValue(String key, Integer newValue) {
        this.putIntegerValue(key, null, newValue, false);
    }

    protected void putIntegerValue(String key, Integer newValue, boolean allowDuplicate) {
        this.putIntegerValue(key, null, newValue, allowDuplicate);
    }

    protected void putIntegerValue(String key, String keySuffix, Integer newValue, boolean allowDuplicate) {
        String elKey = keySuffix == null ? key : String.valueOf(key) + keySuffix;
        String elValue = newValue == null ? null : newValue.toString();
        this.getPersistenceUnit().setProperty(elKey, elValue, allowDuplicate);
    }

    protected Boolean getBooleanValue(String elKey) {
        PersistenceUnit.Property p = this.getPersistenceUnit().getProperty(elKey);
        return p == null ? null : EclipseLinkPersistenceUnitProperties.getBooleanValueOf(p.getValue());
    }

    protected Boolean getBooleanValue(String key, String keySuffix) {
        return this.getBooleanValue(keySuffix == null ? key : String.valueOf(key) + keySuffix);
    }

    protected void putBooleanValue(String key, Boolean newValue) {
        this.putBooleanValue(key, null, newValue, false);
    }

    protected void putBooleanValue(String key, Boolean newValue, boolean allowDuplicate) {
        this.putBooleanValue(key, null, newValue, allowDuplicate);
    }

    protected void putBooleanValue(String key, String keySuffix, Boolean newValue, boolean allowDuplicate) {
        String elKey = keySuffix == null ? key : String.valueOf(key) + keySuffix;
        String elValue = newValue == null ? null : newValue.toString();
        this.getPersistenceUnit().setProperty(elKey, elValue, allowDuplicate);
    }

    protected <T extends Enum<T>> T getEnumValue(String elKey, T[] enumValues) {
        PersistenceUnit.Property p = this.getPersistenceUnit().getProperty(elKey);
        return (T)(p == null ? null : EclipseLinkPersistenceUnitProperties.getEnumValueOf((String)p.getValue(), enumValues));
    }

    protected <T extends Enum<T>> T getEnumValue(String key, String keySuffix, T[] enumValues) {
        return (T)this.getEnumValue(keySuffix == null ? key : String.valueOf(key) + keySuffix, (Enum[])enumValues);
    }

    protected <T extends Enum<T>> void putEnumValue(String key, T newValue) {
        this.putEnumValue(key, null, newValue, false);
    }

    protected <T extends Enum<T>> void putEnumValue(String key, T newValue, boolean allowDuplicate) {
        this.putEnumValue(key, null, newValue, allowDuplicate);
    }

    protected <T extends Enum<T>> void putEnumValue(String key, String keySuffix, T newValue, boolean allowDuplicate) {
        String elKey = keySuffix == null ? key : String.valueOf(key) + keySuffix;
        this.getPersistenceUnit().setProperty(elKey, EclipseLinkPersistenceUnitProperties.getEclipseLinkStringValueOf(newValue), allowDuplicate);
    }

    protected void putProperty(String key, Object value) {
        this.putProperty(key, value, false);
    }

    protected void putProperty(String key, Object value, boolean allowDuplicates) {
        String elKey = this.eclipseLinkKeyFor(key);
        if (value != null && value.getClass().isEnum()) {
            this.putEnumValue(elKey, (Enum)value, allowDuplicates);
        } else {
            this.putEclipseLinkProperty(elKey, value, allowDuplicates);
        }
    }

    private void putEclipseLinkProperty(String key, Object value, boolean allowDuplicates) {
        String string = value == null ? null : value.toString();
        this.getPersistenceUnit().setProperty(key, string, allowDuplicates);
    }

    protected void removeProperty(String key, String value) {
        String elKey = this.eclipseLinkKeyFor(key);
        this.getPersistenceUnit().removeProperty(elKey, value);
    }

    protected Set<PersistenceUnit.Property> getPropertiesSetWithPrefix(String keyPrefix) {
        return CollectionTools.set((Iterator)this.getPersistenceUnit().propertiesWithNamePrefix(keyPrefix));
    }

    protected String getEntityName(PersistenceUnit.Property property) {
        return this.getEntityName(property.getName());
    }

    protected String getEntityName(String propertyName) {
        int index = propertyName.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return propertyName.substring(index + 1);
    }

    public static String getEclipseLinkStringValueOf(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isEnum()) {
            return (String)ClassTools.staticFieldValue(value.getClass(), (String)value.toString().toUpperCase(Locale.ENGLISH));
        }
        return value.toString();
    }

    public static <T extends Enum<T>> T getEnumValueOf(String elStringValue, T[] enumValues) {
        T[] TArray = enumValues;
        int n = enumValues.length;
        int n2 = 0;
        while (n2 < n) {
            T enumValue = TArray[n2];
            if (EclipseLinkPersistenceUnitProperties.getEclipseLinkStringValueOf(enumValue).equals(elStringValue)) {
                return enumValue;
            }
            ++n2;
        }
        return null;
    }

    public static Boolean getBooleanValueOf(String elStringValue) {
        if (elStringValue == null) {
            return null;
        }
        return Boolean.valueOf(elStringValue);
    }

    public static Integer getIntegerValueOf(String elStringValue) {
        if (elStringValue == null) {
            return null;
        }
        return Integer.valueOf(elStringValue);
    }
}

