/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmIdMapping;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmNullAttributeMapping;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmOneToOneMapping;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkOrmPersistentAttributeTests
extends ContextModelTestCase {
    public EclipseLinkOrmPersistentAttributeTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestTypeNullAttributeMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityIdMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Column"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append("@Column(name=\"FOO\")");
            }
        });
    }

    private ICompilationUnit createTestEntityOneToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne");
                sb.append("    private Address address;");
            }
        });
    }

    public void testMakeSpecified() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        ormPersistentAttribute.makeSpecified();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormPersistentAttribute.makeSpecified();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)0, (int)ormPersistentType.virtualAttributesSize());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.specifiedAttributesSize());
        ListIterator specifiedAttributes = ormPersistentType.specifiedAttributes();
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"name", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
    }

    public void testMakeSpecifiedMappingKey() throws Exception {
        this.createTestTypeNullAttributeMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        EclipseLinkOrmPersistentAttributeTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof GenericOrmNullAttributeMapping));
        ormPersistentAttribute.makeSpecified("oneToOne");
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"address", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        EclipseLinkOrmPersistentAttributeTests.assertTrue((boolean)(specifiedOrmPersistentAttribute.getMapping() instanceof GenericOrmOneToOneMapping));
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormPersistentAttribute.makeSpecified("id");
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.specifiedAttributesSize());
        ListIterator specifiedAttributes = ormPersistentType.specifiedAttributes();
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        EclipseLinkOrmPersistentAttributeTests.assertTrue((boolean)(specifiedOrmPersistentAttribute.getMapping() instanceof GenericOrmIdMapping));
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"address", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
    }

    public void testMakeVirtual() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        ((OrmPersistentAttribute)ormPersistentType.virtualAttributes().next()).makeSpecified();
        ((OrmPersistentAttribute)ormPersistentType.virtualAttributes().next()).makeSpecified();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)0, (int)ormPersistentType.virtualAttributesSize());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.specifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        specifiedOrmPersistentAttribute.makeVirtual();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        specifiedOrmPersistentAttribute.makeVirtual();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)0, (int)ormPersistentType.specifiedAttributesSize());
        ListIterator virtualAttributes = ormPersistentType.virtualAttributes();
        OrmPersistentAttribute virtualAttribute = (OrmPersistentAttribute)virtualAttributes.next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"id", (String)virtualAttribute.getName());
        virtualAttribute = (OrmPersistentAttribute)virtualAttributes.next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"name", (String)virtualAttribute.getName());
    }

    public void testMakeVirtualNoUnderlyingJavaAttribute() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        ((OrmPersistentAttribute)ormPersistentType.virtualAttributes().next()).makeSpecified();
        ((OrmPersistentAttribute)ormPersistentType.virtualAttributes().next()).makeSpecified();
        ((OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next()).getMapping().setName("noJavaAttribute");
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.specifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        specifiedOrmPersistentAttribute.makeVirtual();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"id", (String)((OrmPersistentAttribute)ormPersistentType.virtualAttributes().next()).getName());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"name", (String)((OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next()).getName());
    }

    public void testVirtualMappingTypeWhenMetadataComplete() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMappingKey());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"FOO", (String)((IdMapping)ormPersistentAttribute.getMapping()).getColumn().getName());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMappingKey());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"id", (String)((BasicMapping)ormPersistentAttribute.getMapping()).getColumn().getName());
    }

    public void testVirtualMappingTypeWhenMetadataComplete2() throws Exception {
        this.createTestEntityOneToOneMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMappingKey());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)ormPersistentAttribute.getMappingKey());
    }

    public void testGetJavaPersistentAttribute() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        JavaPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        EclipseLinkOrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        EclipseLinkOrmPersistentAttributeTests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        JavaResourcePersistentAttribute javaResourcePersistentAttribute = ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute();
        EclipseLinkOrmPersistentAttributeTests.assertTrue((boolean)javaResourcePersistentAttribute.isField());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"id", (String)javaResourcePersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertEquals(javaPersistentType.getResourcePersistentType().persistableFields().next(), (Object)javaResourcePersistentAttribute);
        ormPersistentAttribute.makeSpecified();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLinkOrmPersistentAttributeTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        ormPersistentAttribute.makeVirtual();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        ormPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        EclipseLinkOrmPersistentAttributeTests.assertNotSame((Object)ormPersistentAttribute, (Object)ormPersistentType.getAttributeNamed("id"));
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLinkOrmPersistentAttributeTests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        javaResourcePersistentAttribute = ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute();
        EclipseLinkOrmPersistentAttributeTests.assertTrue((boolean)javaResourcePersistentAttribute.isProperty());
        EclipseLinkOrmPersistentAttributeTests.assertEquals((String)"id", (String)javaResourcePersistentAttribute.getName());
        EclipseLinkOrmPersistentAttributeTests.assertEquals(javaPersistentType.getResourcePersistentType().persistableProperties().next(), (Object)javaResourcePersistentAttribute);
        ormPersistentType.setSpecifiedAccess(null);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        ormPersistentAttribute.makeSpecified();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        ormPersistentAttribute.getMapping().setName("id2");
        EclipseLinkOrmPersistentAttributeTests.assertEquals(null, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        ormPersistentAttribute.getMapping().setName(null);
        EclipseLinkOrmPersistentAttributeTests.assertEquals(null, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        ormPersistentAttribute.getMapping().setName("id");
        EclipseLinkOrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLinkOrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
    }
}

