/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.orm;

import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkOneToOneMapping;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkRelationshipMapping;
import org.eclipse.jpt.eclipselink.core.context.JoinFetchType;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.EclipseLinkOrmOneToOneMapping;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlEntity;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlJoinFetchType;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlOneToOne;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.orm.EclipseLinkOrmContextModelTestCase;

public class EclipseLinkOrmOneToOneMappingTests
extends EclipseLinkOrmContextModelTestCase {
    public EclipseLinkOrmOneToOneMappingTests(String name) {
        super(name);
    }

    private void createTestDepartment() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Entity").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Id").append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("import ").append("javax.persistence.OneToOne").append(";");
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Department").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne").append(CR);
                sb.append("    private Employee employee;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Department.java", sourceWriter);
    }

    private void createTestEmployee() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Entity").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Id").append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Employee").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int empId;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Employee.java", sourceWriter);
    }

    public void testUpdatePrivateOwned() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOne");
        EclipseLinkOneToOneMapping contextOneToOne = (EclipseLinkOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlOneToOne resourceOneToOne = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)resourceOneToOne.isPrivateOwned());
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)contextOneToOne.getPrivateOwned().isPrivateOwned());
        resourceOneToOne.setPrivateOwned(true);
        EclipseLinkOrmOneToOneMappingTests.assertTrue((boolean)resourceOneToOne.isPrivateOwned());
        EclipseLinkOrmOneToOneMappingTests.assertTrue((boolean)contextOneToOne.getPrivateOwned().isPrivateOwned());
        resourceOneToOne.setPrivateOwned(false);
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)resourceOneToOne.isPrivateOwned());
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)contextOneToOne.getPrivateOwned().isPrivateOwned());
    }

    public void testModifyPrivateOwned() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOne");
        EclipseLinkOneToOneMapping contextOneToOne = (EclipseLinkOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlOneToOne resourceOneToOne = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)resourceOneToOne.isPrivateOwned());
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)contextOneToOne.getPrivateOwned().isPrivateOwned());
        contextOneToOne.getPrivateOwned().setPrivateOwned(true);
        EclipseLinkOrmOneToOneMappingTests.assertTrue((boolean)resourceOneToOne.isPrivateOwned());
        EclipseLinkOrmOneToOneMappingTests.assertTrue((boolean)contextOneToOne.getPrivateOwned().isPrivateOwned());
        contextOneToOne.getPrivateOwned().setPrivateOwned(false);
    }

    public void testUpdateJoinFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOne");
        EclipseLinkOneToOneMapping contextOneToOne = (EclipseLinkOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlOneToOne resourceOneToOne = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)resourceOneToOne.getJoinFetch());
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)contextOneToOne.getJoinFetch().getValue());
        resourceOneToOne.setJoinFetch(XmlJoinFetchType.INNER);
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)XmlJoinFetchType.INNER, (Object)resourceOneToOne.getJoinFetch());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)contextOneToOne.getJoinFetch().getValue());
        resourceOneToOne.setJoinFetch(XmlJoinFetchType.OUTER);
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)XmlJoinFetchType.OUTER, (Object)resourceOneToOne.getJoinFetch());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)contextOneToOne.getJoinFetch().getValue());
        resourceOneToOne.setJoinFetch(null);
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)resourceOneToOne.getJoinFetch());
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)contextOneToOne.getJoinFetch().getValue());
    }

    public void testModifyJoinFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOne");
        EclipseLinkOneToOneMapping contextOneToOne = (EclipseLinkOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlOneToOne resourceOneToOne = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)resourceOneToOne.getJoinFetch());
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)contextOneToOne.getJoinFetch().getValue());
        contextOneToOne.getJoinFetch().setValue(JoinFetchType.INNER);
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)XmlJoinFetchType.INNER, (Object)resourceOneToOne.getJoinFetch());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)contextOneToOne.getJoinFetch().getValue());
        contextOneToOne.getJoinFetch().setValue(JoinFetchType.OUTER);
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)XmlJoinFetchType.OUTER, (Object)resourceOneToOne.getJoinFetch());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)contextOneToOne.getJoinFetch().getValue());
        contextOneToOne.getJoinFetch().setValue(null);
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)resourceOneToOne.getJoinFetch());
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)contextOneToOne.getJoinFetch().getValue());
    }

    public void testJoinFetchDefaultFromJava() throws Exception {
        this.createTestEmployee();
        this.createTestDepartment();
        this.getEntityMappings().addPersistentType("entity", "test.Department");
        this.getEntityMappings().addPersistentType("entity", "test.Employee");
        OrmPersistentType departmentPersistentType = (OrmPersistentType)this.getEntityMappings().persistentTypes().next();
        EclipseLinkOrmOneToOneMapping oneToOne = (EclipseLinkOrmOneToOneMapping)departmentPersistentType.getAttributeNamed("employee").getMapping();
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)oneToOne.getJoinFetch().getValue());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        oneToOne = (EclipseLinkOrmOneToOneMapping)departmentPersistentType.getAttributeNamed("employee").getMapping();
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)oneToOne.getJoinFetch().getValue());
        EclipseLinkRelationshipMapping javaRelationshipMapping = (EclipseLinkRelationshipMapping)departmentPersistentType.getJavaPersistentType().getAttributeNamed("employee").getMapping();
        javaRelationshipMapping.getJoinFetch().setValue(JoinFetchType.OUTER);
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)oneToOne.getJoinFetch().getValue());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        oneToOne = (EclipseLinkOrmOneToOneMapping)departmentPersistentType.getAttributeNamed("employee").getMapping();
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)oneToOne.getJoinFetch().getValue());
    }
}

