/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.Convert;
import org.eclipse.jpt.eclipselink.core.context.TypeConverter;
import org.eclipse.jpt.eclipselink.core.resource.java.TypeConverterAnnotation;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkJavaTypeConverterTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithConvertAndTypeConverter() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.TypeConverter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"foo\")").append(CR);
                sb.append("    @TypeConverter(name=\"foo\"");
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvertAndDataType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.TypeConverter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"foo\")").append(CR);
                sb.append("    @TypeConverter(dataType=Foo.class");
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvertAndObjectType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.TypeConverter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"foo\")").append(CR);
                sb.append("    @TypeConverter(objectType=Foo.class");
            }
        });
    }

    public EclipseLinkJavaTypeConverterTests(String name) {
        super(name);
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithConvertAndTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        TypeConverter converter = (TypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"foo", (String)converter.getName());
    }

    public void testSetName() throws Exception {
        this.createTestEntityWithConvertAndTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        TypeConverter converter = (TypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"foo", (String)converter.getName());
        converter.setName("bar");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"bar", (String)converter.getName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TypeConverterAnnotation converterAnnotation = (TypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"bar", (String)converterAnnotation.getName());
        converter.setName(null);
        EclipseLinkJavaTypeConverterTests.assertEquals(null, (String)converter.getName());
        converterAnnotation = (TypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        EclipseLinkJavaTypeConverterTests.assertEquals(null, (String)converterAnnotation.getName());
        converter.setName("bar");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"bar", (String)converter.getName());
        converterAnnotation = (TypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"bar", (String)converterAnnotation.getName());
    }

    public void testGetNameUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithConvertAndTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        TypeConverter converter = (TypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"foo", (String)converter.getName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TypeConverterAnnotation converterAnnotation = (TypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        converterAnnotation.setName("bar");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"bar", (String)converter.getName());
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        EclipseLinkJavaTypeConverterTests.assertEquals(null, (Object)eclipseLinkConvert.getConverter());
        converterAnnotation = (TypeConverterAnnotation)attributeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        EclipseLinkJavaTypeConverterTests.assertNotNull((Object)eclipseLinkConvert.getConverter());
        converterAnnotation.setName("FOO");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"FOO", (String)eclipseLinkConvert.getConverter().getName());
    }

    public void testGetDataType() throws Exception {
        this.createTestEntityWithConvertAndDataType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        TypeConverter converter = (TypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Foo", (String)converter.getDataType());
    }

    public void testSetDataType() throws Exception {
        this.createTestEntityWithConvertAndDataType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        TypeConverter converter = (TypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Foo", (String)converter.getDataType());
        converter.setDataType("Bar");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Bar", (String)converter.getDataType());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TypeConverterAnnotation converterAnnotation = (TypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Bar", (String)converterAnnotation.getDataType());
        converter.setDataType(null);
        EclipseLinkJavaTypeConverterTests.assertEquals(null, (String)converter.getDataType());
        converterAnnotation = (TypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        EclipseLinkJavaTypeConverterTests.assertEquals(null, (String)converterAnnotation.getDataType());
        converter.setDataType("Bar");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Bar", (String)converter.getDataType());
        converterAnnotation = (TypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Bar", (String)converterAnnotation.getDataType());
    }

    public void testGetDataTypeUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithConvertAndDataType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        TypeConverter converter = (TypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Foo", (String)converter.getDataType());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TypeConverterAnnotation converterAnnotation = (TypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        converterAnnotation.setDataType("Bar");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Bar", (String)converter.getDataType());
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        EclipseLinkJavaTypeConverterTests.assertEquals(null, (Object)eclipseLinkConvert.getConverter());
        converterAnnotation = (TypeConverterAnnotation)attributeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        EclipseLinkJavaTypeConverterTests.assertNotNull((Object)eclipseLinkConvert.getConverter());
        converterAnnotation.setDataType("FooBar");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"FooBar", (String)((TypeConverter)eclipseLinkConvert.getConverter()).getDataType());
    }

    public void testGetObjectType() throws Exception {
        this.createTestEntityWithConvertAndObjectType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        TypeConverter converter = (TypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Foo", (String)converter.getObjectType());
    }

    public void testSetObjectType() throws Exception {
        this.createTestEntityWithConvertAndObjectType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        TypeConverter converter = (TypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Foo", (String)converter.getObjectType());
        converter.setObjectType("Bar");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Bar", (String)converter.getObjectType());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TypeConverterAnnotation converterAnnotation = (TypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Bar", (String)converterAnnotation.getObjectType());
        converter.setObjectType(null);
        EclipseLinkJavaTypeConverterTests.assertEquals(null, (String)converter.getObjectType());
        converterAnnotation = (TypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        EclipseLinkJavaTypeConverterTests.assertEquals(null, (String)converterAnnotation.getObjectType());
        converter.setObjectType("Bar");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Bar", (String)converter.getObjectType());
        converterAnnotation = (TypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Bar", (String)converterAnnotation.getObjectType());
    }

    public void testGetObjectTypeUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithConvertAndObjectType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        TypeConverter converter = (TypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Foo", (String)converter.getObjectType());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TypeConverterAnnotation converterAnnotation = (TypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        converterAnnotation.setObjectType("Bar");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Bar", (String)converter.getObjectType());
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        EclipseLinkJavaTypeConverterTests.assertEquals(null, (Object)eclipseLinkConvert.getConverter());
        converterAnnotation = (TypeConverterAnnotation)attributeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        EclipseLinkJavaTypeConverterTests.assertNotNull((Object)eclipseLinkConvert.getConverter());
        converterAnnotation.setObjectType("FooBar");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"FooBar", (String)((TypeConverter)eclipseLinkConvert.getConverter()).getObjectType());
    }
}

