/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.ChangeTracking;
import org.eclipse.jpt.eclipselink.core.context.Customizer;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkEntity;
import org.eclipse.jpt.eclipselink.core.context.ReadOnly;
import org.eclipse.jpt.eclipselink.core.resource.java.ChangeTrackingAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.ChangeTrackingType;
import org.eclipse.jpt.eclipselink.core.resource.java.CustomizerAnnotation;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkJavaEntityTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithConvertAndCustomizerClass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Customizer"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("    @Customizer(Foo.class");
            }
        });
    }

    private ICompilationUnit createTestEntityWithChangeTracking() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.ChangeTracking"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("    @ChangeTracking").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithReadOnly() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.ReadOnly"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@ReadOnly").append(CR);
            }
        });
    }

    public EclipseLinkJavaEntityTests(String name) {
        super(name);
    }

    public void testGetCustomizerClass() throws Exception {
        this.createTestEntityWithConvertAndCustomizerClass();
        this.addXmlClassRef("test.AnnotationTestType");
        Customizer customizer = ((EclipseLinkEntity)this.getJavaPersistentType().getMapping()).getCustomizer();
        EclipseLinkJavaEntityTests.assertEquals((String)"Foo", (String)customizer.getSpecifiedCustomizerClass());
    }

    public void testSetCustomizerClass() throws Exception {
        this.createTestEntityWithConvertAndCustomizerClass();
        this.addXmlClassRef("test.AnnotationTestType");
        Customizer customizer = ((EclipseLinkEntity)this.getJavaPersistentType().getMapping()).getCustomizer();
        EclipseLinkJavaEntityTests.assertEquals((String)"Foo", (String)customizer.getSpecifiedCustomizerClass());
        customizer.setSpecifiedCustomizerClass("Bar");
        EclipseLinkJavaEntityTests.assertEquals((String)"Bar", (String)customizer.getSpecifiedCustomizerClass());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        CustomizerAnnotation customizerAnnotation = (CustomizerAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLinkJavaEntityTests.assertEquals((String)"Bar", (String)customizerAnnotation.getValue());
        customizer.setSpecifiedCustomizerClass(null);
        EclipseLinkJavaEntityTests.assertEquals(null, (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation = (CustomizerAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLinkJavaEntityTests.assertEquals(null, (Object)customizerAnnotation);
        customizer.setSpecifiedCustomizerClass("Bar");
        EclipseLinkJavaEntityTests.assertEquals((String)"Bar", (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation = (CustomizerAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLinkJavaEntityTests.assertEquals((String)"Bar", (String)customizerAnnotation.getValue());
    }

    public void testGetCustomizerClassUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithConvertAndCustomizerClass();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkEntity entity = (EclipseLinkEntity)this.getJavaPersistentType().getMapping();
        Customizer customizer = entity.getCustomizer();
        EclipseLinkJavaEntityTests.assertEquals((String)"Foo", (String)customizer.getSpecifiedCustomizerClass());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        CustomizerAnnotation customizerAnnotation = (CustomizerAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Customizer");
        customizerAnnotation.setValue("Bar");
        EclipseLinkJavaEntityTests.assertEquals((String)"Bar", (String)customizer.getSpecifiedCustomizerClass());
        typeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLinkJavaEntityTests.assertEquals(null, (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation = (CustomizerAnnotation)typeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLinkJavaEntityTests.assertEquals(null, (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation.setValue("FooBar");
        EclipseLinkJavaEntityTests.assertEquals((String)"FooBar", (String)customizer.getSpecifiedCustomizerClass());
    }

    public void testGetChangeTracking() throws Exception {
        this.createTestEntityWithChangeTracking();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkEntity entity = (EclipseLinkEntity)this.getJavaPersistentType().getMapping();
        ChangeTracking contextChangeTracking = entity.getChangeTracking();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        ChangeTrackingAnnotation resourceChangeTracking = (ChangeTrackingAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        EclipseLinkJavaEntityTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEntityTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEntityTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEntityTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.ATTRIBUTE);
        EclipseLinkJavaEntityTests.assertEquals((Object)ChangeTrackingType.ATTRIBUTE, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEntityTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.ATTRIBUTE, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEntityTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEntityTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.ATTRIBUTE, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.OBJECT);
        EclipseLinkJavaEntityTests.assertEquals((Object)ChangeTrackingType.OBJECT, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEntityTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.OBJECT, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEntityTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEntityTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.OBJECT, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.DEFERRED);
        EclipseLinkJavaEntityTests.assertEquals((Object)ChangeTrackingType.DEFERRED, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEntityTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.DEFERRED, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEntityTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEntityTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.DEFERRED, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.AUTO);
        EclipseLinkJavaEntityTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEntityTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEntityTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEntityTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(null);
        EclipseLinkJavaEntityTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEntityTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEntityTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEntityTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        typeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        EclipseLinkJavaEntityTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEntityTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEntityTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEntityTests.assertNull((Object)contextChangeTracking.getSpecifiedType());
    }

    public void testSetChangeTracking() throws Exception {
        this.createTestEntityWithChangeTracking();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkEntity entity = (EclipseLinkEntity)this.getJavaPersistentType().getMapping();
        ChangeTracking contextChangeTracking = entity.getChangeTracking();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        ChangeTrackingAnnotation resourceChangeTracking = (ChangeTrackingAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        EclipseLinkJavaEntityTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEntityTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO);
        EclipseLinkJavaEntityTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEntityTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.ATTRIBUTE);
        EclipseLinkJavaEntityTests.assertEquals((Object)ChangeTrackingType.ATTRIBUTE, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEntityTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.ATTRIBUTE, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.OBJECT);
        EclipseLinkJavaEntityTests.assertEquals((Object)ChangeTrackingType.OBJECT, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEntityTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.OBJECT, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.DEFERRED);
        EclipseLinkJavaEntityTests.assertEquals((Object)ChangeTrackingType.DEFERRED, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEntityTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.DEFERRED, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(null);
        EclipseLinkJavaEntityTests.assertNull((Object)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ChangeTracking"));
        EclipseLinkJavaEntityTests.assertNull((Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO);
        resourceChangeTracking = (ChangeTrackingAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        EclipseLinkJavaEntityTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEntityTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
    }

    public void testGetReadOnly() throws Exception {
        this.createTestEntityWithReadOnly();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkEntity mappedSuperclass = (EclipseLinkEntity)this.getJavaPersistentType().getMapping();
        ReadOnly readOnly = mappedSuperclass.getReadOnly();
        EclipseLinkJavaEntityTests.assertEquals((boolean)true, (boolean)readOnly.isReadOnly());
    }

    public void testGetSpecifiedReadOnly() throws Exception {
        this.createTestEntityWithReadOnly();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkEntity mappedSuperclass = (EclipseLinkEntity)this.getJavaPersistentType().getMapping();
        ReadOnly readOnly = mappedSuperclass.getReadOnly();
        EclipseLinkJavaEntityTests.assertEquals((Object)Boolean.TRUE, (Object)readOnly.getSpecifiedReadOnly());
    }

    public void testGetDefaultReadOnly() throws Exception {
        this.createTestEntityWithReadOnly();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkEntity mappedSuperclass = (EclipseLinkEntity)this.getJavaPersistentType().getMapping();
        ReadOnly readOnly = mappedSuperclass.getReadOnly();
        EclipseLinkJavaEntityTests.assertEquals((boolean)false, (boolean)readOnly.isDefaultReadOnly());
    }

    public void testSetSpecifiedReadOnly() throws Exception {
        this.createTestEntityWithReadOnly();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkEntity mappedSuperclass = (EclipseLinkEntity)this.getJavaPersistentType().getMapping();
        ReadOnly readOnly = mappedSuperclass.getReadOnly();
        EclipseLinkJavaEntityTests.assertEquals((boolean)true, (boolean)readOnly.isReadOnly());
        readOnly.setSpecifiedReadOnly(Boolean.FALSE);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        EclipseLinkJavaEntityTests.assertNull((Object)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ReadOnly"));
        EclipseLinkJavaEntityTests.assertEquals(null, (Object)readOnly.getSpecifiedReadOnly());
        readOnly.setSpecifiedReadOnly(Boolean.TRUE);
        EclipseLinkJavaEntityTests.assertNotNull((Object)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ReadOnly"));
        EclipseLinkJavaEntityTests.assertEquals((Object)Boolean.TRUE, (Object)readOnly.getSpecifiedReadOnly());
        readOnly.setSpecifiedReadOnly(null);
        EclipseLinkJavaEntityTests.assertNull((Object)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ReadOnly"));
        EclipseLinkJavaEntityTests.assertEquals(null, (Object)readOnly.getSpecifiedReadOnly());
    }

    public void testSpecifiedReadOnlyUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithReadOnly();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkEntity mappedSuperclass = (EclipseLinkEntity)this.getJavaPersistentType().getMapping();
        ReadOnly readOnly = mappedSuperclass.getReadOnly();
        EclipseLinkJavaEntityTests.assertEquals((Object)Boolean.TRUE, (Object)readOnly.getSpecifiedReadOnly());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        typeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.ReadOnly");
        EclipseLinkJavaEntityTests.assertEquals(null, (Object)readOnly.getSpecifiedReadOnly());
        EclipseLinkJavaEntityTests.assertEquals((boolean)false, (boolean)readOnly.isDefaultReadOnly());
        typeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.ReadOnly");
        EclipseLinkJavaEntityTests.assertEquals((Object)Boolean.TRUE, (Object)readOnly.getSpecifiedReadOnly());
    }
}

