/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.ChangeTracking;
import org.eclipse.jpt.eclipselink.core.context.Customizer;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkEmbeddable;
import org.eclipse.jpt.eclipselink.core.resource.java.ChangeTrackingAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.ChangeTrackingType;
import org.eclipse.jpt.eclipselink.core.resource.java.CustomizerAnnotation;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkJavaEmbeddableTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEmbeddableWithConvertAndCustomizerClass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Embeddable", "org.eclipse.persistence.annotations.Customizer"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Embeddable").append(CR);
                sb.append("    @Customizer(Foo.class");
            }
        });
    }

    private ICompilationUnit createTestEmbeddableWithChangeTracking() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Embeddable", "org.eclipse.persistence.annotations.ChangeTracking"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Embeddable").append(CR);
                sb.append("    @ChangeTracking").append(CR);
            }
        });
    }

    public EclipseLinkJavaEmbeddableTests(String name) {
        super(name);
    }

    public void testGetCustomizerClass() throws Exception {
        this.createTestEmbeddableWithConvertAndCustomizerClass();
        this.addXmlClassRef("test.AnnotationTestType");
        Customizer customizer = ((EclipseLinkEmbeddable)this.getJavaPersistentType().getMapping()).getCustomizer();
        EclipseLinkJavaEmbeddableTests.assertEquals((String)"Foo", (String)customizer.getSpecifiedCustomizerClass());
    }

    public void testSetCustomizerClass() throws Exception {
        this.createTestEmbeddableWithConvertAndCustomizerClass();
        this.addXmlClassRef("test.AnnotationTestType");
        Customizer customizer = ((EclipseLinkEmbeddable)this.getJavaPersistentType().getMapping()).getCustomizer();
        EclipseLinkJavaEmbeddableTests.assertEquals((String)"Foo", (String)customizer.getSpecifiedCustomizerClass());
        customizer.setSpecifiedCustomizerClass("Bar");
        EclipseLinkJavaEmbeddableTests.assertEquals((String)"Bar", (String)customizer.getSpecifiedCustomizerClass());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        CustomizerAnnotation customizerAnnotation = (CustomizerAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLinkJavaEmbeddableTests.assertEquals((String)"Bar", (String)customizerAnnotation.getValue());
        customizer.setSpecifiedCustomizerClass(null);
        EclipseLinkJavaEmbeddableTests.assertEquals(null, (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation = (CustomizerAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLinkJavaEmbeddableTests.assertEquals(null, (Object)customizerAnnotation);
        customizer.setSpecifiedCustomizerClass("Bar");
        EclipseLinkJavaEmbeddableTests.assertEquals((String)"Bar", (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation = (CustomizerAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLinkJavaEmbeddableTests.assertEquals((String)"Bar", (String)customizerAnnotation.getValue());
    }

    public void testGetCustomizerClassUpdatesFromResourceModelChange() throws Exception {
        this.createTestEmbeddableWithConvertAndCustomizerClass();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkEmbeddable embeddable = (EclipseLinkEmbeddable)this.getJavaPersistentType().getMapping();
        Customizer customizer = embeddable.getCustomizer();
        EclipseLinkJavaEmbeddableTests.assertEquals((String)"Foo", (String)customizer.getSpecifiedCustomizerClass());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        CustomizerAnnotation customizerAnnotation = (CustomizerAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Customizer");
        customizerAnnotation.setValue("Bar");
        EclipseLinkJavaEmbeddableTests.assertEquals((String)"Bar", (String)customizer.getSpecifiedCustomizerClass());
        typeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLinkJavaEmbeddableTests.assertEquals(null, (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation = (CustomizerAnnotation)typeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLinkJavaEmbeddableTests.assertEquals(null, (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation.setValue("FooBar");
        EclipseLinkJavaEmbeddableTests.assertEquals((String)"FooBar", (String)customizer.getSpecifiedCustomizerClass());
    }

    public void testGetChangeTracking() throws Exception {
        this.createTestEmbeddableWithChangeTracking();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkEmbeddable embeddable = (EclipseLinkEmbeddable)this.getJavaPersistentType().getMapping();
        ChangeTracking contextChangeTracking = embeddable.getChangeTracking();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        ChangeTrackingAnnotation resourceChangeTracking = (ChangeTrackingAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        EclipseLinkJavaEmbeddableTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.ATTRIBUTE);
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)ChangeTrackingType.ATTRIBUTE, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.ATTRIBUTE, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.ATTRIBUTE, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.OBJECT);
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)ChangeTrackingType.OBJECT, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.OBJECT, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.OBJECT, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.DEFERRED);
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)ChangeTrackingType.DEFERRED, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.DEFERRED, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.DEFERRED, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.AUTO);
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(null);
        EclipseLinkJavaEmbeddableTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        typeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        EclipseLinkJavaEmbeddableTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEmbeddableTests.assertNull((Object)contextChangeTracking.getSpecifiedType());
    }

    public void testSetChangeTracking() throws Exception {
        this.createTestEmbeddableWithChangeTracking();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkEmbeddable embeddable = (EclipseLinkEmbeddable)this.getJavaPersistentType().getMapping();
        ChangeTracking contextChangeTracking = embeddable.getChangeTracking();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        ChangeTrackingAnnotation resourceChangeTracking = (ChangeTrackingAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        EclipseLinkJavaEmbeddableTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO);
        EclipseLinkJavaEmbeddableTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.ATTRIBUTE);
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)ChangeTrackingType.ATTRIBUTE, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.ATTRIBUTE, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.OBJECT);
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)ChangeTrackingType.OBJECT, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.OBJECT, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.DEFERRED);
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)ChangeTrackingType.DEFERRED, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.DEFERRED, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(null);
        EclipseLinkJavaEmbeddableTests.assertNull((Object)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ChangeTracking"));
        EclipseLinkJavaEmbeddableTests.assertNull((Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO);
        resourceChangeTracking = (ChangeTrackingAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
    }
}

