/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context;

import org.eclipse.core.resources.IProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.resource.orm.OrmXmlResourceProvider;
import org.eclipse.jpt.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.eclipselink.core.internal.JptEclipseLinkCorePlugin;
import org.eclipse.jpt.eclipselink.core.internal.resource.orm.EclipseLinkOrmXmlResourceProvider;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkJpaProjectTests
extends EclipseLinkContextModelTestCase {
    public EclipseLinkJpaProjectTests(String name) {
        super(name);
    }

    public void testGetDefaultOrmXmlResource() throws Exception {
        JpaXmlResource resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLinkJpaProjectTests.assertNull((Object)resource);
        this.createDefaultOrmXmlFileWithEclipseLinkContentType();
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLinkJpaProjectTests.assertNotNull((Object)resource);
        EclipseLinkJpaProjectTests.assertEquals((Object)JptEclipseLinkCorePlugin.ECLIPSELINK_ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        EclipseLinkJpaProjectTests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLinkJpaProjectTests.assertNull((Object)resource);
        this.createDefaultOrmXmlFile();
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLinkJpaProjectTests.assertNotNull((Object)resource);
        EclipseLinkJpaProjectTests.assertEquals((Object)JptCorePlugin.ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        EclipseLinkJpaProjectTests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
    }

    public void testGetDefaultEclipseLinkOrmXmlResource() throws Exception {
        JpaXmlResource resource = this.getJpaProject().getDefaultEclipseLinkOrmXmlResource();
        EclipseLinkJpaProjectTests.assertNull((Object)resource);
        this.createDefaultEclipseLinkOrmXmlFile();
        resource = this.getJpaProject().getDefaultEclipseLinkOrmXmlResource();
        EclipseLinkJpaProjectTests.assertNotNull((Object)resource);
        EclipseLinkJpaProjectTests.assertEquals((Object)JptEclipseLinkCorePlugin.ECLIPSELINK_ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        EclipseLinkJpaProjectTests.assertEquals((String)"src/META-INF/eclipselink-orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getDefaultEclipseLinkOrmXmlResource();
        EclipseLinkJpaProjectTests.assertNull((Object)resource);
    }

    private void createDefaultOrmXmlFileWithEclipseLinkContentType() throws Exception {
        EclipseLinkOrmXmlResourceProvider resourceProvider = EclipseLinkOrmXmlResourceProvider.getXmlResourceProvider((IProject)this.getJavaProject().getProject(), (String)"META-INF/orm.xml");
        resourceProvider.createFileAndResource();
    }

    private void createDefaultOrmXmlFile() throws Exception {
        OrmXmlResourceProvider resourceProvider = OrmXmlResourceProvider.getDefaultXmlResourceProvider((IProject)this.getJavaProject().getProject());
        resourceProvider.createFileAndResource();
    }

    private void createDefaultEclipseLinkOrmXmlFile() throws Exception {
        EclipseLinkOrmXmlResourceProvider resourceProvider = EclipseLinkOrmXmlResourceProvider.getDefaultXmlResourceProvider((IProject)this.getJavaProject().getProject());
        resourceProvider.createFileAndResource();
    }

    private void createEclipseLinkOrmXmlFile(String filePath) throws Exception {
        EclipseLinkOrmXmlResourceProvider resourceProvider = EclipseLinkOrmXmlResourceProvider.getXmlResourceProvider((IProject)this.getJavaProject().getProject(), (String)filePath);
        resourceProvider.createFileAndResource();
    }

    public void testGetMappingFileResource() throws Exception {
        JpaXmlResource resource = this.getJpaProject().getMappingFileXmlResource("META-INF/eclipselink-orm.xml");
        EclipseLinkJpaProjectTests.assertNull((Object)resource);
        this.createDefaultEclipseLinkOrmXmlFile();
        resource = this.getJpaProject().getMappingFileXmlResource("META-INF/eclipselink-orm.xml");
        EclipseLinkJpaProjectTests.assertNotNull((Object)resource);
        EclipseLinkJpaProjectTests.assertEquals((Object)JptEclipseLinkCorePlugin.ECLIPSELINK_ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        EclipseLinkJpaProjectTests.assertEquals((String)"src/META-INF/eclipselink-orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getMappingFileXmlResource("META-INF/eclipselink-orm.xml");
        EclipseLinkJpaProjectTests.assertNull((Object)resource);
    }

    public void testGetDifferentlyNamedMappingFileResource() throws Exception {
        JpaXmlResource resource = this.getJpaProject().getMappingFileXmlResource("META-INF/orm2.xml");
        EclipseLinkJpaProjectTests.assertNull((Object)resource);
        this.createEclipseLinkOrmXmlFile("META-INF/orm2.xml");
        resource = this.getJpaProject().getMappingFileXmlResource("META-INF/orm2.xml");
        EclipseLinkJpaProjectTests.assertNotNull((Object)resource);
        EclipseLinkJpaProjectTests.assertEquals((Object)JptEclipseLinkCorePlugin.ECLIPSELINK_ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        EclipseLinkJpaProjectTests.assertEquals((String)"src/META-INF/orm2.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getMappingFileXmlResource("META-INF/orm2.xml");
        EclipseLinkJpaProjectTests.assertNull((Object)resource);
        this.createEclipseLinkOrmXmlFile("META-INF/orm2.xml");
        resource = this.getJpaProject().getMappingFileXmlResource("META-INF/orm2.xml");
        EclipseLinkJpaProjectTests.assertNotNull((Object)resource);
        EclipseLinkJpaProjectTests.assertEquals((Object)JptEclipseLinkCorePlugin.ECLIPSELINK_ORM_XML_CONTENT_TYPE, (Object)resource.getContentType());
        EclipseLinkJpaProjectTests.assertEquals((String)"src/META-INF/orm2.xml", (String)resource.getFile().getProjectRelativePath().toString());
    }
}

