/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.core.context.orm.OrmJoinTable;
import org.eclipse.jpt.core.context.orm.OrmJoinTableEnabledRelationshipReference;
import org.eclipse.jpt.core.context.orm.OrmJoinTableJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmRelationshipMapping;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlJoinTable;
import org.eclipse.jpt.core.resource.orm.XmlJoinTableImpl;
import org.eclipse.jpt.core.resource.orm.XmlJoinTableMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmJoinTableJoiningStrategy
extends AbstractXmlContextNode
implements OrmJoinTableJoiningStrategy {
    protected XmlJoinTableMapping resource;
    protected OrmJoinTable joinTable;

    public GenericOrmJoinTableJoiningStrategy(OrmJoinTableEnabledRelationshipReference parent, XmlJoinTableMapping resource) {
        super(parent);
        this.resource = resource;
    }

    @Override
    public OrmJoinTableEnabledRelationshipReference getParent() {
        return (OrmJoinTableEnabledRelationshipReference)super.getParent();
    }

    @Override
    public OrmJoinTableEnabledRelationshipReference getRelationshipReference() {
        return this.getParent();
    }

    public OrmRelationshipMapping getRelationshipMapping() {
        return this.getRelationshipReference().getRelationshipMapping();
    }

    @Override
    public void addStrategy() {
        if (this.joinTable == null) {
            this.setJoinTable_(this.getJpaFactory().buildOrmJoinTable(this, this.resource));
            this.addJoinTableResource();
        }
    }

    @Override
    public void removeStrategy() {
        if (this.joinTable != null) {
            this.setJoinTable_(null);
            this.removeJoinTableResource();
        }
    }

    @Override
    public OrmJoinTable getJoinTable() {
        return this.joinTable;
    }

    @Override
    public OrmJoinTable addJoinTable() {
        this.addStrategy();
        return this.joinTable;
    }

    protected void setJoinTable_(OrmJoinTable newJoinTable) {
        OrmJoinTable oldJoinTable = this.joinTable;
        this.joinTable = newJoinTable;
        this.firePropertyChanged("joinTable", oldJoinTable, newJoinTable);
    }

    protected XmlJoinTable addJoinTableResource() {
        XmlJoinTableImpl resourceTable = OrmFactory.eINSTANCE.createXmlJoinTableImpl();
        this.resource.setJoinTable(resourceTable);
        return resourceTable;
    }

    protected void removeJoinTableResource() {
        this.resource.setJoinTable(null);
    }

    protected boolean mayHaveJoinTable() {
        return this.getJoinTableResource() != null || this.getRelationshipReference().mayHaveDefaultJoinTable();
    }

    protected XmlJoinTable getJoinTableResource() {
        return this.resource.getJoinTable();
    }

    @Override
    public void update() {
        if (this.mayHaveJoinTable()) {
            if (this.joinTable == null) {
                this.setJoinTable_(this.getJpaFactory().buildOrmJoinTable(this, this.resource));
            }
            this.joinTable.update();
        } else if (this.joinTable != null) {
            this.setJoinTable_(null);
        }
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.joinTable != null && this.getRelationshipMapping().shouldValidateAgainstDatabase()) {
            this.joinTable.validate(messages, reporter);
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getRelationshipReference().getValidationTextRange();
    }
}

