/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.JpaValidation;
import org.eclipse.jpt.core.context.AssociationOverride;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.BaseOverride;
import org.eclipse.jpt.core.context.ColumnMapping;
import org.eclipse.jpt.core.context.DiscriminatorColumn;
import org.eclipse.jpt.core.context.DiscriminatorType;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.Generator;
import org.eclipse.jpt.core.context.InheritanceType;
import org.eclipse.jpt.core.context.NamedNativeQuery;
import org.eclipse.jpt.core.context.NamedQuery;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.Query;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.SecondaryTable;
import org.eclipse.jpt.core.context.Table;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaAssociationOverride;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.java.JavaBaseJoinColumn;
import org.eclipse.jpt.core.context.java.JavaDiscriminatorColumn;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.context.java.JavaGenerator;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.context.java.JavaNamedNativeQuery;
import org.eclipse.jpt.core.context.java.JavaNamedQuery;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.java.JavaQuery;
import org.eclipse.jpt.core.context.java.JavaSecondaryTable;
import org.eclipse.jpt.core.context.java.JavaSequenceGenerator;
import org.eclipse.jpt.core.context.java.JavaTable;
import org.eclipse.jpt.core.context.java.JavaTableGenerator;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaTypeMapping;
import org.eclipse.jpt.core.internal.context.java.VirtualAttributeOverrideAnnotation;
import org.eclipse.jpt.core.internal.resource.java.NullAssociationOverrideAnnotation;
import org.eclipse.jpt.core.internal.resource.java.NullPrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.AssociationOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.DiscriminatorValueAnnotation;
import org.eclipse.jpt.core.resource.java.EntityAnnotation;
import org.eclipse.jpt.core.resource.java.IdClassAnnotation;
import org.eclipse.jpt.core.resource.java.InheritanceAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.NamedNativeQueryAnnotation;
import org.eclipse.jpt.core.resource.java.NamedQueryAnnotation;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.SecondaryTableAnnotation;
import org.eclipse.jpt.core.resource.java.SequenceGeneratorAnnotation;
import org.eclipse.jpt.core.resource.java.TableGeneratorAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.DatabaseObject;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaEntity
extends AbstractJavaTypeMapping
implements JavaEntity {
    protected String specifiedName;
    protected String defaultName;
    protected final JavaTable table = this.getJpaFactory().buildJavaTable(this);
    protected boolean specifiedTableIsAllowed;
    protected boolean tableIsUndefined;
    protected final List<JavaSecondaryTable> specifiedSecondaryTables;
    protected final List<JavaPrimaryKeyJoinColumn> specifiedPrimaryKeyJoinColumns;
    protected JavaPrimaryKeyJoinColumn defaultPrimaryKeyJoinColumn;
    protected InheritanceType specifiedInheritanceStrategy;
    protected InheritanceType defaultInheritanceStrategy;
    protected String defaultDiscriminatorValue;
    protected String specifiedDiscriminatorValue;
    protected boolean specifiedDiscriminatorValueIsAllowed;
    protected boolean discriminatorValueIsUndefined;
    protected final JavaDiscriminatorColumn discriminatorColumn = this.buildJavaDiscriminatorColumn();
    protected boolean specifiedDiscriminatorColumnIsAllowed;
    protected boolean discriminatorColumnIsUndefined;
    protected JavaSequenceGenerator sequenceGenerator;
    protected JavaTableGenerator tableGenerator;
    protected final List<JavaAttributeOverride> specifiedAttributeOverrides;
    protected final List<JavaAttributeOverride> virtualAttributeOverrides;
    protected final List<JavaAssociationOverride> specifiedAssociationOverrides;
    protected final List<JavaAssociationOverride> virtualAssociationOverrides;
    protected final List<JavaNamedQuery> namedQueries;
    protected final List<JavaNamedNativeQuery> namedNativeQueries;
    protected String idClass;
    protected Entity rootEntity;
    private static final org.eclipse.jpt.db.Table[] EMPTY_DB_TABLE_ARRAY = new org.eclipse.jpt.db.Table[0];

    protected AbstractJavaEntity(JavaPersistentType parent) {
        super(parent);
        this.specifiedSecondaryTables = new ArrayList<JavaSecondaryTable>();
        this.specifiedPrimaryKeyJoinColumns = new ArrayList<JavaPrimaryKeyJoinColumn>();
        this.specifiedAttributeOverrides = new ArrayList<JavaAttributeOverride>();
        this.virtualAttributeOverrides = new ArrayList<JavaAttributeOverride>();
        this.namedQueries = new ArrayList<JavaNamedQuery>();
        this.namedNativeQueries = new ArrayList<JavaNamedNativeQuery>();
        this.specifiedAssociationOverrides = new ArrayList<JavaAssociationOverride>();
        this.virtualAssociationOverrides = new ArrayList<JavaAssociationOverride>();
    }

    protected JavaBaseJoinColumn.Owner createPrimaryKeyJoinColumnOwner() {
        return new PrimaryKeyJoinColumnOwner();
    }

    protected JavaDiscriminatorColumn buildJavaDiscriminatorColumn() {
        return this.getJpaFactory().buildJavaDiscriminatorColumn(this, this.buildDiscriminatorColumnOwner());
    }

    protected JavaDiscriminatorColumn.Owner buildDiscriminatorColumnOwner() {
        return new JavaDiscriminatorColumn.Owner(){

            public org.eclipse.jpt.db.Table getDbTable(String tableName) {
                return AbstractJavaEntity.this.getDbTable(tableName);
            }

            public TextRange getValidationTextRange(CompilationUnit astRoot) {
                return AbstractJavaEntity.this.getValidationTextRange(astRoot);
            }

            public TypeMapping getTypeMapping() {
                return AbstractJavaEntity.this;
            }

            public String getDefaultColumnName() {
                return AbstractJavaEntity.this.isDescendant() ? AbstractJavaEntity.this.getRootEntity().getDiscriminatorColumn().getName() : (AbstractJavaEntity.this.discriminatorColumnIsUndefined() ? null : "DTYPE");
            }

            public int getDefaultLength() {
                return AbstractJavaEntity.this.isDescendant() ? AbstractJavaEntity.this.getRootEntity().getDiscriminatorColumn().getLength() : (AbstractJavaEntity.this.discriminatorColumnIsUndefined() ? 0 : 31);
            }

            public DiscriminatorType getDefaultDiscriminatorType() {
                return AbstractJavaEntity.this.isDescendant() ? AbstractJavaEntity.this.getRootEntity().getDiscriminatorColumn().getDiscriminatorType() : (AbstractJavaEntity.this.discriminatorColumnIsUndefined() ? null : DiscriminatorColumn.DEFAULT_DISCRIMINATOR_TYPE);
            }
        };
    }

    @Override
    public void initialize(JavaResourcePersistentType resourcePersistentType) {
        super.initialize(resourcePersistentType);
        this.specifiedName = this.getResourceName();
        this.defaultName = this.getResourceDefaultName();
        this.rootEntity = this.calculateRootEntity();
        this.defaultInheritanceStrategy = this.buildDefaultInheritanceStrategy();
        this.specifiedInheritanceStrategy = this.getResourceInheritanceStrategy(this.getResourceInheritance());
        this.specifiedDiscriminatorValueIsAllowed = this.buildSpecifiedDiscriminatorValueIsAllowed();
        this.discriminatorValueIsUndefined = this.buildDiscriminatorValueIsUndefined();
        this.specifiedDiscriminatorValue = this.getResourceDiscriminatorValue().getValue();
        this.defaultDiscriminatorValue = this.buildDefaultDiscriminatorValue();
        this.specifiedDiscriminatorColumnIsAllowed = this.buildSpecifiedDiscriminatorColumnIsAllowed();
        this.discriminatorColumnIsUndefined = this.buildDiscriminatorColumnIsUndefined();
        this.discriminatorColumn.initialize(resourcePersistentType);
        this.specifiedTableIsAllowed = this.buildSpecifiedTableIsAllowed();
        this.tableIsUndefined = this.buildTableIsUndefined();
        this.table.initialize(resourcePersistentType);
        this.initializeSecondaryTables();
        this.initializeTableGenerator();
        this.initializeSequenceGenerator();
        this.initializePrimaryKeyJoinColumns();
        this.initializeDefaultPrimaryKeyJoinColumn();
        this.initializeSpecifiedAttributeOverrides();
        this.initializeVirtualAttributeOverrides();
        this.initializeSpecifiedAssociationOverrides();
        this.initializeDefaultAssociationOverrides();
        this.initializeNamedQueries();
        this.initializeNamedNativeQueries();
        this.initializeIdClass();
    }

    protected void initializeSecondaryTables() {
        ListIterator<NestableAnnotation> stream = this.javaResourcePersistentType.supportingAnnotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        while (stream.hasNext()) {
            this.specifiedSecondaryTables.add(this.buildSecondaryTable((SecondaryTableAnnotation)((Object)stream.next())));
        }
    }

    protected void initializeTableGenerator() {
        TableGeneratorAnnotation tableGeneratorResource = this.getResourceTableGenerator();
        if (tableGeneratorResource != null) {
            this.tableGenerator = this.buildTableGenerator(tableGeneratorResource);
        }
    }

    protected void initializeSequenceGenerator() {
        SequenceGeneratorAnnotation sequenceGeneratorResource = this.getResourceSequenceGenerator();
        if (sequenceGeneratorResource != null) {
            this.sequenceGenerator = this.buildSequenceGenerator(sequenceGeneratorResource);
        }
    }

    protected void initializePrimaryKeyJoinColumns() {
        ListIterator<NestableAnnotation> stream = this.javaResourcePersistentType.supportingAnnotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        while (stream.hasNext()) {
            this.specifiedPrimaryKeyJoinColumns.add(this.buildPrimaryKeyJoinColumn((PrimaryKeyJoinColumnAnnotation)((Object)stream.next())));
        }
    }

    protected boolean shouldBuildDefaultPrimaryKeyJoinColumn() {
        return !this.containsSpecifiedPrimaryKeyJoinColumns();
    }

    protected void initializeDefaultPrimaryKeyJoinColumn() {
        if (!this.shouldBuildDefaultPrimaryKeyJoinColumn()) {
            return;
        }
        this.defaultPrimaryKeyJoinColumn = this.buildPrimaryKeyJoinColumn(new NullPrimaryKeyJoinColumnAnnotation(this.javaResourcePersistentType));
    }

    protected void initializeSpecifiedAttributeOverrides() {
        ListIterator<NestableAnnotation> stream = this.javaResourcePersistentType.supportingAnnotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        while (stream.hasNext()) {
            this.specifiedAttributeOverrides.add(this.buildAttributeOverride((AttributeOverrideAnnotation)((Object)stream.next())));
        }
    }

    protected void initializeVirtualAttributeOverrides() {
        for (PersistentAttribute persistentAttribute : CollectionTools.iterable(this.allOverridableAttributes())) {
            JavaAttributeOverride attributeOverride = this.getAttributeOverrideNamed(persistentAttribute.getName());
            if (attributeOverride != null) continue;
            this.virtualAttributeOverrides.add(this.buildVirtualAttributeOverride(persistentAttribute));
        }
    }

    protected void initializeSpecifiedAssociationOverrides() {
        ListIterator<NestableAnnotation> stream = this.javaResourcePersistentType.supportingAnnotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        while (stream.hasNext()) {
            this.specifiedAssociationOverrides.add(this.buildAssociationOverride((AssociationOverrideAnnotation)((Object)stream.next())));
        }
    }

    protected void initializeDefaultAssociationOverrides() {
        Iterator<String> i = this.allOverridableAssociationNames();
        while (i.hasNext()) {
            String associationName = i.next();
            JavaAssociationOverride associationOverride = this.getAssociationOverrideNamed(associationName);
            if (associationOverride != null) continue;
            this.virtualAssociationOverrides.add(this.buildAssociationOverride(new NullAssociationOverrideAnnotation(this.javaResourcePersistentType, associationName)));
        }
    }

    protected void initializeNamedQueries() {
        ListIterator<NestableAnnotation> stream = this.javaResourcePersistentType.supportingAnnotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        while (stream.hasNext()) {
            this.namedQueries.add(this.buildNamedQuery((NamedQueryAnnotation)((Object)stream.next())));
        }
    }

    protected void initializeNamedNativeQueries() {
        ListIterator<NestableAnnotation> stream = this.javaResourcePersistentType.supportingAnnotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        while (stream.hasNext()) {
            this.namedNativeQueries.add(this.buildNamedNativeQuery((NamedNativeQueryAnnotation)((Object)stream.next())));
        }
    }

    protected InheritanceAnnotation getResourceInheritance() {
        return (InheritanceAnnotation)this.javaResourcePersistentType.getNonNullSupportingAnnotation("javax.persistence.Inheritance");
    }

    protected DiscriminatorValueAnnotation getResourceDiscriminatorValue() {
        return (DiscriminatorValueAnnotation)this.javaResourcePersistentType.getNonNullSupportingAnnotation("javax.persistence.DiscriminatorValue");
    }

    protected void initializeIdClass() {
        IdClassAnnotation resourceIdClass = this.getResourceIdClass();
        if (resourceIdClass != null) {
            this.idClass = resourceIdClass.getValue();
        }
    }

    @Override
    protected EntityAnnotation getResourceMappingAnnotation() {
        return (EntityAnnotation)super.getResourceMappingAnnotation();
    }

    @Override
    public String getKey() {
        return "entity";
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public String getPrimaryTableName() {
        return this.getTable().getName();
    }

    @Override
    public org.eclipse.jpt.db.Table getPrimaryDbTable() {
        return this.getTable().getDbTable();
    }

    @Override
    public org.eclipse.jpt.db.Table getDbTable(String tableName) {
        return (org.eclipse.jpt.db.Table)this.getDataSource().selectDatabaseObjectForIdentifier((DatabaseObject[])((org.eclipse.jpt.db.Table[])CollectionTools.array(this.associatedDbTablesIncludingInherited(), (Object[])EMPTY_DB_TABLE_ARRAY)), tableName);
    }

    protected Iterator<org.eclipse.jpt.db.Table> associatedDbTablesIncludingInherited() {
        return new FilteringIterator<org.eclipse.jpt.db.Table, org.eclipse.jpt.db.Table>(this.associatedDbTablesIncludingInherited_()){

            protected boolean accept(org.eclipse.jpt.db.Table t) {
                return t != null;
            }
        };
    }

    protected Iterator<org.eclipse.jpt.db.Table> associatedDbTablesIncludingInherited_() {
        return new TransformationIterator<Table, org.eclipse.jpt.db.Table>(this.associatedTablesIncludingInherited()){

            protected org.eclipse.jpt.db.Table transform(Table t) {
                return t.getDbTable();
            }
        };
    }

    @Override
    public Schema getDbSchema() {
        return this.getTable().getDbSchema();
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.Entity";
    }

    @Override
    public Iterator<String> correspondingAnnotationNames() {
        return new ArrayIterator((Object[])new String[]{"javax.persistence.Table", "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables", "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns", "javax.persistence.IdClass", "javax.persistence.Inheritance", "javax.persistence.DiscriminatorValue", "javax.persistence.DiscriminatorColumn", "javax.persistence.SequenceGenerator", "javax.persistence.TableGenerator", "javax.persistence.NamedQuery", "javax.persistence.NamedQueries", "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries", "javax.persistence.SqlResultSetMapping", "javax.persistence.ExcludeDefaultListeners", "javax.persistence.ExcludeSuperclassListeners", "javax.persistence.EntityListeners", "javax.persistence.PrePersist", "javax.persistence.PostPersist", "javax.persistence.PreRemove", "javax.persistence.PostRemove", "javax.persistence.PreUpdate", "javax.persistence.PostUpdate", "javax.persistence.PostLoad", "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides", "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides"});
    }

    @Override
    public String getName() {
        return this.getSpecifiedName() == null ? this.getDefaultName() : this.getSpecifiedName();
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        this.getResourceMappingAnnotation().setName(newSpecifiedName);
        this.firePropertyChanged("specifiedName", oldSpecifiedName, newSpecifiedName);
    }

    protected void setSpecifiedName_(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        this.firePropertyChanged("specifiedName", oldSpecifiedName, newSpecifiedName);
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String newDefaultName) {
        String oldDefaultName = this.defaultName;
        this.defaultName = newDefaultName;
        this.firePropertyChanged("defaultName", oldDefaultName, newDefaultName);
    }

    @Override
    public JavaTable getTable() {
        return this.table;
    }

    @Override
    public ListIterator<JavaSecondaryTable> specifiedSecondaryTables() {
        return new CloneListIterator(this.specifiedSecondaryTables);
    }

    @Override
    public int specifiedSecondaryTablesSize() {
        return this.specifiedSecondaryTables.size();
    }

    @Override
    public JavaSecondaryTable addSpecifiedSecondaryTable(int index) {
        JavaSecondaryTable secondaryTable = this.getJpaFactory().buildJavaSecondaryTable(this);
        this.specifiedSecondaryTables.add(index, secondaryTable);
        SecondaryTableAnnotation secondaryTableResource = (SecondaryTableAnnotation)this.javaResourcePersistentType.addSupportingAnnotation(index, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        secondaryTable.initialize(secondaryTableResource);
        this.fireItemAdded("specifiedSecondaryTables", index, secondaryTable);
        return secondaryTable;
    }

    @Override
    public JavaSecondaryTable addSpecifiedSecondaryTable() {
        return this.addSpecifiedSecondaryTable(this.specifiedSecondaryTables.size());
    }

    protected void addSpecifiedSecondaryTable(int index, JavaSecondaryTable secondaryTable) {
        this.addItemToList(index, secondaryTable, this.specifiedSecondaryTables, "specifiedSecondaryTables");
    }

    protected void addSpecifiedSecondaryTable(JavaSecondaryTable secondaryTable) {
        this.addSpecifiedSecondaryTable(this.specifiedSecondaryTables.size(), secondaryTable);
    }

    @Override
    public void removeSpecifiedSecondaryTable(SecondaryTable secondaryTable) {
        this.removeSpecifiedSecondaryTable(this.specifiedSecondaryTables.indexOf(secondaryTable));
    }

    @Override
    public void removeSpecifiedSecondaryTable(int index) {
        JavaSecondaryTable removedSecondaryTable = this.specifiedSecondaryTables.remove(index);
        this.javaResourcePersistentType.removeSupportingAnnotation(index, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        this.fireItemRemoved("specifiedSecondaryTables", index, removedSecondaryTable);
    }

    protected void removeSpecifiedSecondaryTable_(JavaSecondaryTable secondaryTable) {
        this.removeItemFromList(secondaryTable, this.specifiedSecondaryTables, "specifiedSecondaryTables");
    }

    @Override
    public void moveSpecifiedSecondaryTable(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedSecondaryTables, (int)targetIndex, (int)sourceIndex);
        this.javaResourcePersistentType.moveSupportingAnnotation(targetIndex, sourceIndex, "javax.persistence.SecondaryTables");
        this.fireItemMoved("specifiedSecondaryTables", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<JavaSecondaryTable> secondaryTables() {
        return this.specifiedSecondaryTables();
    }

    @Override
    public int secondaryTablesSize() {
        return this.specifiedSecondaryTablesSize();
    }

    @Override
    public InheritanceType getInheritanceStrategy() {
        return this.getSpecifiedInheritanceStrategy() == null ? this.getDefaultInheritanceStrategy() : this.getSpecifiedInheritanceStrategy();
    }

    @Override
    public InheritanceType getDefaultInheritanceStrategy() {
        return this.defaultInheritanceStrategy;
    }

    protected void setDefaultInheritanceStrategy(InheritanceType newInheritanceType) {
        InheritanceType oldInheritanceType = this.defaultInheritanceStrategy;
        this.defaultInheritanceStrategy = newInheritanceType;
        this.firePropertyChanged("defaultInheritanceStrategy", (Object)oldInheritanceType, (Object)newInheritanceType);
    }

    @Override
    public InheritanceType getSpecifiedInheritanceStrategy() {
        return this.specifiedInheritanceStrategy;
    }

    @Override
    public void setSpecifiedInheritanceStrategy(InheritanceType newInheritanceType) {
        InheritanceType oldInheritanceType = this.specifiedInheritanceStrategy;
        this.specifiedInheritanceStrategy = newInheritanceType;
        this.getResourceInheritance().setStrategy(InheritanceType.toJavaResourceModel(newInheritanceType));
        this.firePropertyChanged("specifiedInheritanceStrategy", (Object)oldInheritanceType, (Object)newInheritanceType);
    }

    protected void setSpecifiedInheritanceStrategy_(InheritanceType newInheritanceType) {
        InheritanceType oldInheritanceType = this.specifiedInheritanceStrategy;
        this.specifiedInheritanceStrategy = newInheritanceType;
        this.firePropertyChanged("specifiedInheritanceStrategy", (Object)oldInheritanceType, (Object)newInheritanceType);
    }

    @Override
    public JavaDiscriminatorColumn getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    @Override
    public String getDefaultDiscriminatorValue() {
        return this.defaultDiscriminatorValue;
    }

    protected void setDefaultDiscriminatorValue(String newDefaultDiscriminatorValue) {
        String oldDefaultDiscriminatorValue = this.defaultDiscriminatorValue;
        this.defaultDiscriminatorValue = newDefaultDiscriminatorValue;
        this.firePropertyChanged("defaultDiscriminatorValue", oldDefaultDiscriminatorValue, newDefaultDiscriminatorValue);
    }

    @Override
    public String getSpecifiedDiscriminatorValue() {
        return this.specifiedDiscriminatorValue;
    }

    @Override
    public void setSpecifiedDiscriminatorValue(String newSpecifiedDiscriminatorValue) {
        String oldSpecifiedDiscriminatorValue = this.specifiedDiscriminatorValue;
        this.specifiedDiscriminatorValue = newSpecifiedDiscriminatorValue;
        this.getResourceDiscriminatorValue().setValue(newSpecifiedDiscriminatorValue);
        this.firePropertyChanged("specifiedDiscriminatorValue", oldSpecifiedDiscriminatorValue, newSpecifiedDiscriminatorValue);
    }

    protected void setSpecifiedDiscriminatorValue_(String newSpecifiedDiscriminatorValue) {
        String oldSpecifiedDiscriminatorValue = this.specifiedDiscriminatorValue;
        this.specifiedDiscriminatorValue = newSpecifiedDiscriminatorValue;
        this.firePropertyChanged("specifiedDiscriminatorValue", oldSpecifiedDiscriminatorValue, newSpecifiedDiscriminatorValue);
    }

    @Override
    public String getDiscriminatorValue() {
        return this.getSpecifiedDiscriminatorValue() == null ? this.getDefaultDiscriminatorValue() : this.getSpecifiedDiscriminatorValue();
    }

    @Override
    public boolean specifiedDiscriminatorValueIsAllowed() {
        return this.specifiedDiscriminatorValueIsAllowed;
    }

    protected void setSpecifiedDiscriminatorValueIsAllowed(boolean specifiedDiscriminatorValueIsAllowed) {
        boolean old = this.specifiedDiscriminatorValueIsAllowed;
        this.specifiedDiscriminatorValueIsAllowed = specifiedDiscriminatorValueIsAllowed;
        this.firePropertyChanged("discriminatorValueIsAllowed", old, specifiedDiscriminatorValueIsAllowed);
    }

    @Override
    public boolean discriminatorValueIsUndefined() {
        return this.discriminatorValueIsUndefined;
    }

    protected void setDiscriminatorValueIsUndefined(boolean discriminatorValueIsUndefined) {
        boolean old = this.discriminatorValueIsUndefined;
        this.discriminatorValueIsUndefined = discriminatorValueIsUndefined;
        this.firePropertyChanged("discriminatorValueIsUndefined", old, discriminatorValueIsUndefined);
    }

    @Override
    public boolean specifiedDiscriminatorColumnIsAllowed() {
        return this.specifiedDiscriminatorColumnIsAllowed;
    }

    protected void setSpecifiedDiscriminatorColumnIsAllowed(boolean specifiedDiscriminatorColumnIsAllowed) {
        boolean old = this.specifiedDiscriminatorColumnIsAllowed;
        this.specifiedDiscriminatorColumnIsAllowed = specifiedDiscriminatorColumnIsAllowed;
        this.firePropertyChanged("specifiedDiscriminatorColumnIsAllowed", old, specifiedDiscriminatorColumnIsAllowed);
    }

    @Override
    public boolean discriminatorColumnIsUndefined() {
        return this.discriminatorColumnIsUndefined;
    }

    protected void setDiscriminatorColumnIsUndefined(boolean discriminatorColumnIsUndefined) {
        boolean old = this.discriminatorColumnIsUndefined;
        this.discriminatorColumnIsUndefined = discriminatorColumnIsUndefined;
        this.firePropertyChanged("discriminatorColumnIsUndefined", old, discriminatorColumnIsUndefined);
    }

    @Override
    public boolean specifiedTableIsAllowed() {
        return this.specifiedTableIsAllowed;
    }

    protected void setSpecifiedTableIsAllowed(boolean specifiedTableIsAllowed) {
        boolean old = this.specifiedTableIsAllowed;
        this.specifiedTableIsAllowed = specifiedTableIsAllowed;
        this.firePropertyChanged("specifiedTableIsAllowed", old, specifiedTableIsAllowed);
    }

    @Override
    public boolean tableIsUndefined() {
        return this.tableIsUndefined;
    }

    protected void setTableIsUndefined(boolean tableIsUndefined) {
        boolean old = this.tableIsUndefined;
        this.tableIsUndefined = tableIsUndefined;
        this.firePropertyChanged("tableIsUndefined", old, tableIsUndefined);
    }

    @Override
    public JavaTableGenerator addTableGenerator() {
        if (this.getTableGenerator() != null) {
            throw new IllegalStateException("tableGenerator already exists");
        }
        this.tableGenerator = this.getJpaFactory().buildJavaTableGenerator(this);
        TableGeneratorAnnotation tableGeneratorResource = (TableGeneratorAnnotation)this.javaResourcePersistentType.addSupportingAnnotation("javax.persistence.TableGenerator");
        this.tableGenerator.initialize(tableGeneratorResource);
        this.firePropertyChanged("tableGenerator", null, this.tableGenerator);
        return this.tableGenerator;
    }

    @Override
    public void removeTableGenerator() {
        if (this.getTableGenerator() == null) {
            throw new IllegalStateException("tableGenerator does not exist, cannot be removed");
        }
        JavaTableGenerator oldTableGenerator = this.tableGenerator;
        this.tableGenerator = null;
        this.javaResourcePersistentType.removeSupportingAnnotation("javax.persistence.TableGenerator");
        this.firePropertyChanged("tableGenerator", oldTableGenerator, null);
    }

    @Override
    public JavaTableGenerator getTableGenerator() {
        return this.tableGenerator;
    }

    protected void setTableGenerator(JavaTableGenerator newTableGenerator) {
        JavaTableGenerator oldTableGenerator = this.tableGenerator;
        this.tableGenerator = newTableGenerator;
        this.firePropertyChanged("tableGenerator", oldTableGenerator, newTableGenerator);
    }

    @Override
    public JavaSequenceGenerator addSequenceGenerator() {
        if (this.getSequenceGenerator() != null) {
            throw new IllegalStateException("sequenceGenerator already exists");
        }
        this.sequenceGenerator = this.getJpaFactory().buildJavaSequenceGenerator(this);
        SequenceGeneratorAnnotation sequenceGeneratorResource = (SequenceGeneratorAnnotation)this.javaResourcePersistentType.addSupportingAnnotation("javax.persistence.SequenceGenerator");
        this.sequenceGenerator.initialize(sequenceGeneratorResource);
        this.firePropertyChanged("sequenceGenerator", null, this.sequenceGenerator);
        return this.sequenceGenerator;
    }

    @Override
    public void removeSequenceGenerator() {
        if (this.getSequenceGenerator() == null) {
            throw new IllegalStateException("sequenceGenerator does not exist, cannot be removed");
        }
        JavaSequenceGenerator oldSequenceGenerator = this.sequenceGenerator;
        this.sequenceGenerator = null;
        this.javaResourcePersistentType.removeSupportingAnnotation("javax.persistence.SequenceGenerator");
        this.firePropertyChanged("sequenceGenerator", oldSequenceGenerator, null);
    }

    @Override
    public JavaSequenceGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    protected void setSequenceGenerator(JavaSequenceGenerator newSequenceGenerator) {
        JavaSequenceGenerator oldSequenceGenerator = this.sequenceGenerator;
        this.sequenceGenerator = newSequenceGenerator;
        this.firePropertyChanged("sequenceGenerator", oldSequenceGenerator, newSequenceGenerator);
    }

    protected final Iterator<JavaGenerator> generators() {
        ArrayList<JavaGenerator> generators = new ArrayList<JavaGenerator>();
        this.addGeneratorsTo(generators);
        return generators.iterator();
    }

    protected void addGeneratorsTo(ArrayList<JavaGenerator> generators) {
        if (this.sequenceGenerator != null) {
            generators.add(this.sequenceGenerator);
        }
        if (this.tableGenerator != null) {
            generators.add(this.tableGenerator);
        }
    }

    @Override
    public ListIterator<JavaPrimaryKeyJoinColumn> primaryKeyJoinColumns() {
        return this.containsSpecifiedPrimaryKeyJoinColumns() ? this.specifiedPrimaryKeyJoinColumns() : this.defaultPrimaryKeyJoinColumns();
    }

    @Override
    public int primaryKeyJoinColumnsSize() {
        return this.containsSpecifiedPrimaryKeyJoinColumns() ? this.specifiedPrimaryKeyJoinColumnsSize() : this.defaultPrimaryKeyJoinColumnsSize();
    }

    @Override
    public ListIterator<JavaPrimaryKeyJoinColumn> specifiedPrimaryKeyJoinColumns() {
        return new CloneListIterator(this.specifiedPrimaryKeyJoinColumns);
    }

    @Override
    public int specifiedPrimaryKeyJoinColumnsSize() {
        return this.specifiedPrimaryKeyJoinColumns.size();
    }

    public boolean containsSpecifiedPrimaryKeyJoinColumns() {
        return !this.specifiedPrimaryKeyJoinColumns.isEmpty();
    }

    @Override
    public JavaPrimaryKeyJoinColumn getDefaultPrimaryKeyJoinColumn() {
        return this.defaultPrimaryKeyJoinColumn;
    }

    protected void setDefaultPrimaryKeyJoinColumn(JavaPrimaryKeyJoinColumn newPkJoinColumn) {
        JavaPrimaryKeyJoinColumn oldPkJoinColumn = this.defaultPrimaryKeyJoinColumn;
        this.defaultPrimaryKeyJoinColumn = newPkJoinColumn;
        this.firePropertyChanged("defaultPrimaryKeyJoinColumn", oldPkJoinColumn, newPkJoinColumn);
    }

    protected ListIterator<JavaPrimaryKeyJoinColumn> defaultPrimaryKeyJoinColumns() {
        if (this.defaultPrimaryKeyJoinColumn != null) {
            return new SingleElementListIterator((Object)this.defaultPrimaryKeyJoinColumn);
        }
        return EmptyListIterator.instance();
    }

    protected int defaultPrimaryKeyJoinColumnsSize() {
        return this.defaultPrimaryKeyJoinColumn == null ? 0 : 1;
    }

    @Override
    public JavaPrimaryKeyJoinColumn addSpecifiedPrimaryKeyJoinColumn(int index) {
        JavaPrimaryKeyJoinColumn oldDefaultPkJoinColumn = this.getDefaultPrimaryKeyJoinColumn();
        if (oldDefaultPkJoinColumn != null) {
            this.defaultPrimaryKeyJoinColumn = null;
        }
        JavaPrimaryKeyJoinColumn primaryKeyJoinColumn = this.getJpaFactory().buildJavaPrimaryKeyJoinColumn(this, this.createPrimaryKeyJoinColumnOwner());
        this.specifiedPrimaryKeyJoinColumns.add(index, primaryKeyJoinColumn);
        PrimaryKeyJoinColumnAnnotation pkJoinColumnResource = (PrimaryKeyJoinColumnAnnotation)this.javaResourcePersistentType.addSupportingAnnotation(index, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        primaryKeyJoinColumn.initialize(pkJoinColumnResource);
        this.fireItemAdded("specifiedPrimaryKeyJoinColumns", index, primaryKeyJoinColumn);
        if (oldDefaultPkJoinColumn != null) {
            this.firePropertyChanged("defaultPrimaryKeyJoinColumn", oldDefaultPkJoinColumn, null);
        }
        return primaryKeyJoinColumn;
    }

    protected void addSpecifiedPrimaryKeyJoinColumn(int index, JavaPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.addItemToList(index, primaryKeyJoinColumn, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumns");
    }

    protected void addSpecifiedPrimaryKeyJoinColumn(JavaPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.addSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumns.size(), primaryKeyJoinColumn);
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(PrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.removeSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumns.indexOf(primaryKeyJoinColumn));
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(int index) {
        JavaPrimaryKeyJoinColumn removedPrimaryKeyJoinColumn = this.specifiedPrimaryKeyJoinColumns.remove(index);
        if (!this.containsSpecifiedPrimaryKeyJoinColumns()) {
            this.defaultPrimaryKeyJoinColumn = this.buildPrimaryKeyJoinColumn(new NullPrimaryKeyJoinColumnAnnotation(this.javaResourcePersistentType));
        }
        this.javaResourcePersistentType.removeSupportingAnnotation(index, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        this.fireItemRemoved("specifiedPrimaryKeyJoinColumns", index, removedPrimaryKeyJoinColumn);
        if (this.defaultPrimaryKeyJoinColumn != null) {
            this.firePropertyChanged("defaultPrimaryKeyJoinColumn", null, this.defaultPrimaryKeyJoinColumn);
        }
    }

    protected void removeSpecifiedPrimaryKeyJoinColumn_(JavaPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.removeItemFromList(primaryKeyJoinColumn, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumns");
    }

    @Override
    public void moveSpecifiedPrimaryKeyJoinColumn(int targetIndex, int sourceIndex) {
        this.javaResourcePersistentType.moveSupportingAnnotation(targetIndex, sourceIndex, "javax.persistence.PrimaryKeyJoinColumns");
        this.moveItemInList(targetIndex, sourceIndex, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumns");
    }

    @Override
    public ListIterator<JavaAttributeOverride> attributeOverrides() {
        return new CompositeListIterator(new ListIterator[]{this.specifiedAttributeOverrides(), this.virtualAttributeOverrides()});
    }

    @Override
    public int attributeOverridesSize() {
        return this.specifiedAttributeOverridesSize() + this.virtualAttributeOverridesSize();
    }

    @Override
    public ListIterator<JavaAttributeOverride> virtualAttributeOverrides() {
        return new CloneListIterator(this.virtualAttributeOverrides);
    }

    @Override
    public int virtualAttributeOverridesSize() {
        return this.virtualAttributeOverrides.size();
    }

    @Override
    public ListIterator<JavaAttributeOverride> specifiedAttributeOverrides() {
        return new CloneListIterator(this.specifiedAttributeOverrides);
    }

    @Override
    public int specifiedAttributeOverridesSize() {
        return this.specifiedAttributeOverrides.size();
    }

    protected JavaAttributeOverride addSpecifiedAttributeOverride(int index) {
        JavaAttributeOverride attributeOverride = this.getJpaFactory().buildJavaAttributeOverride(this, this.createAttributeOverrideOwner());
        this.specifiedAttributeOverrides.add(index, attributeOverride);
        AttributeOverrideAnnotation attributeOverrideResource = (AttributeOverrideAnnotation)this.javaResourcePersistentType.addSupportingAnnotation(index, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.initialize(attributeOverrideResource);
        this.fireItemAdded("specifiedAttributeOverrides", index, attributeOverride);
        return attributeOverride;
    }

    protected JavaAttributeOverride setAttributeOverrideVirtual(boolean virtual, JavaAttributeOverride attributeOverride) {
        if (virtual) {
            return this.setAttributeOverrideVirtual(attributeOverride);
        }
        return this.setAttributeOverrideSpecified(attributeOverride);
    }

    protected JavaAttributeOverride setAttributeOverrideVirtual(JavaAttributeOverride attributeOverride) {
        int index = this.specifiedAttributeOverrides.indexOf(attributeOverride);
        this.specifiedAttributeOverrides.remove(index);
        String attributeOverrideName = attributeOverride.getName();
        JavaAttributeOverride virtualAttributeOverride = null;
        if (attributeOverrideName != null) {
            for (PersistentAttribute persistentAttribute : CollectionTools.iterable(this.allOverridableAttributes())) {
                if (!persistentAttribute.getName().equals(attributeOverrideName)) continue;
                virtualAttributeOverride = this.buildVirtualAttributeOverride(persistentAttribute);
                this.virtualAttributeOverrides.add(virtualAttributeOverride);
                break;
            }
        }
        this.javaResourcePersistentType.removeSupportingAnnotation(index, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.fireItemRemoved("specifiedAttributeOverrides", index, attributeOverride);
        if (virtualAttributeOverride != null) {
            this.fireItemAdded("virtualAttributeOverrides", this.virtualAttributeOverridesSize() - 1, virtualAttributeOverride);
        }
        return virtualAttributeOverride;
    }

    protected JavaAttributeOverride setAttributeOverrideSpecified(JavaAttributeOverride oldAttributeOverride) {
        int index = this.specifiedAttributeOverridesSize();
        JavaAttributeOverride newAttributeOverride = this.getJpaFactory().buildJavaAttributeOverride(this, this.createAttributeOverrideOwner());
        this.specifiedAttributeOverrides.add(index, newAttributeOverride);
        AttributeOverrideAnnotation attributeOverrideResource = (AttributeOverrideAnnotation)this.javaResourcePersistentType.addSupportingAnnotation(index, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        newAttributeOverride.initialize(attributeOverrideResource);
        int defaultIndex = this.virtualAttributeOverrides.indexOf(oldAttributeOverride);
        this.virtualAttributeOverrides.remove(defaultIndex);
        newAttributeOverride.setName(oldAttributeOverride.getName());
        newAttributeOverride.getColumn().setSpecifiedName(oldAttributeOverride.getColumn().getName());
        this.fireItemRemoved("virtualAttributeOverrides", defaultIndex, oldAttributeOverride);
        this.fireItemAdded("specifiedAttributeOverrides", index, newAttributeOverride);
        return newAttributeOverride;
    }

    protected AttributeOverride.Owner createAttributeOverrideOwner() {
        return new AttributeOverrideOwner();
    }

    protected void addSpecifiedAttributeOverride(int index, JavaAttributeOverride attributeOverride) {
        this.addItemToList(index, attributeOverride, this.specifiedAttributeOverrides, "specifiedAttributeOverrides");
    }

    protected void addSpecifiedAttributeOverride(JavaAttributeOverride attributeOverride) {
        this.addSpecifiedAttributeOverride(this.specifiedAttributeOverrides.size(), attributeOverride);
    }

    protected void removeSpecifiedAttributeOverride_(JavaAttributeOverride attributeOverride) {
        this.removeItemFromList(attributeOverride, this.specifiedAttributeOverrides, "specifiedAttributeOverrides");
    }

    @Override
    public void moveSpecifiedAttributeOverride(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedAttributeOverrides, (int)targetIndex, (int)sourceIndex);
        this.javaResourcePersistentType.moveSupportingAnnotation(targetIndex, sourceIndex, "javax.persistence.AttributeOverrides");
        this.fireItemMoved("specifiedAttributeOverrides", targetIndex, sourceIndex);
    }

    protected void addVirtualAttributeOverride(JavaAttributeOverride attributeOverride) {
        this.addItemToList(attributeOverride, this.virtualAttributeOverrides, "virtualAttributeOverrides");
    }

    protected void removeVirtualAttributeOverride(JavaAttributeOverride attributeOverride) {
        this.removeItemFromList(attributeOverride, this.virtualAttributeOverrides, "virtualAttributeOverrides");
    }

    @Override
    public JavaAttributeOverride getAttributeOverrideNamed(String name) {
        return (JavaAttributeOverride)this.getOverrideNamed(name, this.attributeOverrides());
    }

    public boolean containsAttributeOverride(String name) {
        return this.containsOverride(name, this.attributeOverrides());
    }

    public boolean containsDefaultAttributeOverride(String name) {
        return this.containsOverride(name, this.virtualAttributeOverrides());
    }

    public boolean containsSpecifiedAttributeOverride(String name) {
        return this.containsOverride(name, this.specifiedAttributeOverrides());
    }

    public JavaAssociationOverride getAssociationOverrideNamed(String name) {
        return (JavaAssociationOverride)this.getOverrideNamed(name, this.associationOverrides());
    }

    public boolean containsAssociationOverride(String name) {
        return this.containsOverride(name, this.associationOverrides());
    }

    public boolean containsSpecifiedAssociationOverride(String name) {
        return this.containsOverride(name, this.specifiedAssociationOverrides());
    }

    public boolean containsDefaultAssociationOverride(String name) {
        return this.containsOverride(name, this.virtualAssociationOverrides());
    }

    protected BaseOverride getOverrideNamed(String name, ListIterator<? extends BaseOverride> overrides) {
        for (BaseOverride override : CollectionTools.iterable(overrides)) {
            String overrideName = override.getName();
            if (overrideName == null && name == null) {
                return override;
            }
            if (overrideName == null || !overrideName.equals(name)) continue;
            return override;
        }
        return null;
    }

    protected boolean containsOverride(String name, ListIterator<? extends BaseOverride> overrides) {
        return this.getOverrideNamed(name, overrides) != null;
    }

    @Override
    public ListIterator<JavaAssociationOverride> associationOverrides() {
        return new CompositeListIterator(new ListIterator[]{this.specifiedAssociationOverrides(), this.virtualAssociationOverrides()});
    }

    @Override
    public int associationOverridesSize() {
        return this.specifiedAssociationOverridesSize() + this.virtualAssociationOverridesSize();
    }

    @Override
    public ListIterator<JavaAssociationOverride> virtualAssociationOverrides() {
        return new CloneListIterator(this.virtualAssociationOverrides);
    }

    @Override
    public int virtualAssociationOverridesSize() {
        return this.virtualAssociationOverrides.size();
    }

    @Override
    public ListIterator<JavaAssociationOverride> specifiedAssociationOverrides() {
        return new CloneListIterator(this.specifiedAssociationOverrides);
    }

    @Override
    public int specifiedAssociationOverridesSize() {
        return this.specifiedAssociationOverrides.size();
    }

    public JavaAssociationOverride addSpecifiedAssociationOverride(int index) {
        JavaAssociationOverride associationOverride = this.getJpaFactory().buildJavaAssociationOverride(this, this.createAssociationOverrideOwner());
        this.specifiedAssociationOverrides.add(index, associationOverride);
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)this.javaResourcePersistentType.addSupportingAnnotation(index, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.initialize(associationOverrideResource);
        this.fireItemAdded("specifiedAssociationOverrides", index, associationOverride);
        return associationOverride;
    }

    protected AssociationOverride.Owner createAssociationOverrideOwner() {
        return new AssociationOverrideOwner();
    }

    protected void addSpecifiedAssociationOverride(int index, JavaAssociationOverride associationOverride) {
        this.addItemToList(index, associationOverride, this.specifiedAssociationOverrides, "specifiedAssociationOverrides");
    }

    protected void addSpecifiedAssociationOverride(JavaAssociationOverride associationOverride) {
        this.addSpecifiedAssociationOverride(this.specifiedAssociationOverrides.size(), associationOverride);
    }

    protected void removeSpecifiedAssociationOverride_(JavaAssociationOverride associationOverride) {
        this.removeItemFromList(associationOverride, this.specifiedAssociationOverrides, "specifiedAssociationOverrides");
    }

    @Override
    public void moveSpecifiedAssociationOverride(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedAssociationOverrides, (int)targetIndex, (int)sourceIndex);
        this.javaResourcePersistentType.moveSupportingAnnotation(targetIndex, sourceIndex, "javax.persistence.AssociationOverrides");
        this.fireItemMoved("specifiedAssociationOverrides", targetIndex, sourceIndex);
    }

    protected JavaAssociationOverride setAssociationOverrideVirtual(boolean virtual, JavaAssociationOverride associationOverride) {
        if (virtual) {
            return this.setAssociationOverrideVirtual(associationOverride);
        }
        return this.setAssociationOverrideSpecified(associationOverride);
    }

    protected JavaAssociationOverride setAssociationOverrideVirtual(JavaAssociationOverride associationOverride) {
        int index = this.specifiedAssociationOverrides.indexOf(associationOverride);
        this.specifiedAssociationOverrides.remove(index);
        String associationOverrideName = associationOverride.getName();
        JavaAssociationOverride virtualAssociationOverride = null;
        if (associationOverrideName != null) {
            for (PersistentAttribute persistentAttribute : CollectionTools.iterable(this.allOverridableAssociations())) {
                if (!persistentAttribute.getName().equals(associationOverrideName)) continue;
                virtualAssociationOverride = this.buildAssociationOverride(new NullAssociationOverrideAnnotation(this.javaResourcePersistentType, associationOverrideName));
                this.virtualAssociationOverrides.add(virtualAssociationOverride);
                break;
            }
        }
        this.javaResourcePersistentType.removeSupportingAnnotation(index, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        this.fireItemRemoved("specifiedAssociationOverrides", index, associationOverride);
        if (virtualAssociationOverride != null) {
            this.fireItemAdded("virtualAssociationOverrides", this.virtualAssociationOverridesSize() - 1, virtualAssociationOverride);
        }
        return virtualAssociationOverride;
    }

    protected JavaAssociationOverride setAssociationOverrideSpecified(JavaAssociationOverride oldAssociationOverride) {
        int index = this.specifiedAssociationOverridesSize();
        JavaAssociationOverride newAssociationOverride = this.getJpaFactory().buildJavaAssociationOverride(this, this.createAssociationOverrideOwner());
        this.specifiedAssociationOverrides.add(index, newAssociationOverride);
        AssociationOverrideAnnotation attributeOverrideResource = (AssociationOverrideAnnotation)this.javaResourcePersistentType.addSupportingAnnotation(index, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        newAssociationOverride.initialize(attributeOverrideResource);
        int virtualIndex = this.virtualAssociationOverrides.indexOf(oldAssociationOverride);
        this.virtualAssociationOverrides.remove(virtualIndex);
        newAssociationOverride.setName(oldAssociationOverride.getName());
        this.fireItemRemoved("virtualAssociationOverrides", virtualIndex, oldAssociationOverride);
        this.fireItemAdded("specifiedAssociationOverrides", index, newAssociationOverride);
        return newAssociationOverride;
    }

    protected void addVirtualAssociationOverride(JavaAssociationOverride associationOverride) {
        this.addItemToList(associationOverride, this.virtualAssociationOverrides, "virtualAssociationOverrides");
    }

    protected void removeVirtualAssociationOverride(JavaAssociationOverride associationOverride) {
        this.removeItemFromList(associationOverride, this.virtualAssociationOverrides, "virtualAssociationOverrides");
    }

    @Override
    public ListIterator<JavaNamedQuery> namedQueries() {
        return new CloneListIterator(this.namedQueries);
    }

    @Override
    public int namedQueriesSize() {
        return this.namedQueries.size();
    }

    @Override
    public JavaNamedQuery addNamedQuery(int index) {
        JavaNamedQuery namedQuery = this.getJpaFactory().buildJavaNamedQuery(this);
        this.namedQueries.add(index, namedQuery);
        NamedQueryAnnotation namedQueryAnnotation = (NamedQueryAnnotation)this.javaResourcePersistentType.addSupportingAnnotation(index, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        namedQuery.initialize(namedQueryAnnotation);
        this.fireItemAdded("namedQueries", index, namedQuery);
        return namedQuery;
    }

    protected void addNamedQuery(int index, JavaNamedQuery namedQuery) {
        this.addItemToList(index, namedQuery, this.namedQueries, "namedQueries");
    }

    protected void addNamedQuery(JavaNamedQuery namedQuery) {
        this.addNamedQuery(this.namedQueries.size(), namedQuery);
    }

    @Override
    public void removeNamedQuery(NamedQuery namedQuery) {
        this.removeNamedQuery(this.namedQueries.indexOf(namedQuery));
    }

    @Override
    public void removeNamedQuery(int index) {
        JavaNamedQuery removedNamedQuery = this.namedQueries.remove(index);
        this.javaResourcePersistentType.removeSupportingAnnotation(index, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        this.fireItemRemoved("namedQueries", index, removedNamedQuery);
    }

    protected void removeNamedQuery_(JavaNamedQuery namedQuery) {
        this.removeItemFromList(namedQuery, this.namedQueries, "namedQueries");
    }

    @Override
    public void moveNamedQuery(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.namedQueries, (int)targetIndex, (int)sourceIndex);
        this.javaResourcePersistentType.moveSupportingAnnotation(targetIndex, sourceIndex, "javax.persistence.NamedQueries");
        this.fireItemMoved("namedQueries", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<JavaNamedNativeQuery> namedNativeQueries() {
        return new CloneListIterator(this.namedNativeQueries);
    }

    @Override
    public int namedNativeQueriesSize() {
        return this.namedNativeQueries.size();
    }

    @Override
    public JavaNamedNativeQuery addNamedNativeQuery(int index) {
        JavaNamedNativeQuery namedNativeQuery = this.getJpaFactory().buildJavaNamedNativeQuery(this);
        this.namedNativeQueries.add(index, namedNativeQuery);
        NamedNativeQueryAnnotation namedNativeQueryAnnotation = (NamedNativeQueryAnnotation)this.javaResourcePersistentType.addSupportingAnnotation(index, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        namedNativeQuery.initialize(namedNativeQueryAnnotation);
        this.fireItemAdded("namedNativeQueries", index, namedNativeQuery);
        return namedNativeQuery;
    }

    protected void addNamedNativeQuery(int index, JavaNamedNativeQuery namedNativeQuery) {
        this.addItemToList(index, namedNativeQuery, this.namedNativeQueries, "namedNativeQueries");
    }

    protected void addNamedNativeQuery(JavaNamedNativeQuery namedNativeQuery) {
        this.addNamedNativeQuery(this.namedNativeQueries.size(), namedNativeQuery);
    }

    @Override
    public void removeNamedNativeQuery(NamedNativeQuery namedNativeQuery) {
        this.removeNamedNativeQuery(this.namedNativeQueries.indexOf(namedNativeQuery));
    }

    @Override
    public void removeNamedNativeQuery(int index) {
        JavaNamedNativeQuery removedNamedNativeQuery = this.namedNativeQueries.remove(index);
        this.javaResourcePersistentType.removeSupportingAnnotation(index, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        this.fireItemRemoved("namedNativeQueries", index, removedNamedNativeQuery);
    }

    protected void removeNamedNativeQuery_(JavaNamedNativeQuery namedNativeQuery) {
        this.removeItemFromList(namedNativeQuery, this.namedNativeQueries, "namedNativeQueries");
    }

    @Override
    public void moveNamedNativeQuery(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.namedNativeQueries, (int)targetIndex, (int)sourceIndex);
        this.javaResourcePersistentType.moveSupportingAnnotation(targetIndex, sourceIndex, "javax.persistence.NamedNativeQueries");
        this.fireItemMoved("namedNativeQueries", targetIndex, sourceIndex);
    }

    public Iterator<JavaQuery> queries() {
        return new CompositeIterator(new Iterator[]{this.namedNativeQueries(), this.namedQueries()});
    }

    @Override
    public char getIdClassEnclosingTypeSeparator() {
        return '.';
    }

    @Override
    public String getIdClass() {
        return this.idClass;
    }

    @Override
    public void setIdClass(String newIdClass) {
        String oldIdClass = this.idClass;
        this.idClass = newIdClass;
        if (newIdClass != oldIdClass) {
            if (newIdClass != null) {
                if (this.getResourceIdClass() == null) {
                    this.addResourceIdClass();
                }
                this.getResourceIdClass().setValue(newIdClass);
            } else {
                this.removeResourceIdClass();
            }
        }
        this.firePropertyChanged("idClass", oldIdClass, newIdClass);
    }

    protected void setIdClass_(String newIdClass) {
        String oldIdClass = this.idClass;
        this.idClass = newIdClass;
        this.firePropertyChanged("idClass", oldIdClass, newIdClass);
    }

    protected IdClassAnnotation getResourceIdClass() {
        return (IdClassAnnotation)this.javaResourcePersistentType.getSupportingAnnotation("javax.persistence.IdClass");
    }

    protected void addResourceIdClass() {
        this.javaResourcePersistentType.addSupportingAnnotation("javax.persistence.IdClass");
    }

    protected void removeResourceIdClass() {
        this.javaResourcePersistentType.removeSupportingAnnotation("javax.persistence.IdClass");
    }

    @Override
    public Entity getParentEntity() {
        Iterator<PersistentType> stream = this.getPersistentType().ancestors();
        while (stream.hasNext()) {
            TypeMapping typeMapping = stream.next().getMapping();
            if (!(typeMapping instanceof Entity)) continue;
            return (Entity)typeMapping;
        }
        return this;
    }

    protected Entity getRootEntity() {
        return this.rootEntity;
    }

    @Override
    public String getDefaultTableName() {
        return this.isSingleTableDescendant() ? this.getRootEntity().getTable().getName() : (this.isAbstractTablePerClass() ? null : this.getName());
    }

    @Override
    public String getDefaultSchema() {
        return this.isSingleTableDescendant() ? this.getRootEntity().getTable().getSchema() : (this.isAbstractTablePerClass() ? null : this.getContextDefaultSchema());
    }

    @Override
    public String getDefaultCatalog() {
        return this.isSingleTableDescendant() ? this.getRootEntity().getTable().getCatalog() : (this.isAbstractTablePerClass() ? null : this.getContextDefaultCatalog());
    }

    protected boolean isSingleTableDescendant() {
        return this.getInheritanceStrategy() == InheritanceType.SINGLE_TABLE && this.isDescendant();
    }

    protected boolean isDescendant() {
        return !this.isRoot();
    }

    protected boolean isRoot() {
        return this == this.getRootEntity();
    }

    protected boolean isRootNoDescendantsNoStrategyDefined() {
        return this.isRoot() && !this.getPersistenceUnit().isRootWithSubEntities(this.getName()) && this.getSpecifiedInheritanceStrategy() == null;
    }

    protected boolean isAbstractTablePerClass() {
        return this.isAbstract() && this.isTablePerClass();
    }

    protected boolean isTablePerClass() {
        return this.getInheritanceStrategy() == InheritanceType.TABLE_PER_CLASS;
    }

    protected boolean isTablePerClassDescendant() {
        return this.isTablePerClass() && this.isDescendant();
    }

    protected boolean isAbstract() {
        return this.javaResourcePersistentType.isAbstract();
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return this.getPrimaryKeyColumnName(this.getPersistentType().allAttributes());
    }

    public String getPrimaryKeyColumnName(Iterator<PersistentAttribute> attributes) {
        String pkColumnName = null;
        Iterator<PersistentAttribute> stream = attributes;
        while (stream.hasNext()) {
            JavaAttributeOverride attributeOverride;
            PersistentAttribute attribute = stream.next();
            String name = attribute.getPrimaryKeyColumnName();
            if (name != null && (attributeOverride = this.getAttributeOverrideNamed(attribute.getName())) != null) {
                name = attributeOverride.getColumn().getName();
            }
            if (pkColumnName == null) {
                pkColumnName = name;
                continue;
            }
            if (name == null) continue;
            return null;
        }
        return pkColumnName;
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return !CollectionTools.contains(this.associatedTableNamesIncludingInherited(), (Object)tableName);
    }

    @Override
    public boolean shouldValidateAgainstDatabase() {
        return super.shouldValidateAgainstDatabase() && !this.isAbstractTablePerClass();
    }

    @Override
    public Iterator<Table> associatedTables() {
        return new CompositeIterator((Object)this.getTable(), this.secondaryTables());
    }

    @Override
    public Iterator<Table> associatedTablesIncludingInherited() {
        return new CompositeIterator((Iterator)new TransformationIterator<TypeMapping, Iterator<Table>>(this.inheritanceHierarchy()){

            protected Iterator<Table> transform(TypeMapping mapping) {
                return new FilteringIterator<Table, Table>(mapping.associatedTables()){

                    protected boolean accept(Table o) {
                        return true;
                    }
                };
            }
        });
    }

    @Override
    public Iterator<String> associatedTableNamesIncludingInherited() {
        return this.nonNullTableNames(this.associatedTablesIncludingInherited());
    }

    protected Iterator<String> nonNullTableNames(Iterator<Table> tables) {
        return new FilteringIterator<String, String>(this.tableNames(tables)){

            protected boolean accept(String o) {
                return o != null;
            }
        };
    }

    protected Iterator<String> tableNames(Iterator<Table> tables) {
        return new TransformationIterator<Table, String>(tables){

            protected String transform(Table t) {
                return t.getName();
            }
        };
    }

    protected Iterator<TypeMapping> inheritanceHierarchy() {
        return new TransformationIterator<PersistentType, TypeMapping>(this.getPersistentType().inheritanceHierarchy()){

            protected TypeMapping transform(PersistentType type) {
                return type.getMapping();
            }
        };
    }

    protected Iterator<TypeMapping> ancestors() {
        return new TransformationIterator<PersistentType, TypeMapping>(this.getPersistentType().ancestors()){

            protected TypeMapping transform(PersistentType type) {
                return type.getMapping();
            }
        };
    }

    @Override
    public Iterator<JavaPersistentAttribute> overridableAttributes() {
        if (!this.isTablePerClass()) {
            return EmptyIterator.instance();
        }
        return new FilteringIterator<JavaPersistentAttribute, JavaPersistentAttribute>(this.getPersistentType().attributes()){

            protected boolean accept(JavaPersistentAttribute o) {
                return o.isOverridableAttribute();
            }
        };
    }

    @Override
    public Iterator<JavaPersistentAttribute> overridableAssociations() {
        if (!this.isTablePerClass()) {
            return EmptyIterator.instance();
        }
        return new FilteringIterator<JavaPersistentAttribute, JavaPersistentAttribute>(this.getPersistentType().attributes()){

            protected boolean accept(JavaPersistentAttribute o) {
                return o.isOverridableAssociation();
            }
        };
    }

    @Override
    public Iterator<PersistentAttribute> allOverridableAttributes() {
        return new CompositeIterator((Iterator)new TransformationIterator<TypeMapping, Iterator<PersistentAttribute>>(this.ancestors()){

            protected Iterator<PersistentAttribute> transform(TypeMapping mapping) {
                return mapping.overridableAttributes();
            }
        });
    }

    @Override
    public Iterator<PersistentAttribute> allOverridableAssociations() {
        return new CompositeIterator((Iterator)new TransformationIterator<TypeMapping, Iterator<PersistentAttribute>>(this.ancestors()){

            protected Iterator<PersistentAttribute> transform(TypeMapping mapping) {
                return mapping.overridableAssociations();
            }
        });
    }

    @Override
    public void update(JavaResourcePersistentType resourcePersistentType) {
        super.update(resourcePersistentType);
        this.setSpecifiedName_(this.getResourceName());
        this.setDefaultName(this.getResourceDefaultName());
        this.updateRootEntity();
        this.updateInheritance(this.getResourceInheritance());
        this.updateDiscriminatorColumn();
        this.updateDiscriminatorValue(this.getResourceDiscriminatorValue());
        this.setSpecifiedTableIsAllowed(this.buildSpecifiedTableIsAllowed());
        this.setTableIsUndefined(this.buildTableIsUndefined());
        this.updateTable();
        this.updateSecondaryTables();
        this.updateTableGenerator();
        this.updateSequenceGenerator();
        this.updateSpecifiedPrimaryKeyJoinColumns();
        this.updateDefaultPrimaryKeyJoinColumn();
        this.updateSpecifiedAttributeOverrides();
        this.updateVirtualAttributeOverrides();
        this.updateSpecifiedAssociationOverrides();
        this.updateVirtualAssociationOverrides();
        this.updateNamedQueries();
        this.updateNamedNativeQueries();
        this.updateIdClass();
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        this.postUpdateDiscriminatorColumn();
        this.postUpdateDiscriminatorValue();
    }

    protected String getResourceName() {
        return this.getResourceMappingAnnotation().getName();
    }

    protected String getResourceDefaultName() {
        return this.javaResourcePersistentType.getName();
    }

    protected void updateTable() {
        this.getTable().update(this.javaResourcePersistentType);
    }

    protected void updateInheritance(InheritanceAnnotation inheritanceResource) {
        this.setSpecifiedInheritanceStrategy_(this.getResourceInheritanceStrategy(inheritanceResource));
        this.setDefaultInheritanceStrategy(this.buildDefaultInheritanceStrategy());
    }

    protected InheritanceType getResourceInheritanceStrategy(InheritanceAnnotation inheritanceResource) {
        return InheritanceType.fromJavaResourceModel(inheritanceResource.getStrategy());
    }

    protected InheritanceType buildDefaultInheritanceStrategy() {
        return this.isRoot() ? InheritanceType.SINGLE_TABLE : this.getRootEntity().getInheritanceStrategy();
    }

    protected void updateRootEntity() {
        this.rootEntity = this.calculateRootEntity();
        if (this.rootEntity != this) {
            this.rootEntity.addSubEntity(this);
        }
    }

    protected Entity calculateRootEntity() {
        Entity root = this;
        Iterator<PersistentType> stream = this.getPersistentType().inheritanceHierarchy();
        while (stream.hasNext()) {
            PersistentType persistentType = stream.next();
            if (!(persistentType.getMapping() instanceof Entity)) continue;
            root = (Entity)persistentType.getMapping();
        }
        return root;
    }

    @Override
    public void addSubEntity(Entity subEntity) {
        this.getPersistenceUnit().addRootWithSubEntities(this.getName());
    }

    protected void updateDiscriminatorColumn() {
        this.setSpecifiedDiscriminatorColumnIsAllowed(this.buildSpecifiedDiscriminatorColumnIsAllowed());
        this.getDiscriminatorColumn().update(this.javaResourcePersistentType);
    }

    protected void postUpdateDiscriminatorColumn() {
        this.setDiscriminatorColumnIsUndefined(this.buildDiscriminatorColumnIsUndefined());
        this.getDiscriminatorColumn().postUpdate();
    }

    protected void updateDiscriminatorValue(DiscriminatorValueAnnotation discriminatorValueResource) {
        this.setSpecifiedDiscriminatorValueIsAllowed(this.buildSpecifiedDiscriminatorValueIsAllowed());
        this.setSpecifiedDiscriminatorValue_(discriminatorValueResource.getValue());
    }

    protected void postUpdateDiscriminatorValue() {
        this.setDiscriminatorValueIsUndefined(this.buildDiscriminatorValueIsUndefined());
        this.setDefaultDiscriminatorValue(this.buildDefaultDiscriminatorValue());
    }

    protected String buildDefaultDiscriminatorValue() {
        if (this.discriminatorValueIsUndefined()) {
            return null;
        }
        if (this.getDiscriminatorType() != DiscriminatorType.STRING) {
            return null;
        }
        return this.getName();
    }

    protected DiscriminatorType getDiscriminatorType() {
        return this.getDiscriminatorColumn().getDiscriminatorType();
    }

    protected boolean buildSpecifiedDiscriminatorValueIsAllowed() {
        return !this.isTablePerClass() && !this.isAbstract();
    }

    protected boolean buildDiscriminatorValueIsUndefined() {
        return this.isTablePerClass() || this.isAbstract() || this.isRootNoDescendantsNoStrategyDefined();
    }

    protected boolean buildSpecifiedDiscriminatorColumnIsAllowed() {
        return !this.isTablePerClass() && this.isRoot();
    }

    protected boolean buildDiscriminatorColumnIsUndefined() {
        return this.isTablePerClass() || this.isRootNoDescendantsNoStrategyDefined();
    }

    protected boolean buildSpecifiedTableIsAllowed() {
        return !this.isAbstractTablePerClass() && !this.isSingleTableDescendant();
    }

    protected boolean buildTableIsUndefined() {
        return this.isAbstractTablePerClass();
    }

    protected void updateSecondaryTables() {
        ListIterator<JavaSecondaryTable> secondaryTables = this.specifiedSecondaryTables();
        ListIterator<NestableAnnotation> resourceSecondaryTables = this.javaResourcePersistentType.supportingAnnotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        while (secondaryTables.hasNext()) {
            JavaSecondaryTable secondaryTable = secondaryTables.next();
            if (resourceSecondaryTables.hasNext()) {
                secondaryTable.update((SecondaryTableAnnotation)((Object)resourceSecondaryTables.next()));
                continue;
            }
            this.removeSpecifiedSecondaryTable_(secondaryTable);
        }
        while (resourceSecondaryTables.hasNext()) {
            this.addSpecifiedSecondaryTable(this.buildSecondaryTable((SecondaryTableAnnotation)((Object)resourceSecondaryTables.next())));
        }
    }

    protected JavaSecondaryTable buildSecondaryTable(SecondaryTableAnnotation secondaryTableResource) {
        JavaSecondaryTable secondaryTable = this.getJpaFactory().buildJavaSecondaryTable(this);
        secondaryTable.initialize(secondaryTableResource);
        return secondaryTable;
    }

    protected void updateTableGenerator() {
        TableGeneratorAnnotation tableGeneratorResource = this.getResourceTableGenerator();
        if (tableGeneratorResource == null) {
            if (this.getTableGenerator() != null) {
                this.setTableGenerator(null);
            }
        } else if (this.getTableGenerator() == null) {
            this.setTableGenerator(this.buildTableGenerator(tableGeneratorResource));
        } else {
            this.getTableGenerator().update(tableGeneratorResource);
        }
    }

    protected JavaTableGenerator buildTableGenerator(TableGeneratorAnnotation tableGeneratorResource) {
        JavaTableGenerator generator = this.getJpaFactory().buildJavaTableGenerator(this);
        generator.initialize(tableGeneratorResource);
        return generator;
    }

    protected TableGeneratorAnnotation getResourceTableGenerator() {
        return (TableGeneratorAnnotation)this.javaResourcePersistentType.getSupportingAnnotation("javax.persistence.TableGenerator");
    }

    protected void updateSequenceGenerator() {
        SequenceGeneratorAnnotation sequenceGeneratorResource = this.getResourceSequenceGenerator();
        if (sequenceGeneratorResource == null) {
            if (this.getSequenceGenerator() != null) {
                this.setSequenceGenerator(null);
            }
        } else if (this.getSequenceGenerator() == null) {
            this.setSequenceGenerator(this.buildSequenceGenerator(sequenceGeneratorResource));
        } else {
            this.getSequenceGenerator().update(sequenceGeneratorResource);
        }
    }

    protected JavaSequenceGenerator buildSequenceGenerator(SequenceGeneratorAnnotation sequenceGeneratorResource) {
        JavaSequenceGenerator generator = this.getJpaFactory().buildJavaSequenceGenerator(this);
        generator.initialize(sequenceGeneratorResource);
        return generator;
    }

    protected SequenceGeneratorAnnotation getResourceSequenceGenerator() {
        return (SequenceGeneratorAnnotation)this.javaResourcePersistentType.getSupportingAnnotation("javax.persistence.SequenceGenerator");
    }

    protected void updateSpecifiedPrimaryKeyJoinColumns() {
        ListIterator<JavaPrimaryKeyJoinColumn> primaryKeyJoinColumns = this.specifiedPrimaryKeyJoinColumns();
        ListIterator<NestableAnnotation> resourcePrimaryKeyJoinColumns = this.javaResourcePersistentType.supportingAnnotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        while (primaryKeyJoinColumns.hasNext()) {
            JavaPrimaryKeyJoinColumn primaryKeyJoinColumn = primaryKeyJoinColumns.next();
            if (resourcePrimaryKeyJoinColumns.hasNext()) {
                primaryKeyJoinColumn.update((PrimaryKeyJoinColumnAnnotation)((Object)resourcePrimaryKeyJoinColumns.next()));
                continue;
            }
            this.removeSpecifiedPrimaryKeyJoinColumn_(primaryKeyJoinColumn);
        }
        while (resourcePrimaryKeyJoinColumns.hasNext()) {
            this.addSpecifiedPrimaryKeyJoinColumn(this.buildPrimaryKeyJoinColumn((PrimaryKeyJoinColumnAnnotation)((Object)resourcePrimaryKeyJoinColumns.next())));
        }
    }

    protected JavaPrimaryKeyJoinColumn buildPrimaryKeyJoinColumn(PrimaryKeyJoinColumnAnnotation primaryKeyJoinColumnResource) {
        JavaPrimaryKeyJoinColumn primaryKeyJoinColumn = this.getJpaFactory().buildJavaPrimaryKeyJoinColumn(this, this.createPrimaryKeyJoinColumnOwner());
        primaryKeyJoinColumn.initialize(primaryKeyJoinColumnResource);
        return primaryKeyJoinColumn;
    }

    protected void updateDefaultPrimaryKeyJoinColumn() {
        if (!this.shouldBuildDefaultPrimaryKeyJoinColumn()) {
            this.setDefaultPrimaryKeyJoinColumn(null);
            return;
        }
        if (this.getDefaultPrimaryKeyJoinColumn() == null) {
            this.setDefaultPrimaryKeyJoinColumn(this.buildPrimaryKeyJoinColumn(new NullPrimaryKeyJoinColumnAnnotation(this.javaResourcePersistentType)));
        } else {
            this.defaultPrimaryKeyJoinColumn.update(new NullPrimaryKeyJoinColumnAnnotation(this.javaResourcePersistentType));
        }
    }

    protected void updateSpecifiedAttributeOverrides() {
        ListIterator<JavaAttributeOverride> attributeOverrides = this.specifiedAttributeOverrides();
        ListIterator<NestableAnnotation> resourceAttributeOverrides = this.javaResourcePersistentType.supportingAnnotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        while (attributeOverrides.hasNext()) {
            JavaAttributeOverride attributeOverride = attributeOverrides.next();
            if (resourceAttributeOverrides.hasNext()) {
                attributeOverride.update((AttributeOverrideAnnotation)((Object)resourceAttributeOverrides.next()));
                continue;
            }
            this.removeSpecifiedAttributeOverride_(attributeOverride);
        }
        while (resourceAttributeOverrides.hasNext()) {
            this.addSpecifiedAttributeOverride(this.buildAttributeOverride((AttributeOverrideAnnotation)((Object)resourceAttributeOverrides.next())));
        }
    }

    protected JavaAttributeOverride buildAttributeOverride(AttributeOverrideAnnotation attributeOverrideResource) {
        JavaAttributeOverride attributeOverride = this.getJpaFactory().buildJavaAttributeOverride(this, this.createAttributeOverrideOwner());
        attributeOverride.initialize(attributeOverrideResource);
        return attributeOverride;
    }

    protected JavaAttributeOverride buildVirtualAttributeOverride(PersistentAttribute attribute) {
        return this.buildAttributeOverride(this.buildVirtualAttributeOverrideAnnotation(attribute));
    }

    protected VirtualAttributeOverrideAnnotation buildVirtualAttributeOverrideAnnotation(PersistentAttribute attribute) {
        ColumnMapping columnMapping = (ColumnMapping)((Object)attribute.getMapping());
        return new VirtualAttributeOverrideAnnotation(this.javaResourcePersistentType, attribute.getName(), columnMapping.getColumn());
    }

    protected void updateVirtualAttributeOverrides() {
        for (PersistentAttribute persistentAttribute : CollectionTools.iterable(this.allOverridableAttributes())) {
            JavaAttributeOverride attributeOverride = this.getAttributeOverrideNamed(persistentAttribute.getName());
            if (attributeOverride == null) {
                this.addVirtualAttributeOverride(this.buildVirtualAttributeOverride(persistentAttribute));
                continue;
            }
            if (!attributeOverride.isVirtual()) continue;
            attributeOverride.update(this.buildVirtualAttributeOverrideAnnotation(persistentAttribute));
        }
        HashBag attributeNames = CollectionTools.collection(this.allOverridableAttributeNames());
        for (JavaAttributeOverride attributeOverride : CollectionTools.iterable(this.virtualAttributeOverrides())) {
            if (attributeNames.contains(attributeOverride.getName()) && !this.containsSpecifiedAttributeOverride(attributeOverride.getName())) continue;
            this.removeVirtualAttributeOverride(attributeOverride);
        }
    }

    protected void updateSpecifiedAssociationOverrides() {
        ListIterator<JavaAssociationOverride> associationOverrides = this.specifiedAssociationOverrides();
        ListIterator<NestableAnnotation> resourceAssociationOverrides = this.javaResourcePersistentType.supportingAnnotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        while (associationOverrides.hasNext()) {
            JavaAssociationOverride associationOverride = associationOverrides.next();
            if (resourceAssociationOverrides.hasNext()) {
                associationOverride.update((AssociationOverrideAnnotation)((Object)resourceAssociationOverrides.next()));
                continue;
            }
            this.removeSpecifiedAssociationOverride_(associationOverride);
        }
        while (resourceAssociationOverrides.hasNext()) {
            this.addSpecifiedAssociationOverride(this.buildAssociationOverride((AssociationOverrideAnnotation)((Object)resourceAssociationOverrides.next())));
        }
    }

    protected JavaAssociationOverride buildAssociationOverride(AssociationOverrideAnnotation associationOverrideResource) {
        JavaAssociationOverride associationOverride = this.getJpaFactory().buildJavaAssociationOverride(this, this.createAssociationOverrideOwner());
        associationOverride.initialize(associationOverrideResource);
        return associationOverride;
    }

    protected void updateVirtualAssociationOverrides() {
        Iterator<String> i = this.allOverridableAssociationNames();
        while (i.hasNext()) {
            String associationName = i.next();
            JavaAssociationOverride associationOverride = this.getAssociationOverrideNamed(associationName);
            if (associationOverride == null) {
                associationOverride = this.buildAssociationOverride(new NullAssociationOverrideAnnotation(this.javaResourcePersistentType, associationName));
                this.addVirtualAssociationOverride(associationOverride);
                continue;
            }
            if (!associationOverride.isVirtual()) continue;
            associationOverride.update(new NullAssociationOverrideAnnotation(this.javaResourcePersistentType, associationName));
        }
        HashBag associationNames = CollectionTools.collection(this.allOverridableAssociationNames());
        for (JavaAssociationOverride associationOverride : CollectionTools.iterable(this.virtualAssociationOverrides())) {
            if (associationNames.contains(associationOverride.getName()) && !this.containsSpecifiedAssociationOverride(associationOverride.getName())) continue;
            this.removeVirtualAssociationOverride(associationOverride);
        }
    }

    protected void updateNamedQueries() {
        ListIterator<JavaNamedQuery> queries = this.namedQueries();
        ListIterator<NestableAnnotation> resourceNamedQueries = this.javaResourcePersistentType.supportingAnnotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        while (queries.hasNext()) {
            JavaNamedQuery namedQuery = queries.next();
            if (resourceNamedQueries.hasNext()) {
                namedQuery.update((NamedQueryAnnotation)((Object)resourceNamedQueries.next()));
                continue;
            }
            this.removeNamedQuery_(namedQuery);
        }
        while (resourceNamedQueries.hasNext()) {
            this.addNamedQuery(this.buildNamedQuery((NamedQueryAnnotation)((Object)resourceNamedQueries.next())));
        }
    }

    protected void updateNamedNativeQueries() {
        ListIterator<JavaNamedNativeQuery> queries = this.namedNativeQueries();
        ListIterator<NestableAnnotation> resourceNamedNativeQueries = this.javaResourcePersistentType.supportingAnnotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        while (queries.hasNext()) {
            JavaNamedNativeQuery namedQuery = queries.next();
            if (resourceNamedNativeQueries.hasNext()) {
                namedQuery.update((NamedNativeQueryAnnotation)((Object)resourceNamedNativeQueries.next()));
                continue;
            }
            this.removeNamedNativeQuery_(namedQuery);
        }
        while (resourceNamedNativeQueries.hasNext()) {
            this.addNamedNativeQuery(this.buildNamedNativeQuery((NamedNativeQueryAnnotation)((Object)resourceNamedNativeQueries.next())));
        }
    }

    protected JavaNamedQuery buildNamedQuery(NamedQueryAnnotation namedQueryResource) {
        JavaNamedQuery namedQuery = this.getJpaFactory().buildJavaNamedQuery(this);
        namedQuery.initialize(namedQueryResource);
        return namedQuery;
    }

    protected JavaNamedNativeQuery buildNamedNativeQuery(NamedNativeQueryAnnotation namedNativeQueryResource) {
        JavaNamedNativeQuery namedNativeQuery = this.getJpaFactory().buildJavaNamedNativeQuery(this);
        namedNativeQuery.initialize(namedNativeQueryResource);
        return namedNativeQuery;
    }

    protected void updateIdClass() {
        IdClassAnnotation annotation = this.getResourceIdClass();
        if (annotation != null) {
            this.setIdClass_(annotation.getValue());
        } else {
            this.setIdClass_(null);
        }
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getTable().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaSecondaryTable sTable : CollectionTools.iterable(this.secondaryTables())) {
            result = sTable.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        for (JavaPrimaryKeyJoinColumn column : CollectionTools.iterable(this.primaryKeyJoinColumns())) {
            result = column.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        for (JavaJpaContextNode override : CollectionTools.iterable(this.attributeOverrides())) {
            result = override.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        for (JavaJpaContextNode override : CollectionTools.iterable(this.associationOverrides())) {
            result = override.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        result = this.getDiscriminatorColumn().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.getTableGenerator() != null && (result = this.getTableGenerator().javaCompletionProposals(pos, filter, astRoot)) != null) {
            return result;
        }
        if (this.getSequenceGenerator() != null && (result = this.getSequenceGenerator().javaCompletionProposals(pos, filter, astRoot)) != null) {
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateTable(messages, reporter, astRoot);
        this.validateId(messages, astRoot);
        this.validateInheritance(messages, reporter, astRoot);
        this.validateGenerators(messages, astRoot);
        this.validateQueries(messages, astRoot);
        ListIterator<JavaJpaContextNode> stream = this.specifiedSecondaryTables();
        while (stream.hasNext()) {
            ((JavaSecondaryTable)stream.next()).validate(messages, reporter, astRoot);
        }
        stream = this.attributeOverrides();
        while (stream.hasNext()) {
            ((JavaAttributeOverride)stream.next()).validate(messages, reporter, astRoot);
        }
        stream = this.associationOverrides();
        while (stream.hasNext()) {
            ((JavaAssociationOverride)stream.next()).validate(messages, reporter, astRoot);
        }
    }

    protected void validateTable(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        if (this.isAbstractTablePerClass()) {
            if (this.table.isResourceSpecified()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_ABSTRACT_TABLE_PER_CLASS_DEFINES_TABLE", new String[]{this.getName()}, this, this.getTable().getValidationTextRange(astRoot)));
            }
            return;
        }
        if (this.isSingleTableDescendant()) {
            if (this.table.isResourceSpecified()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_SINGLE_TABLE_DESCENDANT_DEFINES_TABLE", new String[]{this.getName()}, this, this.getTable().getValidationTextRange(astRoot)));
            }
            return;
        }
        this.table.validate(messages, reporter, astRoot);
    }

    protected void validateId(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.entityHasNoId()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_NO_ID", new String[]{this.getName()}, this, this.getValidationTextRange(astRoot)));
        }
    }

    protected void validateInheritance(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        this.validateInheritanceStrategy(messages, astRoot);
        this.validateDiscriminatorColumn(messages, reporter, astRoot);
        this.validateDiscriminatorValue(messages, astRoot);
    }

    protected void validateDiscriminatorColumn(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        if (this.specifiedDiscriminatorColumnIsAllowed() && !this.discriminatorColumnIsUndefined()) {
            this.getDiscriminatorColumn().validate(messages, reporter, astRoot);
        } else if (this.getDiscriminatorColumn().isResourceSpecified()) {
            if (!this.isRoot()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_NON_ROOT_DISCRIMINATOR_COLUMN_DEFINED", new String[]{this.getName()}, this, this.getDiscriminatorColumnTextRange(astRoot)));
            } else if (this.isTablePerClass()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_TABLE_PER_CLASS_DISCRIMINATOR_COLUMN_DEFINED", new String[]{this.getName()}, this, this.getDiscriminatorColumnTextRange(astRoot)));
            }
        }
    }

    protected void validateDiscriminatorValue(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.discriminatorValueIsUndefined() && this.getSpecifiedDiscriminatorValue() != null) {
            if (this.isAbstract()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(2, "ENTITY_ABSTRACT_DISCRIMINATOR_VALUE_DEFINED", new String[]{this.getName()}, this, this.getDiscriminatorValueTextRange(astRoot)));
            } else if (this.isTablePerClass()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(2, "ENTITY_TABLE_PER_CLASS_DISCRIMINATOR_VALUE_DEFINED", new String[]{this.getName()}, this, this.getDiscriminatorValueTextRange(astRoot)));
            }
        }
    }

    protected void validateInheritanceStrategy(List<IMessage> messages, CompilationUnit astRoot) {
        JpaValidation.Supported tablePerConcreteClassInheritanceIsSupported = this.getJpaValidation().getTablePerConcreteClassInheritanceIsSupported();
        if (tablePerConcreteClassInheritanceIsSupported == JpaValidation.Supported.YES) {
            return;
        }
        if (this.getInheritanceStrategy() == InheritanceType.TABLE_PER_CLASS && this.isRoot()) {
            if (tablePerConcreteClassInheritanceIsSupported == JpaValidation.Supported.NO) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_TABLE_PER_CLASS_NOT_SUPPORTED_ON_PLATFORM", new String[]{this.getName()}, this, this.getInheritanceStrategyTextRange(astRoot)));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(2, "ENTITY_TABLE_PER_CLASS_NOT_PORTABLE_ON_PLATFORM", new String[]{this.getName()}, this, this.getInheritanceStrategyTextRange(astRoot)));
            }
        }
    }

    protected TextRange getDiscriminatorValueTextRange(CompilationUnit astRoot) {
        return this.getResourceDiscriminatorValue().getTextRange(astRoot);
    }

    protected TextRange getDiscriminatorColumnTextRange(CompilationUnit astRoot) {
        return this.getDiscriminatorColumn().getValidationTextRange(astRoot);
    }

    protected TextRange getInheritanceStrategyTextRange(CompilationUnit astRoot) {
        return this.getResourceInheritance().getStrategyTextRange(astRoot);
    }

    protected boolean entityHasNoId() {
        return !this.entityHasId();
    }

    protected boolean entityHasId() {
        Iterator<PersistentAttribute> stream = this.getPersistentType().allAttributes();
        while (stream.hasNext()) {
            if (!stream.next().isIdAttribute()) continue;
            return true;
        }
        return false;
    }

    protected void validateGenerators(List<IMessage> messages, CompilationUnit astRoot) {
        Iterator<JavaGenerator> localGenerators = this.generators();
        while (localGenerators.hasNext()) {
            JavaGenerator localGenerator = localGenerators.next();
            ListIterator<Generator> globalGenerators = this.getPersistenceUnit().generators();
            while (globalGenerators.hasNext()) {
                if (!localGenerator.duplicates((Generator)globalGenerators.next())) continue;
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "GENERATOR_DUPLICATE_NAME", new String[]{localGenerator.getName()}, localGenerator, localGenerator.getNameTextRange(astRoot)));
            }
        }
    }

    protected void validateQueries(List<IMessage> messages, CompilationUnit astRoot) {
        Iterator<JavaQuery> localQueries = this.queries();
        while (localQueries.hasNext()) {
            JavaQuery localQuery = localQueries.next();
            ListIterator<Query> globalQueries = this.getPersistenceUnit().queries();
            while (globalQueries.hasNext()) {
                if (!localQuery.duplicates((Query)globalQueries.next())) continue;
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "QUERY_DUPLICATE_NAME", new String[]{localQuery.getName()}, localQuery, localQuery.getNameTextRange(astRoot)));
            }
        }
    }

    class AssociationOverrideOwner
    implements AssociationOverride.Owner {
        AssociationOverrideOwner() {
        }

        public RelationshipMapping getRelationshipMapping(String attributeName) {
            if (attributeName == null) {
                return null;
            }
            Iterator<PersistentAttribute> stream = AbstractJavaEntity.this.getPersistentType().allAttributes();
            while (stream.hasNext()) {
                PersistentAttribute persAttribute = stream.next();
                if (!attributeName.equals(persAttribute.getName()) || !(persAttribute.getMapping() instanceof RelationshipMapping)) continue;
                return (RelationshipMapping)persAttribute.getMapping();
            }
            return null;
        }

        public boolean isVirtual(BaseOverride override) {
            return AbstractJavaEntity.this.virtualAssociationOverrides.contains(override);
        }

        public BaseOverride setVirtual(boolean virtual, BaseOverride attributeOverride) {
            return AbstractJavaEntity.this.setAssociationOverrideVirtual(virtual, (JavaAssociationOverride)attributeOverride);
        }

        public TypeMapping getTypeMapping() {
            return AbstractJavaEntity.this;
        }

        public TextRange validationTextRange(CompilationUnit astRoot) {
            return null;
        }
    }

    class AttributeOverrideOwner
    implements AttributeOverride.Owner {
        AttributeOverrideOwner() {
        }

        public ColumnMapping getColumnMapping(String attributeName) {
            if (attributeName == null) {
                return null;
            }
            Iterator<PersistentAttribute> stream = AbstractJavaEntity.this.getPersistentType().allAttributes();
            while (stream.hasNext()) {
                PersistentAttribute persAttribute = stream.next();
                if (!attributeName.equals(persAttribute.getName()) || !(persAttribute.getMapping() instanceof ColumnMapping)) continue;
                return (ColumnMapping)((Object)persAttribute.getMapping());
            }
            return null;
        }

        public boolean isVirtual(BaseOverride override) {
            return AbstractJavaEntity.this.virtualAttributeOverrides.contains(override);
        }

        public BaseOverride setVirtual(boolean virtual, BaseOverride attributeOverride) {
            return AbstractJavaEntity.this.setAttributeOverrideVirtual(virtual, (JavaAttributeOverride)attributeOverride);
        }

        public TypeMapping getTypeMapping() {
            return AbstractJavaEntity.this;
        }

        public TextRange validationTextRange(CompilationUnit astRoot) {
            return null;
        }
    }

    class PrimaryKeyJoinColumnOwner
    implements JavaBaseJoinColumn.Owner {
        PrimaryKeyJoinColumnOwner() {
        }

        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return AbstractJavaEntity.this.getValidationTextRange(astRoot);
        }

        public TypeMapping getTypeMapping() {
            return AbstractJavaEntity.this;
        }

        public org.eclipse.jpt.db.Table getDbTable(String tableName) {
            return AbstractJavaEntity.this.getDbTable(tableName);
        }

        public org.eclipse.jpt.db.Table getReferencedColumnDbTable() {
            Entity parentEntity = AbstractJavaEntity.this.getParentEntity();
            return parentEntity == null ? null : parentEntity.getPrimaryDbTable();
        }

        public int joinColumnsSize() {
            return AbstractJavaEntity.this.primaryKeyJoinColumnsSize();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return AbstractJavaEntity.this.defaultPrimaryKeyJoinColumn == joinColumn;
        }

        public String getDefaultColumnName() {
            if (this.joinColumnsSize() != 1) {
                return null;
            }
            return AbstractJavaEntity.this.getParentEntity().getPrimaryKeyColumnName();
        }
    }
}

