/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.jsdt.core;

/**
 * Utility class for decoding additional flags in completion proposal.
 * <p>
 * This class provides static methods only; it is not intended to be
 * instantiated or subclassed by clients.
 * </p>
 *
 * @see CompletionProposal#getAdditionalFlags()
 *
 *  
 * Provisional API: This class/interface is part of an interim API that is still under development and expected to 
 * change significantly before reaching stability. It is being made available at this early stage to solicit feedback 
 * from pioneering adopters on the understanding that any code that uses this API will almost certainly be broken 
 * (repeatedly) as the API evolves.
 */
public final class CompletionFlags {
	/**
	 * Constant representing the absence of any flag
	 */
	public static final int Default = 0x0000;

	/**
	 * Constant representing a static import
	 */
	public static final int StaticImport = 0x0001;

	/**
	 * Not instantiable.
	 */
	private CompletionFlags() {
		// Not instantiable
	}

	/**
	 * Returns whether the given integer includes the {@link #StaticImport} flag.
	 *
	 * @param flags the flags
	 * @return <code>true</code> if the {@link #StaticImport} flag is included
	 */
	public static boolean isStaticImport(int flags) {
		return (flags & StaticImport) != 0;
	}
}
