/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jst.j2ee.internal.J2EEPropertiesConstants;
import org.eclipse.jst.j2ee.internal.ui.refactoring.RenameContextRootChange;
import org.eclipse.jst.j2ee.internal.ui.refactoring.RenameContextRootRefactoringProcessor;
import org.eclipse.jst.j2ee.internal.ui.refactoring.RenameContextRootWizard;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;

public class J2EEPropertiesPage
extends PropertyPage
implements J2EEPropertiesConstants {
    private Text contextRootNameField;
    private boolean dirty = false;

    protected Control createContents(Composite parent) {
        Composite c = parent;
        IProject project = this.getProject();
        if (project != null && JavaEEProjectUtilities.getJ2EEProjectType((IProject)project).equals("jst.web") || JavaEEProjectUtilities.getJ2EEProjectType((IProject)project).equals("wst.web")) {
            c = new Composite(parent, 0);
            Label contextRootLabel = new Label(c, 0);
            contextRootLabel.setText(J2EEPropertiesConstants.WEB_CONTEXT_ROOT);
            this.contextRootNameField = new Text(c, 2048);
            this.contextRootNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    J2EEPropertiesPage.this.dirty = !J2EEPropertiesPage.this.contextRootNameField.getText().equals(ComponentUtilities.getServerContextRoot((IProject)J2EEPropertiesPage.this.getProject()));
                    J2EEPropertiesPage.this.validateText();
                }
            });
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(c);
            GridDataFactory.defaultsFor((Control)contextRootLabel).applyTo((Control)contextRootLabel);
            GridDataFactory.defaultsFor((Control)this.contextRootNameField).grab(true, false).applyTo((Control)this.contextRootNameField);
        }
        this.applyDialogFont(c);
        return c;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.refresh();
        this.refreshApplyButton();
    }

    private void validateText() {
        IStatus status = RenameContextRootChange.validateContextRoot(this.contextRootNameField.getText());
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
            this.setValid(false);
        } else {
            this.setErrorMessage(null);
            this.setValid(true);
            this.refreshApplyButton();
        }
    }

    private void refreshApplyButton() {
        if (this.dirty) {
            if (this.getApplyButton() != null) {
                this.getApplyButton().setEnabled(true);
            }
        } else if (this.getApplyButton() != null) {
            this.getApplyButton().setEnabled(false);
        }
    }

    public void refresh() {
        if (this.contextRootNameField != null) {
            String s = ComponentUtilities.getServerContextRoot((IProject)this.getProject());
            if (s == null) {
                s = "";
            }
            this.contextRootNameField.setText(s);
            this.validateText();
        }
    }

    private IProject getProject() {
        IAdaptable element = this.getElement();
        if (element == null) {
            return null;
        }
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            return project;
        }
        return null;
    }

    private int doRefactor() {
        int id = 0;
        if (this.dirty) {
            RenameContextRootRefactoringProcessor processor = new RenameContextRootRefactoringProcessor();
            processor.setProject(this.getProject());
            processor.setNewName(this.contextRootNameField.getText());
            RenameContextRootWizard wizard = new RenameContextRootWizard(processor, 4);
            wizard.setPrompt(false);
            RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
            try {
                id = operation.run(this.getShell(), "");
            }
            catch (InterruptedException interruptedException) {}
            if (id == 0) {
                this.dirty = false;
                this.refresh();
            }
        }
        return id;
    }

    protected void performApply() {
        this.doRefactor();
    }

    protected void performDefaults() {
        this.refresh();
    }

    public boolean performOk() {
        return this.doRefactor() == 0;
    }
}

