/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;

public final class WtpUtils {
    private static final String WTP_NATURE = "org.eclipse.wst.common.modulecore.ModuleCoreNature";
    private static final String JEM_NATURE = "org.eclipse.jem.workbench.JavaEMFNature";
    private static final String[] NATURES = new String[]{"org.eclipse.wst.common.modulecore.ModuleCoreNature", "org.eclipse.jem.workbench.JavaEMFNature"};

    private WtpUtils() {
    }

    public static void addNatures(IProject project) throws CoreException {
        int i = 0;
        while (i < NATURES.length) {
            if (!project.hasNature(NATURES[i])) {
                ProjectUtilities.addNatureToProject((IProject)project, (String)NATURES[i]);
            }
            ++i;
        }
    }

    public static void addNaturestoEAR(IProject project) throws CoreException {
        IProjectDescription desc = project.getDescription();
        String[] current = desc.getNatureIds();
        String[] replacement = new String[current.length + 1];
        System.arraycopy(current, 0, replacement, 0, current.length);
        replacement[current.length] = WTP_NATURE;
        desc.setNatureIds(replacement);
        project.setDescription(desc, null);
    }

    public static void removeNatures(IProject project) throws CoreException {
        ProjectUtilities.removeNatureFromProject((IProject)project, (String)WTP_NATURE);
        ProjectUtilities.removeNatureFromProject((IProject)project, (String)JEM_NATURE);
    }
}

