/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.JpaPlatformRegistry;
import org.eclipse.jpt.core.internal.JptCoreMessages;
import org.eclipse.jpt.core.internal.facet.JpaFacetDataModelProperties;
import org.eclipse.jpt.core.internal.facet.JpaFacetDataModelProvider;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterables.CompositeIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaFacetVersionChangeDataModelProvider
extends JpaFacetDataModelProvider
implements JpaFacetDataModelProperties {
    protected static final IStatus PLATFORM_DOES_NOT_SUPPORT_FACET_VERSION_STATUS = JpaFacetVersionChangeDataModelProvider.buildErrorStatus(JptCoreMessages.VALIDATE_PLATFORM_DOES_NOT_SUPPORT_FACET_VERSION);

    protected String getProjectName() {
        return this.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
    }

    protected JpaProject getJpaProject() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
        return JptCorePlugin.getJpaProject(project);
    }

    @Override
    protected String getDefaultPlatformId() {
        return this.getJpaProject().getJpaPlatform().getId();
    }

    @Override
    protected String getDefaultConnection() {
        return this.getJpaProject().getDataSource().getConnectionProfileName();
    }

    @Override
    protected Boolean getDefaultUserWantsToOverrideDefaultCatalog() {
        if (this.getJpaProject().getUserOverrideDefaultCatalog() != null) {
            return true;
        }
        return false;
    }

    @Override
    protected String getDefaultCatalogIdentifier() {
        return this.getJpaProject().getUserOverrideDefaultCatalog();
    }

    @Override
    protected Boolean getDefaultUserWantsToOverrideDefaultSchema() {
        if (this.getJpaProject().getUserOverrideDefaultSchema() != null) {
            return true;
        }
        return false;
    }

    @Override
    protected String getDefaultSchemaIdentifier() {
        return this.getJpaProject().getDefaultSchema();
    }

    @Override
    protected Boolean getDefaultDiscoverAnnotatedClasses() {
        return this.getJpaProject().discoversAnnotatedClasses();
    }

    @Override
    protected Iterable<String> buildValidPlatformIds() {
        CompositeIterable validPlatformIds = super.buildValidPlatformIds();
        if (!CollectionTools.contains(validPlatformIds, (Object)this.getDefaultPlatformId())) {
            validPlatformIds = new CompositeIterable((Object)this.getDefaultPlatformId(), validPlatformIds);
        }
        return validPlatformIds;
    }

    @Override
    protected IStatus validatePlatformId() {
        IStatus status = super.validatePlatformId();
        if (status.isOK() && !JpaPlatformRegistry.instance().platformSupportsJpaFacetVersion(this.getPlatformId(), this.getProjectFacetVersion().getVersionString())) {
            status = PLATFORM_DOES_NOT_SUPPORT_FACET_VERSION_STATUS;
        }
        return status;
    }
}

