/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.document;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeEntry;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeRegistryReader;

public class HTMLDocumentTypeRegistry {
    private static HTMLDocumentTypeRegistry instance = null;
    private Hashtable entries = new Hashtable();
    private HTMLDocumentTypeEntry defaultEntry = null;
    private HTMLDocumentTypeEntry defaultXHTMLEntry = null;
    private HTMLDocumentTypeEntry defaultWMLEntry = null;
    private HTMLDocumentTypeEntry defaultCHTMLEntry = null;
    private HTMLDocumentTypeEntry defaultHTML5Entry = null;
    static final int DEFAULT_HTML = 0;
    static final int DEFAULT_XHTML = 1;
    static final int DEFAULT_WML = 2;
    static final int DEFAULT_CHTML = 3;
    static final int DEFAULT_HTML5 = 4;
    public static final String CHTML_PUBLIC_ID = "-//W3C//DTD Compact HTML 1.0 Draft//EN";

    private HTMLDocumentTypeRegistry() {
        String name = "HTML";
        String publicId = "-//W3C//DTD HTML 4.01 Transitional//EN";
        String systemId = "http://www.w3.org/TR/html4/loose.dtd";
        String displayName = "HTML 4.01 Transitional";
        this.defaultEntry = new HTMLDocumentTypeEntry(name, publicId, systemId, null, false, false, displayName, false, false, false, true);
        this.entries.put(publicId, this.defaultEntry);
        publicId = "-//W3C//DTD HTML 4.01//EN";
        systemId = "http://www.w3.org/TR/html4/strict.dtd";
        displayName = "HTML 4.01 Strict";
        this.entries.put(publicId, new HTMLDocumentTypeEntry(name, publicId, systemId, null, false, false, displayName, false, false, false, true));
        publicId = "-//W3C//DTD HTML 4.01 Frameset//EN";
        systemId = "http://www.w3.org/TR/html4/frameset.dtd";
        displayName = "HTML 4.01 Frameset";
        this.entries.put(publicId, new HTMLDocumentTypeEntry(name, publicId, systemId, null, false, true, displayName, false, false, false, true));
        name = "HTML";
        publicId = CHTML_PUBLIC_ID;
        displayName = "Compact HTML 1.0 Draft";
        this.defaultCHTMLEntry = new HTMLDocumentTypeEntry(name, publicId, null, null, false, false, displayName, false, false, false, true);
        this.entries.put(publicId, this.defaultCHTMLEntry);
        name = "HTML5";
        publicId = "";
        displayName = "HTML5";
        this.defaultHTML5Entry = new HTMLDocumentTypeEntry(name, publicId, null, null, false, false, displayName, false, false, false, true);
        this.entries.put(publicId, this.defaultHTML5Entry);
        HTMLDocumentTypeRegistryReader reader = new HTMLDocumentTypeRegistryReader();
        reader.readRegistry(this);
    }

    void regist(String pid, HTMLDocumentTypeEntry doctype) {
        if (pid == null || doctype == null) {
            return;
        }
        this.entries.put(pid, doctype);
        if (this.defaultXHTMLEntry == null && doctype.isDefaultXHTML()) {
            this.defaultXHTMLEntry = doctype;
        }
        if (this.defaultWMLEntry == null && doctype.isDefaultWML()) {
            this.defaultWMLEntry = doctype;
        }
    }

    public HTMLDocumentTypeEntry getDefaultEntry(int type) {
        HTMLDocumentTypeEntry entry = null;
        switch (type) {
            case 4: {
                entry = this.defaultHTML5Entry;
                break;
            }
            case 1: {
                entry = this.defaultXHTMLEntry;
                break;
            }
            case 2: {
                entry = this.defaultWMLEntry;
                break;
            }
            case 3: {
                entry = this.defaultCHTMLEntry;
                break;
            }
            default: {
                entry = this.defaultEntry;
            }
        }
        return entry;
    }

    public HTMLDocumentTypeEntry getDefaultEntry() {
        return this.defaultEntry;
    }

    public HTMLDocumentTypeEntry getXHTMLDefaultEntry() {
        return this.defaultXHTMLEntry;
    }

    public Enumeration getEntries() {
        ArrayList values = new ArrayList(this.entries.values());
        Collections.sort(values, new HTMLDocumentTypeEntryComparator());
        return new Vector(values).elements();
    }

    public HTMLDocumentTypeEntry getEntry(String publicId) {
        if (publicId == null) {
            return null;
        }
        return (HTMLDocumentTypeEntry)this.entries.get(publicId);
    }

    public static synchronized HTMLDocumentTypeRegistry getInstance() {
        if (instance == null) {
            instance = new HTMLDocumentTypeRegistry();
        }
        return instance;
    }

    static class HTMLDocumentTypeEntryComparator
    implements Comparator {
        static Collator delegate = Collator.getInstance();

        HTMLDocumentTypeEntryComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof HTMLDocumentTypeEntry && o2 instanceof HTMLDocumentTypeEntry && ((HTMLDocumentTypeEntry)o1).getDisplayName() != null && ((HTMLDocumentTypeEntry)o2).getDisplayName() != null) {
                return delegate.compare(((HTMLDocumentTypeEntry)o1).getDisplayName(), ((HTMLDocumentTypeEntry)o2).getDisplayName());
            }
            return 0;
        }
    }
}

