/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.modelquery;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.XMLAssociationProvider;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDocumentCache;
import org.w3c.dom.Document;

class XHTMLAssociationProvider
extends XMLAssociationProvider {
    private static final boolean CACHE_FIXED_DOCUMENTS = true;
    private static final String[] STANDARD_SCHEMA_BUNDLES = new String[]{"org.eclipse.wst.standard.schemas", "org.eclipse.jst.standard.schemas"};
    private static final String XML_CATALOG_EXT_POINT = "org.eclipse.wst.xml.core.catalogContributions";
    private static Collection fFixedPublicIDs = null;
    private static Map fFixedCMDocuments = new HashMap();
    private static final boolean USE_QUICK_CACHE = true;
    protected URIResolver idResolver;
    private String fCachedGrammerURI;
    private String fCachedPublicID;
    private String fCachedSystemID;
    private boolean cached;

    public XHTMLAssociationProvider(CMDocumentCache cache, URIResolver idResolver) {
        super(cache);
        this.idResolver = idResolver;
        this.documentManager.setPropertyEnabled("performURIResolution", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMDocument getXHTMLCMDocument(String publicId, String systemId) {
        if (this.idResolver == null) {
            return null;
        }
        String grammerURI = null;
        if (this.cached && this.sameAs(this.fCachedPublicID, publicId) && this.sameAs(this.fCachedSystemID, systemId)) {
            grammerURI = this.fCachedGrammerURI;
        } else {
            this.fCachedGrammerURI = grammerURI = this.idResolver.resolve(null, publicId, systemId);
            this.fCachedPublicID = publicId;
            this.fCachedSystemID = systemId;
            this.cached = true;
        }
        if (grammerURI == null) {
            return null;
        }
        CMDocument cmDocument = null;
        Reference ref = (Reference)fFixedCMDocuments.get(publicId);
        if (ref != null && (cmDocument = (CMDocument)ref.get()) != null) {
            return cmDocument;
        }
        String string = grammerURI;
        synchronized (string) {
            cmDocument = this.documentManager.getCMDocument(publicId, grammerURI, null);
        }
        if (XHTMLAssociationProvider.getFixedPublicIDs().contains(publicId)) {
            fFixedCMDocuments.put(publicId, new SoftReference<CMDocument>(cmDocument));
        }
        return cmDocument;
    }

    protected String resolveGrammarURI(Document document, String publicId, String systemId) {
        return this.idResolver.resolve(null, publicId, systemId);
    }

    private boolean sameAs(String a, String b) {
        boolean result = false;
        result = a == null ? b == null : a.equals(b);
        return result;
    }

    public String getCachedGrammerURI() {
        return this.fCachedGrammerURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection getFixedPublicIDs() {
        String[] stringArray = STANDARD_SCHEMA_BUNDLES;
        synchronized (STANDARD_SCHEMA_BUNDLES) {
            if (fFixedPublicIDs == null) {
                fFixedPublicIDs = new HashSet();
                int i = 0;
                while (i < STANDARD_SCHEMA_BUNDLES.length) {
                    IExtension[] extensions = Platform.getExtensionRegistry().getExtensions(STANDARD_SCHEMA_BUNDLES[i]);
                    int j = 0;
                    while (j < extensions.length) {
                        if (XML_CATALOG_EXT_POINT.equals(extensions[j].getExtensionPointUniqueIdentifier())) {
                            IConfigurationElement[] configurationElements = extensions[j].getConfigurationElements();
                            int k = 0;
                            while (k < configurationElements.length) {
                                IConfigurationElement[] publics = configurationElements[k].getChildren("public");
                                int l = 0;
                                while (l < publics.length) {
                                    String publicId = publics[l].getAttribute("publicId");
                                    if (publicId != null && publicId.length() > 0) {
                                        fFixedPublicIDs.add(publicId);
                                    }
                                    ++l;
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return fFixedPublicIDs;
        }
    }
}

