/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.details;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.details.JpaComposite;
import org.eclipse.jpt.ui.internal.details.AbstractJpaDetailsPage;
import org.eclipse.jpt.ui.internal.details.PersistentTypeMapAsComposite;
import org.eclipse.jpt.ui.internal.util.ControlSwitcher;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.model.value.FilteringPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentTypeDetailsPage
extends AbstractJpaDetailsPage<PersistentType> {
    private Map<String, JpaComposite> mappingComposites;
    private PageBook mappingPageBook;
    private PropertyValueModel<TypeMapping> mappingHolder;

    public PersistentTypeDetailsPage(Composite parent, WidgetFactory widgetFactory) {
        super(parent, widgetFactory);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.mappingComposites = new HashMap<String, JpaComposite>();
    }

    @Override
    protected void initializeLayout(Composite container) {
        new PersistentTypeMapAsComposite(this, this.addSubPane(container, 0, 0, 5, 0));
        this.buildMappingPageBook(container);
    }

    protected PageBook buildMappingPageBook(Composite parent) {
        this.mappingPageBook = new PageBook(parent, 0);
        this.mappingPageBook.showPage((Control)this.addLabel((Composite)this.mappingPageBook, ""));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.mappingPageBook.setLayoutData((Object)gridData);
        this.mappingHolder = this.buildMappingHolder();
        new ControlSwitcher(this.mappingHolder, this.buildPaneTransformer(), this.mappingPageBook);
        return this.mappingPageBook;
    }

    private Transformer<TypeMapping, Control> buildPaneTransformer() {
        return new Transformer<TypeMapping, Control>(){

            public Control transform(TypeMapping typeMapping) {
                if (typeMapping == null) {
                    return null;
                }
                return PersistentTypeDetailsPage.this.getMappingComposite(typeMapping.getKey()).getControl();
            }
        };
    }

    protected PropertyValueModel<TypeMapping> buildMappingHolder(String key) {
        return new FilteringPropertyValueModel(this.mappingHolder, this.buildMappingFilter(key));
    }

    private PropertyAspectAdapter<PersistentType, TypeMapping> buildMappingHolder() {
        return new PropertyAspectAdapter<PersistentType, TypeMapping>(this.getSubjectHolder(), new String[]{"mapping"}){

            protected TypeMapping buildValue_() {
                return ((PersistentType)this.subject).getMapping();
            }
        };
    }

    private Filter<TypeMapping> buildMappingFilter(final String key) {
        return new Filter<TypeMapping>(){

            public boolean accept(TypeMapping mapping) {
                return mapping == null || key == null || key.equals(mapping.getKey());
            }
        };
    }

    private JpaComposite getMappingComposite(String key) {
        JpaComposite mappingComposite = this.mappingComposites.get(key);
        if (mappingComposite != null) {
            return mappingComposite;
        }
        mappingComposite = this.buildMappingComposite(this.mappingPageBook, key);
        if (mappingComposite != null) {
            this.mappingComposites.put(key, mappingComposite);
        }
        return mappingComposite;
    }

    protected JpaComposite buildMappingComposite(PageBook pageBook, String key) {
        return this.getJpaPlatformUi().buildTypeMappingComposite(((PersistentType)this.getSubject()).getResourceType(), key, (Composite)pageBook, this.buildMappingHolder(key), this.getWidgetFactory());
    }

    @Override
    public void dispose() {
        this.log("/debug/ui/detailsView", "PersistentTypeDetailsPage.dispose()");
        for (JpaComposite mappingComposite : this.mappingComposites.values()) {
            mappingComposite.dispose();
        }
        this.mappingComposites.clear();
        super.dispose();
    }
}

