/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tests;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.regex.Matcher;
import org.eclipse.wtp.releng.tests.ComparatorLogMessage;
import org.eclipse.wtp.releng.tests.ComparatorRules;
import org.eclipse.wtp.releng.tests.RuleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparatorLog {
    public static final String COMPARATOR_UNEXPECTED_MESSAGES_LOG_TXT = "comparatorUnexpectedMessages.log.txt";
    public static final String COMPARATOR_EXCLUDED_MESSAGES_LOG_TXT = "comparatorExcludedMessages.log.txt";
    public static final String COMPARATOR_ALL_MESSAGES_LOG_TXT = "comparatorAllMessages.log.txt";
    private String comparatorLogFile;
    private String summaryLogDir;
    private String summary;
    private ArrayList<ComparatorLogMessage> allMessages;
    private ArrayList<ComparatorLogMessage> excludedMessages;
    private ArrayList<ComparatorLogMessage> significantMessages;
    private ArrayList<RuleData> comparatorRules;
    private ComparatorRules comparatorRulesInstance = new ComparatorRules();
    private static final String COMPARATOR_LOG_PARAM = "comparatorLogLocation";
    private static final String SUMMARY_LOG_DIR_PARAM = "comparatorTestSummaryLogDir";
    private static final String LINE_SEPARATOR_PROPERTY_NAME = "line.separator";
    private static final String PATH_SEPARATOR_PROPERTY_NAME = "path.separator";
    private static String EOL = System.getProperty("line.separator");
    private static String PATH_SEPERATOR = System.getProperty("path.separator");
    private String defaultComparatorLogFile = "D:\\builds\\workspaces\\workspaceWTPHead\\org.eclipse.wtp.releng.tests\\comparator.log";
    private String defaultsummaryLogDir = System.getProperty("user.dir");

    public static void main(String[] args) {
        try {
            ComparatorLog comparatorLog = new ComparatorLog();
            int n = comparatorLog.getNumberOfUnexpectedMessages();
            System.out.println("Number of unexpected messages from comparator: " + n);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ComparatorLog() {
    }

    public ComparatorLog(String comparatorLogLocation, String summaryLogDir) {
        this.comparatorLogFile = comparatorLogLocation;
        this.summaryLogDir = summaryLogDir;
    }

    private void dofilterMessages(ArrayList<ComparatorLogMessage> allMessages, ArrayList<ComparatorLogMessage> excludedMessages, ArrayList<ComparatorLogMessage> significantMessages) throws IOException {
        int i = 0;
        while (i < allMessages.size()) {
            ComparatorLogMessage comparatorLogMessage = allMessages.get(i);
            if (this.matchesExcludRule(comparatorLogMessage)) {
                excludedMessages.add(comparatorLogMessage);
            } else {
                significantMessages.add(comparatorLogMessage);
            }
            ++i;
        }
    }

    private void filterMessages() throws IOException {
        this.allMessages = this.getMessages();
        this.excludedMessages = new ArrayList();
        this.significantMessages = new ArrayList();
        this.dofilterMessages(this.allMessages, this.excludedMessages, this.significantMessages);
    }

    private ArrayList<RuleData> getComparatorExcludeRules() throws IOException {
        if (this.comparatorRules == null) {
            this.comparatorRules = this.getComparatorRulesInstance().getDataRules();
        }
        return this.comparatorRules;
    }

    private ComparatorRules getComparatorRulesInstance() {
        return this.comparatorRulesInstance;
    }

    public String getComparatorLogFile() {
        if (this.comparatorLogFile == null) {
            this.comparatorLogFile = System.getProperty(COMPARATOR_LOG_PARAM);
            if (this.comparatorLogFile == null || this.comparatorLogFile.length() <= 0) {
                throw new IllegalArgumentException("Comparator: found no value for log location in comparatorLogLocation");
            }
            System.out.println("Comparator log: comparatorLogLocation specified " + this.comparatorLogFile);
        }
        return this.comparatorLogFile;
    }

    public String getComparatorOutputSummaryDir() {
        if (this.summaryLogDir == null) {
            this.summaryLogDir = System.getProperty(SUMMARY_LOG_DIR_PARAM);
            if (this.summaryLogDir == null || this.summaryLogDir.length() <= 0) {
                this.summaryLogDir = this.defaultsummaryLogDir;
            }
            if (this.summaryLogDir != null) {
                File tempDir = new File(this.summaryLogDir);
                if (!tempDir.exists()) {
                    tempDir.mkdirs();
                    System.out.println("Comparator log: created output directory at " + tempDir);
                } else {
                    System.out.println("Comparator log: using output directory at " + tempDir);
                }
            }
        }
        return this.summaryLogDir;
    }

    private String getLine(BufferedReader logFile) throws IOException {
        String line = "";
        line = logFile.readLine();
        line = line != null ? line.trim() : "";
        return line;
    }

    private BufferedReader getLogFile() throws FileNotFoundException {
        BufferedReader reader = null;
        try {
            String logFileLocationAndName = this.getComparatorLogFile();
            File logFile = new File(logFileLocationAndName);
            FileReader log = new FileReader(logFile);
            reader = new BufferedReader(log);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("Comparator log not found where expected at " + this.getComparatorLogFile());
        }
        return reader;
    }

    private ArrayList<ComparatorLogMessage> getMessages() throws IOException {
        ArrayList<ComparatorLogMessage> loglist = new ArrayList<ComparatorLogMessage>();
        BufferedReader logFile = this.getLogFile();
        this.summary = logFile.readLine();
        while (logFile.ready()) {
            ComparatorLogMessage item = new ComparatorLogMessage();
            String line = logFile.readLine();
            if (line == null) continue;
            line = line.trim();
            item.setSummary(line);
            line = this.getLine(logFile);
            item.setComparison(line);
            line = this.getLine(logFile);
            item.setReason(line);
            if (line.startsWith("IOException") || line.startsWith("The entry")) {
                line = this.getLine(logFile);
                item.setExtraDetail(line);
            }
            loglist.add(item);
        }
        logFile.close();
        return loglist;
    }

    public int getNumberOfUnexpectedMessages() throws IOException {
        this.filterMessages();
        this.printReportFilesAll();
        this.printReportFilesExcluded();
        this.printReportFilesSignificant();
        return this.significantMessages.size();
    }

    private String getSummary() {
        return this.summary;
    }

    private boolean matchesExcludRule(ComparatorLogMessage comparatorLogMessage) throws IOException {
        boolean result = false;
        ArrayList<RuleData> excludeRules = this.getComparatorExcludeRules();
        for (RuleData ruleData : excludeRules) {
            Matcher matcherSummary = ruleData.getSummary().matcher(comparatorLogMessage.getSummary());
            Matcher matcherComparison = ruleData.getComparison().matcher(comparatorLogMessage.getComparison());
            Matcher matcherReason = ruleData.getReason().matcher(comparatorLogMessage.getReason());
            boolean matchesSummmary = matcherSummary.matches();
            boolean matchesComparison = matcherComparison.matches();
            boolean matchesReason = matcherReason.matches();
            boolean bl = result = matchesSummmary && matchesComparison && matchesReason;
            if (result) break;
        }
        return result;
    }

    private void print(ComparatorLogMessage comparatorLogMessage, Writer output) throws IOException {
        output.write(String.valueOf(comparatorLogMessage.getSummary()) + EOL);
        output.write(String.valueOf(comparatorLogMessage.getComparison()) + EOL);
        output.write(String.valueOf(comparatorLogMessage.getReason()) + EOL);
        if (comparatorLogMessage.getExtraDetail() != null) {
            output.write(String.valueOf(comparatorLogMessage.getExtraDetail()) + EOL);
        }
    }

    private void printReportFilesAll() throws IOException {
        BufferedWriter output = null;
        try {
            File outfile = new File(this.getComparatorOutputSummaryDir(), COMPARATOR_ALL_MESSAGES_LOG_TXT);
            FileWriter out = new FileWriter(outfile);
            output = new BufferedWriter(out);
            output.write(String.valueOf(EOL) + EOL + "All Comparator Messages" + EOL + EOL);
            output.write(String.valueOf(EOL) + COMPARATOR_LOG_PARAM + ": " + this.getComparatorLogFile() + EOL);
            output.write(String.valueOf(EOL) + SUMMARY_LOG_DIR_PARAM + ": " + this.getComparatorOutputSummaryDir() + EOL);
            output.write(String.valueOf(EOL) + "comparatorFilterRules" + ": " + this.getComparatorRulesInstance().getFilterPropertyFileLocation() + EOL);
            output.write(EOL);
            output.write(String.valueOf(this.summary) + EOL + EOL);
            int count = 1;
            for (ComparatorLogMessage msg : this.allMessages) {
                output.write(String.valueOf(EOL) + "Message " + count++ + EOL);
                this.print(msg, output);
            }
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    private void printReportFilesExcluded() throws IOException {
        BufferedWriter output = null;
        try {
            File outfile = new File(this.getComparatorOutputSummaryDir(), COMPARATOR_EXCLUDED_MESSAGES_LOG_TXT);
            FileWriter out = new FileWriter(outfile);
            output = new BufferedWriter(out);
            output.write(String.valueOf(EOL) + EOL + "Non-significant (expected) Comparator Messages" + EOL + EOL);
            output.write(String.valueOf(this.summary) + EOL + EOL);
            int count = 1;
            for (ComparatorLogMessage msg : this.excludedMessages) {
                output.write(String.valueOf(EOL) + "Message " + count++ + EOL);
                this.print(msg, output);
            }
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    private void printReportFilesSignificant() throws IOException {
        BufferedWriter output = null;
        try {
            File outfile = new File(this.getComparatorOutputSummaryDir(), COMPARATOR_UNEXPECTED_MESSAGES_LOG_TXT);
            FileWriter out = new FileWriter(outfile);
            output = new BufferedWriter(out);
            output.write(String.valueOf(EOL) + EOL + "Significant (Unexpected) Comparator Messages" + EOL + EOL);
            output.write(String.valueOf(this.summary) + EOL + EOL);
            int count = 1;
            for (ComparatorLogMessage msg : this.significantMessages) {
                output.write(String.valueOf(EOL) + "Message " + count++ + EOL);
                this.print(msg, output);
            }
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    public void setComparatorLogFile(String comparatorLogFile) {
        this.comparatorLogFile = comparatorLogFile;
    }

    public void setComparatorOutputSummaryDir(String comparatorOutputSummaryDir) {
        this.summaryLogDir = comparatorOutputSummaryDir;
    }

    private void setSummary(String summary) {
        this.summary = summary;
    }
}

