/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CUCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.wst.jsdt.ui.CodeGeneration;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class JavadocTagsSubProcessor {
    private static String[] TAG_ORDER = new String[]{"@author", "@version", "@param", "@return", "@throws", "@see", " ", "@serial", "@deprecated"};

    public static void getMissingJavadocTagProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        String label;
        ASTNode node = problem.getCoveringNode(context.getASTRoot());
        if (node == null) {
            return;
        }
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration(node = ASTNodes.getNormalizedNode(node));
        if (bodyDeclaration == null) {
            return;
        }
        JSdoc javadoc = bodyDeclaration.getJavadoc();
        if (javadoc == null) {
            return;
        }
        StructuralPropertyDescriptor location = node.getLocationInParent();
        if (location == SingleVariableDeclaration.NAME_PROPERTY) {
            label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_paramtag_description;
            if (node.getParent().getLocationInParent() != FunctionDeclaration.PARAMETERS_PROPERTY) {
                return;
            }
        } else if (location == TypeParameter.NAME_PROPERTY) {
            label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_paramtag_description;
            StructuralPropertyDescriptor parentLocation = node.getParent().getLocationInParent();
            if (parentLocation != FunctionDeclaration.TYPE_PARAMETERS_PROPERTY && parentLocation != TypeDeclaration.TYPE_PARAMETERS_PROPERTY) {
                return;
            }
        } else if (location == FunctionDeclaration.RETURN_TYPE2_PROPERTY) {
            label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_returntag_description;
        } else if (location == FunctionDeclaration.THROWN_EXCEPTIONS_PROPERTY) {
            label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_throwstag_description;
        } else {
            return;
        }
        AddMissingJavadocTagProposal proposal = new AddMissingJavadocTagProposal(label, context.getCompilationUnit(), bodyDeclaration, node, 1);
        proposals.add(proposal);
        String label2 = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_allmissing_description;
        AddAllMissingJavadocTagsProposal addAllMissing = new AddAllMissingJavadocTagsProposal(label2, context.getCompilationUnit(), bodyDeclaration, 5);
        proposals.add(addAllMissing);
    }

    public static void getMissingJavadocCommentProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        ASTNode node = problem.getCoveringNode(context.getASTRoot());
        if (node == null) {
            return;
        }
        BodyDeclaration declaration = ASTResolving.findParentBodyDeclaration(node);
        if (declaration == null) {
            return;
        }
        IJavaScriptUnit cu = context.getCompilationUnit();
        ITypeBinding binding = Bindings.getBindingOfParentType((ASTNode)declaration);
        if (binding == null) {
            return;
        }
        if (declaration instanceof FunctionDeclaration) {
            String string;
            FunctionDeclaration methodDecl = (FunctionDeclaration)declaration;
            IFunctionBinding methodBinding = methodDecl.resolveBinding();
            IFunctionBinding overridden = null;
            if (methodBinding != null) {
                overridden = Bindings.findOverriddenMethod(methodBinding, true);
            }
            if ((string = CodeGeneration.getMethodComment(cu, binding.getName(), methodDecl, overridden, String.valueOf('\n'))) != null) {
                String label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_method_description;
                proposals.add(new AddJavadocCommentProposal(label, cu, 1, declaration.getStartPosition(), string));
            }
        } else if (declaration instanceof AbstractTypeDeclaration) {
            String[] typeParamNames;
            String typeQualifiedName = Bindings.getTypeQualifiedName(binding);
            if (declaration instanceof TypeDeclaration) {
                List typeParams = ((TypeDeclaration)declaration).typeParameters();
                typeParamNames = new String[typeParams.size()];
                int i = 0;
                while (i < typeParamNames.length) {
                    typeParamNames[i] = ((TypeParameter)typeParams.get(i)).getName().getIdentifier();
                    ++i;
                }
            } else {
                typeParamNames = new String[]{};
            }
            String string = CodeGeneration.getTypeComment(cu, typeQualifiedName, typeParamNames, String.valueOf('\n'));
            if (string != null) {
                String label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_type_description;
                proposals.add(new AddJavadocCommentProposal(label, cu, 1, declaration.getStartPosition(), string));
            }
        } else if (declaration instanceof FieldDeclaration) {
            String comment = "/**\n *\n */\n";
            List fragments = ((FieldDeclaration)declaration).fragments();
            if (fragments != null && fragments.size() > 0) {
                VariableDeclaration decl = (VariableDeclaration)fragments.get(0);
                String fieldName = decl.getName().getIdentifier();
                String typeName = binding.getName();
                comment = CodeGeneration.getFieldComment(cu, typeName, fieldName, String.valueOf('\n'));
            }
            if (comment != null) {
                String label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_field_description;
                proposals.add(new AddJavadocCommentProposal(label, cu, 1, declaration.getStartPosition(), comment));
            }
        }
    }

    public static Set getPreviousTypeParamNames(List typeParams, ASTNode missingNode) {
        HashSet<String> previousNames = new HashSet<String>();
        int i = 0;
        while (i < typeParams.size()) {
            TypeParameter curr = (TypeParameter)typeParams.get(i);
            if (curr == missingNode) {
                return previousNames;
            }
            previousNames.add(String.valueOf('<') + curr.getName().getIdentifier() + '>');
            ++i;
        }
        return previousNames;
    }

    private static Set getPreviousParamNames(List params, ASTNode missingNode) {
        HashSet<String> previousNames = new HashSet<String>();
        int i = 0;
        while (i < params.size()) {
            SingleVariableDeclaration curr = (SingleVariableDeclaration)params.get(i);
            if (curr == missingNode) {
                return previousNames;
            }
            previousNames.add(curr.getName().getIdentifier());
            ++i;
        }
        return previousNames;
    }

    private static Set getPreviousExceptionNames(List list, ASTNode missingNode) {
        HashSet<String> previousNames = new HashSet<String>();
        int i = 0;
        while (i < list.size() && missingNode != list.get(i)) {
            Name curr = (Name)list.get(i);
            previousNames.add(ASTNodes.getSimpleNameIdentifier(curr));
            ++i;
        }
        return previousNames;
    }

    public static TagElement findTag(JSdoc javadoc, String name, String arg) {
        List tags = javadoc.tags();
        int nTags = tags.size();
        int i = 0;
        while (i < nTags) {
            TagElement curr = (TagElement)tags.get(i);
            if (name.equals(curr.getTagName())) {
                if (arg != null) {
                    String argument = JavadocTagsSubProcessor.getArgument(curr);
                    if (arg.equals(argument)) {
                        return curr;
                    }
                } else {
                    return curr;
                }
            }
            ++i;
        }
        return null;
    }

    public static TagElement findParamTag(JSdoc javadoc, String arg) {
        List tags = javadoc.tags();
        int nTags = tags.size();
        int i = 0;
        while (i < nTags) {
            String argument;
            TagElement curr = (TagElement)tags.get(i);
            String currName = curr.getTagName();
            if ("@param".equals(currName) && arg.equals(argument = JavadocTagsSubProcessor.getArgument(curr))) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    public static TagElement findThrowsTag(JSdoc javadoc, String arg) {
        List tags = javadoc.tags();
        int nTags = tags.size();
        int i = 0;
        while (i < nTags) {
            String argument;
            TagElement curr = (TagElement)tags.get(i);
            String currName = curr.getTagName();
            if (("@throws".equals(currName) || "@exception".equals(currName)) && arg.equals(argument = JavadocTagsSubProcessor.getArgument(curr))) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    public static void insertTag(ListRewrite rewriter, TagElement newElement, Set sameKindLeadingNames) {
        JavadocTagsSubProcessor.insertTag(rewriter, newElement, sameKindLeadingNames, null);
    }

    public static void insertTag(ListRewrite rewriter, TagElement newElement, Set sameKindLeadingNames, TextEditGroup groupDescription) {
        List tags = rewriter.getRewrittenList();
        String insertedTagName = newElement.getTagName();
        TagElement after = null;
        int tagRanking = JavadocTagsSubProcessor.getTagRanking(insertedTagName);
        int i = tags.size() - 1;
        while (i >= 0) {
            String arg;
            TagElement curr = (TagElement)tags.get(i);
            String tagName = curr.getTagName();
            if (tagName == null || tagRanking > JavadocTagsSubProcessor.getTagRanking(tagName)) {
                after = curr;
                break;
            }
            if (sameKindLeadingNames != null && JavadocTagsSubProcessor.isSameTag(insertedTagName, tagName) && (arg = JavadocTagsSubProcessor.getArgument(curr)) != null && sameKindLeadingNames.contains(arg)) {
                after = curr;
                break;
            }
            --i;
        }
        if (after != null) {
            rewriter.insertAfter((ASTNode)newElement, after, groupDescription);
        } else {
            rewriter.insertFirst((ASTNode)newElement, groupDescription);
        }
    }

    private static boolean isSameTag(String insertedTagName, String tagName) {
        if (insertedTagName.equals(tagName)) {
            return true;
        }
        if ("@exception".equals(tagName)) {
            return "@throws".equals(insertedTagName);
        }
        return false;
    }

    private static int getTagRanking(String tagName) {
        if (tagName.equals("@exception")) {
            tagName = "@throws";
        }
        int i = 0;
        while (i < TAG_ORDER.length) {
            if (tagName.equals(TAG_ORDER[i])) {
                return i;
            }
            ++i;
        }
        return TAG_ORDER.length;
    }

    private static String getArgument(TagElement curr) {
        List fragments = curr.fragments();
        if (!fragments.isEmpty()) {
            Object first = fragments.get(0);
            if (first instanceof Name) {
                return ASTNodes.getSimpleNameIdentifier((Name)first);
            }
            if (first instanceof TextElement && "@param".equals(curr.getTagName())) {
                String text = ((TextElement)first).getText();
                if ("<".equals(text) && fragments.size() >= 3) {
                    Object second = fragments.get(1);
                    Object third = fragments.get(2);
                    if (second instanceof Name && third instanceof TextElement && ">".equals(((TextElement)third).getText())) {
                        return String.valueOf('<') + ASTNodes.getSimpleNameIdentifier((Name)second) + '>';
                    }
                } else if (text.startsWith(String.valueOf('<')) && text.endsWith(String.valueOf('>')) && text.length() > 2) {
                    return text.substring(1, text.length() - 1);
                }
            }
        }
        return null;
    }

    public static void getRemoveJavadocTagProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ASTNode node = problem.getCoveringNode(context.getASTRoot());
        while (node != null && !(node instanceof TagElement)) {
            node = node.getParent();
        }
        if (node == null) {
            return;
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)node.getAST());
        rewrite.remove(node, null);
        String label = CorrectionMessages.JavadocTagsSubProcessor_removetag_description;
        Image image = JavaScriptPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
        proposals.add(new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 5, image));
    }

    private static final class AddAllMissingJavadocTagsProposal
    extends LinkedCorrectionProposal {
        private final BodyDeclaration fBodyDecl;

        public AddAllMissingJavadocTagsProposal(String label, IJavaScriptUnit cu, BodyDeclaration bodyDecl, int relevance) {
            super(label, cu, (ASTRewrite)null, relevance, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.jdoc_tag_obj.gif"));
            this.fBodyDecl = bodyDecl;
        }

        protected ASTRewrite getRewrite() throws CoreException {
            ASTRewrite rewrite = ASTRewrite.create((AST)this.fBodyDecl.getAST());
            if (this.fBodyDecl instanceof FunctionDeclaration) {
                this.insertAllMissingMethodTags(rewrite, (FunctionDeclaration)this.fBodyDecl);
            } else {
                this.insertAllMissingTypeTags(rewrite, (TypeDeclaration)this.fBodyDecl);
            }
            return rewrite;
        }

        private void insertAllMissingMethodTags(ASTRewrite rewriter, FunctionDeclaration methodDecl) {
            Type type;
            AST ast = methodDecl.getAST();
            JSdoc javadoc = methodDecl.getJavadoc();
            ListRewrite tagsRewriter = rewriter.getListRewrite((ASTNode)javadoc, JSdoc.TAGS_PROPERTY);
            List typeParams = methodDecl.typeParameters();
            ArrayList<String> typeParamNames = new ArrayList<String>();
            int i = typeParams.size() - 1;
            while (i >= 0) {
                TypeParameter decl = (TypeParameter)typeParams.get(i);
                String name = String.valueOf('<') + decl.getName().getIdentifier() + '>';
                if (JavadocTagsSubProcessor.findTag(javadoc, "@param", name) == null) {
                    TagElement newTag = ast.newTagElement();
                    newTag.setTagName("@param");
                    TextElement text = ast.newTextElement();
                    text.setText(name);
                    newTag.fragments().add(text);
                    this.insertTabStop(rewriter, newTag.fragments(), "typeParam" + i);
                    JavadocTagsSubProcessor.insertTag(tagsRewriter, newTag, JavadocTagsSubProcessor.getPreviousTypeParamNames(typeParams, (ASTNode)decl));
                }
                typeParamNames.add(name);
                --i;
            }
            List params = methodDecl.parameters();
            int i2 = params.size() - 1;
            while (i2 >= 0) {
                SingleVariableDeclaration decl = (SingleVariableDeclaration)params.get(i2);
                String name = decl.getName().getIdentifier();
                if (JavadocTagsSubProcessor.findTag(javadoc, "@param", name) == null) {
                    TagElement newTag = ast.newTagElement();
                    newTag.setTagName("@param");
                    newTag.fragments().add(ast.newSimpleName(name));
                    this.insertTabStop(rewriter, newTag.fragments(), "methParam" + i2);
                    Set sameKindLeadingNames = JavadocTagsSubProcessor.getPreviousParamNames(params, (ASTNode)decl);
                    sameKindLeadingNames.addAll(typeParamNames);
                    JavadocTagsSubProcessor.insertTag(tagsRewriter, newTag, sameKindLeadingNames);
                }
                --i2;
            }
            if (!(methodDecl.isConstructor() || (type = methodDecl.getReturnType2()).isPrimitiveType() && ((PrimitiveType)type).getPrimitiveTypeCode() == PrimitiveType.VOID || JavadocTagsSubProcessor.findTag(javadoc, "@return", null) != null)) {
                TagElement newTag = ast.newTagElement();
                newTag.setTagName("@return");
                this.insertTabStop(rewriter, newTag.fragments(), "return");
                JavadocTagsSubProcessor.insertTag(tagsRewriter, newTag, null);
            }
            List thrownExceptions = methodDecl.thrownExceptions();
            int i3 = thrownExceptions.size() - 1;
            while (i3 >= 0) {
                String name;
                Name exception = (Name)thrownExceptions.get(i3);
                ITypeBinding binding = exception.resolveTypeBinding();
                if (binding != null && JavadocTagsSubProcessor.findThrowsTag(javadoc, name = binding.getName()) == null) {
                    TagElement newTag = ast.newTagElement();
                    newTag.setTagName("@throws");
                    TextElement excNode = ast.newTextElement();
                    excNode.setText(ASTNodes.asString((ASTNode)exception));
                    newTag.fragments().add(excNode);
                    this.insertTabStop(rewriter, newTag.fragments(), "exception" + i3);
                    JavadocTagsSubProcessor.insertTag(tagsRewriter, newTag, JavadocTagsSubProcessor.getPreviousExceptionNames(thrownExceptions, (ASTNode)exception));
                }
                --i3;
            }
        }

        private void insertAllMissingTypeTags(ASTRewrite rewriter, TypeDeclaration typeDecl) {
            AST ast = typeDecl.getAST();
            JSdoc javadoc = typeDecl.getJavadoc();
            ListRewrite tagsRewriter = rewriter.getListRewrite((ASTNode)javadoc, JSdoc.TAGS_PROPERTY);
            List typeParams = typeDecl.typeParameters();
            int i = typeParams.size() - 1;
            while (i >= 0) {
                TypeParameter decl = (TypeParameter)typeParams.get(i);
                String name = String.valueOf('<') + decl.getName().getIdentifier() + '>';
                if (JavadocTagsSubProcessor.findTag(javadoc, "@param", name) == null) {
                    TagElement newTag = ast.newTagElement();
                    newTag.setTagName("@param");
                    TextElement text = ast.newTextElement();
                    text.setText(name);
                    newTag.fragments().add(text);
                    this.insertTabStop(rewriter, newTag.fragments(), "typeParam" + i);
                    JavadocTagsSubProcessor.insertTag(tagsRewriter, newTag, JavadocTagsSubProcessor.getPreviousTypeParamNames(typeParams, (ASTNode)decl));
                }
                --i;
            }
        }

        private void insertTabStop(ASTRewrite rewriter, List fragments, String linkedName) {
            TextElement textElement = rewriter.getAST().newTextElement();
            textElement.setText("");
            fragments.add(textElement);
            this.addLinkedPosition(rewriter.track((ASTNode)textElement), false, linkedName);
        }
    }

    private static final class AddJavadocCommentProposal
    extends CUCorrectionProposal {
        private final int fInsertPosition;
        private final String fComment;

        private AddJavadocCommentProposal(String name, IJavaScriptUnit cu, int relevance, int insertPosition, String comment) {
            super(name, cu, relevance, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.jdoc_tag_obj.gif"));
            this.fInsertPosition = insertPosition;
            this.fComment = comment;
        }

        protected void addEdits(IDocument document, TextEdit rootEdit) throws CoreException {
            try {
                String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
                IJavaScriptProject project = this.getCompilationUnit().getJavaScriptProject();
                IRegion region = document.getLineInformationOfOffset(this.fInsertPosition);
                String lineContent = document.get(region.getOffset(), region.getLength());
                String indentString = Strings.getIndentString(lineContent, project);
                String str = Strings.changeIndent(this.fComment, 0, project, indentString, lineDelimiter);
                InsertEdit edit = new InsertEdit(this.fInsertPosition, str);
                rootEdit.addChild((TextEdit)edit);
                if (this.fComment.charAt(this.fComment.length() - 1) != '\n') {
                    rootEdit.addChild((TextEdit)new InsertEdit(this.fInsertPosition, lineDelimiter));
                    rootEdit.addChild((TextEdit)new InsertEdit(this.fInsertPosition, indentString));
                }
            }
            catch (BadLocationException e) {
                throw new CoreException(JavaUIStatus.createError(4, e));
            }
        }
    }

    private static final class AddMissingJavadocTagProposal
    extends LinkedCorrectionProposal {
        private final BodyDeclaration fBodyDecl;
        private final ASTNode fMissingNode;

        public AddMissingJavadocTagProposal(String label, IJavaScriptUnit cu, BodyDeclaration methodDecl, ASTNode missingNode, int relevance) {
            super(label, cu, (ASTRewrite)null, relevance, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.jdoc_tag_obj.gif"));
            this.fBodyDecl = methodDecl;
            this.fMissingNode = missingNode;
        }

        protected ASTRewrite getRewrite() throws CoreException {
            AST ast = this.fBodyDecl.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            this.insertMissingJavadocTag(rewrite, this.fMissingNode, this.fBodyDecl);
            return rewrite;
        }

        private void insertMissingJavadocTag(ASTRewrite rewrite, ASTNode missingNode, BodyDeclaration bodyDecl) {
            TagElement newTag;
            AST ast = bodyDecl.getAST();
            JSdoc javadoc = bodyDecl.getJavadoc();
            ListRewrite tagsRewriter = rewrite.getListRewrite((ASTNode)javadoc, JSdoc.TAGS_PROPERTY);
            StructuralPropertyDescriptor location = missingNode.getLocationInParent();
            if (location == SingleVariableDeclaration.NAME_PROPERTY) {
                SingleVariableDeclaration decl = (SingleVariableDeclaration)missingNode.getParent();
                String name = ((SimpleName)missingNode).getIdentifier();
                newTag = ast.newTagElement();
                newTag.setTagName("@param");
                List fragments = newTag.fragments();
                fragments.add(ast.newSimpleName(name));
                FunctionDeclaration methodDeclaration = (FunctionDeclaration)bodyDecl;
                List params = methodDeclaration.parameters();
                Set sameKindLeadingNames = JavadocTagsSubProcessor.getPreviousParamNames(params, (ASTNode)decl);
                List typeParams = methodDeclaration.typeParameters();
                int i = 0;
                while (i < typeParams.size()) {
                    String curr = String.valueOf('<') + ((TypeParameter)typeParams.get(i)).getName().getIdentifier() + '>';
                    sameKindLeadingNames.add(curr);
                    ++i;
                }
                JavadocTagsSubProcessor.insertTag(tagsRewriter, newTag, sameKindLeadingNames);
            } else if (location == TypeParameter.NAME_PROPERTY) {
                TypeParameter typeParam = (TypeParameter)missingNode.getParent();
                String name = String.valueOf('<') + ((SimpleName)missingNode).getIdentifier() + '>';
                newTag = ast.newTagElement();
                newTag.setTagName("@param");
                TextElement text = ast.newTextElement();
                text.setText(name);
                newTag.fragments().add(text);
                List params = bodyDecl instanceof TypeDeclaration ? ((TypeDeclaration)bodyDecl).typeParameters() : ((FunctionDeclaration)bodyDecl).typeParameters();
                JavadocTagsSubProcessor.insertTag(tagsRewriter, newTag, JavadocTagsSubProcessor.getPreviousTypeParamNames(params, (ASTNode)typeParam));
            } else if (location == FunctionDeclaration.RETURN_TYPE2_PROPERTY) {
                newTag = ast.newTagElement();
                newTag.setTagName("@return");
                JavadocTagsSubProcessor.insertTag(tagsRewriter, newTag, null);
            } else if (location == FunctionDeclaration.THROWN_EXCEPTIONS_PROPERTY) {
                newTag = ast.newTagElement();
                newTag.setTagName("@throws");
                TextElement excNode = ast.newTextElement();
                excNode.setText(ASTNodes.asString(missingNode));
                newTag.fragments().add(excNode);
                List exceptions = ((FunctionDeclaration)bodyDecl).thrownExceptions();
                JavadocTagsSubProcessor.insertTag(tagsRewriter, newTag, JavadocTagsSubProcessor.getPreviousExceptionNames(exceptions, missingNode));
            } else {
                Assert.isTrue((boolean)false, (String)"AddMissingJavadocTagProposal: unexpected node location");
                return;
            }
            TextElement textElement = ast.newTextElement();
            textElement.setText("");
            newTag.fragments().add(textElement);
            this.addLinkedPosition(rewrite.track((ASTNode)textElement), false, "comment_start");
        }
    }
}

