/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jpt.ui.internal.listeners.SWTCollectionChangeListenerWrapper;
import org.eclipse.jpt.ui.internal.listeners.SWTListChangeListenerWrapper;
import org.eclipse.jpt.ui.internal.swt.ColumnAdapter;
import org.eclipse.jpt.ui.internal.swt.TableItemModelAdapter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.model.value.PropertyCollectionValueModelAdapter;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableModelAdapter<E> {
    protected final ListValueModel<E> listHolder;
    protected final ListChangeListener listChangeListener;
    protected final CollectionValueModel<E> selectedItemsHolder;
    protected final CollectionChangeListener selectedItemsChangeListener;
    protected final Table table;
    protected final SelectionListener tableSelectionListener;
    protected SelectionChangeListener<E>[] selectionChangeListeners;
    protected DoubleClickListener<E>[] doubleClickListeners;
    protected final DisposeListener tableDisposeListener;
    protected final ITableLabelProvider labelProvider;
    private ColumnAdapter<E> columnAdapter;
    private List<TableItemModelAdapter> tableItemModelAdapters;

    public static <T> TableModelAdapter<T> adapt(ListValueModel<T> listHolder, PropertyValueModel<T> selectedItemHolder, Table table, ColumnAdapter<T> columnAdapter, ITableLabelProvider labelProvider) {
        return new TableModelAdapter<T>(listHolder, new PropertyCollectionValueModelAdapter(selectedItemHolder), table, columnAdapter, labelProvider);
    }

    protected TableModelAdapter(ListValueModel<E> listHolder, CollectionValueModel<E> selectedItemsHolder, Table table, ColumnAdapter<E> columnAdapter, ITableLabelProvider labelProvider) {
        if (listHolder == null || selectedItemsHolder == null || table == null || labelProvider == null) {
            throw new NullPointerException();
        }
        this.listHolder = listHolder;
        this.selectedItemsHolder = selectedItemsHolder;
        this.table = table;
        this.columnAdapter = columnAdapter;
        this.labelProvider = labelProvider;
        this.tableItemModelAdapters = new ArrayList<TableItemModelAdapter>(columnAdapter.columnCount());
        this.listChangeListener = this.buildListChangeListener();
        this.listHolder.addListChangeListener("list values", this.listChangeListener);
        this.selectedItemsChangeListener = this.buildSelectedItemsChangeListener();
        this.selectedItemsHolder.addCollectionChangeListener("values", this.selectedItemsChangeListener);
        this.tableSelectionListener = this.buildTableSelectionListener();
        this.table.addSelectionListener(this.tableSelectionListener);
        this.selectionChangeListeners = this.buildSelectionChangeListeners();
        this.doubleClickListeners = this.buildDoubleClickListeners();
        this.tableDisposeListener = this.buildTableDisposeListener();
        this.table.addDisposeListener(this.tableDisposeListener);
        this.synchronizeTable();
    }

    protected ListChangeListener buildListChangeListener() {
        return new SWTListChangeListenerWrapper(this.buildListChangeListener_());
    }

    protected ListChangeListener buildListChangeListener_() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent event) {
                TableModelAdapter.this.listItemsAdded(event);
            }

            public void itemsRemoved(ListChangeEvent event) {
                TableModelAdapter.this.listItemsRemoved(event);
            }

            public void itemsMoved(ListChangeEvent event) {
                TableModelAdapter.this.listItemsMoved(event);
            }

            public void itemsReplaced(ListChangeEvent event) {
                TableModelAdapter.this.listItemsReplaced(event);
            }

            public void listCleared(ListChangeEvent event) {
                TableModelAdapter.this.listCleared(event);
            }

            public void listChanged(ListChangeEvent event) {
                TableModelAdapter.this.listChanged(event);
            }

            public String toString() {
                return "list listener";
            }
        };
    }

    protected CollectionChangeListener buildSelectedItemsChangeListener() {
        return new SWTCollectionChangeListenerWrapper(this.buildSelectedItemsChangeListener_());
    }

    protected CollectionChangeListener buildSelectedItemsChangeListener_() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent event) {
                TableModelAdapter.this.selectedItemsAdded(event);
            }

            public void itemsRemoved(CollectionChangeEvent event) {
                TableModelAdapter.this.selectedItemsRemoved(event);
            }

            public void collectionCleared(CollectionChangeEvent event) {
                TableModelAdapter.this.selectedItemsCleared(event);
            }

            public void collectionChanged(CollectionChangeEvent event) {
                TableModelAdapter.this.selectedItemsChanged(event);
            }

            public String toString() {
                return "selected items listener";
            }
        };
    }

    protected SelectionListener buildTableSelectionListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                TableModelAdapter.this.tableSelectionChanged(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                TableModelAdapter.this.tableDoubleClicked(event);
            }

            public String toString() {
                return "table selection listener";
            }
        };
    }

    protected DoubleClickListener<E>[] buildDoubleClickListeners() {
        return new DoubleClickListener[0];
    }

    protected SelectionChangeListener<E>[] buildSelectionChangeListeners() {
        return new SelectionChangeListener[0];
    }

    protected DisposeListener buildTableDisposeListener() {
        return new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                TableModelAdapter.this.tableDisposed(event);
            }

            public String toString() {
                return "table dispose listener";
            }
        };
    }

    protected void synchronizeTable() {
        this.synchronizeTableColumns();
        this.synchronizeTableItems();
        this.synchronizeTableSelection();
    }

    protected void synchronizeTableColumns() {
        if (this.table.isDisposed()) {
            return;
        }
        int columnCount = this.columnAdapter.columnCount();
        int index = 0;
        while (index < columnCount) {
            TableColumn tableColumn = new TableColumn(this.table, 0, index);
            tableColumn.setMoveable(false);
            tableColumn.setResizable(true);
            tableColumn.setWidth(100);
            String columnName = this.columnAdapter.columnName(index);
            if (columnName == null) {
                columnName = "";
            }
            tableColumn.setText(columnName);
            ++index;
        }
    }

    protected void synchronizeTableItems() {
        if (this.table.isDisposed()) {
            return;
        }
        int index = this.table.getItemCount();
        while (--index >= 0) {
            this.table.remove(index);
            this.tableItemModelAdapters.remove(index);
        }
        int itemCount = this.listHolder.size();
        int index2 = 0;
        while (index2 < itemCount) {
            TableItem tableItem = new TableItem(this.table, 0, index2);
            tableItem.setData(this.listHolder.get(index2));
            TableItemModelAdapter adapter = this.buildItemModel(tableItem);
            this.tableItemModelAdapters.add(adapter);
            ++index2;
        }
    }

    protected void listItemsAdded(ListChangeEvent event) {
        if (this.table.isDisposed()) {
            return;
        }
        int index = event.getIndex();
        ListIterator<E> stream = this.items(event);
        while (stream.hasNext()) {
            TableItem tableItem = new TableItem(this.table, 0, index);
            tableItem.setData(stream.next());
            TableItemModelAdapter adapter = this.buildItemModel(tableItem);
            this.tableItemModelAdapters.add(index, adapter);
            ++index;
        }
    }

    protected void listItemsRemoved(ListChangeEvent event) {
        if (this.table.isDisposed()) {
            return;
        }
        this.table.remove(event.getIndex(), event.getIndex() + event.itemsSize() - 1);
        int index = event.getIndex() + event.itemsSize();
        while (--index >= event.getIndex()) {
            this.tableItemModelAdapters.remove(index);
        }
    }

    protected void listItemsMoved(ListChangeEvent event) {
        if (this.table.isDisposed()) {
            return;
        }
        int length = event.getMoveLength();
        int sourceIndex = event.getSourceIndex();
        int targetIndex = event.getTargetIndex();
        int lowStartIndex = Math.min(targetIndex, sourceIndex);
        int hiStartIndex = Math.max(targetIndex, sourceIndex);
        Object[] items = new Object[hiStartIndex - lowStartIndex + length];
        int itemsIndex = items.length;
        int index = hiStartIndex + length;
        while (--index >= lowStartIndex) {
            TableItemModelAdapter tableItemModel = this.tableItemModelAdapters.get(index);
            items[--itemsIndex] = tableItemModel.tableItem.getData();
            this.table.remove(index);
        }
        CollectionTools.move((Object[])items, (int)(targetIndex - lowStartIndex), (int)(sourceIndex - lowStartIndex), (int)length);
        itemsIndex = 0;
        index = lowStartIndex;
        while (index <= hiStartIndex + length - 1) {
            TableItem tableItem = new TableItem(this.table, 0, index);
            tableItem.setData(items[itemsIndex++]);
            TableItemModelAdapter adapter = this.buildItemModel(tableItem);
            this.tableItemModelAdapters.set(index, adapter);
            ++index;
        }
    }

    private TableItemModelAdapter buildItemModel(TableItem tableItem) {
        return TableItemModelAdapter.adapt(tableItem, this.columnAdapter, this.labelProvider);
    }

    protected void listItemsReplaced(ListChangeEvent event) {
        if (this.table.isDisposed()) {
            return;
        }
        int rowIndex = event.getIndex();
        ListIterator<E> stream = this.items(event);
        while (stream.hasNext()) {
            TableItem tableItem = this.table.getItem(rowIndex);
            tableItem.setData(stream.next());
            TableItemModelAdapter adapter = this.tableItemModelAdapters.get(rowIndex);
            int columnCount = this.columnAdapter.columnCount();
            boolean revalidate = columnCount == 1;
            int columnIndex = columnCount;
            while (--columnIndex >= 0) {
                adapter.tableItemChanged(columnIndex, tableItem.getData(), revalidate);
            }
            ++rowIndex;
        }
    }

    protected void listCleared(ListChangeEvent event) {
        if (this.table.isDisposed()) {
            return;
        }
        this.table.removeAll();
    }

    protected void listChanged(ListChangeEvent event) {
        this.synchronizeTableItems();
    }

    protected ListIterator<E> items(ListChangeEvent event) {
        return event.items();
    }

    protected int indexOf(E item) {
        int len = this.listHolder.size();
        int i = 0;
        while (i < len) {
            if (this.listHolder.get(i) == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void synchronizeTableSelection() {
        if (this.table.isDisposed()) {
            return;
        }
        int[] indices = new int[this.selectedItemsHolder.size()];
        int i = 0;
        Iterator stream = this.selectedItemsHolder.iterator();
        while (stream.hasNext()) {
            indices[i++] = this.indexOf(stream.next());
        }
        this.table.deselectAll();
        this.table.select(indices);
    }

    protected void selectedItemsAdded(CollectionChangeEvent event) {
        if (this.table.isDisposed()) {
            return;
        }
        int[] indices = new int[event.itemsSize()];
        int i = 0;
        Iterator<E> stream = this.items(event);
        while (stream.hasNext()) {
            indices[i++] = this.indexOf(stream.next());
        }
        this.table.select(indices);
    }

    protected void selectedItemsRemoved(CollectionChangeEvent event) {
        if (this.table.isDisposed()) {
            return;
        }
        int[] indices = new int[event.itemsSize()];
        int i = 0;
        Iterator<E> stream = this.items(event);
        while (stream.hasNext()) {
            indices[i++] = this.indexOf(stream.next());
        }
        this.table.deselect(indices);
    }

    protected void selectedItemsCleared(CollectionChangeEvent event) {
        if (this.table.isDisposed()) {
            return;
        }
        this.table.deselectAll();
    }

    protected void selectedItemsChanged(CollectionChangeEvent event) {
        this.synchronizeTableSelection();
    }

    protected Iterator<E> items(CollectionChangeEvent event) {
        return event.items();
    }

    protected void tableSelectionChanged(SelectionEvent event) {
        if (this.selectionChangeListeners.length > 0) {
            SelectionChangeEvent<E> scEvent = new SelectionChangeEvent<E>(this, this.selectedItems());
            SelectionChangeListener<E>[] selectionChangeListenerArray = this.selectionChangeListeners;
            int n = this.selectionChangeListeners.length;
            int n2 = 0;
            while (n2 < n) {
                SelectionChangeListener<E> selectionChangeListener = selectionChangeListenerArray[n2];
                selectionChangeListener.selectionChanged(scEvent);
                ++n2;
            }
        }
    }

    protected Collection<E> selectedItems() {
        if (this.table.isDisposed()) {
            return Collections.emptySet();
        }
        ArrayList<Object> selectedItems = new ArrayList<Object>(this.table.getSelectionCount());
        int[] nArray = this.table.getSelectionIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int selectionIndex = nArray[n2];
            selectedItems.add(this.listHolder.get(selectionIndex));
            ++n2;
        }
        return selectedItems;
    }

    protected void tableDoubleClicked(SelectionEvent event) {
        if (this.table.isDisposed()) {
            return;
        }
        if (this.doubleClickListeners.length > 0) {
            Object selection = this.listHolder.get(this.table.getSelectionIndex());
            DoubleClickEvent<Object> dcEvent = new DoubleClickEvent<Object>(this, selection);
            DoubleClickListener<E>[] doubleClickListenerArray = this.doubleClickListeners;
            int n = this.doubleClickListeners.length;
            int n2 = 0;
            while (n2 < n) {
                DoubleClickListener<Object> doubleClickListener = doubleClickListenerArray[n2];
                doubleClickListener.doubleClick(dcEvent);
                ++n2;
            }
        }
    }

    protected void tableDisposed(DisposeEvent event) {
        this.table.removeDisposeListener(this.tableDisposeListener);
        this.table.removeSelectionListener(this.tableSelectionListener);
        this.selectedItemsHolder.removeCollectionChangeListener("values", this.selectedItemsChangeListener);
        this.listHolder.removeListChangeListener("list values", this.listChangeListener);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, this.listHolder);
    }

    public void addDoubleClickListener(DoubleClickListener<E> listener) {
        this.doubleClickListeners = (DoubleClickListener[])CollectionTools.add((Object[])this.doubleClickListeners, listener);
    }

    public void removeDoubleClickListener(DoubleClickListener<E> listener) {
        this.doubleClickListeners = (DoubleClickListener[])CollectionTools.remove((Object[])this.doubleClickListeners, listener);
    }

    public void addSelectionChangeListener(SelectionChangeListener<E> listener) {
        this.selectionChangeListeners = (SelectionChangeListener[])CollectionTools.add((Object[])this.selectionChangeListeners, listener);
    }

    public void removeSelectionChangeListener(SelectionChangeListener<E> listener) {
        this.selectionChangeListeners = (SelectionChangeListener[])CollectionTools.remove((Object[])this.selectionChangeListeners, listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoubleClickEvent<E>
    extends EventObject {
        private final E selection;
        private static final long serialVersionUID = 1L;

        protected DoubleClickEvent(TableModelAdapter<E> source, E selection) {
            super(source);
            if (selection == null) {
                throw new NullPointerException();
            }
            this.selection = selection;
        }

        @Override
        public TableModelAdapter<E> getSource() {
            return (TableModelAdapter)super.getSource();
        }

        public E selection() {
            return this.selection;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DoubleClickListener<E> {
        public void doubleClick(DoubleClickEvent<E> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectionChangeEvent<E>
    extends EventObject {
        private final Collection<E> selection;
        private static final long serialVersionUID = 1L;

        protected SelectionChangeEvent(TableModelAdapter<E> source, Collection<E> selection) {
            super(source);
            if (selection == null) {
                throw new NullPointerException();
            }
            this.selection = selection;
        }

        @Override
        public TableModelAdapter<E> getSource() {
            return (TableModelAdapter)super.getSource();
        }

        public Iterator<E> selection() {
            return this.selection.iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SelectionChangeListener<E> {
        public void selectionChanged(SelectionChangeEvent<E> var1);
    }
}

