/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.adapters.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dali.core.AttributeOverride;
import org.eclipse.dali.core.Column;
import org.eclipse.dali.core.DaliFactory;
import org.eclipse.dali.core.Entity;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.Inheritance;
import org.eclipse.dali.core.Table;
import org.eclipse.dali.core.TypeMapping;
import org.eclipse.dali.core.adapters.IEntityModelAdapter;
import org.eclipse.dali.core.adapters.java.AbstractAnnotationElementAdapter;
import org.eclipse.dali.core.adapters.java.IJavaTypeMappingModelAdapter;
import org.eclipse.dali.core.adapters.java.JavaAttributeOverrideAdapter;
import org.eclipse.dali.core.adapters.java.JavaAttributeOverrideColumnModelAdapter;
import org.eclipse.dali.core.adapters.java.JavaInheritanceModelAdapter;
import org.eclipse.dali.core.adapters.java.JavaTableModelAdapter;
import org.eclipse.dali.core.adapters.java.Member;
import org.eclipse.dali.core.adapters.java.StringAnnotationElementAdapter;
import org.eclipse.dali.core.adapters.java.Type;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;

public class JavaEntityModelAdapter
implements IEntityModelAdapter,
IJavaTypeMappingModelAdapter {
    private Type type;
    private StringAnnotationElementAdapter specifiedNameAdapter;
    private JavaTableModelAdapter tableModelAdapter;
    private JavaInheritanceModelAdapter inheritanceModelAdapter;
    private Entity entity;

    public JavaEntityModelAdapter(Type type) {
        this.type = type;
        this.specifiedNameAdapter = new StringAnnotationElementAdapter(this.buildSpecifiedNameElementInfo());
        this.tableModelAdapter = new JavaTableModelAdapter();
        this.inheritanceModelAdapter = new JavaInheritanceModelAdapter();
    }

    public void engage(TypeMapping typeMapping, CompilationUnit astRoot) {
        this.entity = (Entity)typeMapping;
        Table table = DaliFactory.eINSTANCE.createTable(this.tableModelAdapter);
        ((Entity)typeMapping).setTable(table);
        this.tableModelAdapter.engage(table, astRoot);
        Inheritance inheritance = DaliFactory.eINSTANCE.createInheritance(this.inheritanceModelAdapter);
        ((Entity)typeMapping).setInheritance(inheritance);
        this.inheritanceModelAdapter.engage(inheritance, astRoot);
        this.updatePersModel(astRoot);
    }

    public void disengage() {
        this.entity = null;
    }

    public void addAnnotation() {
        CompilationUnit astRoot = this.type.createASTRoot();
        if (!this.type.containsAnnotation("Entity", astRoot)) {
            this.type.addAnnotation("Entity", astRoot);
        }
    }

    public void removeAnnotation() {
        CompilationUnit astRoot = this.type.createASTRoot();
        if (this.type.containsAnnotation("Entity", astRoot)) {
            this.type.removeAnnotation("Entity", astRoot);
        }
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildSpecifiedNameElementInfo() {
        return new AbstractAnnotationElementAdapter.AnnotationElementInfo(){

            public void setPersValue(String newValue) {
                JavaEntityModelAdapter.this.getEntity().setSpecifiedName(newValue);
            }

            public String persValue() {
                return JavaEntityModelAdapter.this.getEntity().getSpecifiedName();
            }

            public String annotationElementName() {
                return "name";
            }

            public String annotationName() {
                return "Entity";
            }

            public Member member() {
                return JavaEntityModelAdapter.this.type;
            }

            public String defaultValue() {
                return null;
            }
        };
    }

    public void synchWithJavaDelta(IJavaElementDelta delta, CompilationUnit astRoot) {
        if ((delta.getFlags() & 1) != 0) {
            this.updatePersModel(astRoot);
        }
    }

    protected void updatePersModel(CompilationUnit astRoot) {
        this.updatePersDefaultName();
        this.updatePersSpecifiedName(astRoot);
        this.tableModelAdapter.updatePersModel(astRoot);
        this.updatePersAttributeOverrides(astRoot);
        this.inheritanceModelAdapter.updatePersModel(astRoot);
    }

    public Entity getEntity() {
        return this.entity;
    }

    protected void updatePersSpecifiedName(CompilationUnit astRoot) {
        this.specifiedNameAdapter.updatePersElement(astRoot);
    }

    private void updatePersDefaultName() {
        String name = this.defaultName();
        String persName = this.entity.getDefaultName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.entity.setDefaultName(name);
        }
    }

    private AttributeOverride attributeOverrideNamed(String attributeName) {
        Iterator overrides = this.getEntity().getAttributeOverrides().iterator();
        while (overrides.hasNext()) {
            AttributeOverride override = (AttributeOverride)overrides.next();
            if (override.getName() == null || !override.getName().equals(attributeName)) continue;
            return override;
        }
        return null;
    }

    private boolean existsInJava(AttributeOverride override, CompilationUnit astRoot) {
        String overrideName = override.getName();
        if (overrideName == null) {
            return false;
        }
        Iterator attributeNames = this.getEntity().inheritedAttributeNames();
        while (attributeNames.hasNext()) {
            String attributeName = (String)attributeNames.next();
            if (!overrideName.equals(attributeName)) continue;
            return true;
        }
        Iterator overrideAnnotations = this.attributeOverrideNormalAnnotations(astRoot).iterator();
        while (overrideAnnotations.hasNext()) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)overrideAnnotations.next();
            if (!overrideName.equals(this.nameFromAttributeOverrideAnnotation(normalAnnotation))) continue;
            return true;
        }
        return false;
    }

    private void updatePersAttributeOverrides(CompilationUnit astRoot) {
        ArrayList<AttributeOverride> overridesToRemove = new ArrayList<AttributeOverride>();
        Iterator overrides = this.getEntity().getAttributeOverrides().iterator();
        while (overrides.hasNext()) {
            AttributeOverride override = (AttributeOverride)overrides.next();
            if (!this.existsInJava(override, astRoot)) {
                overridesToRemove.add(override);
                continue;
            }
            ((JavaAttributeOverrideAdapter)override.getModelAdapter()).updatePersModel(astRoot);
        }
        this.getEntity().getAttributeOverrides().removeAll(overridesToRemove);
        Iterator i = this.attributeOverrideNormalAnnotations(astRoot).iterator();
        while (i.hasNext()) {
            this.addOrUpdatePersAttributeOverrideFrom((NormalAnnotation)i.next(), astRoot);
        }
        Iterator attributes = this.getEntity().inheritedAttributeNames();
        while (attributes.hasNext()) {
            String attributeName = (String)attributes.next();
            AttributeOverride existingOverride = this.attributeOverrideNamed(attributeName);
            if (existingOverride != null) continue;
            this.createAttributeOverride(attributeName);
        }
    }

    private Collection attributeOverrideNormalAnnotations(CompilationUnit astRoot) {
        ArrayList<Annotation> overrideAnnotations = new ArrayList<Annotation>();
        Annotation attributeOverridesAnnotation = this.type.getAnnotation("AttributeOverrides", astRoot);
        if (attributeOverridesAnnotation != null) {
            MemberValuePair valueValuePair;
            Expression valueExpression = null;
            if (attributeOverridesAnnotation.isSingleMemberAnnotation()) {
                valueExpression = ((SingleMemberAnnotation)attributeOverridesAnnotation).getValue();
            } else if (attributeOverridesAnnotation.isNormalAnnotation() && (valueValuePair = ASTTools.getMemberValuePair((NormalAnnotation)attributeOverridesAnnotation, "value")) != null) {
                valueExpression = valueValuePair.getValue();
            }
            if (valueExpression == null) {
                return overrideAnnotations;
            }
            if (valueExpression.getNodeType() == 77) {
                if (((NormalAnnotation)valueExpression).getTypeName().getFullyQualifiedName().equals("AttributeOverride")) {
                    overrideAnnotations.add((Annotation)valueExpression);
                }
            } else if (valueExpression.getNodeType() == 4) {
                List expressions = ((ArrayInitializer)valueExpression).expressions();
                int i = 0;
                while (i < expressions.size()) {
                    Expression expression = (Expression)expressions.get(i);
                    if (expression.getNodeType() == 77 && ((NormalAnnotation)expression).getTypeName().getFullyQualifiedName().equals("AttributeOverride")) {
                        overrideAnnotations.add((Annotation)expression);
                    }
                    ++i;
                }
            }
        } else {
            Annotation attributeOverrideAnnotation = this.type.getAnnotation("AttributeOverride", astRoot);
            if (attributeOverrideAnnotation != null && attributeOverrideAnnotation.getNodeType() == 77) {
                overrideAnnotations.add(attributeOverrideAnnotation);
            }
        }
        return overrideAnnotations;
    }

    private void addOrUpdatePersAttributeOverrideFrom(NormalAnnotation attributeOverrideAnnotation, CompilationUnit astRoot) {
        AttributeOverride attributeOverride;
        String attributeName = this.nameFromAttributeOverrideAnnotation(attributeOverrideAnnotation);
        Iterator attributeOverrides = this.getEntity().getAttributeOverrides().iterator();
        while (attributeOverrides.hasNext()) {
            attributeOverride = (AttributeOverride)attributeOverrides.next();
            if (!attributeOverride.getName().equals(attributeName)) continue;
            ((JavaAttributeOverrideAdapter)attributeOverride.getModelAdapter()).updatePersModel(astRoot);
            return;
        }
        attributeOverride = this.createAttributeOverride(attributeName);
        attributeOverride.setSpecifiedName(attributeName);
    }

    private String nameFromAttributeOverrideAnnotation(NormalAnnotation attributeOverrideAnnotation) {
        MemberValuePair nameValuePair = ASTTools.getMemberValuePair(attributeOverrideAnnotation, "name");
        String attributeName = null;
        if (nameValuePair != null && nameValuePair.getValue().getNodeType() == 45) {
            attributeName = ((StringLiteral)nameValuePair.getValue()).getLiteralValue();
        }
        return attributeName;
    }

    public void specifiedNameChanged() {
        this.updateJavaSpecifiedName();
    }

    private void updateJavaSpecifiedName() {
        this.specifiedNameAdapter.updateJavaElement();
    }

    protected String defaultName() {
        return this.javaDefaultName();
    }

    private String javaDefaultName() {
        return this.type.getName();
    }

    public ITextRange tableTextRange() {
        return this.tableModelAdapter.getTextRange();
    }

    public ITextRange getTextRange() {
        return this.type.getTextRange(this.getEntity().getAnnotationName());
    }

    public AttributeOverride createAttributeOverride(String attributeName) {
        JavaAttributeOverrideAdapter overrideAdapter = new JavaAttributeOverrideAdapter();
        AttributeOverride attributeOverride = DaliFactory.eINSTANCE.createAttributeOverride(overrideAdapter);
        attributeOverride.setDefaultName(attributeName);
        JavaAttributeOverrideColumnModelAdapter modelAdapter = new JavaAttributeOverrideColumnModelAdapter();
        Column column = DaliFactory.eINSTANCE.createColumn(modelAdapter, this.buildColumnContext());
        attributeOverride.setColumn(column);
        this.getEntity().getAttributeOverrides().add((Object)attributeOverride);
        CompilationUnit ast = this.type.createASTRoot();
        overrideAdapter.engage(attributeOverride, this.type, modelAdapter, column, ast);
        return attributeOverride;
    }

    private Column.ColumnContext buildColumnContext() {
        return new Column.ColumnContext(){

            public org.eclipse.dali.db.Table getExpectedTable() {
                return JavaEntityModelAdapter.this.getEntity().getResolvedDBTable();
            }
        };
    }
}

