/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.tests.AbstractUndoManagerTest;
import org.eclipse.text.undo.DocumentUndoEvent;
import org.eclipse.text.undo.DocumentUndoManager;
import org.eclipse.text.undo.IDocumentUndoListener;
import org.eclipse.text.undo.IDocumentUndoManager;

public class TextViewerUndoManagerTest
extends AbstractUndoManagerTest {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.tests.TextViewerUndoManagerTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public TextViewerUndoManagerTest(String name) {
        super(name);
    }

    protected IUndoManager createUndoManager(int maxUndoLevel) {
        return new TextViewerUndoManager(maxUndoLevel);
    }

    public void internalTestTransferNonTextOp(final boolean isUndoable) throws Exception {
        Object context = new Object();
        DocumentUndoManager tempUndoManager = new DocumentUndoManager((IDocument)new Document());
        tempUndoManager.connect(context);
        AbstractOperation operation = new AbstractOperation(""){

            public boolean canUndo() {
                return isUndoable;
            }

            public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return Status.OK_STATUS;
            }

            public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return Status.OK_STATUS;
            }

            public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return Status.OK_STATUS;
            }
        };
        operation.addContext(tempUndoManager.getUndoContext());
        OperationHistoryFactory.getOperationHistory().add((IUndoableOperation)operation);
        TextViewerUndoManagerTest.assertEquals((boolean)isUndoable, (boolean)tempUndoManager.undoable());
        DocumentUndoManager undoManager = new DocumentUndoManager((IDocument)new Document());
        Object newContext = new Object();
        undoManager.connect(newContext);
        undoManager.addDocumentUndoListener(new IDocumentUndoListener(){

            public void documentUndoNotification(DocumentUndoEvent event) {
                TextViewerUndoManagerTest.fail();
            }
        });
        undoManager.transferUndoHistory((IDocumentUndoManager)tempUndoManager);
        tempUndoManager.disconnect(context);
        TextViewerUndoManagerTest.assertEquals((boolean)isUndoable, (boolean)undoManager.undoable());
        undoManager.undo();
        TextViewerUndoManagerTest.assertEquals((boolean)false, (boolean)undoManager.undoable());
        undoManager.disconnect(newContext);
    }

    public void testTransferNonUndoableNonTextOp() throws Exception {
        this.internalTestTransferNonTextOp(false);
    }

    public void testTransferUndoableNonTextOp() throws Exception {
        this.internalTestTransferNonTextOp(true);
    }

    public void testCanUndo() throws Exception {
        Document doc = new Document();
        final DocumentUndoManager undoManager = new DocumentUndoManager((IDocument)doc);
        Object context = new Object();
        undoManager.connect(context);
        undoManager.addDocumentUndoListener(new IDocumentUndoListener(){

            public void documentUndoNotification(DocumentUndoEvent event) {
                if (event.getEventType() == 1) {
                    TextViewerUndoManagerTest.assertEquals((boolean)true, (boolean)undoManager.undoable());
                } else if (event.getEventType() == 4) {
                    TextViewerUndoManagerTest.assertEquals((boolean)false, (boolean)undoManager.undoable());
                }
            }
        });
        doc.set("foo");
        TextViewerUndoManagerTest.assertEquals((boolean)true, (boolean)undoManager.undoable());
        undoManager.undo();
        TextViewerUndoManagerTest.assertEquals((boolean)false, (boolean)undoManager.undoable());
        undoManager.disconnect(context);
    }
}

