/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.state;

import junit.framework.TestCase;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.ws.jaxws.dom.runtime.IPropertyState;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.DomFactory;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.DomPackage;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.state.PropertyStateAdapterFactory;

public class WsPropertyStateAdapterTest
extends TestCase {
    private IWebService ws;

    public void setUp() {
        this.ws = DomFactory.eINSTANCE.createIWebService();
    }

    public void testIsAdapted() {
        IPropertyState adapter = (IPropertyState)PropertyStateAdapterFactory.INSTANCE.adapt((Notifier)this.ws, IPropertyState.class);
        WsPropertyStateAdapterTest.assertNotNull((Object)adapter);
    }

    public void testIsChangebleOutsideInWs() {
        this.ws.setWsdlLocation("C:/test");
        IPropertyState adapter = (IPropertyState)PropertyStateAdapterFactory.INSTANCE.adapt((Notifier)this.ws, IPropertyState.class);
        WsPropertyStateAdapterTest.assertFalse((boolean)adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__NAME));
        WsPropertyStateAdapterTest.assertFalse((boolean)adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_SERVICE__PORT_NAME));
        WsPropertyStateAdapterTest.assertFalse((boolean)adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_SERVICE__SERVICE_ENDPOINT));
        WsPropertyStateAdapterTest.assertFalse((boolean)adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_SERVICE__TARGET_NAMESPACE));
        WsPropertyStateAdapterTest.assertFalse((boolean)adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_SERVICE__WSDL_LOCATION));
    }

    public void testIsChangableInOut() {
        IPropertyState adapter = (IPropertyState)PropertyStateAdapterFactory.INSTANCE.adapt((Notifier)this.ws, IPropertyState.class);
        WsPropertyStateAdapterTest.assertTrue((boolean)adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__NAME));
        WsPropertyStateAdapterTest.assertTrue((boolean)adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_SERVICE__PORT_NAME));
        WsPropertyStateAdapterTest.assertFalse((boolean)adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_SERVICE__SERVICE_ENDPOINT));
        WsPropertyStateAdapterTest.assertTrue((boolean)adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_SERVICE__TARGET_NAMESPACE));
        WsPropertyStateAdapterTest.assertFalse((boolean)adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_SERVICE__WSDL_LOCATION));
    }

    public void testIsChangebleNonWsInstance() {
        IServiceEndpointInterface sei = DomFactory.eINSTANCE.createIServiceEndpointInterface();
        IPropertyState adapter = (IPropertyState)PropertyStateAdapterFactory.INSTANCE.adapt((Notifier)this.ws, IPropertyState.class);
        ((Adapter)adapter).setTarget((Notifier)sei);
        WsPropertyStateAdapterTest.assertFalse((boolean)adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__NAME));
    }
}

