/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.tests.encoding.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import junit.framework.TestCase;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.IResourceCharsetDetector;
import org.eclipse.wst.xml.core.internal.contenttype.XMLResourceEncodingDetector;
import org.eclipse.wst.xml.tests.encoding.TestsPlugin;

public class XMLEncodingTests
extends TestCase {
    private int READ_BUFFER_SIZE = 8000;
    private boolean DEBUG = false;
    private final String fileRoot = "testfiles/";
    private final String fileDir = "xml/";
    private final String fileLocation = "testfiles/xml/";

    public XMLEncodingTests(String name) {
        super(name);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doTestFileStream(String filename, String expectedIANAEncoding, IResourceCharsetDetector detector) throws IOException {
        FileInputStream inputStream;
        block5: {
            File file = TestsPlugin.getTestFile(filename);
            if (!file.exists()) {
                throw new IllegalArgumentException(String.valueOf(filename) + " was not found");
            }
            inputStream = new FileInputStream(file);
            InputStream istream = XMLEncodingTests.getMarkSupportedStream(inputStream);
            try {
                detector.set(istream);
                EncodingMemento encodingMemento = ((XMLResourceEncodingDetector)detector).getEncodingMemento();
                String foundIANAEncoding = encodingMemento.getJavaCharsetName();
                boolean expectedIANAResult = false;
                expectedIANAResult = expectedIANAEncoding.equalsIgnoreCase(foundIANAEncoding);
                XMLEncodingTests.assertTrue((String)("encoding test file " + filename + " expected: " + expectedIANAEncoding + " found: " + foundIANAEncoding), (boolean)expectedIANAResult);
                this.ensureCanRead(filename, foundIANAEncoding, istream);
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (istream != null) {
                    istream.close();
                }
                if (inputStream == null) throw throwable;
                ((InputStream)inputStream).close();
                throw throwable;
            }
            {
                Object var10_12 = null;
                if (istream == null) break block5;
            }
            istream.close();
        }
        if (inputStream == null) return;
        ((InputStream)inputStream).close();
    }

    public void testXMLEmptyFile() throws IOException {
        String filename = "testfiles/xml/EmptyFile.xml";
        this.doTestFileStream(filename, "UTF-8", (IResourceCharsetDetector)new XMLResourceEncodingDetector());
    }

    public void testXMLIllformedNormalNonDefault() throws IOException {
        String filename = "testfiles/xml/IllformedNormalNonDefault.xml";
        String ianaInFile = "ISO-8859-1";
        this.doTestFileStream(filename, ianaInFile, (IResourceCharsetDetector)new XMLResourceEncodingDetector());
    }

    public void testXMLNormalNonDefault() throws IOException {
        String filename = "testfiles/xml/NormalNonDefault.xml";
        String ianaInFile = "ISO-8859-1";
        this.doTestFileStream(filename, ianaInFile, (IResourceCharsetDetector)new XMLResourceEncodingDetector());
    }

    public void testXMLNoEncoding() throws IOException {
        String filename = "testfiles/xml/NoEncoding.xml";
        this.doTestFileStream(filename, "UTF-8", (IResourceCharsetDetector)new XMLResourceEncodingDetector());
    }

    public void testUTF16() throws IOException {
        String filename = "testfiles/xml/utf16WithJapaneseChars.xml";
        this.doTestFileStream(filename, "UTF-16", (IResourceCharsetDetector)new XMLResourceEncodingDetector());
    }

    public void testUtf16UnicodeStreamWithNoEncodingInHeader() throws IOException {
        String filename = "testfiles/xml/utf16UnicodeStreamWithNoEncodingInHeader2.xml";
        this.doTestFileStream(filename, "UTF-16", (IResourceCharsetDetector)new XMLResourceEncodingDetector());
    }

    public void testUtf16UnicodeStreamWithNoEncodingInHeaderBE() throws IOException {
        String filename = "testfiles/xml/utf16UnicodeStreamWithNoEncodingInHeaderBE.xml";
        this.doTestFileStream(filename, "UTF-16", (IResourceCharsetDetector)new XMLResourceEncodingDetector());
    }

    public void testUTF83ByteBOM() throws IOException {
        String filename = "testfiles/xml/UTF8With3ByteBOM.xml";
        this.doTestFileStream(filename, "UTF-8", (IResourceCharsetDetector)new XMLResourceEncodingDetector());
    }

    public void testUTF16BE() throws IOException {
        String filename = "testfiles/xml/utf16be.xml";
        this.doTestFileStream(filename, "UTF-16BE", (IResourceCharsetDetector)new XMLResourceEncodingDetector());
    }

    public void testUTF16LE() throws IOException {
        String filename = "testfiles/xml/utf16le.xml";
        this.doTestFileStream(filename, "UTF-16LE", (IResourceCharsetDetector)new XMLResourceEncodingDetector());
    }

    public void testUTF16LEMalformed() throws IOException {
        String filename = "testfiles/xml/utf16leMalformed.xml";
        this.doTestFileStream(filename, "UTF-16LE", (IResourceCharsetDetector)new XMLResourceEncodingDetector());
    }

    public void testUTF16BEMalformed() throws IOException {
        String filename = "testfiles/xml/utf16beMalformed.xml";
        this.doTestFileStream(filename, "UTF-16BE", (IResourceCharsetDetector)new XMLResourceEncodingDetector());
    }

    private static InputStream getMarkSupportedStream(InputStream original) {
        if (original == null) {
            return null;
        }
        if (original.markSupported()) {
            return original;
        }
        return new BufferedInputStream(original);
    }

    private StringBuffer readInputStream(Reader reader) throws IOException {
        StringBuffer buffer = new StringBuffer();
        int numRead = 0;
        char[] tBuff = new char[this.READ_BUFFER_SIZE];
        while ((numRead = reader.read(tBuff, 0, tBuff.length)) != -1) {
            buffer.append(tBuff, 0, numRead);
        }
        return buffer;
    }

    private void ensureCanRead(String filename, String encoding, InputStream inStream) throws IOException {
        Charset charset = Charset.forName(encoding);
        CharsetDecoder charsetDecoder = charset.newDecoder();
        charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
        charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        InputStreamReader reader = new InputStreamReader(inStream, charsetDecoder);
        StringBuffer stringBuffer = this.readInputStream(reader);
        if (this.DEBUG) {
            System.out.println();
            System.out.println(filename);
            System.out.println(stringBuffer.toString());
        }
    }
}

