/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.tests.document;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.Assert;

public class Accessor {
    private Class fClass;
    private Object fInstance;

    public Accessor(Object instance, Class clazz) {
        Assert.isNotNull((Object)instance);
        Assert.isNotNull((Object)clazz);
        this.fInstance = instance;
        this.fClass = clazz;
    }

    public Accessor(Object instance, String className, ClassLoader classLoader) {
        Assert.isNotNull((Object)instance);
        Assert.isNotNull((Object)className);
        Assert.isNotNull((Object)classLoader);
        this.fInstance = instance;
        try {
            this.fClass = Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.fail();
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            this.fail();
        }
    }

    public Accessor(String className, ClassLoader classLoader, Object[] constructorArgs) {
        this(className, classLoader, Accessor.getTypes(constructorArgs), constructorArgs);
    }

    public Accessor(String className, ClassLoader classLoader, Class[] constructorTypes, Object[] constructorArgs) {
        try {
            this.fClass = Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.fail();
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            this.fail();
        }
        Constructor constructor = null;
        try {
            constructor = this.fClass.getDeclaredConstructor(constructorTypes);
        }
        catch (SecurityException securityException) {
            this.fail();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.fail();
        }
        Assert.isNotNull(constructor);
        constructor.setAccessible(true);
        try {
            this.fInstance = constructor.newInstance(constructorArgs);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.fail();
        }
        catch (InvocationTargetException invocationTargetException) {
            this.fail();
        }
        catch (InstantiationException instantiationException) {
            this.fail();
        }
        catch (IllegalAccessException illegalAccessException) {
            this.fail();
        }
    }

    public Accessor(String className, ClassLoader classLoader) {
        try {
            this.fClass = Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.fail();
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            this.fail();
        }
    }

    public Object invoke(String methodName, Object[] arguments) {
        return this.invoke(methodName, Accessor.getTypes(arguments), arguments);
    }

    public Object invoke(String methodName, Class[] types, Object[] arguments) {
        Method method = null;
        try {
            method = this.fClass.getDeclaredMethod(methodName, types);
        }
        catch (SecurityException securityException) {
            this.fail();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.fail();
        }
        Assert.isNotNull((Object)method);
        method.setAccessible(true);
        try {
            return method.invoke(this.fInstance, arguments);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.fail();
        }
        catch (InvocationTargetException invocationTargetException) {
            this.fail();
        }
        catch (IllegalAccessException illegalAccessException) {
            this.fail();
        }
        return null;
    }

    public void set(String fieldName, Object value) {
        Field field = this.getField(fieldName);
        try {
            field.set(this.fInstance, value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.fail();
        }
        catch (IllegalAccessException illegalAccessException) {
            this.fail();
        }
    }

    public void set(String fieldName, boolean value) {
        Field field = this.getField(fieldName);
        try {
            field.setBoolean(this.fInstance, value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.fail();
        }
        catch (IllegalAccessException illegalAccessException) {
            this.fail();
        }
    }

    public void set(String fieldName, int value) {
        Field field = this.getField(fieldName);
        try {
            field.setInt(this.fInstance, value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.fail();
        }
        catch (IllegalAccessException illegalAccessException) {
            this.fail();
        }
    }

    public Object get(String fieldName) {
        Field field = this.getField(fieldName);
        try {
            return field.get(this.fInstance);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.fail();
        }
        catch (IllegalAccessException illegalAccessException) {
            this.fail();
        }
        return null;
    }

    public boolean getBoolean(String fieldName) {
        Field field = this.getField(fieldName);
        try {
            return field.getBoolean(this.fInstance);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.fail();
        }
        catch (IllegalAccessException illegalAccessException) {
            this.fail();
        }
        return false;
    }

    public int getInt(String fieldName) {
        Field field = this.getField(fieldName);
        try {
            return field.getInt(this.fInstance);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.fail();
        }
        catch (IllegalAccessException illegalAccessException) {
            this.fail();
        }
        return 0;
    }

    private Field getField(String fieldName) {
        Field field = null;
        try {
            field = this.fClass.getDeclaredField(fieldName);
        }
        catch (SecurityException securityException) {
            this.fail();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.fail();
        }
        field.setAccessible(true);
        return field;
    }

    private static Class[] getTypes(Object[] objects) {
        if (objects == null) {
            return null;
        }
        int length = objects.length;
        Class[] classes = new Class[length];
        int i = 0;
        while (i < length) {
            Assert.isNotNull((Object)objects[i]);
            classes[i] = objects[i].getClass();
            ++i;
        }
        return classes;
    }

    private void fail() {
        Assert.isTrue((boolean)false);
    }
}

