/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.parser;

import org.eclipse.wst.jsdt.core.tests.compiler.parser.AbstractCompletionTest;

public class NameReferenceCompletionTest
extends AbstractCompletionTest {
    public NameReferenceCompletionTest(String testName) {
        super(testName);
    }

    public void test1FTZ849() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tvar o = new X;\t\t\t\t\t\t\n\tfred.xyz;\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "fred.x", "<CompleteOnMemberAccess:fred.x>", "function foo() {\n  var o = new   X;\n  <CompleteOnMemberAccess:fred.x>;\n}\n", "x", "xyz", "<1FTZ849>");
    }

    public void test1FUUP73() {
        this.runTestCheckDietParse("var s = \"hello\";\t\t\t\nvar o = s.concat(\"boo\");\t\n", "var o = s", "<CompleteOnName:s>", "var s = \"hello\";\nvar o = <CompleteOnName:s>.concat(\"boo\");\n", "s", "s", "<1FUUP73>");
        this.runTestCheckDietParse("var s = \"hello\";\t\t\t\nvar o = s.concat(\"boo\");\t\n", "var o = s.c", "<CompleteOnMessageSend:s.c(\"boo\")>", "var s = \"hello\";\nvar o = <CompleteOnMessageSend:s.c(\"boo\")>;\n", "c", "concat(\"boo\")", "<1FUUP73>");
    }

    public void testEmptyNameReference() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tvar i = 0;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "var i = 0;\t\t\t\t\t\t\t\n\t\t", "<CompleteOnName:>", "function foo() {\n  var i = 0;\n  <CompleteOnName:>;\n}\n", "", "", "<complete on empty name reference>");
    }

    public void testEmptyNameReferenceAfterPlus() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\t1 + \t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "1 +", "<CompleteOnName:>", "function foo() {\n  (1 + <CompleteOnName:>);\n}\n", "", "", "<complete on empty name reference after + operator>");
    }

    public void testInIfThenStatement() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tif (bar()) \t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "\n\t\t\t", "<CompleteOnName:>", "function foo() {\n  if (bar())\n      <CompleteOnName:>;\n}\n", "", "", "<complete in if then statement>");
    }

    public void testInvocationFieldInitializer() {
        this.runTestCheckDietParse("var s = fred(1 + );\t\t\t\t\t\nfunction foo() {\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "(1 + ", "<CompleteOnName:>", "var s = fred((1 + <CompleteOnName:>));\nfunction foo() {\n}\n", "", "", "<complete on empty name reference in invocation in field initializer>");
    }

    public void testUnicode() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\n\tbar.\\u005ax \t\t\n}\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:bar.Zx>", "function foo() {\n  <CompleteOnMemberAccess:bar.Zx>;\n}\n", "Zx", "\\u005ax", "<complete on unicode>");
    }
}

