/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.dom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTMatcher;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BlockComment;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.CharacterLiteral;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.Comment;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EmptyStatement;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.FunctionRef;
import org.eclipse.wst.jsdt.core.dom.FunctionRefParameter;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.LineComment;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.tests.dom.SampleASTs;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class ASTTest {
    AST ast;
    int API_LEVEL = 3;

    @Before
    public void setUp() throws Exception {
        this.ast = AST.newAST((int)this.API_LEVEL);
    }

    @After
    public void tearDown() throws Exception {
        this.ast = null;
    }

    @Test
    public void testExampleSnippets() {
        AST localAst = AST.newAST((int)this.ast.apiLevel());
        JavaScriptUnit cu = localAst.newJavaScriptUnit();
        PackageDeclaration pd = localAst.newPackageDeclaration();
        pd.setName(localAst.newName(new String[]{"com", "example"}));
        cu.setPackage(pd);
        Assert.assertTrue((pd.getRoot() == cu ? 1 : 0) != 0);
        ImportDeclaration im1 = localAst.newImportDeclaration();
        im1.setName(localAst.newName(new String[]{"java", "io"}));
        im1.setOnDemand(true);
        cu.imports().add(im1);
        Assert.assertTrue((im1.getRoot() == cu ? 1 : 0) != 0);
        ImportDeclaration im2 = localAst.newImportDeclaration();
        im2.setName(localAst.newName(new String[]{"java", "util", "List"}));
        im2.setOnDemand(false);
        cu.imports().add(im2);
        Assert.assertTrue((im2.getRoot() == cu ? 1 : 0) != 0);
        TypeDeclaration td = localAst.newTypeDeclaration();
        if (this.ast.apiLevel() == 2) {
            td.setModifiers(1);
        } else {
            td.modifiers().add(localAst.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        }
        td.setName(localAst.newSimpleName("MyClass"));
        JSdoc jd = localAst.newJSdoc();
        TagElement tg0 = localAst.newTagElement();
        jd.tags().add(tg0);
        TextElement tx1 = localAst.newTextElement();
        tx1.setText("Spec.");
        tg0.fragments().add(tx1);
        TagElement tg1 = localAst.newTagElement();
        tg1.setTagName("@deprecated");
        jd.tags().add(tg1);
        TextElement tx2 = localAst.newTextElement();
        tx2.setText("Use ");
        tg1.fragments().add(tx2);
        TagElement tg2 = localAst.newTagElement();
        tg2.setTagName("@link");
        tg1.fragments().add(tg2);
        FunctionRef mr1 = localAst.newFunctionRef();
        mr1.setName(localAst.newSimpleName("foo"));
        tg2.fragments().add(mr1);
        TextElement tx3 = localAst.newTextElement();
        tx3.setText("bar");
        tg2.fragments().add(tx3);
        TextElement tx4 = localAst.newTextElement();
        tx2.setText(" instead.");
        tg1.fragments().add(tx4);
        cu.types().add(td);
        Assert.assertTrue((td.getRoot() == cu ? 1 : 0) != 0);
        VariableDeclarationFragment f1 = localAst.newVariableDeclarationFragment();
        f1.setName(localAst.newSimpleName("DEBUG"));
        f1.setInitializer((Expression)localAst.newBooleanLiteral(true));
        FieldDeclaration fd = localAst.newFieldDeclaration(f1);
        fd.setType((Type)localAst.newPrimitiveType(PrimitiveType.BOOLEAN));
        if (this.ast.apiLevel() == 2) {
            fd.setModifiers(18);
        } else {
            fd.modifiers().add(localAst.newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD));
            fd.modifiers().add(localAst.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        }
        td.bodyDeclarations().add(fd);
        Assert.assertTrue((fd.getRoot() == cu ? 1 : 0) != 0);
        FunctionDeclaration md = localAst.newFunctionDeclaration();
        if (this.ast.apiLevel() == 2) {
            md.setModifiers(9);
            md.setReturnType((Type)localAst.newPrimitiveType(PrimitiveType.VOID));
        } else {
            md.modifiers().add(localAst.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
            md.modifiers().add(localAst.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
            md.setReturnType2((Type)localAst.newPrimitiveType(PrimitiveType.VOID));
        }
        md.setConstructor(false);
        md.setName(localAst.newSimpleName("main"));
        td.bodyDeclarations().add(md);
        Assert.assertTrue((md.getRoot() == cu ? 1 : 0) != 0);
        SingleVariableDeclaration a1 = localAst.newSingleVariableDeclaration();
        a1.setType((Type)localAst.newArrayType((Type)localAst.newSimpleType((Name)localAst.newSimpleName("String"))));
        a1.setName(localAst.newSimpleName("args"));
        md.parameters().add(a1);
        Assert.assertTrue((a1.getRoot() == cu ? 1 : 0) != 0);
        Block b = localAst.newBlock();
        md.setBody(b);
        Assert.assertTrue((b.getRoot() == cu ? 1 : 0) != 0);
        FunctionInvocation e = localAst.newFunctionInvocation();
        e.setExpression((Expression)localAst.newName(new String[]{"System", "out"}));
        e.setName(localAst.newSimpleName("println"));
        StringLiteral h = localAst.newStringLiteral();
        h.setLiteralValue("hello world");
        e.arguments().add(h);
        b.statements().add(localAst.newExpressionStatement((Expression)e));
        Assert.assertTrue((e.getRoot() == cu ? 1 : 0) != 0);
        Assert.assertTrue((h.getRoot() == cu ? 1 : 0) != 0);
        ArrayCreation ac1 = localAst.newArrayCreation();
        ac1.setType(localAst.newArrayType((Type)localAst.newSimpleType((Name)localAst.newSimpleName("String"))));
        ac1.dimensions().add(localAst.newSimpleName("len"));
        b.statements().add(localAst.newExpressionStatement((Expression)ac1));
        Assert.assertTrue((ac1.getRoot() == cu ? 1 : 0) != 0);
        ArrayCreation ac2 = localAst.newArrayCreation();
        ac2.setType(localAst.newArrayType((Type)localAst.newPrimitiveType(PrimitiveType.DOUBLE), 3));
        ac2.dimensions().add(localAst.newNumberLiteral("7"));
        ac2.dimensions().add(localAst.newNumberLiteral("24"));
        b.statements().add(localAst.newExpressionStatement((Expression)ac2));
        Assert.assertTrue((ac2.getRoot() == cu ? 1 : 0) != 0);
        ArrayCreation ac3 = localAst.newArrayCreation();
        ac3.setType(localAst.newArrayType((Type)localAst.newPrimitiveType(PrimitiveType.INT)));
        ArrayInitializer ai = localAst.newArrayInitializer();
        ac3.setInitializer(ai);
        ai.expressions().add(localAst.newNumberLiteral("1"));
        ai.expressions().add(localAst.newNumberLiteral("2"));
        b.statements().add(localAst.newExpressionStatement((Expression)ac3));
        Assert.assertTrue((ac3.getRoot() == cu ? 1 : 0) != 0);
        Assert.assertTrue((ai.getRoot() == cu ? 1 : 0) != 0);
        ClassInstanceCreation cr1 = localAst.newClassInstanceCreation();
        if (this.ast.apiLevel() == 2) {
            cr1.setName((Name)localAst.newSimpleName("String"));
        } else {
            cr1.setType((Type)localAst.newSimpleType((Name)localAst.newSimpleName("String")));
        }
        cr1.arguments().add(localAst.newNumberLiteral("10"));
        b.statements().add(localAst.newExpressionStatement((Expression)cr1));
        Assert.assertTrue((cr1.getRoot() == cu ? 1 : 0) != 0);
        ClassInstanceCreation cr2 = localAst.newClassInstanceCreation();
        AnonymousClassDeclaration ad1 = localAst.newAnonymousClassDeclaration();
        cr2.setAnonymousClassDeclaration(ad1);
        if (this.ast.apiLevel() == 2) {
            cr2.setName((Name)localAst.newSimpleName("Listener"));
        } else {
            cr2.setType((Type)localAst.newSimpleType((Name)localAst.newSimpleName("Listener")));
        }
        FunctionDeclaration md0 = localAst.newFunctionDeclaration();
        if (this.ast.apiLevel() == 2) {
            md0.setModifiers(1);
        } else {
            md0.modifiers().add(localAst.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        }
        md0.setName(localAst.newSimpleName("handleEvent"));
        md0.setBody(localAst.newBlock());
        ad1.bodyDeclarations().add(md0);
        b.statements().add(localAst.newExpressionStatement((Expression)cr2));
        Assert.assertTrue((cr2.getRoot() == cu ? 1 : 0) != 0);
        Assert.assertTrue((md0.getRoot() == cu ? 1 : 0) != 0);
        Assert.assertTrue((ad1.getRoot() == cu ? 1 : 0) != 0);
    }

    void genericPropertyTest(ASTNode node, Property prop) {
        block20: {
            ASTNode x1 = prop.sample(node.getAST(), false);
            prop.set(x1);
            Assert.assertTrue((prop.get() == x1 ? 1 : 0) != 0);
            Assert.assertTrue((x1.getParent() == node ? 1 : 0) != 0);
            if (prop.isCompulsory()) {
                try {
                    prop.set(null);
                }
                catch (RuntimeException runtimeException) {}
            } else {
                long previousCount = node.getAST().modificationCount();
                prop.set(null);
                Assert.assertTrue((prop.get() == null ? 1 : 0) != 0);
                Assert.assertTrue((node.getAST().modificationCount() > previousCount ? 1 : 0) != 0);
            }
            try {
                AST newAST = AST.newAST((int)node.getAST().apiLevel());
                prop.set(prop.sample(newAST, false));
                Assert.assertTrue((boolean)false);
            }
            catch (RuntimeException runtimeException) {}
            try {
                ASTNode b1 = prop.sample(node.getAST(), true);
                prop.set(b1);
                Assert.assertTrue((boolean)false);
            }
            catch (RuntimeException runtimeException) {}
            Assert.assertTrue((node.getParent() == null ? 1 : 0) != 0);
            ASTNode s1 = null;
            try {
                try {
                    s1 = prop.wrap();
                    if (s1 != null) {
                        prop.set(s1);
                        Assert.assertTrue((boolean)false);
                    }
                }
                catch (RuntimeException runtimeException) {
                    if (s1 != null) {
                        prop.unwrap();
                        Assert.assertTrue((node.getParent() == null ? 1 : 0) != 0);
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (s1 != null) {
                    prop.unwrap();
                    Assert.assertTrue((node.getParent() == null ? 1 : 0) != 0);
                }
                throw throwable;
            }
            if (s1 != null) {
                prop.unwrap();
                Assert.assertTrue((node.getParent() == null ? 1 : 0) != 0);
            }
        }
        ASTNode[] b1 = prop.counterExamples(node.getAST());
        int i = 0;
        while (i < b1.length) {
            try {
                prop.set(b1[i]);
                Assert.assertTrue((boolean)false);
            }
            catch (RuntimeException runtimeException) {}
            ++i;
        }
    }

    void genericPropertyListTest(ASTNode node, List children, Property prop) {
        block19: {
            if (children != null) {
                children.clear();
                Assert.assertTrue((children.size() == 0 ? 1 : 0) != 0);
            }
            ASTNode x1 = prop.sample(node.getAST(), false);
            long previousCount = node.getAST().modificationCount();
            children.add(x1);
            Assert.assertTrue((node.getAST().modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((children.size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((children.get(0) == x1 ? 1 : 0) != 0);
            Assert.assertTrue((x1.getParent() == node ? 1 : 0) != 0);
            ASTNode x2 = prop.sample(node.getAST(), false);
            previousCount = node.getAST().modificationCount();
            children.add(x2);
            Assert.assertTrue((node.getAST().modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((children.size() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((children.get(0) == x1 ? 1 : 0) != 0);
            Assert.assertTrue((children.get(1) == x2 ? 1 : 0) != 0);
            Assert.assertTrue((x1.getParent() == node ? 1 : 0) != 0);
            Assert.assertTrue((x2.getParent() == node ? 1 : 0) != 0);
            previousCount = node.getAST().modificationCount();
            children.remove(0);
            Assert.assertTrue((node.getAST().modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((children.size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((children.get(0) == x2 ? 1 : 0) != 0);
            Assert.assertTrue((x1.getParent() == null ? 1 : 0) != 0);
            Assert.assertTrue((x2.getParent() == node ? 1 : 0) != 0);
            previousCount = node.getAST().modificationCount();
            children.remove(x2);
            Assert.assertTrue((node.getAST().modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((children.size() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((x1.getParent() == null ? 1 : 0) != 0);
            Assert.assertTrue((x2.getParent() == null ? 1 : 0) != 0);
            try {
                children.add(null);
            }
            catch (RuntimeException runtimeException) {}
            try {
                AST newAST = AST.newAST((int)node.getAST().apiLevel());
                children.add(prop.sample(newAST, false));
                Assert.assertTrue((boolean)false);
            }
            catch (RuntimeException runtimeException) {}
            try {
                ASTNode b1 = prop.sample(node.getAST(), true);
                children.add(b1);
                Assert.assertTrue((boolean)false);
            }
            catch (RuntimeException runtimeException) {}
            Assert.assertTrue((node.getParent() == null ? 1 : 0) != 0);
            ASTNode s1 = null;
            try {
                try {
                    s1 = prop.wrap();
                    if (s1 != null) {
                        children.add(s1);
                        Assert.assertTrue((boolean)false);
                    }
                }
                catch (RuntimeException runtimeException) {
                    if (s1 != null) {
                        prop.unwrap();
                        Assert.assertTrue((node.getParent() == null ? 1 : 0) != 0);
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (s1 != null) {
                    prop.unwrap();
                    Assert.assertTrue((node.getParent() == null ? 1 : 0) != 0);
                }
                throw throwable;
            }
            if (s1 != null) {
                prop.unwrap();
                Assert.assertTrue((node.getParent() == null ? 1 : 0) != 0);
            }
        }
        ASTNode[] b1 = prop.counterExamples(node.getAST());
        int i = 0;
        while (i < b1.length) {
            try {
                children.add(b1[i]);
                Assert.assertTrue((boolean)false);
            }
            catch (RuntimeException runtimeException) {}
            ++i;
        }
    }

    @Test
    public void testAST() {
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        AST a0 = new AST();
        Assert.assertTrue((a0.apiLevel() == 2 ? 1 : 0) != 0);
        AST a1 = new AST(new HashMap());
        Assert.assertTrue((a1.apiLevel() == 2 ? 1 : 0) != 0);
        AST a2 = AST.newAST((int)2);
        Assert.assertTrue((a2.apiLevel() == 2 ? 1 : 0) != 0);
        AST a3 = AST.newAST((int)3);
        Assert.assertTrue((a3.apiLevel() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() >= 0L ? 1 : 0) != 0);
        long previousCount = this.ast.modificationCount();
        SimpleName x = this.ast.newSimpleName("first");
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.getIdentifier();
        x.getParent();
        x.getRoot();
        x.getAST();
        x.getFlags();
        x.getStartPosition();
        x.getLength();
        x.equals((Object)x);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.getProperty("any");
        x.setProperty("any", (Object)"value");
        x.properties();
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setIdentifier("second");
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setFlags(0);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setSourceRange(-1, 0);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
    }

    @Test
    public void testWellKnownBindings() {
        String[] wkbs = new String[]{"byte", "char", "short", "int", "long", "boolean", "float", "double", "void", "java.lang.Class", "java.lang.Cloneable", "java.lang.Error", "java.lang.Exception", "java.lang.Object", "java.lang.RuntimeException", "java.lang.String", "java.lang.StringBuffer", "java.lang.Throwable", "java.io.Serializable", "java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.Void"};
        String[] nwkbs = new String[]{"verylong", "java.lang.Math", "com.example.MyCode"};
        int i = 0;
        while (i < wkbs.length) {
            Assert.assertTrue((this.ast.resolveWellKnownType(wkbs[i]) == null ? 1 : 0) != 0);
            ++i;
        }
        i = 0;
        while (i < nwkbs.length) {
            Assert.assertTrue((this.ast.resolveWellKnownType(nwkbs[i]) == null ? 1 : 0) != 0);
            ++i;
        }
    }

    @Test
    @Ignore(value="ignored until a correct validation is implemented for SimpleName")
    public void testSimpleName() {
        long previousCount = this.ast.modificationCount();
        SimpleName x = this.ast.newSimpleName("foo");
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)"foo".equals(x.getIdentifier()));
        Assert.assertTrue((boolean)"foo".equals(x.getFullyQualifiedName()));
        Assert.assertTrue((x.getNodeType() == 42 ? 1 : 0) != 0);
        Assert.assertTrue((!x.isDeclaration() ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == SimpleName.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setIdentifier("bar");
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((boolean)"bar".equals(x.getIdentifier()));
        Assert.assertTrue((boolean)"bar".equals(x.getFullyQualifiedName()));
        try {
            x.setIdentifier(null);
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
        String[] reserved = new String[]{"true", "false", "null", "abstract", "default", "if", "private", "this", "boolean", "do", "implements", "protected", "throw", "break", "double", "import", "public", "throws", "byte", "else", "instanceof", "return", "transient", "case", "extends", "int", "short", "try", "catch", "final", "interface", "static", "void", "char", "finally", "long", "strictfp", "volatile", "class", "float", "native", "super", "while", "const", "for", "new", "switch", "continue", "goto", "package", "synchronized"};
        int i = 0;
        while (i < reserved.length) {
            try {
                x.setIdentifier(reserved[i]);
            }
            catch (RuntimeException runtimeException) {}
            ++i;
        }
        String[] bogus = new String[]{"a b", "a ", " a", "a-b", "a[]", "a<T>", "", " ", "a.b"};
        int i2 = 0;
        while (i2 < bogus.length) {
            try {
                x.setIdentifier(bogus[i2]);
                Assert.assertTrue((boolean)false);
            }
            catch (RuntimeException runtimeException) {}
            ++i2;
        }
        x.setIdentifier("assert");
        x.setIdentifier("enum");
        QualifiedName y = this.ast.newQualifiedName((Name)this.ast.newSimpleName("a"), x);
        Assert.assertTrue((!x.isDeclaration() ? 1 : 0) != 0);
        y.setName(this.ast.newSimpleName("b"));
        Assert.assertTrue((!x.isDeclaration() ? 1 : 0) != 0);
        TypeDeclaration td = this.ast.newTypeDeclaration();
        td.setName(x);
        Assert.assertTrue((boolean)x.isDeclaration());
        td.setName(this.ast.newSimpleName("b"));
        Assert.assertTrue((!x.isDeclaration() ? 1 : 0) != 0);
        FunctionDeclaration md = this.ast.newFunctionDeclaration();
        md.setName(x);
        Assert.assertTrue((boolean)x.isDeclaration());
        md.setName(this.ast.newSimpleName("b"));
        Assert.assertTrue((!x.isDeclaration() ? 1 : 0) != 0);
        SingleVariableDeclaration vd = this.ast.newSingleVariableDeclaration();
        vd.setName(x);
        Assert.assertTrue((boolean)x.isDeclaration());
        vd.setName(this.ast.newSimpleName("b"));
        Assert.assertTrue((!x.isDeclaration() ? 1 : 0) != 0);
        VariableDeclarationFragment fd = this.ast.newVariableDeclarationFragment();
        fd.setName(x);
        Assert.assertTrue((boolean)x.isDeclaration());
        fd.setName(this.ast.newSimpleName("b"));
        Assert.assertTrue((!x.isDeclaration() ? 1 : 0) != 0);
    }

    @Test
    public void testQualifiedName() {
        long previousCount = this.ast.modificationCount();
        final QualifiedName x = this.ast.newQualifiedName((Name)this.ast.newSimpleName("q"), this.ast.newSimpleName("i"));
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getQualifier().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((!x.getName().isDeclaration() ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 40 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)"q.i".equals(x.getFullyQualifiedName()));
        Assert.assertTrue((x.structuralPropertiesForType() == QualifiedName.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Qualifier", true, Name.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                QualifiedName result = targetAst.newQualifiedName((Name)targetAst.newSimpleName("a"), targetAst.newSimpleName("b"));
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                QualifiedName s1 = ast.newQualifiedName((Name)x, ast.newSimpleName("z"));
                return s1;
            }

            @Override
            public void unwrap() {
                QualifiedName s1 = (QualifiedName)x.getParent();
                s1.setQualifier((Name)ast.newSimpleName("z"));
            }

            @Override
            public ASTNode get() {
                return x.getQualifier();
            }

            @Override
            public void set(ASTNode value) {
                x.setQualifier((Name)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((SimpleName)value);
            }
        });
        Name q0 = this.ast.newName(new String[]{"a", "bb", "ccc", "dddd", "eeeee", "ffffff"});
        Assert.assertTrue((boolean)"a.bb.ccc.dddd.eeeee.ffffff".equals(q0.getFullyQualifiedName()));
    }

    @Test
    public void testNameFactories() {
        long previousCount = this.ast.modificationCount();
        Name x = this.ast.newName("foo");
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)"foo".equals(x.getFullyQualifiedName()));
        Assert.assertTrue((x.getNodeType() == 42 ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x = this.ast.newName("foo.bar");
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)"foo.bar".equals(x.getFullyQualifiedName()));
        Assert.assertTrue((x.getNodeType() == 40 ? 1 : 0) != 0);
        QualifiedName q = (QualifiedName)x;
        Assert.assertTrue((boolean)"bar".equals(q.getName().getFullyQualifiedName()));
        Assert.assertTrue((boolean)"foo".equals(q.getQualifier().getFullyQualifiedName()));
        String[] legal = new String[]{"a", "abcdef", "XYZZY", "a.b", "java.lang.Object", "a.b.c.d.e"};
        int i = 0;
        while (i < legal.length) {
            try {
                x = this.ast.newName(legal[i]);
                Assert.assertTrue((boolean)legal[i].equals(x.getFullyQualifiedName()));
            }
            catch (RuntimeException runtimeException) {
                Assert.assertTrue((boolean)false);
            }
            ++i;
        }
        String[] bogus = new String[]{"", ".", ".a", "a.", "a..b", "..a"};
        int i2 = 0;
        while (i2 < bogus.length) {
            try {
                x = this.ast.newName(bogus[i2]);
                Assert.assertTrue((boolean)false);
            }
            catch (RuntimeException runtimeException) {}
            ++i2;
        }
    }

    @Test
    public void testNullLiteral() {
        long previousCount = this.ast.modificationCount();
        NullLiteral x = this.ast.newNullLiteral();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 33 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == NullLiteral.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
    }

    @Test
    public void testBooleanLiteral() {
        long previousCount = this.ast.modificationCount();
        BooleanLiteral x = this.ast.newBooleanLiteral(true);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.booleanValue());
        Assert.assertTrue((x.getNodeType() == 9 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == BooleanLiteral.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setBooleanValue(false);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((!x.booleanValue() ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setBooleanValue(true);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.booleanValue());
    }

    @Test
    public void testStringLiteral() {
        long previousCount = this.ast.modificationCount();
        StringLiteral x = this.ast.newStringLiteral();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)"\"\"".equals(x.getEscapedValue()));
        Assert.assertTrue((boolean)"".equals(x.getLiteralValue()));
        Assert.assertTrue((x.getNodeType() == 45 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == StringLiteral.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setEscapedValue("\"bye\"");
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((boolean)"\"bye\"".equals(x.getEscapedValue()));
        Assert.assertTrue((boolean)"bye".equals(x.getLiteralValue()));
        previousCount = this.ast.modificationCount();
        x.setLiteralValue("hi");
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((boolean)"\"hi\"".equals(x.getEscapedValue()));
        Assert.assertTrue((boolean)"hi".equals(x.getLiteralValue()));
        previousCount = this.ast.modificationCount();
        x.setLiteralValue("\\012\\015");
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertEquals((String)"different", (Object)"\"\\\\012\\\\015\"", (Object)x.getEscapedValue());
        Assert.assertTrue((boolean)"\\012\\015".equals(x.getLiteralValue()));
        previousCount = this.ast.modificationCount();
        x.setLiteralValue("\n\r");
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((boolean)"\n\r".equals(x.getLiteralValue()));
        Assert.assertEquals((String)"different", (Object)"\"\\n\\r\"", (Object)x.getEscapedValue());
        try {
            x.setEscapedValue(null);
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
        try {
            x.setLiteralValue(null);
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
    }

    @Test
    public void testStringLiteralUnicode() {
        AST localAst = AST.newAST((int)this.ast.apiLevel());
        StringLiteral literal = localAst.newStringLiteral();
        literal.setEscapedValue("\"hello\\u0026\\u0050worl\\u0064\"");
        Assert.assertTrue((boolean)literal.getLiteralValue().equals("hello&Pworld"));
        localAst = AST.newAST((int)this.ast.apiLevel());
        literal = localAst.newStringLiteral();
        literal.setEscapedValue("\"hello\\nworld\"");
        Assert.assertTrue((boolean)literal.getLiteralValue().equals("hello\nworld"));
        localAst = AST.newAST((int)this.ast.apiLevel());
        literal = localAst.newStringLiteral();
        literal.setLiteralValue("hello\nworld");
        Assert.assertTrue((boolean)literal.getLiteralValue().equals("hello\nworld"));
        localAst = AST.newAST((int)this.ast.apiLevel());
        literal = localAst.newStringLiteral();
        literal.setLiteralValue("\n");
        Assert.assertTrue((boolean)literal.getEscapedValue().equals("\"\\n\""));
        Assert.assertTrue((boolean)literal.getLiteralValue().equals("\n"));
        localAst = AST.newAST((int)this.ast.apiLevel());
        literal = localAst.newStringLiteral();
        literal.setEscapedValue("\"hello\\\"world\"");
        Assert.assertTrue((boolean)literal.getLiteralValue().equals("hello\"world"));
        localAst = AST.newAST((int)this.ast.apiLevel());
        literal = localAst.newStringLiteral();
        literal.setLiteralValue("hello\\u0026world");
        Assert.assertTrue((boolean)literal.getLiteralValue().equals("hello\\u0026world"));
        localAst = AST.newAST((int)this.ast.apiLevel());
        literal = localAst.newStringLiteral();
        literal.setLiteralValue("hello\\u0026world");
        Assert.assertTrue((boolean)literal.getEscapedValue().equals("\"hello\\\\u0026world\""));
        localAst = AST.newAST((int)this.ast.apiLevel());
        literal = localAst.newStringLiteral();
        literal.setLiteralValue("\\u0001");
        Assert.assertTrue((boolean)literal.getEscapedValue().equals("\"\\\\u0001\""));
    }

    @Test
    public void testCharacterLiteral() {
        long previousCount = this.ast.modificationCount();
        CharacterLiteral x = this.ast.newCharacterLiteral();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.getEscapedValue().startsWith("'"));
        Assert.assertTrue((boolean)x.getEscapedValue().endsWith("'"));
        Assert.assertTrue((x.getNodeType() == 13 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == CharacterLiteral.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setEscapedValue("'z'");
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((boolean)"'z'".equals(x.getEscapedValue()));
        Assert.assertTrue((x.charValue() == 'z' ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        CharacterLiteral y = this.ast.newCharacterLiteral();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((y.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((y.getParent() == null ? 1 : 0) != 0);
        String v = y.getEscapedValue();
        Assert.assertTrue((v.length() >= 3 && v.charAt(0) == '\'' & v.charAt(v.length() - 1) == '\'' ? 1 : 0) != 0);
        try {
            x.setEscapedValue(null);
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
        try {
            x.setEscapedValue("'\\b'");
            x.setEscapedValue("'\\t'");
            x.setEscapedValue("'\\n'");
            x.setEscapedValue("'\\f'");
            x.setEscapedValue("'\\\"'");
            x.setEscapedValue("'\\''");
            x.setEscapedValue("'\\\\'");
            x.setEscapedValue("'\\0'");
            x.setEscapedValue("'\\1'");
            x.setEscapedValue("'\\2'");
            x.setEscapedValue("'\\3'");
            x.setEscapedValue("'\\4'");
            x.setEscapedValue("'\\5'");
            x.setEscapedValue("'\\6'");
            x.setEscapedValue("'\\7'");
            x.setEscapedValue("'\\u0041'");
            Assert.assertTrue((x.charValue() == 'A' ? 1 : 0) != 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)false);
        }
        x.setCharValue('A');
        Assert.assertTrue((boolean)x.getEscapedValue().equals("'A'"));
        x.setCharValue('\t');
        Assert.assertTrue((boolean)x.getEscapedValue().equals("'\\t'"));
        x.setEscapedValue("'\\\\'");
        Assert.assertTrue((boolean)x.getEscapedValue().equals("'\\\\'"));
        Assert.assertTrue((x.charValue() == '\\' ? 1 : 0) != 0);
        x.setEscapedValue("'\\''");
        Assert.assertTrue((boolean)x.getEscapedValue().equals("'\\''"));
        Assert.assertTrue((x.charValue() == '\'' ? 1 : 0) != 0);
        x.setCharValue('\'');
        Assert.assertTrue((boolean)x.getEscapedValue().equals("'\\''"));
        Assert.assertTrue((x.charValue() == '\'' ? 1 : 0) != 0);
        x.setCharValue('\\');
        Assert.assertTrue((boolean)x.getEscapedValue().equals("'\\\\'"));
        Assert.assertTrue((x.charValue() == '\\' ? 1 : 0) != 0);
    }

    @Test
    public void testNumberLiteral() {
        long previousCount = this.ast.modificationCount();
        NumberLiteral x = this.ast.newNumberLiteral("1234");
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)"1234".equals(x.getToken()));
        Assert.assertTrue((x.getNodeType() == 34 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == NumberLiteral.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        NumberLiteral y = this.ast.newNumberLiteral();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((y.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((y.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)"0".equals(y.getToken()));
        String[] samples = new String[]{"0", "1", "1234567890", "0L", "1L", "1234567890L", "0l", "1l", "1234567890l", "077", "0177", "012345670", "077L", "0177L", "012345670L", "077l", "0177l", "012345670l", "0x00", "0x1", "0x0123456789ABCDEF", "0x00L", "0x1L", "0x0123456789ABCDEFL", "0x00l", "0x1l", "0x0123456789ABCDEFl", "1e1f", "2.f", ".3f", "0f", "3.14f", "6.022137e+23f", "1e1", "2.", ".3", "0.0", "3.14", "1e-9d", "1e137"};
        int i = 0;
        while (i < samples.length) {
            previousCount = this.ast.modificationCount();
            x.setToken(samples[i]);
            Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((boolean)samples[i].equals(x.getToken()));
            ++i;
        }
        try {
            x.setToken(null);
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
    }

    @Test
    public void testSimpleType() {
        long previousCount = this.ast.modificationCount();
        final SimpleType x = this.ast.newSimpleType((Name)this.ast.newSimpleName("String"));
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.isSimpleType());
        Assert.assertTrue((!x.isArrayType() ? 1 : 0) != 0);
        Assert.assertTrue((!x.isPrimitiveType() ? 1 : 0) != 0);
        Assert.assertTrue((!x.isQualifiedType() ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 43 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == SimpleType.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, Name.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("a");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((Name)value);
            }
        });
    }

    @Test
    public void testPrimitiveType() {
        long previousCount = this.ast.modificationCount();
        PrimitiveType x = this.ast.newPrimitiveType(PrimitiveType.INT);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.getPrimitiveTypeCode().equals(PrimitiveType.INT));
        Assert.assertTrue((!x.isSimpleType() ? 1 : 0) != 0);
        Assert.assertTrue((!x.isArrayType() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.isPrimitiveType());
        Assert.assertTrue((!x.isQualifiedType() ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 39 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == PrimitiveType.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        Assert.assertTrue((boolean)PrimitiveType.BYTE.toString().equals("byte"));
        Assert.assertTrue((boolean)PrimitiveType.INT.toString().equals("int"));
        Assert.assertTrue((boolean)PrimitiveType.BOOLEAN.toString().equals("boolean"));
        Assert.assertTrue((boolean)PrimitiveType.CHAR.toString().equals("char"));
        Assert.assertTrue((boolean)PrimitiveType.SHORT.toString().equals("short"));
        Assert.assertTrue((boolean)PrimitiveType.LONG.toString().equals("long"));
        Assert.assertTrue((boolean)PrimitiveType.FLOAT.toString().equals("float"));
        Assert.assertTrue((boolean)PrimitiveType.DOUBLE.toString().equals("double"));
        Assert.assertTrue((boolean)PrimitiveType.VOID.toString().equals("void"));
        PrimitiveType.Code[] known = new PrimitiveType.Code[]{PrimitiveType.BOOLEAN, PrimitiveType.BYTE, PrimitiveType.CHAR, PrimitiveType.INT, PrimitiveType.SHORT, PrimitiveType.LONG, PrimitiveType.FLOAT, PrimitiveType.DOUBLE, PrimitiveType.VOID};
        int i = 0;
        while (i < known.length) {
            int j = 0;
            while (j < known.length) {
                Assert.assertTrue((i == j || !known[i].equals(known[j]) ? 1 : 0) != 0);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < known.length) {
            previousCount = this.ast.modificationCount();
            x.setPrimitiveTypeCode(known[i]);
            Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((boolean)x.getPrimitiveTypeCode().equals(known[i]));
            ++i;
        }
        try {
            x.setPrimitiveTypeCode(null);
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
        i = 0;
        while (i < known.length) {
            String name = known[i].toString();
            Assert.assertTrue((boolean)PrimitiveType.toCode((String)name).equals(known[i]));
            ++i;
        }
        Assert.assertTrue((PrimitiveType.toCode((String)"not-a-type") == null ? 1 : 0) != 0);
    }

    @Test
    public void testArrayType() {
        SimpleName x1 = this.ast.newSimpleName("String");
        SimpleType x2 = this.ast.newSimpleType((Name)x1);
        long previousCount = this.ast.modificationCount();
        final ArrayType x = this.ast.newArrayType((Type)x2);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getComponentType().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        Assert.assertTrue((!x.isSimpleType() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.isArrayType());
        Assert.assertTrue((!x.isPrimitiveType() ? 1 : 0) != 0);
        Assert.assertTrue((!x.isQualifiedType() ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == ArrayType.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((x.getDimensions() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((x.getElementType() == x2 ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "ComponentType", true, Type.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("a"));
                if (parented) {
                    targetAst.newArrayType((Type)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ArrayType result = ast.newArrayType((Type)x);
                return result;
            }

            @Override
            public void unwrap() {
                ArrayType a = (ArrayType)x.getParent();
                a.setComponentType((Type)ast.newPrimitiveType(PrimitiveType.INT));
            }

            @Override
            public ASTNode get() {
                return x.getComponentType();
            }

            @Override
            public void set(ASTNode value) {
                x.setComponentType((Type)value);
            }
        });
        x.setComponentType((Type)this.ast.newArrayType((Type)this.ast.newPrimitiveType(PrimitiveType.INT), 4));
        Assert.assertTrue((x.getDimensions() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.getElementType().isPrimitiveType());
    }

    @Test
    public void testQualifiedType() {
        if (this.ast.apiLevel() == 2) {
            try {
                this.ast.newQualifiedType((Type)this.ast.newSimpleType((Name)this.ast.newSimpleName("q")), this.ast.newSimpleName("i"));
                Assert.assertTrue((boolean)false);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
            return;
        }
        long previousCount = this.ast.modificationCount();
        final QualifiedType x = this.ast.newQualifiedType((Type)this.ast.newSimpleType((Name)this.ast.newSimpleName("q")), this.ast.newSimpleName("i"));
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getQualifier().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((!x.getName().isDeclaration() ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 75 ? 1 : 0) != 0);
        Assert.assertTrue((!x.isSimpleType() ? 1 : 0) != 0);
        Assert.assertTrue((!x.isArrayType() ? 1 : 0) != 0);
        Assert.assertTrue((!x.isPrimitiveType() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.isQualifiedType());
        Assert.assertTrue((x.structuralPropertiesForType() == QualifiedType.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Qualifier", true, Type.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("a"));
                if (parented) {
                    targetAst.newArrayType((Type)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                QualifiedType s1 = ast.newQualifiedType((Type)x, ast.newSimpleName("z"));
                return s1;
            }

            @Override
            public void unwrap() {
                QualifiedType s1 = (QualifiedType)x.getParent();
                s1.setQualifier((Type)ast.newSimpleType((Name)ast.newSimpleName("z")));
            }

            @Override
            public ASTNode get() {
                return x.getQualifier();
            }

            @Override
            public void set(ASTNode value) {
                x.setQualifier((Type)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((SimpleName)value);
            }
        });
    }

    @Test
    public void testPackageDeclaration() {
        long previousCount = this.ast.modificationCount();
        final PackageDeclaration x = this.ast.newPackageDeclaration();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getJavadoc() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 35 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == PackageDeclaration.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        if (this.ast.apiLevel() >= 3) {
            this.genericPropertyTest((ASTNode)x, new Property(this, "Javadoc", false, JSdoc.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    JSdoc result = targetAst.newJSdoc();
                    if (parented) {
                        targetAst.newInitializer().setJavadoc(result);
                    }
                    return result;
                }

                @Override
                public ASTNode get() {
                    return x.getJavadoc();
                }

                @Override
                public void set(ASTNode value) {
                    x.setJavadoc((JSdoc)value);
                }
            });
        }
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, Name.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("a");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((Name)value);
            }
        });
    }

    @Test
    public void testImportDeclaration() {
        long previousCount = this.ast.modificationCount();
        final ImportDeclaration x = this.ast.newImportDeclaration();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((!x.isOnDemand() ? 1 : 0) != 0);
        if (this.ast.apiLevel() >= 3) {
            Assert.assertTrue((!x.isStatic() ? 1 : 0) != 0);
        }
        Assert.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 26 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == ImportDeclaration.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, Name.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("a");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((Name)value);
            }
        });
        previousCount = this.ast.modificationCount();
        x.setOnDemand(false);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((!x.isOnDemand() ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setOnDemand(true);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.isOnDemand());
        if (this.ast.apiLevel() >= 3) {
            x.setStatic(true);
            Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((boolean)x.isStatic());
        }
    }

    @Test
    public void testCompilationUnit() {
        long previousCount = this.ast.modificationCount();
        final JavaScriptUnit x = this.ast.newJavaScriptUnit();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getPackage() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.imports().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((x.types().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 15 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == JavaScriptUnit.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tClientProperties((ASTNode)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Package", false, PackageDeclaration.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                PackageDeclaration result = targetAst.newPackageDeclaration();
                if (parented) {
                    JavaScriptUnit cu = targetAst.newJavaScriptUnit();
                    cu.setPackage(result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getPackage();
            }

            @Override
            public void set(ASTNode value) {
                x.setPackage((PackageDeclaration)value);
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.imports(), new Property(this, "Imports", true, ImportDeclaration.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                ImportDeclaration result = targetAst.newImportDeclaration();
                if (parented) {
                    JavaScriptUnit cu = targetAst.newJavaScriptUnit();
                    cu.imports().add(result);
                }
                return result;
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.types(), new Property(this, "Types", true, AbstractTypeDeclaration.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                TypeDeclaration result = targetAst.newTypeDeclaration();
                if (parented) {
                    JavaScriptUnit cu = targetAst.newJavaScriptUnit();
                    cu.types().add(result);
                }
                return result;
            }
        });
        TypeDeclaration t1 = this.ast.newTypeDeclaration();
        x.types().add(t1);
        Assert.assertTrue((!t1.isLocalTypeDeclaration() ? 1 : 0) != 0);
        Assert.assertTrue((!t1.isMemberTypeDeclaration() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)t1.isPackageMemberTypeDeclaration());
    }

    @Test
    public void testCompilationUnitLineNumberTable() {
    }

    @Test
    public void testTypeDeclaration() {
        long previousCount = this.ast.modificationCount();
        final TypeDeclaration x = this.ast.newTypeDeclaration();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() == 2) {
            Assert.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((x.getSuperclass() == null ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((x.modifiers().size() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((x.getSuperclassType() == null ? 1 : 0) != 0);
        }
        Assert.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.getName().isDeclaration());
        Assert.assertTrue((x.getJavadoc() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.bodyDeclarations().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 55 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == TypeDeclaration.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        if (this.ast.apiLevel() == 2) {
            int legal = 3103;
            previousCount = this.ast.modificationCount();
            x.setModifiers(legal);
            Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((x.getModifiers() == legal ? 1 : 0) != 0);
            previousCount = this.ast.modificationCount();
            x.setModifiers(0);
            Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
        }
        this.tJavadocComment((BodyDeclaration)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((SimpleName)value);
            }
        });
        if (this.ast.apiLevel() == 2) {
            this.genericPropertyTest((ASTNode)x, new Property(this, "Superclass", false, Name.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    SimpleName result = targetAst.newSimpleName("foo");
                    if (parented) {
                        targetAst.newExpressionStatement((Expression)result);
                    }
                    return result;
                }

                @Override
                public ASTNode get() {
                    return x.getSuperclass();
                }

                @Override
                public void set(ASTNode value) {
                    x.setSuperclass((Name)value);
                }
            });
        }
        if (this.ast.apiLevel() >= 3) {
            this.genericPropertyTest((ASTNode)x, new Property(this, "SuperclassType", false, Type.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("foo"));
                    if (parented) {
                        targetAst.newArrayType((Type)result);
                    }
                    return result;
                }

                @Override
                public ASTNode get() {
                    return x.getSuperclassType();
                }

                @Override
                public void set(ASTNode value) {
                    x.setSuperclassType((Type)value);
                }
            });
        }
        this.genericPropertyListTest((ASTNode)x, x.bodyDeclarations(), new Property(this, "BodyDeclarations", true, BodyDeclaration.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                TypeDeclaration result = targetAst.newTypeDeclaration();
                if (parented) {
                    JavaScriptUnit cu = targetAst.newJavaScriptUnit();
                    cu.types().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                TypeDeclaration s1 = x.getAST().newTypeDeclaration();
                s1.bodyDeclarations().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                TypeDeclaration s1 = (TypeDeclaration)x.getParent();
                s1.bodyDeclarations().remove(x);
            }
        });
        x.bodyDeclarations().clear();
        FieldDeclaration f1 = this.ast.newFieldDeclaration(this.ast.newVariableDeclarationFragment());
        FieldDeclaration f2 = this.ast.newFieldDeclaration(this.ast.newVariableDeclarationFragment());
        FunctionDeclaration m1 = this.ast.newFunctionDeclaration();
        FunctionDeclaration m2 = this.ast.newFunctionDeclaration();
        TypeDeclaration t1 = this.ast.newTypeDeclaration();
        TypeDeclaration t2 = this.ast.newTypeDeclaration();
        x.bodyDeclarations().add(this.ast.newInitializer());
        x.bodyDeclarations().add(f1);
        x.bodyDeclarations().add(this.ast.newInitializer());
        x.bodyDeclarations().add(f2);
        x.bodyDeclarations().add(this.ast.newInitializer());
        x.bodyDeclarations().add(t1);
        x.bodyDeclarations().add(this.ast.newInitializer());
        x.bodyDeclarations().add(m1);
        x.bodyDeclarations().add(this.ast.newInitializer());
        x.bodyDeclarations().add(m2);
        x.bodyDeclarations().add(this.ast.newInitializer());
        x.bodyDeclarations().add(t2);
        x.bodyDeclarations().add(this.ast.newInitializer());
        List<FieldDeclaration> fs = Arrays.asList(x.getFields());
        Assert.assertTrue((fs.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(f1));
        Assert.assertTrue((boolean)fs.contains(f2));
        List<FunctionDeclaration> ms = Arrays.asList(x.getMethods());
        Assert.assertTrue((ms.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)ms.contains(m1));
        Assert.assertTrue((boolean)ms.contains(m2));
        List<TypeDeclaration> ts = Arrays.asList(x.getTypes());
        Assert.assertTrue((ts.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)ts.contains(t1));
        Assert.assertTrue((boolean)ts.contains(t2));
        Assert.assertTrue((!t1.isLocalTypeDeclaration() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)t1.isMemberTypeDeclaration());
        Assert.assertTrue((!t1.isPackageMemberTypeDeclaration() ? 1 : 0) != 0);
    }

    @Test
    public void testSingleVariableDeclaration() {
        long previousCount = this.ast.modificationCount();
        final SingleVariableDeclaration x = this.ast.newSingleVariableDeclaration();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() == 2) {
            Assert.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((x.modifiers().size() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((!x.isVarargs() ? 1 : 0) != 0);
        }
        Assert.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.getName().isDeclaration());
        Assert.assertTrue((x.getType().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getExtraDimensions() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((x.getInitializer() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 44 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == SingleVariableDeclaration.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        if (this.ast.apiLevel() == 2) {
            int legal = 223;
            previousCount = this.ast.modificationCount();
            x.setModifiers(legal);
            Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((x.getModifiers() == legal ? 1 : 0) != 0);
            previousCount = this.ast.modificationCount();
            x.setModifiers(0);
            Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
        }
        previousCount = this.ast.modificationCount();
        x.setExtraDimensions(1);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((x.getExtraDimensions() == 1 ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setExtraDimensions(0);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((x.getExtraDimensions() == 0 ? 1 : 0) != 0);
        if (this.ast.apiLevel() >= 3) {
            previousCount = this.ast.modificationCount();
            x.setVarargs(true);
            Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((boolean)x.isVarargs());
            previousCount = this.ast.modificationCount();
            x.setVarargs(false);
            Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((!x.isVarargs() ? 1 : 0) != 0);
        }
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((SimpleName)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Type", true, Type.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("foo"));
                if (parented) {
                    targetAst.newArrayType((Type)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getType();
            }

            @Override
            public void set(ASTNode value) {
                x.setType((Type)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Initializer", false, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                CatchClause s1 = ast.newCatchClause();
                s1.setException(x);
                return s1;
            }

            @Override
            public void unwrap() {
                CatchClause s1 = (CatchClause)x.getParent();
                s1.setException(ast.newSingleVariableDeclaration());
            }

            @Override
            public ASTNode get() {
                return x.getInitializer();
            }

            @Override
            public void set(ASTNode value) {
                x.setInitializer((Expression)value);
            }
        });
    }

    @Test
    public void testVariableDeclarationFragment() {
        long previousCount = this.ast.modificationCount();
        final VariableDeclarationFragment x = this.ast.newVariableDeclarationFragment();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.getName().isDeclaration());
        Assert.assertTrue((x.getExtraDimensions() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((x.getInitializer() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 59 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == VariableDeclarationFragment.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setExtraDimensions(1);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((x.getExtraDimensions() == 1 ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setExtraDimensions(0);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((x.getExtraDimensions() == 0 ? 1 : 0) != 0);
        try {
            x.setExtraDimensions(-1);
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((SimpleName)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Initializer", false, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                VariableDeclarationExpression s1 = ast.newVariableDeclarationExpression(x);
                return s1;
            }

            @Override
            public void unwrap() {
                VariableDeclarationExpression s1 = (VariableDeclarationExpression)x.getParent();
                s1.fragments().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getInitializer();
            }

            @Override
            public void set(ASTNode value) {
                x.setInitializer((Expression)value);
            }
        });
    }

    @Test
    public void testMethodDeclaration() {
        long previousCount = this.ast.modificationCount();
        final FunctionDeclaration x = this.ast.newFunctionDeclaration();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.modifiers().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((x.getReturnType2().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.getReturnType2().isPrimitiveType());
        Assert.assertTrue((((PrimitiveType)x.getReturnType2()).getPrimitiveTypeCode() == PrimitiveType.ANY_CODE ? 1 : 0) != 0);
        Assert.assertTrue((!x.isConstructor() ? 1 : 0) != 0);
        Assert.assertTrue((x.getExtraDimensions() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((x.getJavadoc() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.parameters().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((x.thrownExceptions().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((x.getBody() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 31 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == FunctionDeclaration.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setConstructor(true);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.isConstructor());
        previousCount = this.ast.modificationCount();
        x.setConstructor(false);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((!x.isConstructor() ? 1 : 0) != 0);
        if (this.ast.apiLevel() == 2) {
            previousCount = this.ast.modificationCount();
            int legal = 3391;
            x.setModifiers(legal);
            Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((x.getModifiers() == legal ? 1 : 0) != 0);
            previousCount = this.ast.modificationCount();
            x.setModifiers(0);
            Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
        }
        previousCount = this.ast.modificationCount();
        x.setExtraDimensions(1);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((x.getExtraDimensions() == 1 ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setExtraDimensions(0);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((x.getExtraDimensions() == 0 ? 1 : 0) != 0);
        this.tJavadocComment((BodyDeclaration)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((SimpleName)value);
            }
        });
        if (this.ast.apiLevel() == 2) {
            this.genericPropertyTest((ASTNode)x, new Property(this, "ReturnType", true, Type.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("foo"));
                    if (parented) {
                        targetAst.newArrayType((Type)result);
                    }
                    return result;
                }

                @Override
                public ASTNode get() {
                    return x.getReturnType();
                }

                @Override
                public void set(ASTNode value) {
                    x.setReturnType((Type)value);
                }
            });
        }
        if (this.ast.apiLevel() >= 3) {
            this.genericPropertyTest((ASTNode)x, new Property(this, "ReturnType2", false, Type.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("foo"));
                    if (parented) {
                        targetAst.newArrayType((Type)result);
                    }
                    return result;
                }

                @Override
                public ASTNode get() {
                    return x.getReturnType2();
                }

                @Override
                public void set(ASTNode value) {
                    x.setReturnType2((Type)value);
                }
            });
        }
        this.genericPropertyListTest((ASTNode)x, x.parameters(), new Property(this, "Parameters", true, SingleVariableDeclaration.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SingleVariableDeclaration result = targetAst.newSingleVariableDeclaration();
                if (parented) {
                    targetAst.newCatchClause().setException(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                SingleVariableDeclaration s1 = ast.newSingleVariableDeclaration();
                ClassInstanceCreation s2 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s2.setAnonymousClassDeclaration(a1);
                s1.setInitializer((Expression)s2);
                a1.bodyDeclarations().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                AnonymousClassDeclaration a1 = (AnonymousClassDeclaration)x.getParent();
                a1.bodyDeclarations().remove(x);
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.thrownExceptions(), new Property(this, "ThrownExceptions", true, Name.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Body", false, Block.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                Block result = targetAst.newBlock();
                if (parented) {
                    Block b2 = targetAst.newBlock();
                    b2.statements().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                Block s1 = ast.newBlock();
                TypeDeclaration s2 = ast.newTypeDeclaration();
                s1.statements().add(ast.newTypeDeclarationStatement(s2));
                s2.bodyDeclarations().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                TypeDeclaration s2 = (TypeDeclaration)x.getParent();
                s2.bodyDeclarations().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getBody();
            }

            @Override
            public void set(ASTNode value) {
                x.setBody((Block)value);
            }
        });
        if (this.ast.apiLevel() >= 3) {
            x.parameters().clear();
            Assert.assertTrue((!x.isVarargs() ? 1 : 0) != 0);
            x.parameters().add(this.ast.newSingleVariableDeclaration());
            Assert.assertTrue((!x.isVarargs() ? 1 : 0) != 0);
            SingleVariableDeclaration v = this.ast.newSingleVariableDeclaration();
            x.parameters().add(v);
            Assert.assertTrue((!x.isVarargs() ? 1 : 0) != 0);
            v.setVarargs(true);
            Assert.assertTrue((boolean)x.isVarargs());
            x.parameters().add(this.ast.newSingleVariableDeclaration());
            Assert.assertTrue((!x.isVarargs() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testInitializer() {
        long previousCount = this.ast.modificationCount();
        final Initializer x = this.ast.newInitializer();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getJavadoc() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() == 2) {
            Assert.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((x.modifiers().size() == 0 ? 1 : 0) != 0);
        }
        Assert.assertTrue((x.getBody().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getBody().statements().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 28 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == Initializer.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tJavadocComment((BodyDeclaration)x);
        if (this.ast.apiLevel() == 2) {
            int legal = 8;
            previousCount = this.ast.modificationCount();
            x.setModifiers(legal);
            Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((x.getModifiers() == legal ? 1 : 0) != 0);
            previousCount = this.ast.modificationCount();
            x.setModifiers(0);
            Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
        }
        this.genericPropertyTest((ASTNode)x, new Property(this, "Body", true, Block.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                Block result = targetAst.newBlock();
                if (parented) {
                    Block b2 = targetAst.newBlock();
                    b2.statements().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                Block s1 = ast.newBlock();
                TypeDeclaration s2 = ast.newTypeDeclaration();
                s1.statements().add(ast.newTypeDeclarationStatement(s2));
                s2.bodyDeclarations().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                TypeDeclaration s2 = (TypeDeclaration)x.getParent();
                s2.bodyDeclarations().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getBody();
            }

            @Override
            public void set(ASTNode value) {
                x.setBody((Block)value);
            }
        });
    }

    @Test
    public void testJavadoc() {
        long previousCount = this.ast.modificationCount();
        JSdoc x = this.ast.newJSdoc();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() == 2) {
            Assert.assertTrue((boolean)x.getComment().startsWith("/**"));
            Assert.assertTrue((boolean)x.getComment().endsWith("*/"));
        }
        Assert.assertTrue((x.getNodeType() == 29 ? 1 : 0) != 0);
        Assert.assertTrue((!x.isBlockComment() ? 1 : 0) != 0);
        Assert.assertTrue((!x.isLineComment() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.isDocComment());
        Assert.assertTrue((boolean)x.tags().isEmpty());
        Assert.assertTrue((x.getAlternateRoot() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == JSdoc.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        Assert.assertTrue((boolean)"@author".equals("@author"));
        Assert.assertTrue((boolean)"@deprecated".equals("@deprecated"));
        Assert.assertTrue((boolean)"@docRoot".equals("@docRoot"));
        Assert.assertTrue((boolean)"@exception".equals("@exception"));
        Assert.assertTrue((boolean)"@inheritDoc".equals("@inheritDoc"));
        Assert.assertTrue((boolean)"@link".equals("@link"));
        Assert.assertTrue((boolean)"@linkplain".equals("@linkplain"));
        Assert.assertTrue((boolean)"@param".equals("@param"));
        Assert.assertTrue((boolean)"@return".equals("@return"));
        Assert.assertTrue((boolean)"@see".equals("@see"));
        Assert.assertTrue((boolean)"@serial".equals("@serial"));
        Assert.assertTrue((boolean)"@serialData".equals("@serialData"));
        Assert.assertTrue((boolean)"@serialField".equals("@serialField"));
        Assert.assertTrue((boolean)"@since".equals("@since"));
        Assert.assertTrue((boolean)"@throws".equals("@throws"));
        Assert.assertTrue((boolean)"@value".equals("@value"));
        Assert.assertTrue((boolean)"@version".equals("@version"));
        if (this.ast.apiLevel() == 2) {
            String[] samples = new String[]{"/** Hello there */", "/**\n * Line 1\n * Line 2\n */", "/***/"};
            int i = 0;
            while (i < samples.length) {
                previousCount = this.ast.modificationCount();
                x.setComment(samples[i]);
                Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
                Assert.assertTrue((boolean)samples[i].equals(x.getComment()));
                ++i;
            }
            String[] stringArray = new String[5];
            stringArray[1] = "";
            stringArray[2] = "/* */";
            stringArray[3] = "/**";
            stringArray[4] = "*/";
            String[] badSamples = stringArray;
            int i2 = 0;
            while (i2 < badSamples.length) {
                try {
                    x.setComment(badSamples[i2]);
                    Assert.assertTrue((boolean)false);
                }
                catch (RuntimeException runtimeException) {}
                ++i2;
            }
        }
        this.tAlternateRoot((Comment)x);
        this.genericPropertyListTest((ASTNode)x, x.tags(), new Property(this, "Tags", true, TagElement.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                TagElement result = targetAst.newTagElement();
                if (parented) {
                    JSdoc parent = targetAst.newJSdoc();
                    parent.tags().add(result);
                }
                return result;
            }

            @Override
            public ASTNode[] counterExamples(AST targetAst) {
                return new ASTNode[]{targetAst.newEmptyStatement(), targetAst.newJavaScriptUnit(), targetAst.newTypeDeclaration(), targetAst.newJSdoc(), targetAst.newTextElement(), targetAst.newFunctionRef()};
            }
        });
    }

    @Test
    public void testBlockComment() {
        long previousCount = this.ast.modificationCount();
        BlockComment x = this.ast.newBlockComment();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 64 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.isBlockComment());
        Assert.assertTrue((!x.isLineComment() ? 1 : 0) != 0);
        Assert.assertTrue((!x.isDocComment() ? 1 : 0) != 0);
        Assert.assertTrue((x.getAlternateRoot() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == BlockComment.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tAlternateRoot((Comment)x);
    }

    @Test
    public void testLineComment() {
        long previousCount = this.ast.modificationCount();
        LineComment x = this.ast.newLineComment();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 63 ? 1 : 0) != 0);
        Assert.assertTrue((!x.isBlockComment() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.isLineComment());
        Assert.assertTrue((!x.isDocComment() ? 1 : 0) != 0);
        Assert.assertTrue((x.getAlternateRoot() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == LineComment.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tAlternateRoot((Comment)x);
    }

    @Test
    public void testTagElement() {
        long previousCount = this.ast.modificationCount();
        final TagElement x = this.ast.newTagElement();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 65 ? 1 : 0) != 0);
        Assert.assertTrue((x.getTagName() == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.fragments().isEmpty());
        Assert.assertTrue((x.structuralPropertiesForType() == TagElement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        String s1 = new String("hello");
        x.setTagName(s1);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((x.getTagName() == s1 ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        String s2 = new String("bye");
        x.setTagName(s2);
        Assert.assertTrue((x.getTagName() == s2 ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        x.setTagName(null);
        Assert.assertTrue((x.getTagName() == null ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        this.genericPropertyListTest((ASTNode)x, x.fragments(), new Property(this, "Fragments", true, TagElement.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                TagElement result = targetAst.newTagElement();
                if (parented) {
                    JSdoc parent = targetAst.newJSdoc();
                    parent.tags().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                TagElement tagElement = ast.newTagElement();
                tagElement.fragments().add(x);
                return tagElement;
            }

            @Override
            public void unwrap() {
                TagElement tagElement = (TagElement)x.getParent();
                tagElement.fragments().remove(x);
            }

            @Override
            public ASTNode[] counterExamples(AST targetAst) {
                return new ASTNode[]{targetAst.newEmptyStatement(), targetAst.newJavaScriptUnit(), targetAst.newTypeDeclaration(), targetAst.newJSdoc()};
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.fragments(), new Property(this, "Fragments", true, Name.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.fragments(), new Property(this, "Fragments", true, TextElement.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                TextElement result = targetAst.newTextElement();
                if (parented) {
                    TagElement parent = targetAst.newTagElement();
                    parent.fragments().add(result);
                }
                return result;
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.fragments(), new Property(this, "Fragments", true, FunctionRef.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                FunctionRef result = targetAst.newFunctionRef();
                if (parented) {
                    TagElement parent = targetAst.newTagElement();
                    parent.fragments().add(result);
                }
                return result;
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.fragments(), new Property(this, "Fragments", true, MemberRef.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                MemberRef result = targetAst.newMemberRef();
                if (parented) {
                    TagElement parent = targetAst.newTagElement();
                    parent.fragments().add(result);
                }
                return result;
            }
        });
    }

    @Test
    public void testTextElement() {
        long previousCount = this.ast.modificationCount();
        TextElement x = this.ast.newTextElement();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 66 ? 1 : 0) != 0);
        Assert.assertTrue((x.getText().length() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == TextElement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        String s1 = new String("hello");
        x.setText(s1);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((x.getText() == s1 ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        String s2 = new String("");
        x.setText(s2);
        Assert.assertTrue((x.getText() == s2 ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        try {
            x.setText(null);
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        try {
            x.setText("this would be the */ end of it");
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
    }

    @Test
    public void testMemberRef() {
        long previousCount = this.ast.modificationCount();
        final MemberRef x = this.ast.newMemberRef();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 67 ? 1 : 0) != 0);
        Assert.assertTrue((x.getQualifier() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == MemberRef.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Qualifier", false, Name.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                QualifiedName result = targetAst.newQualifiedName((Name)targetAst.newSimpleName("a"), targetAst.newSimpleName("b"));
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getQualifier();
            }

            @Override
            public void set(ASTNode value) {
                x.setQualifier((Name)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((SimpleName)value);
            }
        });
    }

    @Test
    public void testMethodRef() {
        long previousCount = this.ast.modificationCount();
        final FunctionRef x = this.ast.newFunctionRef();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 68 ? 1 : 0) != 0);
        Assert.assertTrue((x.getQualifier() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.parameters().isEmpty());
        Assert.assertTrue((x.structuralPropertiesForType() == FunctionRef.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Qualifier", false, Name.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                QualifiedName result = targetAst.newQualifiedName((Name)targetAst.newSimpleName("a"), targetAst.newSimpleName("b"));
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getQualifier();
            }

            @Override
            public void set(ASTNode value) {
                x.setQualifier((Name)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((SimpleName)value);
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.parameters(), new Property(this, "Parameters", true, FunctionRefParameter.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                FunctionRefParameter result = targetAst.newFunctionRefParameter();
                if (parented) {
                    FunctionRef parent = targetAst.newFunctionRef();
                    parent.parameters().add(result);
                }
                return result;
            }
        });
    }

    @Test
    public void testMethodRefParameter() {
        long previousCount = this.ast.modificationCount();
        final FunctionRefParameter x = this.ast.newFunctionRefParameter();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 69 ? 1 : 0) != 0);
        Assert.assertTrue((x.getType().getParent() == x ? 1 : 0) != 0);
        if (this.ast.apiLevel() >= 3) {
            Assert.assertTrue((!x.isVarargs() ? 1 : 0) != 0);
        }
        Assert.assertTrue((x.getName() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == FunctionRefParameter.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        if (this.ast.apiLevel() >= 3) {
            previousCount = this.ast.modificationCount();
            x.setVarargs(true);
            Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((boolean)x.isVarargs());
            previousCount = this.ast.modificationCount();
            x.setVarargs(false);
            Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((!x.isVarargs() ? 1 : 0) != 0);
        }
        this.genericPropertyTest((ASTNode)x, new Property(this, "Type", true, Type.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("foo"));
                if (parented) {
                    targetAst.newArrayType((Type)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getType();
            }

            @Override
            public void set(ASTNode value) {
                x.setType((Type)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", false, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((SimpleName)value);
            }
        });
    }

    @Test
    public void testBlock() {
        long previousCount = this.ast.modificationCount();
        final Block x = this.ast.newBlock();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.statements().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 8 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == Block.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyListTest((ASTNode)x, x.statements(), new Property(this, "Statements", true, Statement.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                Block result = targetAst.newBlock();
                if (parented) {
                    Block b2 = targetAst.newBlock();
                    b2.statements().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                Block s1 = ast.newBlock();
                s1.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s2 = (Block)x.getParent();
                s2.statements().remove(x);
            }
        });
    }

    @Test
    public void testMethodInvocation() {
        long previousCount = this.ast.modificationCount();
        final FunctionInvocation x = this.ast.newFunctionInvocation();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() >= 3) {
            Assert.assertTrue((boolean)x.typeArguments().isEmpty());
        }
        Assert.assertTrue((x.getExpression() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.arguments().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 32 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == FunctionInvocation.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", false, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("x"));
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
        if (this.ast.apiLevel() >= 3) {
            this.genericPropertyListTest((ASTNode)x, x.typeArguments(), new Property(this, "TypeArguments", true, Type.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("X"));
                    if (parented) {
                        targetAst.newArrayType((Type)result);
                    }
                    return result;
                }
            });
        }
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((SimpleName)value);
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.arguments(), new Property(this, "Arguments", true, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("x"));
            }
        });
    }

    @Test
    public void testExpressionStatement() {
        long previousCount = this.ast.modificationCount();
        SimpleName x1 = this.ast.newSimpleName("foo");
        final ExpressionStatement x = this.ast.newExpressionStatement((Expression)x1);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getExpression() == x1 ? 1 : 0) != 0);
        Assert.assertTrue((x1.getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 21 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == ExpressionStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", true, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
    }

    @Test
    public void testVariableDeclarationStatement() {
        VariableDeclarationFragment x1 = this.ast.newVariableDeclarationFragment();
        long previousCount = this.ast.modificationCount();
        final VariableDeclarationStatement x = this.ast.newVariableDeclarationStatement(x1);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() == 2) {
            Assert.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((x.modifiers().size() == 0 ? 1 : 0) != 0);
        }
        Assert.assertTrue((x.getType() != null ? 1 : 0) != 0);
        Assert.assertTrue((x.getType().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.fragments().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((x.fragments().get(0) == x1 ? 1 : 0) != 0);
        Assert.assertTrue((x1.getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 60 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == VariableDeclarationStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        if (this.ast.apiLevel() == 2) {
            int legal = 16;
            previousCount = this.ast.modificationCount();
            x.setModifiers(legal);
            Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((x.getModifiers() == legal ? 1 : 0) != 0);
            previousCount = this.ast.modificationCount();
            x.setModifiers(0);
            Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
        }
        this.genericPropertyTest((ASTNode)x, new Property(this, "Type", true, Type.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("foo"));
                if (parented) {
                    targetAst.newArrayType((Type)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getType();
            }

            @Override
            public void set(ASTNode value) {
                x.setType((Type)value);
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.fragments(), new Property(this, "VariableSpecifiers", true, VariableDeclarationFragment.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                VariableDeclarationFragment result = targetAst.newVariableDeclarationFragment();
                if (parented) {
                    targetAst.newVariableDeclarationExpression(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                VariableDeclarationFragment s1 = ast.newVariableDeclarationFragment();
                ClassInstanceCreation s0 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s0.setAnonymousClassDeclaration(a1);
                s1.setInitializer((Expression)s0);
                Initializer s2 = ast.newInitializer();
                a1.bodyDeclarations().add(s2);
                s2.getBody().statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }
        });
    }

    @Test
    public void testTypeDeclarationStatement() {
        TypeDeclaration x1 = this.ast.newTypeDeclaration();
        long previousCount = this.ast.modificationCount();
        final TypeDeclarationStatement x = this.ast.newTypeDeclarationStatement((AbstractTypeDeclaration)x1);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() == 2) {
            Assert.assertTrue((x.getTypeDeclaration() == x1 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((x.getDeclaration() == x1 ? 1 : 0) != 0);
        }
        Assert.assertTrue((x1.getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 56 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == TypeDeclarationStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x1.isLocalTypeDeclaration());
        Assert.assertTrue((!x1.isMemberTypeDeclaration() ? 1 : 0) != 0);
        Assert.assertTrue((!x1.isPackageMemberTypeDeclaration() ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        if (this.ast.apiLevel() == 2) {
            this.genericPropertyTest((ASTNode)x, new Property(this, "TypeDeclaration", true, TypeDeclaration.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    TypeDeclaration result = targetAst.newTypeDeclaration();
                    if (parented) {
                        targetAst.newTypeDeclarationStatement(result);
                    }
                    return result;
                }

                @Override
                public ASTNode wrap() {
                    TypeDeclaration s1 = ast.newTypeDeclaration();
                    FunctionDeclaration s2 = ast.newFunctionDeclaration();
                    s1.bodyDeclarations().add(s2);
                    Block s3 = ast.newBlock();
                    s2.setBody(s3);
                    s3.statements().add(x);
                    return s1;
                }

                @Override
                public void unwrap() {
                    Block s3 = (Block)x.getParent();
                    s3.statements().remove(x);
                }

                @Override
                public ASTNode get() {
                    return x.getTypeDeclaration();
                }

                @Override
                public void set(ASTNode value) {
                    x.setTypeDeclaration((TypeDeclaration)value);
                }
            });
        }
        if (this.ast.apiLevel() >= 3) {
            this.genericPropertyTest((ASTNode)x, new Property(this, "Declaration", true, AbstractTypeDeclaration.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    TypeDeclaration result = targetAst.newTypeDeclaration();
                    if (parented) {
                        targetAst.newTypeDeclarationStatement((AbstractTypeDeclaration)result);
                    }
                    return result;
                }

                @Override
                public ASTNode wrap() {
                    TypeDeclaration s1 = ast.newTypeDeclaration();
                    FunctionDeclaration s2 = ast.newFunctionDeclaration();
                    s1.bodyDeclarations().add(s2);
                    Block s3 = ast.newBlock();
                    s2.setBody(s3);
                    s3.statements().add(x);
                    return s1;
                }

                @Override
                public void unwrap() {
                    Block s3 = (Block)x.getParent();
                    s3.statements().remove(x);
                }

                @Override
                public ASTNode get() {
                    return x.getDeclaration();
                }

                @Override
                public void set(ASTNode value) {
                    x.setDeclaration((AbstractTypeDeclaration)value);
                }
            });
        }
    }

    @Test
    public void testVariableDeclarationExpression() {
        VariableDeclarationFragment x1 = this.ast.newVariableDeclarationFragment();
        long previousCount = this.ast.modificationCount();
        final VariableDeclarationExpression x = this.ast.newVariableDeclarationExpression(x1);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() == 2) {
            Assert.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((x.modifiers().size() == 0 ? 1 : 0) != 0);
        }
        Assert.assertTrue((x.getType() != null ? 1 : 0) != 0);
        Assert.assertTrue((x.getType().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.fragments().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((x.fragments().get(0) == x1 ? 1 : 0) != 0);
        Assert.assertTrue((x1.getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 58 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == VariableDeclarationExpression.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        if (this.ast.apiLevel() == 2) {
            int legal = 16;
            previousCount = this.ast.modificationCount();
            x.setModifiers(legal);
            Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((x.getModifiers() == legal ? 1 : 0) != 0);
            previousCount = this.ast.modificationCount();
            x.setModifiers(0);
            Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
        }
        this.genericPropertyTest((ASTNode)x, new Property(this, "Type", true, Type.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("foo"));
                if (parented) {
                    targetAst.newArrayType((Type)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getType();
            }

            @Override
            public void set(ASTNode value) {
                x.setType((Type)value);
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.fragments(), new Property(this, "VariableSpecifiers", true, VariableDeclarationFragment.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                VariableDeclarationFragment result = targetAst.newVariableDeclarationFragment();
                if (parented) {
                    targetAst.newVariableDeclarationExpression(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                VariableDeclarationFragment s1 = ast.newVariableDeclarationFragment();
                ClassInstanceCreation s0 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s0.setAnonymousClassDeclaration(a1);
                s1.setInitializer((Expression)s0);
                ForStatement s2 = ast.newForStatement();
                s2.initializers().add(x);
                Initializer s3 = ast.newInitializer();
                a1.bodyDeclarations().add(s3);
                s3.getBody().statements().add(s2);
                return s1;
            }

            @Override
            public void unwrap() {
                ForStatement s2 = (ForStatement)x.getParent();
                s2.initializers().remove(x);
            }
        });
    }

    @Test
    public void testFieldDeclaration() {
        VariableDeclarationFragment x1 = this.ast.newVariableDeclarationFragment();
        long previousCount = this.ast.modificationCount();
        final FieldDeclaration x = this.ast.newFieldDeclaration(x1);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getJavadoc() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() == 2) {
            Assert.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((x.modifiers().size() == 0 ? 1 : 0) != 0);
        }
        Assert.assertTrue((x.getType() != null ? 1 : 0) != 0);
        Assert.assertTrue((x.getType().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.fragments().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((x.fragments().get(0) == x1 ? 1 : 0) != 0);
        Assert.assertTrue((x1.getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 23 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == FieldDeclaration.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        if (this.ast.apiLevel() == 2) {
            int legal = 223;
            previousCount = this.ast.modificationCount();
            x.setModifiers(legal);
            Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((x.getModifiers() == legal ? 1 : 0) != 0);
            previousCount = this.ast.modificationCount();
            x.setModifiers(0);
            Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
        }
        this.tJavadocComment((BodyDeclaration)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Type", true, Type.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("foo"));
                if (parented) {
                    targetAst.newArrayType((Type)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getType();
            }

            @Override
            public void set(ASTNode value) {
                x.setType((Type)value);
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.fragments(), new Property(this, "VariableSpecifiers", true, VariableDeclarationFragment.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                VariableDeclarationFragment result = targetAst.newVariableDeclarationFragment();
                if (parented) {
                    targetAst.newVariableDeclarationStatement(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                VariableDeclarationFragment s1 = ast.newVariableDeclarationFragment();
                ClassInstanceCreation s2 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s2.setAnonymousClassDeclaration(a1);
                s1.setInitializer((Expression)s2);
                a1.bodyDeclarations().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                AnonymousClassDeclaration a1 = (AnonymousClassDeclaration)x.getParent();
                a1.bodyDeclarations().remove(x);
            }
        });
    }

    @Test
    public void testAssignment() {
        long previousCount = this.ast.modificationCount();
        final Assignment x = this.ast.newAssignment();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getOperator() == Assignment.Operator.ASSIGN ? 1 : 0) != 0);
        Assert.assertTrue((x.getLeftHandSide().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getRightHandSide().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 7 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == Assignment.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setOperator(Assignment.Operator.PLUS_ASSIGN);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((x.getOperator() == Assignment.Operator.PLUS_ASSIGN ? 1 : 0) != 0);
        Assert.assertTrue((Assignment.Operator.PLUS_ASSIGN != Assignment.Operator.ASSIGN ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Assignment.Operator.ASSIGN.toString().equals("="));
        Assert.assertTrue((boolean)Assignment.Operator.PLUS_ASSIGN.toString().equals("+="));
        Assert.assertTrue((boolean)Assignment.Operator.MINUS_ASSIGN.toString().equals("-="));
        Assert.assertTrue((boolean)Assignment.Operator.TIMES_ASSIGN.toString().equals("*="));
        Assert.assertTrue((boolean)Assignment.Operator.DIVIDE_ASSIGN.toString().equals("/="));
        Assert.assertTrue((boolean)Assignment.Operator.REMAINDER_ASSIGN.toString().equals("%="));
        Assert.assertTrue((boolean)Assignment.Operator.LEFT_SHIFT_ASSIGN.toString().equals("<<="));
        Assert.assertTrue((boolean)Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN.toString().equals(">>="));
        Assert.assertTrue((boolean)Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN.toString().equals(">>>="));
        Assert.assertTrue((boolean)Assignment.Operator.BIT_AND_ASSIGN.toString().equals("&="));
        Assert.assertTrue((boolean)Assignment.Operator.BIT_OR_ASSIGN.toString().equals("|="));
        Assert.assertTrue((boolean)Assignment.Operator.BIT_XOR_ASSIGN.toString().equals("^="));
        Assignment.Operator[] known = new Assignment.Operator[]{Assignment.Operator.ASSIGN, Assignment.Operator.PLUS_ASSIGN, Assignment.Operator.MINUS_ASSIGN, Assignment.Operator.TIMES_ASSIGN, Assignment.Operator.DIVIDE_ASSIGN, Assignment.Operator.REMAINDER_ASSIGN, Assignment.Operator.LEFT_SHIFT_ASSIGN, Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN, Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN, Assignment.Operator.BIT_AND_ASSIGN, Assignment.Operator.BIT_OR_ASSIGN, Assignment.Operator.BIT_XOR_ASSIGN};
        int i = 0;
        while (i < known.length) {
            int j = 0;
            while (j < known.length) {
                Assert.assertTrue((i == j || !known[i].equals(known[j]) ? 1 : 0) != 0);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < known.length) {
            previousCount = this.ast.modificationCount();
            x.setOperator(known[i]);
            Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((boolean)x.getOperator().equals(known[i]));
            ++i;
        }
        try {
            x.setOperator(null);
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
        i = 0;
        while (i < known.length) {
            String name = known[i].toString();
            Assert.assertTrue((boolean)Assignment.Operator.toOperator((String)name).equals(known[i]));
            ++i;
        }
        Assert.assertTrue((Assignment.Operator.toOperator((String)"not-an-op") == null ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "LeftHandSide", true, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("x"));
            }

            @Override
            public ASTNode get() {
                return x.getLeftHandSide();
            }

            @Override
            public void set(ASTNode value) {
                x.setLeftHandSide((Expression)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "RightHandSide", true, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("x"));
            }

            @Override
            public ASTNode get() {
                return x.getRightHandSide();
            }

            @Override
            public void set(ASTNode value) {
                x.setRightHandSide((Expression)value);
            }
        });
    }

    @Test
    public void testBreakStatement() {
        long previousCount = this.ast.modificationCount();
        final BreakStatement x = this.ast.newBreakStatement();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getLabel() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 10 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == BreakStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Label", false, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getLabel();
            }

            @Override
            public void set(ASTNode value) {
                x.setLabel((SimpleName)value);
            }
        });
    }

    @Test
    public void testContinueStatement() {
        long previousCount = this.ast.modificationCount();
        final ContinueStatement x = this.ast.newContinueStatement();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getLabel() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 18 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == ContinueStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Label", false, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getLabel();
            }

            @Override
            public void set(ASTNode value) {
                x.setLabel((SimpleName)value);
            }
        });
    }

    @Test
    public void testIfStatement() {
        long previousCount = this.ast.modificationCount();
        final IfStatement x = this.ast.newIfStatement();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getExpression().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getThenStatement().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(x.getThenStatement() instanceof Block));
        Assert.assertTrue((boolean)((Block)x.getThenStatement()).statements().isEmpty());
        Assert.assertTrue((x.getElseStatement() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 25 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == IfStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "ThenStatement", true, Statement.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                Block result = targetAst.newBlock();
                if (parented) {
                    Block b2 = targetAst.newBlock();
                    b2.statements().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                Block s1 = ast.newBlock();
                s1.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s2 = (Block)x.getParent();
                s2.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getThenStatement();
            }

            @Override
            public void set(ASTNode value) {
                x.setThenStatement((Statement)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "ElseStatement", false, Statement.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                Block result = targetAst.newBlock();
                if (parented) {
                    Block b2 = targetAst.newBlock();
                    b2.statements().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                Block s1 = ast.newBlock();
                s1.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s2 = (Block)x.getParent();
                s2.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getElseStatement();
            }

            @Override
            public void set(ASTNode value) {
                x.setElseStatement((Statement)value);
            }
        });
    }

    @Test
    public void testWhileStatement() {
        long previousCount = this.ast.modificationCount();
        final WhileStatement x = this.ast.newWhileStatement();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getExpression().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getBody().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(x.getBody() instanceof Block));
        Assert.assertTrue((boolean)((Block)x.getBody()).statements().isEmpty());
        Assert.assertTrue((x.getNodeType() == 61 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == WhileStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Body", true, Statement.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                Block result = targetAst.newBlock();
                if (parented) {
                    Block b2 = targetAst.newBlock();
                    b2.statements().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                Block s1 = ast.newBlock();
                s1.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s2 = (Block)x.getParent();
                s2.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getBody();
            }

            @Override
            public void set(ASTNode value) {
                x.setBody((Statement)value);
            }
        });
    }

    @Test
    public void testDoStatement() {
        long previousCount = this.ast.modificationCount();
        final DoStatement x = this.ast.newDoStatement();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getExpression().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getBody().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(x.getBody() instanceof Block));
        Assert.assertTrue((boolean)((Block)x.getBody()).statements().isEmpty());
        Assert.assertTrue((x.getNodeType() == 19 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == DoStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Body", true, Statement.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                Block result = targetAst.newBlock();
                if (parented) {
                    Block b2 = targetAst.newBlock();
                    b2.statements().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                Block s1 = ast.newBlock();
                s1.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s2 = (Block)x.getParent();
                s2.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getBody();
            }

            @Override
            public void set(ASTNode value) {
                x.setBody((Statement)value);
            }
        });
    }

    @Test
    public void testTryStatement() {
        long previousCount = this.ast.modificationCount();
        final TryStatement x = this.ast.newTryStatement();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getBody().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.getBody().statements().isEmpty());
        Assert.assertTrue((x.getFinally() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.catchClauses().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 54 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == TryStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Body", true, Block.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                Block result = targetAst.newBlock();
                if (parented) {
                    Block b2 = targetAst.newBlock();
                    b2.statements().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                Block s1 = ast.newBlock();
                s1.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s2 = (Block)x.getParent();
                s2.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getBody();
            }

            @Override
            public void set(ASTNode value) {
                x.setBody((Block)value);
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.catchClauses(), new Property(this, "CatchClauses", true, CatchClause.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                CatchClause result = targetAst.newCatchClause();
                if (parented) {
                    TryStatement s1 = targetAst.newTryStatement();
                    s1.catchClauses().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                CatchClause s1 = ast.newCatchClause();
                Block s2 = ast.newBlock();
                s1.setBody(s2);
                s2.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s2 = (Block)x.getParent();
                s2.statements().remove(x);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Finally", false, Block.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                Block result = targetAst.newBlock();
                if (parented) {
                    Block b2 = targetAst.newBlock();
                    b2.statements().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                Block s1 = ast.newBlock();
                s1.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s2 = (Block)x.getParent();
                s2.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getFinally();
            }

            @Override
            public void set(ASTNode value) {
                x.setFinally((Block)value);
            }
        });
    }

    @Test
    public void testCatchClause() {
        long previousCount = this.ast.modificationCount();
        final CatchClause x = this.ast.newCatchClause();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getBody().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.getBody().statements().isEmpty());
        Assert.assertTrue((x.getException().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 12 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == CatchClause.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Exception", true, SingleVariableDeclaration.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SingleVariableDeclaration result = targetAst.newSingleVariableDeclaration();
                if (parented) {
                    targetAst.newCatchClause().setException(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                SingleVariableDeclaration s1 = ast.newSingleVariableDeclaration();
                ClassInstanceCreation s2 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s2.setAnonymousClassDeclaration(a1);
                s1.setInitializer((Expression)s2);
                FunctionDeclaration s3 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s3);
                Block s4 = ast.newBlock();
                s3.setBody(s4);
                TryStatement s5 = ast.newTryStatement();
                s4.statements().add(s5);
                s5.catchClauses().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                TryStatement s5 = (TryStatement)x.getParent();
                s5.catchClauses().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getException();
            }

            @Override
            public void set(ASTNode value) {
                x.setException((SingleVariableDeclaration)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Body", true, Block.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                Block result = targetAst.newBlock();
                if (parented) {
                    Block b2 = targetAst.newBlock();
                    b2.statements().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                Block s1 = ast.newBlock();
                TryStatement s2 = ast.newTryStatement();
                s1.statements().add(s2);
                s2.catchClauses().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                TryStatement s2 = (TryStatement)x.getParent();
                s2.catchClauses().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getBody();
            }

            @Override
            public void set(ASTNode value) {
                x.setBody((Block)value);
            }
        });
    }

    @Test
    public void testEmptyStatement() {
        long previousCount = this.ast.modificationCount();
        EmptyStatement x = this.ast.newEmptyStatement();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 20 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == EmptyStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
    }

    void tLeadingComment(Statement x) {
        long previousCount = this.ast.modificationCount();
        x.setLeadingComment(null);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setLeadingComment("/* X */");
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((x.getLeadingComment() == "/* X */" ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setLeadingComment("/* X\n *Y\n */");
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((x.getLeadingComment() == "/* X\n *Y\n */" ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setLeadingComment("// X\n");
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((x.getLeadingComment() == "// X\n" ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setLeadingComment("// X");
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((x.getLeadingComment() == "// X" ? 1 : 0) != 0);
        try {
            x.setLeadingComment("// X\n extra");
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
    }

    void tJavadocComment(final BodyDeclaration x) {
        this.genericPropertyTest((ASTNode)x, new Property(this, "Javadoc", false, JSdoc.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                JSdoc result = targetAst.newJSdoc();
                if (parented) {
                    targetAst.newInitializer().setJavadoc(result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getJavadoc();
            }

            @Override
            public void set(ASTNode value) {
                x.setJavadoc((JSdoc)value);
            }
        });
    }

    Modifier[] allModifiers() {
        Modifier[] allMods = new Modifier[]{this.ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD), this.ast.newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD), this.ast.newModifier(Modifier.ModifierKeyword.PROTECTED_KEYWORD), this.ast.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD), this.ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD), this.ast.newModifier(Modifier.ModifierKeyword.ABSTRACT_KEYWORD), this.ast.newModifier(Modifier.ModifierKeyword.NATIVE_KEYWORD), this.ast.newModifier(Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD), this.ast.newModifier(Modifier.ModifierKeyword.TRANSIENT_KEYWORD), this.ast.newModifier(Modifier.ModifierKeyword.VOLATILE_KEYWORD), this.ast.newModifier(Modifier.ModifierKeyword.STRICTFP_KEYWORD)};
        return allMods;
    }

    void tAlternateRoot(Comment x) {
        JavaScriptUnit cu = this.ast.newJavaScriptUnit();
        long previousCount = this.ast.modificationCount();
        x.setAlternateRoot((ASTNode)cu);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        Assert.assertTrue((x.getAlternateRoot() == cu ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setAlternateRoot(null);
        Assert.assertTrue((x.getAlternateRoot() == null ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
    }

    void tClientProperties(ASTNode x) {
        long previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.properties().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((x.getProperty("1") == null ? 1 : 0) != 0);
        x.setProperty("1", null);
        Assert.assertTrue((x.getProperty("1") == null ? 1 : 0) != 0);
        Assert.assertTrue((x.properties().size() == 0 ? 1 : 0) != 0);
        x.setProperty("1", (Object)"a1");
        Assert.assertTrue((x.getProperty("1") == "a1" ? 1 : 0) != 0);
        Assert.assertTrue((x.properties().size() == 1 ? 1 : 0) != 0);
        Map.Entry[] m = x.properties().entrySet().toArray(new Map.Entry[1]);
        Assert.assertTrue((m[0].getKey() == "1" ? 1 : 0) != 0);
        Assert.assertTrue((m[0].getValue() == "a1" ? 1 : 0) != 0);
        x.setProperty("1", (Object)"a2");
        Assert.assertTrue((x.getProperty("1") == "a2" ? 1 : 0) != 0);
        Assert.assertTrue((x.properties().size() == 1 ? 1 : 0) != 0);
        m = x.properties().entrySet().toArray(new Map.Entry[1]);
        Assert.assertTrue((m[0].getKey() == "1" ? 1 : 0) != 0);
        Assert.assertTrue((m[0].getValue() == "a2" ? 1 : 0) != 0);
        x.setProperty("1", null);
        Assert.assertTrue((x.getProperty("1") == null ? 1 : 0) != 0);
        Assert.assertTrue((x.properties().size() == 0 ? 1 : 0) != 0);
        x.setProperty("1", (Object)"a1");
        x.setProperty("2", (Object)"b1");
        x.setProperty("3", (Object)"c1");
        Assert.assertTrue((x.getProperty("1") == "a1" ? 1 : 0) != 0);
        Assert.assertTrue((x.getProperty("2") == "b1" ? 1 : 0) != 0);
        Assert.assertTrue((x.getProperty("3") == "c1" ? 1 : 0) != 0);
        Assert.assertTrue((x.properties().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((x.properties().get("1") == "a1" ? 1 : 0) != 0);
        Assert.assertTrue((x.properties().get("2") == "b1" ? 1 : 0) != 0);
        Assert.assertTrue((x.properties().get("3") == "c1" ? 1 : 0) != 0);
        x.setProperty("1", (Object)"a2");
        x.setProperty("2", (Object)"b2");
        x.setProperty("3", (Object)"c2");
        Assert.assertTrue((x.getProperty("1") == "a2" ? 1 : 0) != 0);
        Assert.assertTrue((x.getProperty("2") == "b2" ? 1 : 0) != 0);
        Assert.assertTrue((x.getProperty("3") == "c2" ? 1 : 0) != 0);
        Assert.assertTrue((x.properties().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((x.properties().get("1") == "a2" ? 1 : 0) != 0);
        Assert.assertTrue((x.properties().get("2") == "b2" ? 1 : 0) != 0);
        Assert.assertTrue((x.properties().get("3") == "c2" ? 1 : 0) != 0);
        x.setProperty("2", null);
        Assert.assertTrue((x.getProperty("1") == "a2" ? 1 : 0) != 0);
        Assert.assertTrue((x.getProperty("2") == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getProperty("3") == "c2" ? 1 : 0) != 0);
        Assert.assertTrue((x.properties().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((x.properties().get("1") == "a2" ? 1 : 0) != 0);
        Assert.assertTrue((x.properties().get("2") == null ? 1 : 0) != 0);
        Assert.assertTrue((x.properties().get("3") == "c2" ? 1 : 0) != 0);
        x.setProperty("1", null);
        Assert.assertTrue((x.getProperty("1") == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getProperty("2") == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getProperty("3") == "c2" ? 1 : 0) != 0);
        Assert.assertTrue((x.properties().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((x.properties().get("1") == null ? 1 : 0) != 0);
        Assert.assertTrue((x.properties().get("2") == null ? 1 : 0) != 0);
        Assert.assertTrue((x.properties().get("3") == "c2" ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
    }

    @Test
    public void testReturnStatement() {
        long previousCount = this.ast.modificationCount();
        final ReturnStatement x = this.ast.newReturnStatement();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getExpression() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 41 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == ReturnStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", false, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
    }

    @Test
    public void testThrowStatement() {
        long previousCount = this.ast.modificationCount();
        final ThrowStatement x = this.ast.newThrowStatement();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getExpression().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 53 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == ThrowStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
    }

    @Test
    public void testSwitchStatement() {
        long previousCount = this.ast.modificationCount();
        final SwitchStatement x = this.ast.newSwitchStatement();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getExpression().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.statements().isEmpty());
        Assert.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 50 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == SwitchStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.statements(), new Property(this, "Statements", true, Statement.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                Block result = targetAst.newBlock();
                if (parented) {
                    Block b2 = targetAst.newBlock();
                    b2.statements().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                Block s1 = ast.newBlock();
                s1.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s2 = (Block)x.getParent();
                s2.statements().remove(x);
            }
        });
    }

    @Test
    public void testSwitchCase() {
        long previousCount = this.ast.modificationCount();
        final SwitchCase x = this.ast.newSwitchCase();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getExpression().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        Assert.assertTrue((!x.isDefault() ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 49 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == SwitchCase.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", false, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                SwitchStatement s4 = ast.newSwitchStatement();
                s3.statements().add(s4);
                s4.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                SwitchStatement s4 = (SwitchStatement)x.getParent();
                s4.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
    }

    @Test
    public void testLabeledStatement() {
        long previousCount = this.ast.modificationCount();
        final LabeledStatement x = this.ast.newLabeledStatement();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getLabel().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getBody().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 30 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == LabeledStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Label", true, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getLabel();
            }

            @Override
            public void set(ASTNode value) {
                x.setLabel((SimpleName)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Body", true, Statement.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                Block result = targetAst.newBlock();
                if (parented) {
                    Block b2 = targetAst.newBlock();
                    b2.statements().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                Block s1 = ast.newBlock();
                s1.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s2 = (Block)x.getParent();
                s2.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getBody();
            }

            @Override
            public void set(ASTNode value) {
                x.setBody((Statement)value);
            }
        });
    }

    void assignSourceRanges(ASTNode target) {
        StringBuffer buffer = new StringBuffer();
        ArrayList stack = new ArrayList();
        class PositionAssigner
        extends ASTVisitor {
            private final /* synthetic */ StringBuffer val$buffer;
            private final /* synthetic */ List val$stack;

            PositionAssigner(StringBuffer stringBuffer, List list) {
                this.val$buffer = stringBuffer;
                this.val$stack = list;
                super(true);
            }

            public void preVisit(ASTNode node) {
                int start = this.val$buffer.length();
                this.val$buffer.append("(");
                this.val$stack.add(start);
            }

            public void postVisit(ASTNode node) {
                int start = (Integer)this.val$stack.remove(this.val$stack.size() - 1);
                this.val$buffer.append(")");
                int length = this.val$buffer.length() - start;
                node.setSourceRange(start, length);
            }
        }
        target.accept((ASTVisitor)new PositionAssigner(buffer, stack));
    }

    @Test
    public void testClone() {
        ASTNode x = SampleASTs.oneOfEach(this.ast);
        this.assignSourceRanges(x);
        Assert.assertTrue((boolean)x.subtreeMatch((ASTMatcher)new CheckPositionsMatcher(), (Object)x));
        ASTNode y = ASTNode.copySubtree((AST)this.ast, (ASTNode)x);
        Assert.assertTrue((boolean)x.subtreeMatch((ASTMatcher)new CheckPositionsMatcher(), (Object)y));
        Assert.assertTrue((boolean)y.subtreeMatch((ASTMatcher)new CheckPositionsMatcher(), (Object)x));
        AST newAST = AST.newAST((int)this.ast.apiLevel());
        ASTNode z = ASTNode.copySubtree((AST)newAST, (ASTNode)x);
        Assert.assertTrue((boolean)x.subtreeMatch((ASTMatcher)new CheckPositionsMatcher(), (Object)z));
        Assert.assertTrue((boolean)z.subtreeMatch((ASTMatcher)new CheckPositionsMatcher(), (Object)x));
    }

    @Test
    public void testNullResolve() {
        ASTNode x = SampleASTs.oneOfEach(this.ast);
        ASTVisitor v = new ASTVisitor(true){

            public boolean visit(SimpleName node) {
                Assert.assertTrue((node.resolveBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(QualifiedName node) {
                Assert.assertTrue((node.resolveBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(SimpleType node) {
                Assert.assertTrue((node.resolveBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(ArrayType node) {
                Assert.assertTrue((node.resolveBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(PrimitiveType node) {
                Assert.assertTrue((node.resolveBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(QualifiedType node) {
                Assert.assertTrue((node.resolveBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(Assignment node) {
                Assert.assertTrue((node.resolveTypeBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(ClassInstanceCreation node) {
                Assert.assertTrue((node.resolveConstructorBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(ConstructorInvocation node) {
                Assert.assertTrue((node.resolveConstructorBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(SuperConstructorInvocation node) {
                Assert.assertTrue((node.resolveConstructorBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(PackageDeclaration node) {
                Assert.assertTrue((node.resolveBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(ImportDeclaration node) {
                Assert.assertTrue((node.resolveBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(FunctionDeclaration node) {
                Assert.assertTrue((node.resolveBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(TypeDeclaration node) {
                Assert.assertTrue((node.resolveBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(TypeDeclarationStatement node) {
                Assert.assertTrue((node.resolveBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(SingleVariableDeclaration node) {
                Assert.assertTrue((node.resolveBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(VariableDeclarationFragment node) {
                Assert.assertTrue((node.resolveBinding() == null ? 1 : 0) != 0);
                return true;
            }
        };
        x.accept(v);
    }

    @Test
    public void testForStatement() {
        long previousCount = this.ast.modificationCount();
        final ForStatement x = this.ast.newForStatement();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.initializers().isEmpty());
        Assert.assertTrue((x.getExpression() == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.updaters().isEmpty());
        Assert.assertTrue((x.getBody().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(x.getBody() instanceof Block));
        Assert.assertTrue((boolean)((Block)x.getBody()).statements().isEmpty());
        Assert.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 24 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == ForStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyListTest((ASTNode)x, x.initializers(), new Property(this, "Initializers", true, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", false, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.updaters(), new Property(this, "Updaters", true, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Body", true, Statement.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                Block result = targetAst.newBlock();
                if (parented) {
                    Block b2 = targetAst.newBlock();
                    b2.statements().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                Block s1 = ast.newBlock();
                s1.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s2 = (Block)x.getParent();
                s2.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getBody();
            }

            @Override
            public void set(ASTNode value) {
                x.setBody((Statement)value);
            }
        });
    }

    @Test
    public void testEnhancedForStatement() {
        if (this.ast.apiLevel() == 2) {
            try {
                this.ast.newEnhancedForStatement();
                Assert.assertTrue((boolean)false);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
            return;
        }
        long previousCount = this.ast.modificationCount();
        final EnhancedForStatement x = this.ast.newEnhancedForStatement();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getParameter() != null ? 1 : 0) != 0);
        Assert.assertTrue((x.getParameter().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getExpression() != null ? 1 : 0) != 0);
        Assert.assertTrue((x.getExpression().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getBody().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(x.getBody() instanceof Block));
        Assert.assertTrue((boolean)((Block)x.getBody()).statements().isEmpty());
        Assert.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 70 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == EnhancedForStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Parameter", true, SingleVariableDeclaration.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SingleVariableDeclaration result = targetAst.newSingleVariableDeclaration();
                if (parented) {
                    CatchClause parent = targetAst.newCatchClause();
                    parent.setException(result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getParameter();
            }

            @Override
            public void set(ASTNode value) {
                x.setParameter((SingleVariableDeclaration)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", true, Expression.class){

            @Override
            public ASTNode sample(AST target, boolean parented) {
                SimpleName result = target.newSimpleName("foo");
                if (parented) {
                    target.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
    }

    @Test
    public void testConstructorInvocation() {
        long previousCount = this.ast.modificationCount();
        final ConstructorInvocation x = this.ast.newConstructorInvocation();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() >= 3) {
            Assert.assertTrue((boolean)x.typeArguments().isEmpty());
        }
        Assert.assertTrue((boolean)x.arguments().isEmpty());
        Assert.assertTrue((x.getNodeType() == 17 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == ConstructorInvocation.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        if (this.ast.apiLevel() >= 3) {
            this.genericPropertyListTest((ASTNode)x, x.typeArguments(), new Property(this, "TypeArguments", true, Type.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("X"));
                    if (parented) {
                        targetAst.newArrayType((Type)result);
                    }
                    return result;
                }
            });
        }
        this.genericPropertyListTest((ASTNode)x, x.arguments(), new Property(this, "Arguments", true, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }
        });
    }

    @Test
    public void testSuperConstructorInvocation() {
        long previousCount = this.ast.modificationCount();
        final SuperConstructorInvocation x = this.ast.newSuperConstructorInvocation();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getExpression() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() >= 3) {
            Assert.assertTrue((boolean)x.typeArguments().isEmpty());
        }
        Assert.assertTrue((boolean)x.arguments().isEmpty());
        Assert.assertTrue((x.getNodeType() == 46 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == SuperConstructorInvocation.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", false, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
        if (this.ast.apiLevel() >= 3) {
            this.genericPropertyListTest((ASTNode)x, x.typeArguments(), new Property(this, "TypeArguments", true, Type.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("X"));
                    if (parented) {
                        targetAst.newArrayType((Type)result);
                    }
                    return result;
                }
            });
        }
        this.genericPropertyListTest((ASTNode)x, x.arguments(), new Property(this, "Arguments", true, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }
        });
    }

    @Test
    public void testThisExpression() {
        long previousCount = this.ast.modificationCount();
        final ThisExpression x = this.ast.newThisExpression();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getQualifier() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 52 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == ThisExpression.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Qualifier", false, Name.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                QualifiedName result = targetAst.newQualifiedName((Name)targetAst.newSimpleName("a"), targetAst.newSimpleName("b"));
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getQualifier();
            }

            @Override
            public void set(ASTNode value) {
                x.setQualifier((Name)value);
            }
        });
    }

    @Test
    public void testFieldAccess() {
        long previousCount = this.ast.modificationCount();
        final FieldAccess x = this.ast.newFieldAccess();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getExpression().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 22 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == FieldAccess.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("fie"));
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((SimpleName)value);
            }
        });
    }

    @Test
    public void testSuperFieldAccess() {
        long previousCount = this.ast.modificationCount();
        final SuperFieldAccess x = this.ast.newSuperFieldAccess();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getQualifier() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 47 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == SuperFieldAccess.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Qualifier", false, Name.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                QualifiedName result = targetAst.newQualifiedName((Name)targetAst.newSimpleName("a"), targetAst.newSimpleName("b"));
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getQualifier();
            }

            @Override
            public void set(ASTNode value) {
                x.setQualifier((Name)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((SimpleName)value);
            }
        });
    }

    @Test
    public void testSuperMethodInvocation() {
        long previousCount = this.ast.modificationCount();
        final SuperMethodInvocation x = this.ast.newSuperMethodInvocation();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() >= 3) {
            Assert.assertTrue((boolean)x.typeArguments().isEmpty());
        }
        Assert.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getQualifier() == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.arguments().isEmpty());
        Assert.assertTrue((x.getNodeType() == 48 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == SuperMethodInvocation.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Qualifier", false, Name.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                QualifiedName result = targetAst.newQualifiedName((Name)targetAst.newSimpleName("a"), targetAst.newSimpleName("b"));
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getQualifier();
            }

            @Override
            public void set(ASTNode value) {
                x.setQualifier((Name)value);
            }
        });
        if (this.ast.apiLevel() >= 3) {
            this.genericPropertyListTest((ASTNode)x, x.typeArguments(), new Property(this, "TypeArguments", true, Type.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("X"));
                    if (parented) {
                        targetAst.newArrayType((Type)result);
                    }
                    return result;
                }
            });
        }
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((SimpleName)value);
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.arguments(), new Property(this, "Arguments", true, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("x"));
            }
        });
    }

    @Test
    public void testTypeLiteral() {
        long previousCount = this.ast.modificationCount();
        final TypeLiteral x = this.ast.newTypeLiteral();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getType().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 57 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == TypeLiteral.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Type", true, Type.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("a"));
                if (parented) {
                    targetAst.newArrayType((Type)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getType();
            }

            @Override
            public void set(ASTNode value) {
                x.setType((Type)value);
            }
        });
    }

    @Test
    public void testPrefixExpression() {
        long previousCount = this.ast.modificationCount();
        final PrefixExpression x = this.ast.newPrefixExpression();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getOperand().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getOperator() != null ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 38 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == PrefixExpression.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        Assert.assertTrue((boolean)PrefixExpression.Operator.INCREMENT.toString().equals("++"));
        Assert.assertTrue((boolean)PrefixExpression.Operator.DECREMENT.toString().equals("--"));
        Assert.assertTrue((boolean)PrefixExpression.Operator.PLUS.toString().equals("+"));
        Assert.assertTrue((boolean)PrefixExpression.Operator.MINUS.toString().equals("-"));
        Assert.assertTrue((boolean)PrefixExpression.Operator.COMPLEMENT.toString().equals("~"));
        Assert.assertTrue((boolean)PrefixExpression.Operator.NOT.toString().equals("!"));
        PrefixExpression.Operator[] known = new PrefixExpression.Operator[]{PrefixExpression.Operator.INCREMENT, PrefixExpression.Operator.DECREMENT, PrefixExpression.Operator.PLUS, PrefixExpression.Operator.MINUS, PrefixExpression.Operator.COMPLEMENT, PrefixExpression.Operator.NOT};
        int i = 0;
        while (i < known.length) {
            int j = 0;
            while (j < known.length) {
                Assert.assertTrue((i == j || !known[i].equals(known[j]) ? 1 : 0) != 0);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < known.length) {
            previousCount = this.ast.modificationCount();
            x.setOperator(known[i]);
            Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((boolean)x.getOperator().equals(known[i]));
            ++i;
        }
        try {
            x.setOperator(null);
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
        i = 0;
        while (i < known.length) {
            String name = known[i].toString();
            Assert.assertTrue((boolean)PrefixExpression.Operator.toOperator((String)name).equals(known[i]));
            ++i;
        }
        Assert.assertTrue((PrefixExpression.Operator.toOperator((String)"huh") == null ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Operand", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("fie"));
            }

            @Override
            public ASTNode get() {
                return x.getOperand();
            }

            @Override
            public void set(ASTNode value) {
                x.setOperand((Expression)value);
            }
        });
    }

    @Test
    public void testPostfixExpression() {
        long previousCount = this.ast.modificationCount();
        final PostfixExpression x = this.ast.newPostfixExpression();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getOperand().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getOperator() != null ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 37 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == PostfixExpression.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        Assert.assertTrue((boolean)PostfixExpression.Operator.INCREMENT.toString().equals("++"));
        Assert.assertTrue((boolean)PostfixExpression.Operator.DECREMENT.toString().equals("--"));
        PostfixExpression.Operator[] known = new PostfixExpression.Operator[]{PostfixExpression.Operator.INCREMENT, PostfixExpression.Operator.DECREMENT};
        int i = 0;
        while (i < known.length) {
            int j = 0;
            while (j < known.length) {
                Assert.assertTrue((i == j || !known[i].equals(known[j]) ? 1 : 0) != 0);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < known.length) {
            previousCount = this.ast.modificationCount();
            x.setOperator(known[i]);
            Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((boolean)x.getOperator().equals(known[i]));
            ++i;
        }
        try {
            x.setOperator(null);
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
        i = 0;
        while (i < known.length) {
            String name = known[i].toString();
            Assert.assertTrue((boolean)PostfixExpression.Operator.toOperator((String)name).equals(known[i]));
            ++i;
        }
        Assert.assertTrue((PostfixExpression.Operator.toOperator((String)"huh") == null ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Operand", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("fie"));
            }

            @Override
            public ASTNode get() {
                return x.getOperand();
            }

            @Override
            public void set(ASTNode value) {
                x.setOperand((Expression)value);
            }
        });
    }

    @Test
    public void testInfixExpression() {
        long previousCount = this.ast.modificationCount();
        final InfixExpression x = this.ast.newInfixExpression();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getLeftOperand().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getOperator() != null ? 1 : 0) != 0);
        Assert.assertTrue((x.getRightOperand().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.extendedOperands().isEmpty());
        Assert.assertTrue((x.getNodeType() == 27 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == InfixExpression.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        Assert.assertTrue((boolean)InfixExpression.Operator.TIMES.toString().equals("*"));
        Assert.assertTrue((boolean)InfixExpression.Operator.DIVIDE.toString().equals("/"));
        Assert.assertTrue((boolean)InfixExpression.Operator.REMAINDER.toString().equals("%"));
        Assert.assertTrue((boolean)InfixExpression.Operator.PLUS.toString().equals("+"));
        Assert.assertTrue((boolean)InfixExpression.Operator.MINUS.toString().equals("-"));
        Assert.assertTrue((boolean)InfixExpression.Operator.LEFT_SHIFT.toString().equals("<<"));
        Assert.assertTrue((boolean)InfixExpression.Operator.RIGHT_SHIFT_SIGNED.toString().equals(">>"));
        Assert.assertTrue((boolean)InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED.toString().equals(">>>"));
        Assert.assertTrue((boolean)InfixExpression.Operator.LESS.toString().equals("<"));
        Assert.assertTrue((boolean)InfixExpression.Operator.GREATER.toString().equals(">"));
        Assert.assertTrue((boolean)InfixExpression.Operator.LESS_EQUALS.toString().equals("<="));
        Assert.assertTrue((boolean)InfixExpression.Operator.GREATER_EQUALS.toString().equals(">="));
        Assert.assertTrue((boolean)InfixExpression.Operator.EQUALS.toString().equals("=="));
        Assert.assertTrue((boolean)InfixExpression.Operator.NOT_EQUALS.toString().equals("!="));
        Assert.assertTrue((boolean)InfixExpression.Operator.XOR.toString().equals("^"));
        Assert.assertTrue((boolean)InfixExpression.Operator.OR.toString().equals("|"));
        Assert.assertTrue((boolean)InfixExpression.Operator.AND.toString().equals("&"));
        Assert.assertTrue((boolean)InfixExpression.Operator.CONDITIONAL_OR.toString().equals("||"));
        Assert.assertTrue((boolean)InfixExpression.Operator.CONDITIONAL_AND.toString().equals("&&"));
        InfixExpression.Operator[] known = new InfixExpression.Operator[]{InfixExpression.Operator.TIMES, InfixExpression.Operator.DIVIDE, InfixExpression.Operator.REMAINDER, InfixExpression.Operator.PLUS, InfixExpression.Operator.MINUS, InfixExpression.Operator.LEFT_SHIFT, InfixExpression.Operator.RIGHT_SHIFT_SIGNED, InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED, InfixExpression.Operator.LESS, InfixExpression.Operator.GREATER, InfixExpression.Operator.LESS_EQUALS, InfixExpression.Operator.GREATER_EQUALS, InfixExpression.Operator.EQUALS, InfixExpression.Operator.NOT_EQUALS, InfixExpression.Operator.XOR, InfixExpression.Operator.OR, InfixExpression.Operator.AND, InfixExpression.Operator.CONDITIONAL_OR, InfixExpression.Operator.CONDITIONAL_AND};
        int i = 0;
        while (i < known.length) {
            int j = 0;
            while (j < known.length) {
                Assert.assertTrue((i == j || !known[i].equals(known[j]) ? 1 : 0) != 0);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < known.length) {
            previousCount = this.ast.modificationCount();
            x.setOperator(known[i]);
            Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((boolean)x.getOperator().equals(known[i]));
            ++i;
        }
        try {
            x.setOperator(null);
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
        i = 0;
        while (i < known.length) {
            String name = known[i].toString();
            Assert.assertTrue((boolean)InfixExpression.Operator.toOperator((String)name).equals(known[i]));
            ++i;
        }
        Assert.assertTrue((InfixExpression.Operator.toOperator((String)"huh") == null ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "LeftOperand", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("fie"));
            }

            @Override
            public ASTNode get() {
                return x.getLeftOperand();
            }

            @Override
            public void set(ASTNode value) {
                x.setLeftOperand((Expression)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "RightOperand", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("fie"));
            }

            @Override
            public ASTNode get() {
                return x.getRightOperand();
            }

            @Override
            public void set(ASTNode value) {
                x.setRightOperand((Expression)value);
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.extendedOperands(), new Property(this, "ExtendedOperands", true, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("x"));
            }
        });
    }

    @Test
    public void testInstanceofExpression() {
        long previousCount = this.ast.modificationCount();
        final InstanceofExpression x = this.ast.newInstanceofExpression();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getLeftOperand().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getRightOperand().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 62 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == InstanceofExpression.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "LeftOperand", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("fie"));
            }

            @Override
            public ASTNode get() {
                return x.getLeftOperand();
            }

            @Override
            public void set(ASTNode value) {
                x.setLeftOperand((Expression)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "RightOperand", true, Type.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleType result = localAst.newSimpleType((Name)localAst.newSimpleName("Object"));
                if (parented) {
                    localAst.newArrayType((Type)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("fie"));
            }

            @Override
            public ASTNode get() {
                return x.getRightOperand();
            }

            @Override
            public void set(ASTNode value) {
                x.setRightOperand((Type)value);
            }
        });
    }

    @Test
    public void testConditionalExpression() {
        long previousCount = this.ast.modificationCount();
        final ConditionalExpression x = this.ast.newConditionalExpression();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getExpression().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getThenExpression().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getElseExpression().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 16 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == ConditionalExpression.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("fie"));
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "ThenExpression", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("fie"));
            }

            @Override
            public ASTNode get() {
                return x.getThenExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setThenExpression((Expression)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "ElseExpression", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("fie"));
            }

            @Override
            public ASTNode get() {
                return x.getElseExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setElseExpression((Expression)value);
            }
        });
    }

    @Test
    public void testArrayAccess() {
        long previousCount = this.ast.modificationCount();
        final ArrayAccess x = this.ast.newArrayAccess();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getArray().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getIndex().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == ArrayAccess.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Array", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("fie"));
            }

            @Override
            public ASTNode get() {
                return x.getArray();
            }

            @Override
            public void set(ASTNode value) {
                x.setArray((Expression)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Index", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("fie"));
            }

            @Override
            public ASTNode get() {
                return x.getIndex();
            }

            @Override
            public void set(ASTNode value) {
                x.setIndex((Expression)value);
            }
        });
    }

    @Test
    public void testArrayInitializer() {
        long previousCount = this.ast.modificationCount();
        final ArrayInitializer x = this.ast.newArrayInitializer();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.expressions().isEmpty());
        Assert.assertTrue((x.getNodeType() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == ArrayInitializer.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyListTest((ASTNode)x, x.expressions(), new Property(this, "Expressions", true, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("x"));
            }
        });
    }

    @Test
    public void testClassInstanceCreation() {
        long previousCount = this.ast.modificationCount();
        final ClassInstanceCreation x = this.ast.newClassInstanceCreation();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertSame((Object)this.ast, (Object)x.getAST());
        Assert.assertNull((Object)x.getParent());
        Assert.assertNull((Object)x.getExpression());
        Assert.assertNull((Object)x.getType());
        Assert.assertTrue((boolean)x.typeArguments().isEmpty());
        Assert.assertTrue((boolean)x.arguments().isEmpty());
        Assert.assertNull((Object)x.getAnonymousClassDeclaration());
        Assert.assertEquals((long)14L, (long)x.getNodeType());
        Assert.assertSame((Object)x.structuralPropertiesForType(), (Object)ClassInstanceCreation.propertyDescriptors((int)this.ast.apiLevel()));
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", false, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("x"));
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
        if (this.ast.apiLevel() >= 3) {
            this.genericPropertyListTest((ASTNode)x, x.typeArguments(), new Property(this, "TypeArguments", true, Type.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("X"));
                    if (parented) {
                        targetAst.newArrayType((Type)result);
                    }
                    return result;
                }
            });
        }
        if (this.ast.apiLevel() == 2) {
            this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, Name.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    SimpleName result = targetAst.newSimpleName("a");
                    if (parented) {
                        targetAst.newExpressionStatement((Expression)result);
                    }
                    return result;
                }

                @Override
                public ASTNode get() {
                    return x.getName();
                }

                @Override
                public void set(ASTNode value) {
                    x.setName((Name)value);
                }
            });
        }
        if (this.ast.apiLevel() >= 3) {
            this.genericPropertyTest((ASTNode)x, new Property(this, "Type", true, Type.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("foo"));
                    if (parented) {
                        targetAst.newArrayType((Type)result);
                    }
                    return result;
                }

                @Override
                public ASTNode get() {
                    return x.getType();
                }

                @Override
                public void set(ASTNode value) {
                    x.setType((Type)value);
                }
            });
        }
        this.genericPropertyListTest((ASTNode)x, x.arguments(), new Property(this, "Arguments", true, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("x"));
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "AnonymousClassDeclaration", false, AnonymousClassDeclaration.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                AnonymousClassDeclaration result = targetAst.newAnonymousClassDeclaration();
                if (parented) {
                    targetAst.newClassInstanceCreation().setAnonymousClassDeclaration(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                AnonymousClassDeclaration s0 = x.getAST().newAnonymousClassDeclaration();
                VariableDeclarationFragment s1 = x.getAST().newVariableDeclarationFragment();
                FieldDeclaration s2 = x.getAST().newFieldDeclaration(s1);
                s0.bodyDeclarations().add(s2);
                s1.setInitializer((Expression)x);
                return s0;
            }

            @Override
            public void unwrap() {
                VariableDeclarationFragment s1 = (VariableDeclarationFragment)x.getParent();
                s1.setInitializer(null);
            }

            @Override
            public ASTNode get() {
                return x.getAnonymousClassDeclaration();
            }

            @Override
            public void set(ASTNode value) {
                x.setAnonymousClassDeclaration((AnonymousClassDeclaration)value);
            }
        });
    }

    @Test
    public void testAnonymousClassDeclaration() {
        long previousCount = this.ast.modificationCount();
        final AnonymousClassDeclaration x = this.ast.newAnonymousClassDeclaration();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.bodyDeclarations().isEmpty());
        Assert.assertTrue((x.getNodeType() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == AnonymousClassDeclaration.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyListTest((ASTNode)x, x.bodyDeclarations(), new Property(this, "BodyDeclarations", true, BodyDeclaration.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                TypeDeclaration result = targetAst.newTypeDeclaration();
                if (parented) {
                    JavaScriptUnit compilationUnit = targetAst.newJavaScriptUnit();
                    compilationUnit.types().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                VariableDeclarationFragment s0 = x.getAST().newVariableDeclarationFragment();
                FieldDeclaration s1 = x.getAST().newFieldDeclaration(s0);
                ClassInstanceCreation s2 = x.getAST().newClassInstanceCreation();
                s0.setInitializer((Expression)s2);
                s2.setAnonymousClassDeclaration(x);
                return s1;
            }

            @Override
            public void unwrap() {
                ClassInstanceCreation s2 = (ClassInstanceCreation)x.getParent();
                s2.setAnonymousClassDeclaration(null);
            }
        });
        TypeDeclaration t1 = this.ast.newTypeDeclaration();
        x.bodyDeclarations().add(t1);
        Assert.assertTrue((!t1.isLocalTypeDeclaration() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)t1.isMemberTypeDeclaration());
        Assert.assertTrue((!t1.isPackageMemberTypeDeclaration() ? 1 : 0) != 0);
    }

    @Test
    public void testArrayCreation() {
        long previousCount = this.ast.modificationCount();
        final ArrayCreation x = this.ast.newArrayCreation();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getType().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((boolean)x.dimensions().isEmpty());
        Assert.assertTrue((x.getInitializer() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == ArrayCreation.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Type", true, ArrayType.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                ArrayType result = targetAst.newArrayType((Type)targetAst.newSimpleType((Name)targetAst.newSimpleName("a")));
                if (parented) {
                    targetAst.newArrayType((Type)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getType();
            }

            @Override
            public void set(ASTNode value) {
                x.setType((ArrayType)value);
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.dimensions(), new Property(this, "Dimensions", true, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("x"));
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Initializer", false, ArrayInitializer.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                ArrayInitializer result = targetAst.newArrayInitializer();
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ArrayInitializer s1 = ast.newArrayInitializer();
                s1.expressions().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                ArrayInitializer s1 = (ArrayInitializer)x.getParent();
                s1.expressions().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getInitializer();
            }

            @Override
            public void set(ASTNode value) {
                x.setInitializer((ArrayInitializer)value);
            }
        });
    }

    @Test
    public void testParenthesizedExpression() {
        long previousCount = this.ast.modificationCount();
        final ParenthesizedExpression x = this.ast.newParenthesizedExpression();
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getExpression().getParent() == x ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 36 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == ParenthesizedExpression.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("fie"));
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
    }

    @Test
    public void testModifiers() {
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        int[] mods = new int[]{1024, 16, 256, 2, 4, 1, 8, 2048, 32, 128, 64};
        int i = 0;
        while (i < mods.length) {
            int m = mods[i];
            Assert.assertTrue((Modifier.isAbstract((int)m) == (m == 1024) ? 1 : 0) != 0);
            Assert.assertTrue((Modifier.isFinal((int)m) == (m == 16) ? 1 : 0) != 0);
            Assert.assertTrue((Modifier.isNative((int)m) == (m == 256) ? 1 : 0) != 0);
            Assert.assertTrue((Modifier.isPrivate((int)m) == (m == 2) ? 1 : 0) != 0);
            Assert.assertTrue((Modifier.isProtected((int)m) == (m == 4) ? 1 : 0) != 0);
            Assert.assertTrue((Modifier.isPublic((int)m) == (m == 1) ? 1 : 0) != 0);
            Assert.assertTrue((Modifier.isStatic((int)m) == (m == 8) ? 1 : 0) != 0);
            Assert.assertTrue((Modifier.isStrictfp((int)m) == (m == 2048) ? 1 : 0) != 0);
            Assert.assertTrue((Modifier.isSynchronized((int)m) == (m == 32) ? 1 : 0) != 0);
            Assert.assertTrue((Modifier.isTransient((int)m) == (m == 128) ? 1 : 0) != 0);
            Assert.assertTrue((Modifier.isVolatile((int)m) == (m == 64) ? 1 : 0) != 0);
            ++i;
        }
        if (this.ast.apiLevel() == 2) {
            try {
                this.ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD);
                Assert.assertTrue((boolean)false);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
            try {
                this.ast.newModifiers(0);
                Assert.assertTrue((boolean)false);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
            return;
        }
        long previousCount = this.ast.modificationCount();
        Modifier x = this.ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        Assert.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        Assert.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((x.getKeyword() == Modifier.ModifierKeyword.PUBLIC_KEYWORD ? 1 : 0) != 0);
        Assert.assertTrue((x.getNodeType() == 100 ? 1 : 0) != 0);
        Assert.assertTrue((x.structuralPropertiesForType() == Modifier.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        Assert.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Modifier.ModifierKeyword.PUBLIC_KEYWORD.toString().equals("public"));
        Assert.assertTrue((boolean)Modifier.ModifierKeyword.PROTECTED_KEYWORD.toString().equals("protected"));
        Assert.assertTrue((boolean)Modifier.ModifierKeyword.PRIVATE_KEYWORD.toString().equals("private"));
        Assert.assertTrue((boolean)Modifier.ModifierKeyword.STATIC_KEYWORD.toString().equals("static"));
        Assert.assertTrue((boolean)Modifier.ModifierKeyword.ABSTRACT_KEYWORD.toString().equals("abstract"));
        Assert.assertTrue((boolean)Modifier.ModifierKeyword.FINAL_KEYWORD.toString().equals("final"));
        Assert.assertTrue((boolean)Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD.toString().equals("synchronized"));
        Assert.assertTrue((boolean)Modifier.ModifierKeyword.NATIVE_KEYWORD.toString().equals("native"));
        Assert.assertTrue((boolean)Modifier.ModifierKeyword.TRANSIENT_KEYWORD.toString().equals("transient"));
        Assert.assertTrue((boolean)Modifier.ModifierKeyword.VOLATILE_KEYWORD.toString().equals("volatile"));
        Assert.assertTrue((boolean)Modifier.ModifierKeyword.STRICTFP_KEYWORD.toString().equals("strictfp"));
        Modifier.ModifierKeyword[] known = new Modifier.ModifierKeyword[]{Modifier.ModifierKeyword.PUBLIC_KEYWORD, Modifier.ModifierKeyword.PROTECTED_KEYWORD, Modifier.ModifierKeyword.PRIVATE_KEYWORD, Modifier.ModifierKeyword.STATIC_KEYWORD, Modifier.ModifierKeyword.ABSTRACT_KEYWORD, Modifier.ModifierKeyword.FINAL_KEYWORD, Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD, Modifier.ModifierKeyword.NATIVE_KEYWORD, Modifier.ModifierKeyword.TRANSIENT_KEYWORD, Modifier.ModifierKeyword.VOLATILE_KEYWORD, Modifier.ModifierKeyword.STRICTFP_KEYWORD};
        int i2 = 0;
        while (i2 < known.length) {
            int j = 0;
            while (j < known.length) {
                Assert.assertTrue((i2 == j || !known[i2].equals(known[j]) ? 1 : 0) != 0);
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < known.length) {
            previousCount = this.ast.modificationCount();
            x.setKeyword(known[i2]);
            Assert.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            Assert.assertTrue((boolean)x.getKeyword().equals(known[i2]));
            ++i2;
        }
        try {
            x.setKeyword(null);
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
        i2 = 0;
        while (i2 < known.length) {
            String name = known[i2].toString();
            Assert.assertTrue((boolean)Modifier.ModifierKeyword.toKeyword((String)name).equals(known[i2]));
            ++i2;
        }
        Assert.assertTrue((Modifier.ModifierKeyword.toKeyword((String)"huh") == null ? 1 : 0) != 0);
        i2 = 0;
        while (i2 < mods.length) {
            int m = mods[i2];
            List result = this.ast.newModifiers(m);
            Assert.assertEquals((long)1L, (long)result.size());
            Modifier modNode = (Modifier)result.get(0);
            Assert.assertEquals((long)m, (long)modNode.getKeyword().toFlagValue());
            ++i2;
        }
        Modifier.ModifierKeyword[] expectedOrder = new Modifier.ModifierKeyword[]{Modifier.ModifierKeyword.PUBLIC_KEYWORD, Modifier.ModifierKeyword.PROTECTED_KEYWORD, Modifier.ModifierKeyword.PRIVATE_KEYWORD, Modifier.ModifierKeyword.ABSTRACT_KEYWORD, Modifier.ModifierKeyword.STATIC_KEYWORD, Modifier.ModifierKeyword.FINAL_KEYWORD, Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD, Modifier.ModifierKeyword.NATIVE_KEYWORD, Modifier.ModifierKeyword.STRICTFP_KEYWORD, Modifier.ModifierKeyword.TRANSIENT_KEYWORD, Modifier.ModifierKeyword.VOLATILE_KEYWORD};
        int all = 0;
        int i3 = 0;
        while (i3 < mods.length) {
            all |= mods[i3];
            ++i3;
        }
        List result = this.ast.newModifiers(all);
        Assert.assertEquals((long)expectedOrder.length, (long)result.size());
        int i4 = 0;
        while (i4 < expectedOrder.length) {
            Modifier modifier = (Modifier)result.get(i4);
            Assert.assertEquals((Object)expectedOrder[i4], (Object)modifier.getKeyword());
            if (modifier.isAbstract()) {
                Assert.assertEquals((Object)Modifier.ModifierKeyword.ABSTRACT_KEYWORD, (Object)modifier.getKeyword());
            } else if (modifier.isFinal()) {
                Assert.assertEquals((Object)Modifier.ModifierKeyword.FINAL_KEYWORD, (Object)modifier.getKeyword());
            } else if (modifier.isNative()) {
                Assert.assertEquals((Object)Modifier.ModifierKeyword.NATIVE_KEYWORD, (Object)modifier.getKeyword());
            } else if (modifier.isPrivate()) {
                Assert.assertEquals((Object)Modifier.ModifierKeyword.PRIVATE_KEYWORD, (Object)modifier.getKeyword());
            } else if (modifier.isProtected()) {
                Assert.assertEquals((Object)Modifier.ModifierKeyword.PROTECTED_KEYWORD, (Object)modifier.getKeyword());
            } else if (modifier.isPublic()) {
                Assert.assertEquals((Object)Modifier.ModifierKeyword.PUBLIC_KEYWORD, (Object)modifier.getKeyword());
            } else if (modifier.isStatic()) {
                Assert.assertEquals((Object)Modifier.ModifierKeyword.STATIC_KEYWORD, (Object)modifier.getKeyword());
            } else if (modifier.isStrictfp()) {
                Assert.assertEquals((Object)Modifier.ModifierKeyword.STRICTFP_KEYWORD, (Object)modifier.getKeyword());
            } else if (modifier.isSynchronized()) {
                Assert.assertEquals((Object)Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD, (Object)modifier.getKeyword());
            } else if (modifier.isTransient()) {
                Assert.assertEquals((Object)Modifier.ModifierKeyword.TRANSIENT_KEYWORD, (Object)modifier.getKeyword());
            } else {
                Assert.assertEquals((Object)Modifier.ModifierKeyword.VOLATILE_KEYWORD, (Object)modifier.getKeyword());
            }
            ++i4;
        }
    }

    @Test
    public void testSubtreeBytes() {
        ASTNode x = SampleASTs.oneOfEach(this.ast);
        int subtreeBytes = x.subtreeBytes();
        Assert.assertTrue((subtreeBytes > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNodeTypeConstants() {
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        int[] all = new int[]{1, 2, 3, 4, 5, 7, 8, 64, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 70, 21, 22, 23, 24, 25, 26, 27, 62, 28, 29, 30, 63, 67, 31, 32, 68, 69, 100, 33, 34, 35, 36, 37, 38, 39, 40, 75, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 65, 66, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61};
        int MIN = 1;
        int MAX = 100;
        HashSet<Integer> s = new HashSet<Integer>();
        int i = 0;
        while (i < all.length) {
            Assert.assertTrue((MIN <= all[i] && all[i] <= MAX ? 1 : 0) != 0);
            s.add(all[i]);
            ++i;
        }
        Assert.assertTrue((s.size() == all.length ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Integer.valueOf(1).equals(1));
    }

    class CheckPositionsMatcher
    extends ASTMatcher {
        public CheckPositionsMatcher() {
            super(true);
        }

        private void checkPositions(Object source, Object destination) {
            int length;
            Assert.assertTrue((boolean)(source instanceof ASTNode));
            Assert.assertTrue((boolean)(destination instanceof ASTNode));
            int startPosition = ((ASTNode)source).getStartPosition();
            if (startPosition != -1) {
                Assert.assertTrue((startPosition == ((ASTNode)destination).getStartPosition() ? 1 : 0) != 0);
            }
            if ((length = ((ASTNode)source).getLength()) != 0) {
                Assert.assertTrue((length == ((ASTNode)destination).getLength() ? 1 : 0) != 0);
            }
        }

        public boolean match(AnonymousClassDeclaration node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ArrayAccess node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ArrayCreation node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ArrayInitializer node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ArrayType node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(Assignment node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(Block node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(BlockComment node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(BooleanLiteral node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(BreakStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(CatchClause node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(CharacterLiteral node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ClassInstanceCreation node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(JavaScriptUnit node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ConditionalExpression node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ConstructorInvocation node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ContinueStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(DoStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(EmptyStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(EnhancedForStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ExpressionStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(FieldAccess node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(FieldDeclaration node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ForStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(IfStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ImportDeclaration node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(InfixExpression node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(Initializer node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(InstanceofExpression node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(JSdoc node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(LabeledStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(LineComment node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(MemberRef node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(FunctionDeclaration node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(FunctionInvocation node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(FunctionRef node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(FunctionRefParameter node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(Modifier node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(NullLiteral node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(NumberLiteral node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(PackageDeclaration node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ParenthesizedExpression node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(PostfixExpression node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(PrefixExpression node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(PrimitiveType node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(QualifiedName node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(QualifiedType node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ReturnStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(SimpleName node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(SimpleType node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(SingleVariableDeclaration node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(StringLiteral node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(SuperConstructorInvocation node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(SuperFieldAccess node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(SuperMethodInvocation node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(SwitchCase node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(SwitchStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(TagElement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(TextElement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ThisExpression node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ThrowStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(TryStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(TypeDeclaration node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(TypeDeclarationStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(TypeLiteral node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(VariableDeclarationExpression node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(VariableDeclarationFragment node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(VariableDeclarationStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(WhileStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }
    }

    abstract class Property {
        private boolean compulsory;
        private Class nodeType;
        private String propertyName;

        Property(String propertyName, boolean compulsory, Class nodeType) {
            this.propertyName = propertyName;
            this.compulsory = compulsory;
            this.nodeType = nodeType;
        }

        public abstract ASTNode sample(AST var1, boolean var2);

        public ASTNode[] counterExamples(AST targetAST) {
            return new ASTNode[0];
        }

        public ASTNode wrap() {
            return null;
        }

        public void unwrap() {
        }

        public final boolean isCompulsory() {
            return this.compulsory;
        }

        public ASTNode get() {
            throw new RuntimeException("get not implemented");
        }

        public void set(ASTNode value) {
            throw new RuntimeException("get(" + value + ") not implemented");
        }

        public String toString() {
            return "Property(" + this.propertyName + ", " + this.compulsory + ", " + this.nodeType + ")";
        }
    }
}

