/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.tests.contentassist;

import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xsl.ui.tests.AbstractSourceViewerTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TestHrefCompletionProposal
extends AbstractSourceViewerTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Ignore
    @Test
    public void testHrefProposalsAtStart() throws Exception {
        this.fileName = String.valueOf(this.projectName) + File.separator + "hrefs" + File.separator + "mainFile.xsl";
        this.loadFileForTesting(this.fileName);
        IStructuredDocument document = (IStructuredDocument)this.sourceViewer.getDocument();
        int column = 25;
        int line = 16;
        int offset = document.getLineOffset(line) + column;
        ICompletionProposal[] proposals = this.getProposals(offset);
        Assert.assertTrue((String)"Incorrect number of proposals", (proposals.length > 3 ? 1 : 0) != 0);
        this.doCommonTests(proposals);
    }

    private void doCommonTests(ICompletionProposal[] proposals) {
        int currDepth = 1;
        ICompletionProposal[] iCompletionProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal completionProposal = iCompletionProposalArray[n2];
            System.out.println(completionProposal.getDisplayString());
            Path p = new Path(completionProposal.getDisplayString());
            Assert.assertNotSame((String)"Stylesheet must not include itself", (Object)new Path("mainFile.xsl"), (Object)p);
            Assert.assertTrue((String)"Proposals wrongly ordered - number of segments should increase down the list", (p.segmentCount() >= currDepth ? 1 : 0) != 0);
            currDepth = p.segmentCount();
            ++n2;
        }
    }
}

