/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests.reconciler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.AbstractReconciler;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.tests.TestTextViewer;
import org.eclipse.text.tests.Accessor;

public class AbstractReconcilerTest
extends TestCase {
    private Accessor fAccessor;
    private Barrier fBarrier;
    private List fCallLog;
    private ITextViewer fViewer;
    protected AbstractReconciler fReconciler;
    private Document fDocument;
    static /* synthetic */ Class class$0;

    protected void setUp() {
        this.fBarrier = new Barrier();
        this.fCallLog = Collections.synchronizedList(new ArrayList());
        this.fReconciler = new AbstractReconciler(){

            protected void initialProcess() {
                AbstractReconcilerTest.this.fCallLog.add("initialProcess");
                AbstractReconcilerTest.this.fBarrier.await();
            }

            protected void process(DirtyRegion dirtyRegion) {
                AbstractReconcilerTest.this.fCallLog.add("process");
                AbstractReconcilerTest.this.fBarrier.await();
            }

            protected void reconcilerDocumentChanged(IDocument newDocument) {
                AbstractReconcilerTest.this.fCallLog.add("reconcilerDocumentChanged");
            }

            protected void aboutToBeReconciled() {
                AbstractReconcilerTest.this.fCallLog.add("aboutToBeReconciled");
            }

            protected void reconcilerReset() {
                AbstractReconcilerTest.this.fCallLog.add("reconcilerReset");
            }

            public IReconcilingStrategy getReconcilingStrategy(String contentType) {
                return null;
            }
        };
        this.fReconciler.setIsIncrementalReconciler(false);
        this.fReconciler.setDelay(50);
        this.fViewer = new TestTextViewer();
        this.fReconciler.install(this.fViewer);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.reconciler.AbstractReconciler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fAccessor = new Accessor(this.fReconciler, clazz);
        Object object = this.fAccessor.get("fThread");
        this.fAccessor = new Accessor(object, object.getClass());
    }

    protected void tearDown() throws Exception {
        this.fBarrier.shutdown();
        this.fReconciler.uninstall();
    }

    public void testInitialReconcile() throws InterruptedException {
        AbstractReconcilerTest.assertFalse((boolean)this.isActive());
        AbstractReconcilerTest.assertFalse((boolean)this.isDirty());
        this.fDocument = new Document("foo");
        this.fViewer.setDocument((IDocument)this.fDocument);
        AbstractReconcilerTest.assertEquals((Object)"reconcilerDocumentChanged", this.fCallLog.remove(0));
        AbstractReconcilerTest.assertEquals((Object)"aboutToBeReconciled", this.fCallLog.remove(0));
        this.fBarrier.await();
        AbstractReconcilerTest.assertEquals((Object)"initialProcess", this.fCallLog.remove(0));
        AbstractReconcilerTest.assertFalse((boolean)this.isActive());
        AbstractReconcilerTest.assertFalse((boolean)this.isDirty());
        this.fBarrier.wakeAll();
        this.pollUntilClean();
        AbstractReconcilerTest.assertFalse((boolean)this.isActive());
        AbstractReconcilerTest.assertFalse((boolean)this.isDirty());
    }

    public void testDirtyingWhenClean() throws BadLocationException, InterruptedException {
        this.installDocument();
        this.dirty();
        AbstractReconcilerTest.assertEquals((Object)"aboutToBeReconciled", this.fCallLog.remove(0));
        AbstractReconcilerTest.assertEquals((Object)"reconcilerReset", this.fCallLog.remove(0));
        this.fBarrier.await();
        AbstractReconcilerTest.assertEquals((Object)"process", this.fCallLog.remove(0));
        AbstractReconcilerTest.assertTrue((boolean)this.isActive());
        AbstractReconcilerTest.assertTrue((boolean)this.isDirty());
        this.fBarrier.wakeAll();
        this.pollUntilClean();
        AbstractReconcilerTest.assertFalse((boolean)this.isActive());
        AbstractReconcilerTest.assertFalse((boolean)this.isDirty());
    }

    private void dirty() throws BadLocationException {
        this.fDocument.replace(0, 0, "bar");
    }

    public void testDirtyingWhenRunning() throws InterruptedException, BadLocationException {
        this.installDocument();
        this.dirty();
        this.fBarrier.await();
        AbstractReconcilerTest.assertTrue((boolean)this.isActive());
        AbstractReconcilerTest.assertTrue((boolean)this.isDirty());
        this.fCallLog.clear();
        this.dirty();
        AbstractReconcilerTest.assertEquals((Object)"reconcilerReset", this.fCallLog.remove(0));
        this.fBarrier.wakeAll();
        this.fBarrier.await();
        AbstractReconcilerTest.assertEquals((Object)"process", this.fCallLog.remove(0));
        this.fBarrier.wakeAll();
        this.pollUntilClean();
        AbstractReconcilerTest.assertFalse((boolean)this.isActive());
        AbstractReconcilerTest.assertFalse((boolean)this.isDirty());
    }

    public void testCancellingWhenClean() throws InterruptedException, BadLocationException {
        this.installDocument();
        this.dirty();
        this.fBarrier.await();
        this.fBarrier.wakeAll();
        this.fCallLog.clear();
        this.fReconciler.uninstall();
        this.pollUntilInactive();
        AbstractReconcilerTest.assertTrue((boolean)this.fCallLog.isEmpty());
        AbstractReconcilerTest.assertFalse((boolean)this.isActive());
    }

    public void testCancellingWhenRunning() throws InterruptedException, BadLocationException {
        this.installDocument();
        this.dirty();
        this.fBarrier.await();
        this.fCallLog.clear();
        this.fReconciler.uninstall();
        this.fBarrier.wakeAll();
        this.pollUntilInactive();
        AbstractReconcilerTest.assertTrue((boolean)this.fCallLog.isEmpty());
        AbstractReconcilerTest.assertFalse((boolean)this.isActive());
    }

    public void testReplacingDocumentWhenClean() throws InterruptedException {
        this.installDocument();
        this.fCallLog.clear();
        this.fViewer.setDocument((IDocument)new Document("bar"));
        AbstractReconcilerTest.assertEquals((Object)"reconcilerDocumentChanged", this.fCallLog.remove(0));
        AbstractReconcilerTest.assertEquals((Object)"aboutToBeReconciled", this.fCallLog.remove(0));
        AbstractReconcilerTest.assertEquals((Object)"reconcilerReset", this.fCallLog.remove(0));
        this.fBarrier.await();
        AbstractReconcilerTest.assertEquals((Object)"process", this.fCallLog.remove(0));
        this.fBarrier.wakeAll();
        this.pollUntilClean();
        AbstractReconcilerTest.assertFalse((boolean)this.isActive());
        AbstractReconcilerTest.assertFalse((boolean)this.isDirty());
    }

    public void testReplacingDocumentWhenRunning() throws InterruptedException, BadLocationException {
        this.installDocument();
        this.dirty();
        this.fBarrier.await();
        this.fCallLog.clear();
        this.fViewer.setDocument((IDocument)new Document("bar"));
        AbstractReconcilerTest.assertEquals((Object)"reconcilerDocumentChanged", this.fCallLog.remove(0));
        AbstractReconcilerTest.assertEquals((Object)"reconcilerReset", this.fCallLog.remove(0));
        AbstractReconcilerTest.assertTrue((boolean)this.fCallLog.isEmpty());
        this.fBarrier.wakeAll();
    }

    void installDocument() throws InterruptedException {
        this.fDocument = new Document("foo");
        this.fViewer.setDocument((IDocument)this.fDocument);
        this.fBarrier.await();
        this.fBarrier.wakeAll();
        this.pollUntilClean();
        this.fCallLog.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pollUntilClean() throws InterruptedException {
        long start = System.currentTimeMillis();
        while (this.isDirty()) {
            long current = System.currentTimeMillis();
            if (current > start + 5000L) {
                AbstractReconcilerTest.fail((String)"waited > 5s for reconciler to complete");
            }
            AbstractReconcilerTest abstractReconcilerTest = this;
            synchronized (abstractReconcilerTest) {
                ((Object)((Object)this)).wait(50L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pollUntilInactive() throws InterruptedException {
        long start = System.currentTimeMillis();
        while (this.isActive()) {
            long current = System.currentTimeMillis();
            if (current > start + 5000L) {
                AbstractReconcilerTest.fail((String)"waited > 5s for reconciler to complete");
            }
            AbstractReconcilerTest abstractReconcilerTest = this;
            synchronized (abstractReconcilerTest) {
                ((Object)((Object)this)).wait(50L);
            }
        }
    }

    boolean isActive() {
        Object bool = this.fAccessor.invoke("isActive", null);
        return (Boolean)bool;
    }

    boolean isDirty() {
        Object bool = this.fAccessor.invoke("isDirty", null);
        return (Boolean)bool;
    }

    static class Barrier {
        private final Object fMutex = new Object();
        private final int fParticipants;
        private final Thread fMainThread = Thread.currentThread();
        private int fWaiting = 0;
        private boolean fMainThreadArrived = false;
        private boolean fIsInactive = false;

        Barrier() {
            this.fParticipants = 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void await() {
            Object object = this.fMutex;
            synchronized (object) {
                boolean isMainThread;
                if (this.fIsInactive) {
                    return;
                }
                ++this.fWaiting;
                boolean bl = isMainThread = Thread.currentThread() == this.fMainThread;
                if (isMainThread) {
                    this.fMainThreadArrived = true;
                }
                if (this.allArrived()) {
                    if (!this.fMainThreadArrived) {
                        --this.fWaiting;
                        throw new RuntimeException(this.getClass() + " can't join barrier if only the main thread is missing!");
                    }
                    if (!isMainThread) {
                        this.notifyMainThread();
                    }
                }
                if (!this.allArrived() || !isMainThread) {
                    try {
                        if (!isMainThread) {
                            this.fMutex.wait();
                        } else {
                            this.fMutex.wait(5000L);
                            if (!this.allArrived()) {
                                AbstractReconcilerTest.fail((String)"reconciler never ran in 5 seconds");
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        throw new Error();
                    }
                }
            }
        }

        private boolean allArrived() {
            return this.fWaiting == this.fParticipants;
        }

        private void notifyMainThread() {
            this.fMutex.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void wakeAll() {
            Object object = this.fMutex;
            synchronized (object) {
                this.fWaiting = 0;
                this.fMainThreadArrived = false;
                this.fMutex.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Object object = this.fMutex;
            synchronized (object) {
                this.fIsInactive = true;
                this.fMutex.notifyAll();
            }
        }
    }
}

