/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.deque;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.deque.Deque;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.comparator.ComparatorTools;
import org.eclipse.jpt.common.utility.internal.deque.ArrayDeque;
import org.eclipse.jpt.common.utility.internal.deque.DequeTools;
import org.eclipse.jpt.common.utility.internal.deque.FixedCapacityArrayDeque;
import org.eclipse.jpt.common.utility.internal.deque.LinkedDeque;
import org.eclipse.jpt.common.utility.internal.deque.PriorityDeque;
import org.eclipse.jpt.common.utility.internal.deque.SynchronizedDeque;
import org.eclipse.jpt.common.utility.internal.queue.ArrayQueue;
import org.eclipse.jpt.common.utility.internal.queue.QueueTools;
import org.eclipse.jpt.common.utility.internal.stack.ArrayStack;
import org.eclipse.jpt.common.utility.internal.stack.StackTools;
import org.eclipse.jpt.common.utility.queue.Queue;
import org.eclipse.jpt.common.utility.stack.Stack;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class DequeToolsTests
extends TestCase {
    public static final Transformer<String, String> FIRST_LETTER_TRANSFORMER = new FirstLetterTransformer();
    public static final Transformer<String, String> EMPHASIZER = new StringTools.CharDelimiter('*');

    public DequeToolsTests(String name) {
        super(name);
    }

    public void testEnqueueTailAllIterable() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayDeque deque = DequeTools.arrayDeque();
        DequeToolsTests.assertTrue((boolean)DequeTools.enqueueTailAll((Deque)deque, iterable));
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueHead()));
    }

    public void testEnqueueTailAllIterable_empty() {
        ArrayList iterable = new ArrayList();
        ArrayDeque deque = DequeTools.arrayDeque();
        DequeToolsTests.assertFalse((boolean)DequeTools.enqueueTailAll((Deque)deque, iterable));
        DequeToolsTests.assertTrue((boolean)deque.isEmpty());
    }

    public void testEnqueueHeadAllIterable() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayDeque deque = DequeTools.arrayDeque();
        DequeToolsTests.assertTrue((boolean)DequeTools.enqueueHeadAll((Deque)deque, iterable));
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueTail()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueTail()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueTail()));
    }

    public void testEnqueueHeadAllIterable_empty() {
        ArrayList iterable = new ArrayList();
        ArrayDeque deque = DequeTools.arrayDeque();
        DequeToolsTests.assertFalse((boolean)DequeTools.enqueueHeadAll((Deque)deque, iterable));
        DequeToolsTests.assertTrue((boolean)deque.isEmpty());
    }

    public void testEnqueueTailAllIterator() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayDeque deque = DequeTools.arrayDeque();
        DequeToolsTests.assertTrue((boolean)DequeTools.enqueueTailAll((Deque)deque, iterable.iterator()));
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueHead()));
    }

    public void testEnqueueHeadAllIterator() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayDeque deque = DequeTools.arrayDeque();
        DequeToolsTests.assertTrue((boolean)DequeTools.enqueueHeadAll((Deque)deque, iterable.iterator()));
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueTail()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueTail()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueTail()));
    }

    public void testEnqueueTailAllArray() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayDeque deque = DequeTools.arrayDeque();
        DequeToolsTests.assertTrue((boolean)DequeTools.enqueueTailAll((Deque)deque, (Object[])iterable.toArray(StringTools.EMPTY_STRING_ARRAY)));
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueHead()));
    }

    public void testEnqueueTailAllArray_empty() {
        ArrayList iterable = new ArrayList();
        ArrayDeque deque = DequeTools.arrayDeque();
        DequeToolsTests.assertFalse((boolean)DequeTools.enqueueTailAll((Deque)deque, (Object[])iterable.toArray(StringTools.EMPTY_STRING_ARRAY)));
        DequeToolsTests.assertTrue((boolean)deque.isEmpty());
    }

    public void testEnqueueHeadAllArray() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayDeque deque = DequeTools.arrayDeque();
        DequeToolsTests.assertTrue((boolean)DequeTools.enqueueHeadAll((Deque)deque, (Object[])iterable.toArray(StringTools.EMPTY_STRING_ARRAY)));
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueTail()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueTail()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueTail()));
    }

    public void testEnqueueHeadAllArray_empty() {
        ArrayList iterable = new ArrayList();
        ArrayDeque deque = DequeTools.arrayDeque();
        DequeToolsTests.assertFalse((boolean)DequeTools.enqueueHeadAll((Deque)deque, (Object[])iterable.toArray(StringTools.EMPTY_STRING_ARRAY)));
        DequeToolsTests.assertTrue((boolean)deque.isEmpty());
    }

    public void testDrainHead() {
        ArrayDeque d = DequeTools.arrayDeque();
        d.enqueueTail((Object)"one");
        d.enqueueTail((Object)"two");
        d.enqueueTail((Object)"three");
        ArrayList list = DequeTools.drainHead((Deque)d);
        DequeToolsTests.assertEquals((String)"one", (String)((String)list.get(0)));
        DequeToolsTests.assertEquals((String)"two", (String)((String)list.get(1)));
        DequeToolsTests.assertEquals((String)"three", (String)((String)list.get(2)));
    }

    public void testDrainTail() {
        ArrayDeque d = DequeTools.arrayDeque();
        d.enqueueTail((Object)"one");
        d.enqueueTail((Object)"two");
        d.enqueueTail((Object)"three");
        ArrayList list = DequeTools.drainTail((Deque)d);
        DequeToolsTests.assertEquals((String)"one", (String)((String)list.get(2)));
        DequeToolsTests.assertEquals((String)"two", (String)((String)list.get(1)));
        DequeToolsTests.assertEquals((String)"three", (String)((String)list.get(0)));
    }

    public void testDrainHeadToCollection() {
        ArrayDeque d = DequeTools.arrayDeque();
        d.enqueueTail((Object)"one");
        d.enqueueTail((Object)"two");
        d.enqueueTail((Object)"three");
        ArrayList list = new ArrayList();
        DequeToolsTests.assertTrue((boolean)DequeTools.drainHeadTo((Deque)d, list));
        DequeToolsTests.assertEquals((String)"one", (String)((String)list.get(0)));
        DequeToolsTests.assertEquals((String)"two", (String)((String)list.get(1)));
        DequeToolsTests.assertEquals((String)"three", (String)((String)list.get(2)));
    }

    public void testDrainHeadToCollection_empty() {
        ArrayDeque d = DequeTools.arrayDeque();
        ArrayList list = new ArrayList();
        DequeToolsTests.assertFalse((boolean)DequeTools.drainHeadTo((Deque)d, list));
        DequeToolsTests.assertTrue((boolean)list.isEmpty());
    }

    public void testDrainTailToCollection() {
        ArrayDeque d = DequeTools.arrayDeque();
        d.enqueueTail((Object)"one");
        d.enqueueTail((Object)"two");
        d.enqueueTail((Object)"three");
        ArrayList list = new ArrayList();
        DequeToolsTests.assertTrue((boolean)DequeTools.drainTailTo((Deque)d, list));
        DequeToolsTests.assertEquals((String)"one", (String)((String)list.get(2)));
        DequeToolsTests.assertEquals((String)"two", (String)((String)list.get(1)));
        DequeToolsTests.assertEquals((String)"three", (String)((String)list.get(0)));
    }

    public void testDrainTailToCollection_empty() {
        ArrayDeque d = DequeTools.arrayDeque();
        ArrayList list = new ArrayList();
        DequeToolsTests.assertFalse((boolean)DequeTools.drainTailTo((Deque)d, list));
        DequeToolsTests.assertTrue((boolean)list.isEmpty());
    }

    public void testDrainHeadToListIndex() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        list.add("three");
        ArrayDeque deque = DequeTools.arrayDeque();
        deque.enqueueTail((Object)"aaa");
        deque.enqueueTail((Object)"bbb");
        deque.enqueueTail((Object)"ccc");
        DequeToolsTests.assertTrue((boolean)DequeTools.drainHeadTo((Deque)deque, list, (int)2));
        DequeToolsTests.assertEquals((String)"one", (String)((String)list.get(0)));
        DequeToolsTests.assertEquals((String)"two", (String)((String)list.get(1)));
        DequeToolsTests.assertEquals((String)"aaa", (String)((String)list.get(2)));
        DequeToolsTests.assertEquals((String)"bbb", (String)((String)list.get(3)));
        DequeToolsTests.assertEquals((String)"ccc", (String)((String)list.get(4)));
        DequeToolsTests.assertEquals((String)"three", (String)((String)list.get(5)));
    }

    public void testDrainHeadToListIndex_end() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        list.add("three");
        ArrayDeque deque = DequeTools.arrayDeque();
        deque.enqueueTail((Object)"aaa");
        deque.enqueueTail((Object)"bbb");
        deque.enqueueTail((Object)"ccc");
        DequeToolsTests.assertTrue((boolean)DequeTools.drainHeadTo((Deque)deque, list, (int)3));
        DequeToolsTests.assertEquals((String)"one", (String)((String)list.get(0)));
        DequeToolsTests.assertEquals((String)"two", (String)((String)list.get(1)));
        DequeToolsTests.assertEquals((String)"three", (String)((String)list.get(2)));
        DequeToolsTests.assertEquals((String)"aaa", (String)((String)list.get(3)));
        DequeToolsTests.assertEquals((String)"bbb", (String)((String)list.get(4)));
        DequeToolsTests.assertEquals((String)"ccc", (String)((String)list.get(5)));
    }

    public void testDrainHeadToListIndex_empty() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        list.add("three");
        ArrayDeque deque = DequeTools.arrayDeque();
        DequeToolsTests.assertFalse((boolean)DequeTools.drainHeadTo((Deque)deque, list, (int)3));
        DequeToolsTests.assertEquals((String)"one", (String)((String)list.get(0)));
        DequeToolsTests.assertEquals((String)"two", (String)((String)list.get(1)));
        DequeToolsTests.assertEquals((String)"three", (String)((String)list.get(2)));
    }

    public void testDrainTailToListIndex() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        list.add("three");
        ArrayDeque deque = DequeTools.arrayDeque();
        deque.enqueueTail((Object)"aaa");
        deque.enqueueTail((Object)"bbb");
        deque.enqueueTail((Object)"ccc");
        DequeToolsTests.assertTrue((boolean)DequeTools.drainTailTo((Deque)deque, list, (int)2));
        DequeToolsTests.assertEquals((String)"one", (String)((String)list.get(0)));
        DequeToolsTests.assertEquals((String)"two", (String)((String)list.get(1)));
        DequeToolsTests.assertEquals((String)"ccc", (String)((String)list.get(2)));
        DequeToolsTests.assertEquals((String)"bbb", (String)((String)list.get(3)));
        DequeToolsTests.assertEquals((String)"aaa", (String)((String)list.get(4)));
        DequeToolsTests.assertEquals((String)"three", (String)((String)list.get(5)));
    }

    public void testDrainTailToListIndex_end() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        list.add("three");
        ArrayDeque deque = DequeTools.arrayDeque();
        deque.enqueueTail((Object)"aaa");
        deque.enqueueTail((Object)"bbb");
        deque.enqueueTail((Object)"ccc");
        DequeToolsTests.assertTrue((boolean)DequeTools.drainTailTo((Deque)deque, list, (int)3));
        DequeToolsTests.assertEquals((String)"one", (String)((String)list.get(0)));
        DequeToolsTests.assertEquals((String)"two", (String)((String)list.get(1)));
        DequeToolsTests.assertEquals((String)"three", (String)((String)list.get(2)));
        DequeToolsTests.assertEquals((String)"ccc", (String)((String)list.get(3)));
        DequeToolsTests.assertEquals((String)"bbb", (String)((String)list.get(4)));
        DequeToolsTests.assertEquals((String)"aaa", (String)((String)list.get(5)));
    }

    public void testDrainTailToListIndex_empty() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        list.add("three");
        ArrayDeque deque = DequeTools.arrayDeque();
        DequeToolsTests.assertFalse((boolean)DequeTools.drainTailTo((Deque)deque, list, (int)3));
        DequeToolsTests.assertEquals((String)"one", (String)((String)list.get(0)));
        DequeToolsTests.assertEquals((String)"two", (String)((String)list.get(1)));
        DequeToolsTests.assertEquals((String)"three", (String)((String)list.get(2)));
    }

    public void testDrainHeadToStack() {
        ArrayDeque d = DequeTools.arrayDeque();
        d.enqueueTail((Object)"one");
        d.enqueueTail((Object)"two");
        d.enqueueTail((Object)"three");
        ArrayStack stack = StackTools.arrayStack();
        DequeToolsTests.assertTrue((boolean)DequeTools.drainHeadTo((Deque)d, (Stack)stack));
        DequeToolsTests.assertEquals((String)"three", (String)((String)stack.pop()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)stack.pop()));
        DequeToolsTests.assertEquals((String)"one", (String)((String)stack.pop()));
    }

    public void testDrainHeadToStack_empty() {
        ArrayDeque d = DequeTools.arrayDeque();
        ArrayStack stack = StackTools.arrayStack();
        DequeToolsTests.assertFalse((boolean)DequeTools.drainHeadTo((Deque)d, (Stack)stack));
        DequeToolsTests.assertTrue((boolean)stack.isEmpty());
    }

    public void testDrainTailToStack() {
        ArrayDeque d = DequeTools.arrayDeque();
        d.enqueueTail((Object)"one");
        d.enqueueTail((Object)"two");
        d.enqueueTail((Object)"three");
        ArrayStack stack = StackTools.arrayStack();
        DequeToolsTests.assertTrue((boolean)DequeTools.drainTailTo((Deque)d, (Stack)stack));
        DequeToolsTests.assertEquals((String)"one", (String)((String)stack.pop()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)stack.pop()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)stack.pop()));
    }

    public void testDrainTailToStack_empty() {
        ArrayDeque d = DequeTools.arrayDeque();
        ArrayStack stack = StackTools.arrayStack();
        DequeToolsTests.assertFalse((boolean)DequeTools.drainTailTo((Deque)d, (Stack)stack));
        DequeToolsTests.assertTrue((boolean)stack.isEmpty());
    }

    public void testDrainHeadToQueue() {
        ArrayDeque d = DequeTools.arrayDeque();
        d.enqueueTail((Object)"one");
        d.enqueueTail((Object)"two");
        d.enqueueTail((Object)"three");
        ArrayQueue queue = QueueTools.arrayQueue();
        DequeToolsTests.assertTrue((boolean)DequeTools.drainHeadTo((Deque)d, (Queue)queue));
        DequeToolsTests.assertEquals((String)"one", (String)((String)queue.dequeue()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)queue.dequeue()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)queue.dequeue()));
    }

    public void testDrainHeadToQueue_empty() {
        ArrayDeque d = DequeTools.arrayDeque();
        ArrayQueue queue = QueueTools.arrayQueue();
        DequeToolsTests.assertFalse((boolean)DequeTools.drainHeadTo((Deque)d, (Queue)queue));
        DequeToolsTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testDrainTailToQueue() {
        ArrayDeque d = DequeTools.arrayDeque();
        d.enqueueTail((Object)"one");
        d.enqueueTail((Object)"two");
        d.enqueueTail((Object)"three");
        ArrayQueue queue = QueueTools.arrayQueue();
        DequeToolsTests.assertTrue((boolean)DequeTools.drainTailTo((Deque)d, (Queue)queue));
        DequeToolsTests.assertEquals((String)"three", (String)((String)queue.dequeue()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)queue.dequeue()));
        DequeToolsTests.assertEquals((String)"one", (String)((String)queue.dequeue()));
    }

    public void testDrainTailToQueue_empty() {
        ArrayDeque d = DequeTools.arrayDeque();
        ArrayQueue queue = QueueTools.arrayQueue();
        DequeToolsTests.assertFalse((boolean)DequeTools.drainTailTo((Deque)d, (Queue)queue));
        DequeToolsTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testDrainHeadToDeque() {
        ArrayDeque d = DequeTools.arrayDeque();
        d.enqueueTail((Object)"one");
        d.enqueueTail((Object)"two");
        d.enqueueTail((Object)"three");
        ArrayDeque d2 = DequeTools.arrayDeque();
        DequeToolsTests.assertTrue((boolean)DequeTools.drainHeadTo((Deque)d, (Deque)d2));
        DequeToolsTests.assertEquals((String)"one", (String)((String)d2.dequeueHead()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)d2.dequeueHead()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)d2.dequeueHead()));
    }

    public void testDrainHeadToDeque_empty() {
        ArrayDeque d = DequeTools.arrayDeque();
        ArrayDeque d2 = DequeTools.arrayDeque();
        DequeToolsTests.assertFalse((boolean)DequeTools.drainHeadTo((Deque)d, (Deque)d2));
        DequeToolsTests.assertTrue((boolean)d2.isEmpty());
    }

    public void testDrainTailToDeque() {
        ArrayDeque d = DequeTools.arrayDeque();
        d.enqueueTail((Object)"one");
        d.enqueueTail((Object)"two");
        d.enqueueTail((Object)"three");
        ArrayDeque d2 = DequeTools.arrayDeque();
        DequeToolsTests.assertTrue((boolean)DequeTools.drainTailTo((Deque)d, (Deque)d2));
        DequeToolsTests.assertEquals((String)"one", (String)((String)d2.dequeueHead()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)d2.dequeueHead()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)d2.dequeueHead()));
    }

    public void testDrainTailToDeque_empty() {
        ArrayDeque d = DequeTools.arrayDeque();
        ArrayDeque d2 = DequeTools.arrayDeque();
        DequeToolsTests.assertFalse((boolean)DequeTools.drainTailTo((Deque)d, (Deque)d2));
        DequeToolsTests.assertTrue((boolean)d2.isEmpty());
    }

    public void testDrainHeadToMapTransformer() {
        ArrayDeque d = DequeTools.arrayDeque();
        d.enqueueTail((Object)"zero");
        d.enqueueTail((Object)"one");
        d.enqueueTail((Object)"two");
        HashMap map = new HashMap();
        DequeToolsTests.assertTrue((boolean)DequeTools.drainHeadTo((Deque)d, map, FIRST_LETTER_TRANSFORMER));
        DequeToolsTests.assertEquals((String)"one", (String)((String)map.get("o")));
        DequeToolsTests.assertEquals((String)"two", (String)((String)map.get("t")));
        DequeToolsTests.assertEquals((String)"zero", (String)((String)map.get("z")));
    }

    public void testDrainHeadToMapTransformer_empty() {
        ArrayDeque d = DequeTools.arrayDeque();
        HashMap map = new HashMap();
        DequeToolsTests.assertFalse((boolean)DequeTools.drainHeadTo((Deque)d, map, FIRST_LETTER_TRANSFORMER));
        DequeToolsTests.assertTrue((boolean)map.isEmpty());
    }

    public void testDrainTailToMapTransformer() {
        ArrayDeque d = DequeTools.arrayDeque();
        d.enqueueTail((Object)"zero");
        d.enqueueTail((Object)"one");
        d.enqueueTail((Object)"two");
        HashMap map = new HashMap();
        DequeToolsTests.assertTrue((boolean)DequeTools.drainTailTo((Deque)d, map, FIRST_LETTER_TRANSFORMER));
        DequeToolsTests.assertEquals((String)"one", (String)((String)map.get("o")));
        DequeToolsTests.assertEquals((String)"two", (String)((String)map.get("t")));
        DequeToolsTests.assertEquals((String)"zero", (String)((String)map.get("z")));
    }

    public void testDrainTailToMapTransformer_empty() {
        ArrayDeque d = DequeTools.arrayDeque();
        HashMap map = new HashMap();
        DequeToolsTests.assertFalse((boolean)DequeTools.drainTailTo((Deque)d, map, FIRST_LETTER_TRANSFORMER));
        DequeToolsTests.assertTrue((boolean)map.isEmpty());
    }

    public void testDrainHeadToMapTransformerTransformer() {
        ArrayDeque d = DequeTools.arrayDeque();
        d.enqueueTail((Object)"zero");
        d.enqueueTail((Object)"one");
        d.enqueueTail((Object)"two");
        HashMap map = new HashMap();
        DequeToolsTests.assertTrue((boolean)DequeTools.drainHeadTo((Deque)d, map, FIRST_LETTER_TRANSFORMER, EMPHASIZER));
        DequeToolsTests.assertEquals((String)"*one*", (String)((String)map.get("o")));
        DequeToolsTests.assertEquals((String)"*two*", (String)((String)map.get("t")));
        DequeToolsTests.assertEquals((String)"*zero*", (String)((String)map.get("z")));
    }

    public void testDrainHeadToMapTransformerTransformer_empty() {
        ArrayDeque d = DequeTools.arrayDeque();
        HashMap map = new HashMap();
        DequeToolsTests.assertFalse((boolean)DequeTools.drainHeadTo((Deque)d, map, FIRST_LETTER_TRANSFORMER, EMPHASIZER));
        DequeToolsTests.assertTrue((boolean)map.isEmpty());
    }

    public void testDrainTailToMapTransformerTransformer() {
        ArrayDeque d = DequeTools.arrayDeque();
        d.enqueueTail((Object)"zero");
        d.enqueueTail((Object)"one");
        d.enqueueTail((Object)"two");
        HashMap map = new HashMap();
        DequeToolsTests.assertTrue((boolean)DequeTools.drainTailTo((Deque)d, map, FIRST_LETTER_TRANSFORMER, EMPHASIZER));
        DequeToolsTests.assertEquals((String)"*one*", (String)((String)map.get("o")));
        DequeToolsTests.assertEquals((String)"*two*", (String)((String)map.get("t")));
        DequeToolsTests.assertEquals((String)"*zero*", (String)((String)map.get("z")));
    }

    public void testDrainTailToMapTransformerTransformer_empty() {
        ArrayDeque d = DequeTools.arrayDeque();
        HashMap map = new HashMap();
        DequeToolsTests.assertFalse((boolean)DequeTools.drainTailTo((Deque)d, map, FIRST_LETTER_TRANSFORMER, EMPHASIZER));
        DequeToolsTests.assertTrue((boolean)map.isEmpty());
    }

    public void testArrayDeque() {
        ArrayDeque d = DequeTools.arrayDeque();
        DequeToolsTests.assertTrue((boolean)d.isEmpty());
    }

    public void testArrayDequeInt() {
        ArrayDeque d = DequeTools.arrayDeque((int)20);
        DequeToolsTests.assertTrue((boolean)d.isEmpty());
        DequeToolsTests.assertEquals((int)20, (int)((Object[])ObjectTools.get((Object)d, (String)"elements")).length);
    }

    public void testArrayDequeIterable() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayDeque deque = DequeTools.arrayDeque(iterable);
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueHead()));
    }

    public void testArrayDequeIterableInt() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayDeque deque = DequeTools.arrayDeque(iterable, (int)5);
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueHead()));
    }

    public void testReverseArrayDequeIterable() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayDeque deque = DequeTools.reverseArrayDeque(iterable);
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueTail()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueTail()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueTail()));
    }

    public void testReverseArrayDequeIterableInt() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayDeque deque = DequeTools.reverseArrayDeque(iterable, (int)77);
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueTail()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueTail()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueTail()));
    }

    public void testArrayDequeIterator() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayDeque deque = DequeTools.arrayDeque(iterable.iterator());
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueHead()));
    }

    public void testArrayDequeIteratorInt() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayDeque deque = DequeTools.arrayDeque(iterable.iterator(), (int)5);
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueHead()));
    }

    public void testReverseArrayDequeIterator() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayDeque deque = DequeTools.reverseArrayDeque(iterable.iterator());
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueTail()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueTail()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueTail()));
    }

    public void testReverseArrayDequeIteratorInt() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayDeque deque = DequeTools.reverseArrayDeque(iterable.iterator(), (int)42);
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueTail()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueTail()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueTail()));
    }

    public void testArrayDequeArray() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayDeque deque = DequeTools.arrayDeque((Object[])iterable.toArray(StringTools.EMPTY_STRING_ARRAY));
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueHead()));
    }

    public void testReverseArrayDequeArray() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        ArrayDeque deque = DequeTools.reverseArrayDeque((Object[])iterable.toArray(StringTools.EMPTY_STRING_ARRAY));
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueTail()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueTail()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueTail()));
    }

    public void testLinkedDeque() {
        LinkedDeque d = DequeTools.linkedDeque();
        DequeToolsTests.assertTrue((boolean)d.isEmpty());
    }

    public void testLinkedDequeInt() {
        LinkedDeque d = DequeTools.linkedDeque((int)20);
        DequeToolsTests.assertTrue((boolean)d.isEmpty());
    }

    public void testLinkedDequeIterable() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        LinkedDeque deque = DequeTools.linkedDeque(iterable);
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueHead()));
    }

    public void testLinkedDequeIterableInt() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        LinkedDeque deque = DequeTools.linkedDeque(iterable, (int)5);
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueHead()));
    }

    public void testReverseLinkedDequeIterable() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        LinkedDeque deque = DequeTools.reverseLinkedDeque(iterable);
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueTail()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueTail()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueTail()));
    }

    public void testReverseLinkedDequeIterableInt() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        LinkedDeque deque = DequeTools.reverseLinkedDeque(iterable, (int)77);
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueTail()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueTail()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueTail()));
    }

    public void testLinkedDequeIterator() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        LinkedDeque deque = DequeTools.linkedDeque(iterable.iterator());
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueHead()));
    }

    public void testLinkedDequeIteratorInt() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        LinkedDeque deque = DequeTools.linkedDeque(iterable.iterator(), (int)5);
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueHead()));
    }

    public void testReverseLinkedDequeIterator() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        LinkedDeque deque = DequeTools.reverseLinkedDeque(iterable.iterator());
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueTail()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueTail()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueTail()));
    }

    public void testReverseLinkedDequeIteratorInt() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        LinkedDeque deque = DequeTools.reverseLinkedDeque(iterable.iterator(), (int)42);
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueTail()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueTail()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueTail()));
    }

    public void testLinkedDequeArray() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        LinkedDeque deque = DequeTools.linkedDeque((Object[])iterable.toArray(StringTools.EMPTY_STRING_ARRAY));
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueHead()));
    }

    public void testReverseLinkedDequeArray() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        LinkedDeque deque = DequeTools.reverseLinkedDeque((Object[])iterable.toArray(StringTools.EMPTY_STRING_ARRAY));
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueTail()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueTail()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueTail()));
    }

    public void testFixedCapacityArrayDequeCollection() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        FixedCapacityArrayDeque deque = DequeTools.fixedCapacityArrayDeque(iterable);
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueHead()));
    }

    public void testReverseFixedCapacityArrayDequeCollection() {
        ArrayList<String> iterable = new ArrayList<String>();
        iterable.add("one");
        iterable.add("two");
        iterable.add("three");
        FixedCapacityArrayDeque deque = DequeTools.reverseFixedCapacityArrayDeque(iterable);
        DequeToolsTests.assertEquals((String)"three", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"two", (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)"one", (String)((String)deque.dequeueHead()));
    }

    public void testPriorityDequeComparator() {
        PriorityDeque deque = DequeTools.priorityDeque((Comparator)ComparatorTools.reverseComparator());
        String first = "first";
        String second = "second";
        deque.enqueue((Object)first);
        deque.enqueueTail((Object)second);
        DequeToolsTests.assertEquals((String)second, (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)first, (String)((String)deque.dequeueHead()));
    }

    public void testSynchronizedDequeObject() {
        Object lock = new Object();
        SynchronizedDeque deque = DequeTools.synchronizedDeque((Object)lock);
        String first = "first";
        String second = "second";
        deque.enqueueTail((Object)first);
        deque.enqueueTail((Object)second);
        DequeToolsTests.assertEquals((String)first, (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)second, (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((Object)lock, (Object)deque.getMutex());
    }

    public void testSynchronizedDequeDequeObject() {
        Object lock = new Object();
        ArrayDeque innerDeque = DequeTools.arrayDeque();
        String first = "first";
        String second = "second";
        innerDeque.enqueueTail((Object)first);
        innerDeque.enqueueTail((Object)second);
        SynchronizedDeque deque = DequeTools.synchronizedDeque((Deque)innerDeque, (Object)lock);
        DequeToolsTests.assertEquals((String)first, (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((String)second, (String)((String)deque.dequeueHead()));
        DequeToolsTests.assertEquals((Object)lock, (Object)deque.getMutex());
    }

    public void testConstructor() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Object at = ClassTools.newInstance(DequeTools.class);
                DequeToolsTests.fail((String)("bogus: " + at));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof InvocationTargetException) || !(ex.getCause().getCause() instanceof UnsupportedOperationException)) break block2;
                exCaught = true;
            }
        }
        DequeToolsTests.assertTrue((boolean)exCaught);
    }

    static class FirstLetterTransformer
    implements Transformer<String, String> {
        FirstLetterTransformer() {
        }

        public String transform(String string) {
            return string.substring(0, 1);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

