/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.impl.AbstractCreateFeature;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.ui.editor.IDiagramContainerUI;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.jpa.core.JpaPreferences;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.propertypage.JPADiagramPropertyPage;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;

public class CreateEmbeddableFeature
extends AbstractCreateFeature {
    public CreateEmbeddableFeature(IFeatureProvider fp) {
        super(fp, JPAEditorMessages.CreateEmbeddableFeature_EmbeddableFeatureName, JPAEditorMessages.CreateEmbeddableFeature_EmbeddableFeatureDescription);
    }

    public boolean canCreate(ICreateContext context) {
        return context.getTargetContainer() instanceof Diagram;
    }

    public Object[] create(ICreateContext context) {
        EList shapes = this.getFeatureProvider().getDiagramTypeProvider().getDiagram().getChildren();
        IProject targetProject = null;
        JpaProject jpaProject = null;
        if (shapes == null || shapes.size() == 0) {
            jpaProject = this.getTargetJPAProject();
            targetProject = jpaProject.getProject();
        } else {
            Shape sh = (Shape)shapes.get(0);
            PersistentType jpt = (PersistentType)this.getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)sh);
            if (jpt == null) {
                return new Object[0];
            }
            jpaProject = jpt.getJpaProject();
            targetProject = jpaProject.getProject();
        }
        String embeddableName = this.getFeatureProvider().getJPAEditorUtil().generateUniqueTypeName(jpaProject, JPADiagramPropertyPage.getDefaultPackage(jpaProject.getProject()), ".Embeddable", this.getFeatureProvider());
        if (!JpaPreferences.getDiscoverAnnotatedClasses((IProject)jpaProject.getProject())) {
            JPAEditorUtil.createRegisterEntityInXMLJob(jpaProject, embeddableName);
        }
        try {
            this.getFeatureProvider().getJPAEditorUtil().createEmbeddableInProject(targetProject, embeddableName);
        }
        catch (Exception e1) {
            JPADiagramEditorPlugin.logError("Cannot create a embeddable in the project " + targetProject.getName(), e1);
        }
        PersistenceUnit pu = JpaArtifactFactory.instance().getPersistenceUnit(jpaProject);
        PersistentType jpt = JpaArtifactFactory.instance().getJPT(embeddableName, pu);
        if (jpt != null) {
            if (JPADiagramPropertyPage.doesSupportOrmXml(targetProject)) {
                JpaArtifactFactory.instance().addPersistentTypeToORMXml(jpaProject, embeddableName, "embeddable");
            }
            this.addGraphicalRepresentation((IAreaContext)context, jpt);
            IWorkbenchPartSite ws = ((IDiagramContainerUI)this.getFeatureProvider().getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer()).getSite();
            ICompilationUnit cu = this.getFeatureProvider().getCompilationUnit(jpt);
            this.getFeatureProvider().getJPAEditorUtil().formatCode(cu, (IWorkbenchSite)ws);
            return new Object[]{jpt};
        }
        JPADiagramEditorPlugin.logError("The embeddable " + embeddableName + " could not be created", new Exception());
        IWorkbenchPartSite ws = ((IDiagramContainerUI)this.getDiagramBehavior().getDiagramContainer()).getSite();
        ICompilationUnit cu = JPAEditorUtil.getCompilationUnit(jpt);
        this.getFeatureProvider().getJPAEditorUtil().formatCode(cu, (IWorkbenchSite)ws);
        return new Object[]{jpt};
    }

    public String getCreateImageId() {
        return "org.eclipse.jpt.jpadiagrameditor.ui.add_embeddable";
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    private JpaProject getTargetJPAProject() {
        return this.getFeatureProvider().getMoinIntegrationUtil().getProjectByDiagram(this.getDiagram());
    }
}

