/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jpt.common.core.JptCommonCoreMessages;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class ExtensionPointTools {
    public static <T> T instantiate(String pluginID, String extensionPoint, String className, Class<T> interfaze) {
        Class<T> clazz = ExtensionPointTools.loadClass(pluginID, extensionPoint, className, interfaze);
        return clazz == null ? null : (T)ExtensionPointTools.instantiate(pluginID, extensionPoint, clazz);
    }

    private static <T> Class<T> loadClass(String pluginID, String extensionPoint, String className, Class<T> interfaze) {
        Class clazz;
        Bundle bundle = Platform.getBundle((String)pluginID);
        if (bundle == null) {
            ExtensionPointTools.logError(JptCommonCoreMessages.REGISTRY_MISSING_BUNDLE, pluginID);
            return null;
        }
        try {
            clazz = bundle.loadClass(className);
        }
        catch (Exception ex) {
            ExtensionPointTools.logFailedClassLoad(ex, pluginID, extensionPoint, className);
            return null;
        }
        if (!interfaze.isAssignableFrom(clazz)) {
            ExtensionPointTools.logFailedInterfaceAssignment(pluginID, extensionPoint, clazz, interfaze);
            return null;
        }
        Class clazzT = clazz;
        return clazzT;
    }

    private static void logFailedClassLoad(Exception ex, String pluginID, String extensionPoint, String className) {
        ExtensionPointTools.logError(ex, JptCommonCoreMessages.REGISTRY_FAILED_CLASS_LOAD, className, extensionPoint, pluginID);
    }

    private static void logFailedInterfaceAssignment(String pluginID, String extensionPoint, Class<?> clazz, Class<?> interfaze) {
        ExtensionPointTools.logError(JptCommonCoreMessages.REGISTRY_FAILED_INTERFACE_ASSIGNMENT, clazz.getName(), extensionPoint, pluginID, interfaze.getName());
    }

    private static <T> T instantiate(String pluginID, String extensionPoint, Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception ex) {
            ExtensionPointTools.logFailedInstantiation(ex, pluginID, extensionPoint, clazz);
            return null;
        }
    }

    private static void logFailedInstantiation(Exception ex, String pluginID, String extensionPoint, Class<?> clazz) {
        ExtensionPointTools.logError(ex, JptCommonCoreMessages.REGISTRY_FAILED_INSTANTIATION, clazz.getName(), extensionPoint, pluginID);
    }

    private static void logError(String msg, Object ... args) {
        JptCommonCorePlugin.instance().logError(msg, args);
    }

    private static void logError(Throwable ex, String msg, Object ... args) {
        JptCommonCorePlugin.instance().logError(ex, msg, args);
    }

    public static String buildMissingAttributeMessage(IConfigurationElement element, String attributeName) {
        return ExtensionPointTools.bind(JptCommonCoreMessages.REGISTRY_MISSING_ATTRIBUTE, attributeName, element.getName(), element.getDeclaringExtension().getExtensionPointUniqueIdentifier(), element.getContributor().getName());
    }

    public static String buildInvalidValueMessage(IConfigurationElement element, String attributeName, String invalidValue) {
        return ExtensionPointTools.bind(JptCommonCoreMessages.REGISTRY_INVALID_VALUE, invalidValue, attributeName, element.getDeclaringExtension().getExtensionPointUniqueIdentifier(), element.getContributor().getName());
    }

    private static String bind(String msg, Object ... args) {
        return NLS.bind((String)msg, (Object[])args);
    }

    private ExtensionPointTools() {
        throw new UnsupportedOperationException();
    }
}

