/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.serializer;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.serializer.MethodSerializerAdapter;
import org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.serializer.SerializerAdapterTestFixture;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationFactory;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotationInspector;

public class MethodSerializerAdapterTest
extends SerializerAdapterTestFixture {
    private IWebMethod webMethod1;
    private IMethod method1;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.resource.startSynchronizing();
        this.method1 = this.seiType.createMethod("public void test1();", null, true, null);
        this.webMethod1 = (IWebMethod)this.sei.getWebMethods().get(0);
    }

    public void testGetAnnotationDefaultValues() throws Exception {
        MyMethodSerializerAdapter adapter = new MyMethodSerializerAdapter(this.resource, this.webMethod1);
        IAnnotation<? extends IJavaElement> annotation = adapter.getAnnotation();
        MethodSerializerAdapterTest.assertNotNull(annotation);
        MethodSerializerAdapterTest.assertEquals((int)0, (int)annotation.getParamValuePairs().size());
        MethodSerializerAdapterTest.assertNull((Object)annotation.getPropertyValue("operationName"));
        MethodSerializerAdapterTest.assertNull((Object)annotation.getPropertyValue("exclude"));
    }

    public void testGetAnnotationNonDefaultValues() throws Exception {
        this.resource.disableSaving();
        this.webMethod1.setName("changed");
        this.webMethod1.setExcluded(true);
        MyMethodSerializerAdapter adapter = new MyMethodSerializerAdapter(this.resource, this.webMethod1);
        IAnnotation<? extends IJavaElement> annotation = adapter.getAnnotation();
        MethodSerializerAdapterTest.assertNotNull(annotation);
        MethodSerializerAdapterTest.assertEquals((int)2, (int)annotation.getParamValuePairs().size());
        MethodSerializerAdapterTest.assertEquals((String)"changed", (String)annotation.getPropertyValue("operationName"));
        MethodSerializerAdapterTest.assertEquals((String)"true", (String)annotation.getPropertyValue("exclude"));
    }

    public void testSaveAnnotation() throws Exception {
        this.webMethod1.setName("changedOperation");
        IAnnotationInspector inspector = AnnotationFactory.createAnnotationInspector((IType)this.seiType);
        IAnnotation annotation = inspector.inspectMethod(this.method1, "javax.jws.WebMethod");
        MethodSerializerAdapterTest.assertNotNull((Object)annotation);
        MethodSerializerAdapterTest.assertEquals((String)"changedOperation", (String)annotation.getPropertyValue("operationName"));
    }

    public void testSaveAnnotationEmptyName() throws Exception {
        this.webMethod1.setName("method1");
        this.webMethod1.setName(null);
        IAnnotationInspector inspector = AnnotationFactory.createAnnotationInspector((IType)this.seiType);
        IAnnotation annotation = inspector.inspectMethod(this.method1, "javax.jws.WebMethod");
        MethodSerializerAdapterTest.assertNotNull((Object)annotation);
        MethodSerializerAdapterTest.assertEquals((String)"method1", (String)annotation.getPropertyValue("operationName"));
    }

    protected class MyMethodSerializerAdapter
    extends MethodSerializerAdapter {
        public MyMethodSerializerAdapter(JaxWsWorkspaceResource resource, IWebMethod webMethod) {
            super(resource);
            this.setTarget((Notifier)webMethod);
        }

        public IAnnotation<? extends IJavaElement> getAnnotation() throws JavaModelException {
            return super.getAnnotation();
        }
    }
}

