/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.liveedit;

import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.chromium.UpdatableScript;
import org.eclipse.wst.jsdt.chromium.debug.core.model.PushChangesPlan;
import org.eclipse.wst.jsdt.chromium.debug.ui.DialogUtils;
import org.eclipse.wst.jsdt.chromium.debug.ui.liveedit.Messages;

class PreviewLoader
implements DialogUtils.ValueSource<DialogUtils.Optional<Data>> {
    private final DialogUtils.Updater updater;
    private final DialogUtils.ValueSource<PushChangesPlan> inputParameterSource;
    private boolean active = false;
    private final Monitor dataMonitor = new Monitor();
    private final DialogUtils.ValueConsumer parametersConsumer = new DialogUtils.ValueConsumer(){

        @Override
        public void update(DialogUtils.Updater updater) {
            PushChangesPlan inputPlan = (PushChangesPlan)PreviewLoader.this.inputParameterSource.getValue();
            boolean updated = PreviewLoader.this.dataMonitor.updateInput(inputPlan);
            if (updated && PreviewLoader.this.active) {
                PreviewLoader.this.requestPreview();
            }
        }
    };
    private static final DialogUtils.Optional<Data> NO_DATA = DialogUtils.createErrorOptional(new DialogUtils.Message(Messages.PreviewLoader_WAITING_FOR_DIFF, DialogUtils.MessagePriority.NONE));
    private static final DialogUtils.Optional<Data> EMPTY_DATA = DialogUtils.createErrorOptional(new DialogUtils.Message(Messages.PreviewLoader_FAILED_TO_LOAD, DialogUtils.MessagePriority.NONE));

    PreviewLoader(DialogUtils.Updater updater, DialogUtils.ValueSource<PushChangesPlan> inputParameterSource) {
        this.updater = updater;
        this.inputParameterSource = inputParameterSource;
    }

    void registerSelf(DialogUtils.Scope scope) {
        this.updater.addSource(scope, this);
        this.updater.addConsumer(scope, this.parametersConsumer);
        this.updater.addDependency(this.parametersConsumer, this.inputParameterSource);
    }

    void setActive(boolean active) {
        this.active = active;
        if (active) {
            this.requestPreview();
        }
    }

    private void requestPreview() {
        final PushChangesPlan plan = this.inputParameterSource.getValue();
        boolean inputIsNew = this.dataMonitor.updateInputAndStarted(plan);
        if (!inputIsNew) {
            return;
        }
        this.updater.reportChanged(this);
        UpdatableScript.UpdateCallback callback = new UpdatableScript.UpdateCallback(){

            public void failure(final String message, UpdatableScript.Failure failure) {
                DialogUtils.Optional result = (DialogUtils.Optional)failure.accept((UpdatableScript.Failure.Visitor)new UpdatableScript.Failure.Visitor<DialogUtils.Optional<Data>>(){

                    public DialogUtils.Optional<Data> visitUnspecified() {
                        return DialogUtils.createErrorOptional(new DialogUtils.Message(NLS.bind((String)Messages.PreviewLoader_FAILED_TO_GET, (Object)message), DialogUtils.MessagePriority.WARNING));
                    }

                    public DialogUtils.Optional<Data> visitCompileError(final UpdatableScript.CompileErrorFailure compileError) {
                        Data data = new Data(){

                            @Override
                            public <R> R accept(Data.Visitor<R> visitor) {
                                return visitor.visitCompileError(compileError);
                            }

                            @Override
                            public PushChangesPlan getChangesPlan() {
                                return plan;
                            }
                        };
                        return DialogUtils.createOptional(data);
                    }
                });
                this.done(result);
            }

            public void success(boolean resumed, Object report, final UpdatableScript.ChangeDescription changeDescription) {
                DialogUtils.Optional<2> result;
                if (changeDescription == null) {
                    result = EMPTY_DATA;
                } else {
                    Data data = new Data(){

                        @Override
                        public PushChangesPlan getChangesPlan() {
                            return plan;
                        }

                        @Override
                        public <R> R accept(Data.Visitor<R> visitor) {
                            return visitor.visitSuccess(changeDescription);
                        }
                    };
                    result = DialogUtils.createOptional(data);
                }
                this.done((DialogUtils.Optional<Data>)result);
            }

            private void done(DialogUtils.Optional<Data> result) {
                boolean resultTaken = PreviewLoader.this.dataMonitor.updateResult(result, plan);
                if (resultTaken) {
                    PreviewLoader.this.updater.reportChanged(PreviewLoader.this);
                    PreviewLoader.this.updater.updateAsync();
                }
            }
        };
        plan.execute(true, callback, null);
    }

    @Override
    public DialogUtils.Optional<Data> getValue() {
        return this.dataMonitor.getValue();
    }

    public static interface Data {
        public <R> R accept(Visitor<R> var1);

        public PushChangesPlan getChangesPlan();

        public static interface Visitor<R> {
            public R visitSuccess(UpdatableScript.ChangeDescription var1);

            public R visitCompileError(UpdatableScript.CompileErrorFailure var1);
        }
    }

    private static class Monitor {
        private PushChangesPlan input = null;
        private boolean alreadyStarted = false;
        private DialogUtils.Optional<Data> result = PreviewLoader.access$5();

        private Monitor() {
        }

        synchronized boolean updateInputAndStarted(PushChangesPlan inputPlan) {
            if (inputPlan == this.input) {
                if (this.alreadyStarted) {
                    return false;
                }
                this.alreadyStarted = true;
                return true;
            }
            this.input = inputPlan;
            this.result = NO_DATA;
            this.alreadyStarted = true;
            return true;
        }

        synchronized boolean updateInput(PushChangesPlan inputPlan) {
            if (inputPlan == this.input) {
                return false;
            }
            this.input = inputPlan;
            this.result = NO_DATA;
            this.alreadyStarted = false;
            return true;
        }

        synchronized DialogUtils.Optional<Data> getValue() {
            return this.result;
        }

        synchronized boolean updateResult(DialogUtils.Optional<Data> result, PushChangesPlan inputPlan) {
            if (inputPlan != this.input) {
                return false;
            }
            this.result = result;
            return true;
        }
    }
}

