/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.widgets;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jdt.internal.ui.wizards.NewClassCreationWizard;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jpt.common.core.internal.utility.JavaProjectTools;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.plugin.JptCommonUiPlugin;
import org.eclipse.jpt.common.ui.internal.swt.listeners.SWTListenerTools;
import org.eclipse.jpt.common.ui.internal.widgets.ChooserPane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.ClassNameTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.widgets.Hyperlink;

public abstract class ClassChooserPane<T extends Model>
extends ChooserPane<T> {
    protected JavaTypeCompletionProcessor javaTypeCompletionProcessor;
    private PropertyChangeListener subjectChangeListener;

    public ClassChooserPane(Pane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    public ClassChooserPane(Pane<? extends T> parentPane, Composite parent, Hyperlink hyperlink) {
        super(parentPane, parent);
        this.initialize(hyperlink);
    }

    public ClassChooserPane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    public ClassChooserPane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent, Hyperlink hyperlink) {
        super(parentPane, subjectHolder, parent);
        this.initialize(hyperlink);
    }

    public ClassChooserPane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, PropertyValueModel<Boolean> enabledModel, Composite parent) {
        super(parentPane, subjectHolder, enabledModel, parent);
    }

    public ClassChooserPane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, PropertyValueModel<Boolean> enabledModel, Composite parent, Hyperlink hyperlink) {
        this(parentPane, subjectHolder, enabledModel, parent);
        this.initialize(hyperlink);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.javaTypeCompletionProcessor = this.buildJavaTypeCompletionProcessor();
        this.subjectChangeListener = this.buildSubjectChangeListener();
        this.getSubjectHolder().addPropertyChangeListener("value", this.subjectChangeListener);
        this.classChooserSubjectChanged(this.getSubject());
    }

    protected void initialize(Hyperlink hyperlink) {
        final Runnable hyperLinkAction = this.buildHyperLinkAction();
        hyperlink.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Hyperlink hyperLink = (Hyperlink)e.widget;
                if (hyperLink.isEnabled()) {
                    hyperLinkAction.run();
                }
            }
        });
    }

    protected JavaTypeCompletionProcessor buildJavaTypeCompletionProcessor() {
        return new JavaTypeCompletionProcessor(false, false);
    }

    private PropertyChangeListener buildSubjectChangeListener() {
        return SWTListenerTools.wrap(this.buildSubjectChangeListener_());
    }

    private PropertyChangeListener buildSubjectChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                ClassChooserPane.this.classChooserSubjectChanged((Model)e.getNewValue());
            }
        };
    }

    protected void classChooserSubjectChanged(T newSubject) {
        IPackageFragmentRoot root;
        IPackageFragment packageFragment = null;
        if (newSubject != null && (root = this.getPackageFragmentRoot()) != null) {
            packageFragment = root.getPackageFragment("");
        }
        this.javaTypeCompletionProcessor.setPackageFragment(packageFragment);
    }

    private Runnable buildHyperLinkAction() {
        return new Runnable(){

            @Override
            public void run() {
                ClassChooserPane.this.hyperLinkSelected();
            }
        };
    }

    protected void hyperLinkSelected() {
        IType type = this.resolveJdtType();
        if (type != null) {
            this.openInEditor(type);
        } else {
            this.createType();
        }
    }

    protected IType resolveJdtType() {
        String className = this.getFullyQualifiedClassName();
        if (className == null) {
            return null;
        }
        return JavaProjectTools.findType((IJavaProject)this.getJavaProject(), (String)className);
    }

    protected void createType() {
        StructuredSelection selection = new StructuredSelection((Object)this.getJavaProject().getProject());
        NewClassWizardPage newClassWizardPage = new NewClassWizardPage();
        newClassWizardPage.init((IStructuredSelection)selection);
        newClassWizardPage.setSuperClass(this.getSuperclassName(), true);
        newClassWizardPage.setSuperInterfaces(this.getSuperInterfaceNames(), true);
        String qualifiedClassName = this.getFullyQualifiedClassName();
        if (!StringTools.isBlank((String)qualifiedClassName)) {
            newClassWizardPage.setTypeName(ClassNameTools.simpleName((String)qualifiedClassName), true);
            String packageName = ClassNameTools.packageName((String)qualifiedClassName);
            newClassWizardPage.setPackageFragment(this.getFirstJavaSourceFolder().getPackageFragment(packageName), true);
        }
        NewClassCreationWizard wizard = new NewClassCreationWizard(newClassWizardPage, false);
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)selection);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
        int dResult = dialog.open();
        if (dResult == 0) {
            String className = newClassWizardPage.getCreatedType().getFullyQualifiedName(this.getEnclosingTypeSeparator());
            this.setClassName(className);
        }
    }

    protected abstract void setClassName(String var1);

    protected char getEnclosingTypeSeparator() {
        return '$';
    }

    protected String getSuperclassName() {
        return "";
    }

    protected List<String> getSuperInterfaceNames() {
        return this.getSuperInterfaceName() != null ? Collections.singletonList(this.getSuperInterfaceName()) : Collections.emptyList();
    }

    protected String getSuperInterfaceName() {
        return null;
    }

    protected void openInEditor(IType type) {
        try {
            JavaUI.openInEditor((IJavaElement)type, (boolean)true, (boolean)true);
        }
        catch (JavaModelException e) {
            JptCommonUiPlugin.instance().logError(e);
        }
        catch (PartInitException e) {
            JptCommonUiPlugin.instance().logError(e);
        }
    }

    protected abstract IJavaProject getJavaProject();

    @Override
    protected final Runnable buildBrowseAction() {
        return new Runnable(){

            @Override
            public void run() {
                ClassChooserPane.this.promptType();
            }
        };
    }

    @Override
    protected Control addMainControl(Composite container) {
        Text text = this.addText(container, this.buildTextHolder(), this.getHelpId());
        ControlContentAssistHelper.createTextContentAssistant((Text)text, (IContentAssistProcessor)this.javaTypeCompletionProcessor);
        return text;
    }

    protected abstract ModifiablePropertyValueModel<String> buildTextHolder();

    protected IType chooseType() {
        SelectionDialog dialog;
        try {
            dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.getJavaProject()}), (int)this.getTypeDialogStyle(), (boolean)false, (String)(StringTools.isBlank((String)this.getClassName()) ? "" : ClassNameTools.simpleName((String)this.getClassName())));
        }
        catch (JavaModelException ex) {
            JptCommonUiPlugin.instance().logError(ex);
            return null;
        }
        dialog.setTitle(JptCommonUiMessages.CLASS_CHOOSER_PANE__DIALOG_TITLE);
        dialog.setMessage(JptCommonUiMessages.CLASS_CHOOSER_PANE__DIALOG_MESSAGE);
        return dialog.open() == 0 ? (IType)dialog.getResult()[0] : null;
    }

    protected int getTypeDialogStyle() {
        return 2;
    }

    protected abstract String getClassName();

    protected String getFullyQualifiedClassName() {
        return this.getClassName() == null ? null : this.getClassName().replace('$', '.');
    }

    protected IPackageFragmentRoot getFirstJavaSourceFolder() {
        Iterator i = JavaProjectTools.getSourceFolders((IJavaProject)this.getJavaProject()).iterator();
        return i.hasNext() ? (IPackageFragmentRoot)i.next() : null;
    }

    protected void promptType() {
        IType type = this.chooseType();
        if (type != null) {
            String className = type.getFullyQualifiedName(this.getEnclosingTypeSeparator());
            this.setClassName(className);
        }
    }

    protected IPackageFragmentRoot getPackageFragmentRoot() {
        try {
            return this.getJavaProject().getPackageFragmentRoots()[0];
        }
        catch (JavaModelException ex) {
            JptCommonUiPlugin.instance().logError(ex);
            return null;
        }
    }

    @Override
    public void controlDisposed() {
        this.getSubjectHolder().removePropertyChangeListener("value", this.subjectChangeListener);
        super.controlDisposed();
    }
}

