/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.read;

import java.util.List;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterType;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.PropertyType;
import org.eclipse.jst.jsf.facesconfig.tests.read.BaseReadTestCase;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class ReadPropertyConverterTestCase
extends BaseReadTestCase {
    public ReadPropertyConverterTestCase(String name) {
        super(name);
    }

    public void testProperty() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadPropertyConverterTestCase.assertNotNull((Object)edit.getFacesConfig());
            PropertyType property1 = this.getProperty1(edit.getFacesConfig());
            ReadPropertyConverterTestCase.assertNotNull((Object)property1);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private ConverterType getConverter1(FacesConfigType facesConfigType) {
        return (ConverterType)FacesConfigModelUtil.findEObjectElementById((List)facesConfigType.getConverter(), "converter1");
    }

    private PropertyType getProperty1(FacesConfigType facesConfigType) {
        ConverterType converter1 = this.getConverter1(facesConfigType);
        ReadPropertyConverterTestCase.assertNotNull((Object)converter1);
        return (PropertyType)FacesConfigModelUtil.findEObjectElementById((List)converter1.getProperty(), "converter1Property");
    }

    public void testDescription() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadPropertyConverterTestCase.assertNotNull((Object)edit.getFacesConfig());
            PropertyType propertyType = this.getProperty1(edit.getFacesConfig());
            ReadPropertyConverterTestCase.assertNotNull((Object)propertyType);
            DescriptionType descType = (DescriptionType)FacesConfigModelUtil.findEObjectElementById((List)propertyType.getDescription(), "converter1_property_description");
            ReadPropertyConverterTestCase.assertEquals((String)"converter-property-description", (String)descType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testDisplayName() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadPropertyConverterTestCase.assertNotNull((Object)edit.getFacesConfig());
            PropertyType propertyType = this.getProperty1(edit.getFacesConfig());
            ReadPropertyConverterTestCase.assertNotNull((Object)propertyType);
            DisplayNameType displayNameType = (DisplayNameType)FacesConfigModelUtil.findEObjectElementById((List)propertyType.getDisplayName(), "converter1_property_display-name");
            ReadPropertyConverterTestCase.assertEquals((String)"converter-property-display-name", (String)displayNameType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testIcon() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadPropertyConverterTestCase.assertNotNull((Object)edit.getFacesConfig());
            PropertyType propertyType = this.getProperty1(edit.getFacesConfig());
            ReadPropertyConverterTestCase.assertNotNull((Object)propertyType);
            IconType iconType = (IconType)FacesConfigModelUtil.findEObjectElementById((List)propertyType.getIcon(), "converter1_property_icon");
            ReadPropertyConverterTestCase.assertNotNull((Object)iconType);
            ReadPropertyConverterTestCase.assertEquals((String)"converter1-property-small-icon", (String)iconType.getSmallIcon().getTextContent());
            ReadPropertyConverterTestCase.assertEquals((String)"converter1-property-large-icon", (String)iconType.getLargeIcon().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testPropertyNameAndClass() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadPropertyConverterTestCase.assertNotNull((Object)edit.getFacesConfig());
            PropertyType property1 = this.getProperty1(edit.getFacesConfig());
            ReadPropertyConverterTestCase.assertNotNull((Object)property1);
            ReadPropertyConverterTestCase.assertEquals((String)"converter-property-name", (String)property1.getPropertyName().getTextContent());
            ReadPropertyConverterTestCase.assertEquals((String)"converter-property-propertyClass", (String)property1.getPropertyClass().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testSuggestedValue() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadPropertyConverterTestCase.assertNotNull((Object)edit.getFacesConfig());
            PropertyType propertyType = this.getProperty1(edit.getFacesConfig());
            ReadPropertyConverterTestCase.assertNotNull((Object)propertyType);
            ReadPropertyConverterTestCase.assertEquals((String)"converter-property-suggested-value", (String)propertyType.getSuggestedValue().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testDefaultValue() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadPropertyConverterTestCase.assertNotNull((Object)edit.getFacesConfig());
            PropertyType propertyType = this.getProperty1(edit.getFacesConfig());
            ReadPropertyConverterTestCase.assertNotNull((Object)propertyType);
            ReadPropertyConverterTestCase.assertEquals((String)"converter-property-default-value", (String)propertyType.getDefaultValue().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

