/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.write;

import java.util.List;
import org.eclipse.jst.jsf.facesconfig.emf.DynamicElement;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.LifecycleExtensionType;
import org.eclipse.jst.jsf.facesconfig.emf.LifecycleType;
import org.eclipse.jst.jsf.facesconfig.tests.util.CommonStructuresUtil;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.tests.write.WriteLifecycleTestCase;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class WriteLifecycleTestCase_1_2
extends WriteLifecycleTestCase {
    private static final String EXTENDED_LIFECYCLE_ID = "extended-lifecycle-id";
    private static final String LIFECYCLE_EXTENSION = CommonStructuresUtil.createPreficedString("lifecycle", "extension");
    private static final String LIFECYCLE_EXTENSION_ID = CommonStructuresUtil.createPreficedString(LIFECYCLE_EXTENSION, "id");
    private static final String LIFECYCLE_EXTENSION_TAG = CommonStructuresUtil.createPreficedString(LIFECYCLE_EXTENSION, "tag");

    public WriteLifecycleTestCase_1_2(String name) {
        super(name);
    }

    public void testLifecycleExtension() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForWrite();
            WriteLifecycleTestCase_1_2.assertNotNull((Object)edit.getFacesConfig());
            FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
            FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
            LifecycleType lifecycle = facesConfigFactory.createLifecycleType();
            lifecycle.setId(EXTENDED_LIFECYCLE_ID);
            LifecycleExtensionType extensionType = facesConfigFactory.createLifecycleExtensionType();
            extensionType.setId(LIFECYCLE_EXTENSION_ID);
            extensionType.getChildNodes().add((Object)this.createDynamicElement(LIFECYCLE_EXTENSION_TAG));
            lifecycle.getLifecycleExtension().add((Object)extensionType);
            edit.getFacesConfig().getLifecycle().add((Object)lifecycle);
            edit.save(null);
        }
        finally {
            if (edit != null) {
                edit.dispose();
                WriteLifecycleTestCase_1_2.assertTrue((boolean)edit.isDisposed());
                edit = null;
            }
        }
        try {
            edit = this.getArtifactEditForRead();
            WriteLifecycleTestCase_1_2.assertNotNull((Object)edit.getFacesConfig());
            LifecycleType lifecycle = (LifecycleType)FacesConfigModelUtil.findEObjectElementById((List)edit.getFacesConfig().getLifecycle(), EXTENDED_LIFECYCLE_ID);
            WriteLifecycleTestCase_1_2.assertNotNull((Object)lifecycle);
            WriteLifecycleTestCase_1_2.assertEquals((int)1, (int)lifecycle.getLifecycleExtension().size());
            LifecycleExtensionType extensionType = (LifecycleExtensionType)lifecycle.getLifecycleExtension().get(0);
            WriteLifecycleTestCase_1_2.assertEquals((String)LIFECYCLE_EXTENSION_ID, (String)extensionType.getId());
            WriteLifecycleTestCase_1_2.assertEquals((int)1, (int)extensionType.getChildNodes().size());
            DynamicElement element = (DynamicElement)extensionType.getChildNodes().get(0);
            WriteLifecycleTestCase_1_2.assertEquals((String)LIFECYCLE_EXTENSION_TAG, (String)element.getName());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

