/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.write;

import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.ListEntriesType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanNameType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanScopeType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedPropertyType;
import org.eclipse.jst.jsf.facesconfig.emf.MapEntriesType;
import org.eclipse.jst.jsf.facesconfig.emf.NullValueType;
import org.eclipse.jst.jsf.facesconfig.emf.ValueType;
import org.eclipse.jst.jsf.facesconfig.tests.util.CommonStructuresUtil;
import org.eclipse.jst.jsf.facesconfig.tests.write.BaseWriteTestCase;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class WriteManagedBeanTestCase
extends BaseWriteTestCase {
    protected static final String MANAGED_BEAN = "managed-bean";
    private static final String SCOPE = "scope";
    private static final String MANAGED_BEAN_NAME = CommonStructuresUtil.createPreficedString("managed-bean", "name");
    private static final String MANAGED_BEAN_SCOPE = CommonStructuresUtil.createPreficedString("managed-bean", "scope");
    private static final String MANAGED_BEAN_CLASS = CommonStructuresUtil.createPreficedString("managed-bean", "class");
    private static final String MANAGED_BEAN_PROPERTY = CommonStructuresUtil.createPreficedString("managed-bean", "property");

    public WriteManagedBeanTestCase(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForWrite();
            edit.getFacesConfig().getManagedBean().clear();
            edit.save(null);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testWriteManagedBean() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForWrite();
            WriteManagedBeanTestCase.assertNotNull((Object)edit.getFacesConfig());
            FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
            FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
            ManagedBeanType managedBean = this.createManagedBeanBase();
            ManagedPropertyType managedPropWithNullValue = CommonStructuresUtil.createManagedPropertyBase(CommonStructuresUtil.createPreficedString("null", MANAGED_BEAN_PROPERTY));
            NullValueType nullValue = facesConfigFactory.createNullValueType();
            nullValue.setId(CommonStructuresUtil.createPreficedString(CommonStructuresUtil.createPreficedString("null", MANAGED_BEAN_PROPERTY), "id"));
            managedPropWithNullValue.setNullValue(nullValue);
            managedBean.getManagedProperty().add((Object)managedPropWithNullValue);
            ManagedPropertyType managedPropWithValue = CommonStructuresUtil.createManagedPropertyBase(CommonStructuresUtil.createPreficedString("value", MANAGED_BEAN_PROPERTY));
            managedPropWithValue.setValue(CommonStructuresUtil.createValue(MANAGED_BEAN_PROPERTY));
            managedBean.getManagedProperty().add((Object)managedPropWithValue);
            ManagedPropertyType managedMapProp = CommonStructuresUtil.createManagedPropertyBase(CommonStructuresUtil.createPreficedString("map", MANAGED_BEAN_PROPERTY));
            managedMapProp.setMapEntries(CommonStructuresUtil.createMapEntries(MANAGED_BEAN_PROPERTY));
            managedBean.getManagedProperty().add((Object)managedMapProp);
            ManagedPropertyType managedListProp = CommonStructuresUtil.createManagedPropertyBase(CommonStructuresUtil.createPreficedString("list", MANAGED_BEAN_PROPERTY));
            managedListProp.setListEntries(CommonStructuresUtil.createListEntries(MANAGED_BEAN_PROPERTY));
            managedBean.getManagedProperty().add((Object)managedListProp);
            edit.getFacesConfig().getManagedBean().add((Object)managedBean);
            edit.save(null);
        }
        finally {
            if (edit != null) {
                edit.dispose();
                WriteManagedBeanTestCase.assertTrue((boolean)edit.isDisposed());
                edit = null;
            }
        }
        try {
            edit = this.getArtifactEditForRead();
            WriteManagedBeanTestCase.assertNotNull((Object)edit.getFacesConfig());
            WriteManagedBeanTestCase.assertEquals((int)1, (int)edit.getFacesConfig().getManagedBean().size());
            ManagedBeanType managedBean = (ManagedBeanType)edit.getFacesConfig().getManagedBean().get(0);
            this.assertMatchManagedBeanBase(managedBean);
            WriteManagedBeanTestCase.assertEquals((int)4, (int)managedBean.getManagedProperty().size());
            ManagedPropertyType managedPropWithNullValue = (ManagedPropertyType)managedBean.getManagedProperty().get(0);
            CommonStructuresUtil.assertMatchManagedPropertyBase(CommonStructuresUtil.createPreficedString("null", MANAGED_BEAN_PROPERTY), managedPropWithNullValue);
            NullValueType nullValue = managedPropWithNullValue.getNullValue();
            WriteManagedBeanTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(CommonStructuresUtil.createPreficedString("null", MANAGED_BEAN_PROPERTY), "id"), (String)nullValue.getId());
            ManagedPropertyType managedPropWithValue = (ManagedPropertyType)managedBean.getManagedProperty().get(1);
            CommonStructuresUtil.assertMatchManagedPropertyBase(CommonStructuresUtil.createPreficedString("value", MANAGED_BEAN_PROPERTY), managedPropWithValue);
            ValueType valueType = managedPropWithValue.getValue();
            CommonStructuresUtil.assertMatchValue(MANAGED_BEAN_PROPERTY, valueType);
            ManagedPropertyType managedMapProp = (ManagedPropertyType)managedBean.getManagedProperty().get(2);
            CommonStructuresUtil.assertMatchManagedPropertyBase(CommonStructuresUtil.createPreficedString("map", MANAGED_BEAN_PROPERTY), managedMapProp);
            CommonStructuresUtil.assertMatchMapEntries(MANAGED_BEAN_PROPERTY, managedMapProp.getMapEntries());
            ManagedPropertyType managedListProp = (ManagedPropertyType)managedBean.getManagedProperty().get(3);
            CommonStructuresUtil.assertMatchManagedPropertyBase(CommonStructuresUtil.createPreficedString("list", MANAGED_BEAN_PROPERTY), managedListProp);
            CommonStructuresUtil.assertMatchListEntries(MANAGED_BEAN_PROPERTY, managedListProp.getListEntries());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testWriteMapManagedBean() {
        ManagedBeanType managedBean;
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForWrite();
            WriteManagedBeanTestCase.assertNotNull((Object)edit.getFacesConfig());
            managedBean = this.createManagedBeanBase();
            managedBean.setMapEntries(CommonStructuresUtil.createMapEntries(MANAGED_BEAN));
            edit.getFacesConfig().getManagedBean().add((Object)managedBean);
            edit.save(null);
        }
        finally {
            if (edit != null) {
                edit.dispose();
                WriteManagedBeanTestCase.assertTrue((boolean)edit.isDisposed());
                edit = null;
            }
        }
        try {
            edit = this.getArtifactEditForRead();
            WriteManagedBeanTestCase.assertNotNull((Object)edit.getFacesConfig());
            WriteManagedBeanTestCase.assertEquals((int)1, (int)edit.getFacesConfig().getManagedBean().size());
            managedBean = (ManagedBeanType)edit.getFacesConfig().getManagedBean().get(0);
            this.assertMatchManagedBeanBase(managedBean);
            MapEntriesType mapEntries = managedBean.getMapEntries();
            CommonStructuresUtil.assertMatchMapEntries(MANAGED_BEAN, mapEntries);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testWriteListManagedBean() {
        ManagedBeanType managedBean;
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForWrite();
            WriteManagedBeanTestCase.assertNotNull((Object)edit.getFacesConfig());
            managedBean = this.createManagedBeanBase();
            managedBean.setListEntries(CommonStructuresUtil.createListEntries(MANAGED_BEAN));
            edit.getFacesConfig().getManagedBean().add((Object)managedBean);
            edit.save(null);
        }
        finally {
            if (edit != null) {
                edit.dispose();
                WriteManagedBeanTestCase.assertTrue((boolean)edit.isDisposed());
                edit = null;
            }
        }
        try {
            edit = this.getArtifactEditForRead();
            WriteManagedBeanTestCase.assertNotNull((Object)edit.getFacesConfig());
            WriteManagedBeanTestCase.assertEquals((int)1, (int)edit.getFacesConfig().getManagedBean().size());
            managedBean = (ManagedBeanType)edit.getFacesConfig().getManagedBean().get(0);
            this.assertMatchManagedBeanBase(managedBean);
            ListEntriesType mapEntries = managedBean.getListEntries();
            CommonStructuresUtil.assertMatchListEntries(MANAGED_BEAN, mapEntries);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private ManagedBeanType createManagedBeanBase() {
        FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
        FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
        ManagedBeanType managedBean = facesConfigFactory.createManagedBeanType();
        managedBean.getDescription().add((Object)CommonStructuresUtil.createDescription(MANAGED_BEAN));
        managedBean.getDisplayName().add((Object)CommonStructuresUtil.createDisplayName(MANAGED_BEAN));
        managedBean.getIcon().add((Object)CommonStructuresUtil.createIcon(MANAGED_BEAN));
        ManagedBeanNameType managedBeanNameType = facesConfigFactory.createManagedBeanNameType();
        managedBeanNameType.setTextContent(MANAGED_BEAN_NAME);
        managedBeanNameType.setId(CommonStructuresUtil.createPreficedString(MANAGED_BEAN_NAME, "id"));
        managedBean.setManagedBeanName(managedBeanNameType);
        ManagedBeanClassType managedBeanClassType = facesConfigFactory.createManagedBeanClassType();
        managedBeanClassType.setTextContent(MANAGED_BEAN_CLASS);
        managedBeanClassType.setId(CommonStructuresUtil.createPreficedString(MANAGED_BEAN_CLASS, "id"));
        managedBean.setManagedBeanClass(managedBeanClassType);
        ManagedBeanScopeType managedBeanScopeType = facesConfigFactory.createManagedBeanScopeType();
        managedBeanScopeType.setTextContent(MANAGED_BEAN_SCOPE);
        managedBeanScopeType.setId(CommonStructuresUtil.createPreficedString(MANAGED_BEAN_SCOPE, "id"));
        managedBean.setManagedBeanScope(managedBeanScopeType);
        return managedBean;
    }

    private void assertMatchManagedBeanBase(ManagedBeanType managedBean) {
        WriteManagedBeanTestCase.assertEquals((int)1, (int)managedBean.getDescription().size());
        DescriptionType description = (DescriptionType)managedBean.getDescription().get(0);
        CommonStructuresUtil.assertMatchesDescription(MANAGED_BEAN, description);
        WriteManagedBeanTestCase.assertEquals((int)1, (int)managedBean.getDisplayName().size());
        DisplayNameType displayName = (DisplayNameType)managedBean.getDisplayName().get(0);
        CommonStructuresUtil.assertMatchesDisplayName(MANAGED_BEAN, displayName);
        WriteManagedBeanTestCase.assertEquals((int)1, (int)managedBean.getIcon().size());
        IconType icon = (IconType)managedBean.getIcon().get(0);
        CommonStructuresUtil.assertMatchesIcon(MANAGED_BEAN, icon);
        ManagedBeanNameType managedBeanNameType = managedBean.getManagedBeanName();
        WriteManagedBeanTestCase.assertEquals((String)MANAGED_BEAN_NAME, (String)managedBeanNameType.getTextContent());
        WriteManagedBeanTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(MANAGED_BEAN_NAME, "id"), (String)managedBeanNameType.getId());
        ManagedBeanClassType managedBeanClassType = managedBean.getManagedBeanClass();
        WriteManagedBeanTestCase.assertEquals((String)MANAGED_BEAN_CLASS, (String)managedBeanClassType.getTextContent());
        WriteManagedBeanTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(MANAGED_BEAN_CLASS, "id"), (String)managedBeanClassType.getId());
        ManagedBeanScopeType managedBeanScopeType = managedBean.getManagedBeanScope();
        WriteManagedBeanTestCase.assertEquals((String)MANAGED_BEAN_SCOPE, (String)managedBeanScopeType.getTextContent());
        WriteManagedBeanTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(MANAGED_BEAN_SCOPE, "id"), (String)managedBeanScopeType.getId());
    }
}

