/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.predicate;

import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.internal.predicate.UniquePredicate;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class UniquePredicateTests
extends TestCase {
    private UniquePredicate<String> uniquePredicate;

    public UniquePredicateTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.uniquePredicate = PredicateTools.uniquePredicate();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testEvaluate() {
        UniquePredicateTests.assertTrue((boolean)this.uniquePredicate.evaluate((Object)"Fred"));
        UniquePredicateTests.assertTrue((boolean)this.uniquePredicate.evaluate((Object)"Wilma"));
        UniquePredicateTests.assertTrue((boolean)this.uniquePredicate.evaluate((Object)"Barney"));
        UniquePredicateTests.assertTrue((boolean)this.uniquePredicate.evaluate(null));
        UniquePredicateTests.assertFalse((boolean)this.uniquePredicate.evaluate(null));
        UniquePredicateTests.assertFalse((boolean)this.uniquePredicate.evaluate((Object)"Fred"));
        UniquePredicateTests.assertFalse((boolean)this.uniquePredicate.evaluate((Object)"Barney"));
    }

    public void testAdd() {
        UniquePredicateTests.assertTrue((boolean)this.uniquePredicate.evaluate((Object)"Fred"));
        UniquePredicateTests.assertTrue((boolean)this.uniquePredicate.add((Object)"Wilma"));
        UniquePredicateTests.assertTrue((boolean)this.uniquePredicate.add((Object)"Barney"));
        UniquePredicateTests.assertTrue((boolean)this.uniquePredicate.evaluate(null));
        UniquePredicateTests.assertFalse((boolean)this.uniquePredicate.evaluate(null));
        UniquePredicateTests.assertFalse((boolean)this.uniquePredicate.evaluate((Object)"Fred"));
        UniquePredicateTests.assertFalse((boolean)this.uniquePredicate.evaluate((Object)"Barney"));
    }

    public void testAddAll() {
        UniquePredicateTests.assertTrue((boolean)this.uniquePredicate.evaluate((Object)"Fred"));
        UniquePredicateTests.assertTrue((boolean)this.uniquePredicate.addAll(Arrays.asList("Wilma", "Barney")));
        UniquePredicateTests.assertTrue((boolean)this.uniquePredicate.evaluate(null));
        UniquePredicateTests.assertFalse((boolean)this.uniquePredicate.evaluate(null));
        UniquePredicateTests.assertFalse((boolean)this.uniquePredicate.evaluate((Object)"Fred"));
        UniquePredicateTests.assertFalse((boolean)this.uniquePredicate.evaluate((Object)"Barney"));
    }
}

