/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.widgets;

import java.util.Collection;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.ui.internal.widgets.DialogPane;
import org.eclipse.jpt.common.ui.internal.widgets.NewNameStateObject;
import org.eclipse.jpt.common.ui.internal.widgets.ValidatingDialog;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewNameDialog
extends ValidatingDialog<NewNameStateObject> {
    private String description;
    private Image descriptionImage;
    private String descriptionTitle;
    private String labelText;
    private String name;
    private Collection<String> names;

    NewNameDialog(Shell parentShell, String dialogTitle, String descriptionTitle, Image descriptionImage, String description, String labelText, String name, Collection<String> names, ResourceManager resourceManager) {
        super(parentShell, resourceManager, dialogTitle);
        this.name = name;
        this.names = names;
        this.labelText = labelText;
        this.description = description;
        this.descriptionImage = descriptionImage;
        this.descriptionTitle = descriptionTitle;
    }

    @Override
    protected DialogPane<NewNameStateObject> buildLayout(Composite container) {
        return new NewNameDialogPane(this.labelText, this.getSubjectHolder(), container, this.resourceManager);
    }

    @Override
    protected NewNameStateObject buildStateObject() {
        return new NewNameStateObject(this.name, this.names);
    }

    @Override
    public void create() {
        super.create();
        this.getPane().selectAll();
        this.getButton(0).setEnabled(false);
    }

    protected NewNameDialogPane getPane() {
        return (NewNameDialogPane)super.getPane();
    }

    @Override
    protected String getDescription() {
        return this.description;
    }

    @Override
    protected Image getDescriptionImage() {
        return this.descriptionImage;
    }

    @Override
    protected String getDescriptionTitle() {
        return this.descriptionTitle;
    }

    public String getName() {
        return ((NewNameStateObject)((Object)this.getSubject())).getName();
    }

    static class NewNameDialogPane
    extends DialogPane<NewNameStateObject> {
        private final String labelText;
        private Text text;

        NewNameDialogPane(String labelText, PropertyValueModel<NewNameStateObject> subjectModel, Composite parentComposite, ResourceManager resourceManager) {
            super(subjectModel, parentComposite, resourceManager);
            this.labelText = labelText;
        }

        @Override
        protected Composite addComposite(Composite container) {
            return this.addSubPane(container, 2, 0, 0, 0, 0);
        }

        @Override
        protected void initializeLayout(Composite container) {
            this.addLabel(container, this.labelText);
            this.text = this.addText(container, this.buildNameModel());
        }

        private ModifiablePropertyValueModel<String> buildNameModel() {
            return new PropertyAspectAdapter<NewNameStateObject, String>(this.getSubjectHolder(), new String[]{"name"}){

                protected String buildValue_() {
                    return ((NewNameStateObject)((Object)this.subject)).getName();
                }

                protected void setValue_(String value) {
                    ((NewNameStateObject)((Object)this.subject)).setName(value);
                }
            };
        }

        void selectAll() {
            this.text.selectAll();
        }
    }
}

