/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckJSDoc;
import com.google.javascript.jscomp.CheckRequiresForConstructors;
import com.google.javascript.jscomp.ClosureRewriteClass;
import com.google.javascript.jscomp.ClosureRewriteModule;
import com.google.javascript.jscomp.CombinedCompilerPass;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefaultPassConfig;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.PassConfig;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.ScopedAliases;
import com.google.javascript.jscomp.lint.CheckDuplicateCase;
import com.google.javascript.jscomp.lint.CheckEmptyStatements;
import com.google.javascript.jscomp.lint.CheckEnums;
import com.google.javascript.jscomp.lint.CheckInterfaces;
import com.google.javascript.jscomp.lint.CheckJSDocStyle;
import com.google.javascript.jscomp.lint.CheckPrototypeProperties;
import com.google.javascript.jscomp.lint.CheckRequiresAndProvidesSorted;
import com.google.javascript.jscomp.lint.CheckUselessBlocks;
import java.util.List;

class LintPassConfig
extends PassConfig.PassConfigDelegate {
    private final PassFactory checkRequiresAndProvidesSorted = new PassFactory("checkRequiresAndProvidesSorted", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CheckRequiresAndProvidesSorted(compiler);
        }
    };
    private final PassFactory closureRewriteModule = new PassFactory("closureRewriteModule", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new ClosureRewriteModule(compiler);
        }
    };
    private final PassFactory closureGoogScopeAliases = new PassFactory("closureGoogScopeAliases", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new ScopedAliases(compiler, null, LintPassConfig.this.options.getAliasTransformationHandler());
        }
    };
    private final PassFactory closureRewriteClass = new PassFactory("closureRewriteClass", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new ClosureRewriteClass(compiler);
        }
    };
    private final PassFactory jsdocChecks = new PassFactory("jsdocChecks", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CombinedCompilerPass(compiler, (List<NodeTraversal.Callback>)ImmutableList.of((Object)new CheckJSDocStyle(compiler), (Object)new CheckJSDoc(compiler)));
        }
    };
    private final PassFactory lintChecks = new PassFactory("lintChecks", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CombinedCompilerPass(compiler, (List<NodeTraversal.Callback>)ImmutableList.of((Object)new CheckDuplicateCase(compiler), (Object)new CheckEmptyStatements(compiler), (Object)new CheckEnums(compiler), (Object)new CheckInterfaces(compiler), (Object)new CheckPrototypeProperties(compiler), (Object)new CheckUselessBlocks(compiler)));
        }
    };
    private final PassFactory checkRequires = new PassFactory("checkRequires", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CheckRequiresForConstructors(compiler, CheckRequiresForConstructors.Mode.SINGLE_FILE);
        }
    };

    LintPassConfig(CompilerOptions options) {
        super(new DefaultPassConfig(options));
    }

    @Override
    protected List<PassFactory> getChecks() {
        return ImmutableList.of((Object)this.checkRequiresAndProvidesSorted, (Object)this.jsdocChecks, (Object)this.closureRewriteModule, (Object)this.closureGoogScopeAliases, (Object)this.closureRewriteClass, (Object)this.lintChecks, (Object)this.checkRequires);
    }

    @Override
    protected List<PassFactory> getOptimizations() {
        return ImmutableList.of();
    }
}

