/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IClassLoaderProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IImageDescriptorProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataLocator;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataSourceModelProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IResourceBundleProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IResourceURLProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IStandardMetaDataSourceInfo;
import org.eclipse.jst.jsf.common.metadata.internal.PluginRelativeStandardMetaDataSourceFileLocator;
import org.eclipse.jst.jsf.common.metadata.internal.StandardMetaDataFileRegistryReader;
import org.eclipse.jst.jsf.common.metadata.internal.StandardMetaDataSourceFileLocator;
import org.eclipse.jst.jsf.common.metadata.internal.StandardModelFactory;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.osgi.framework.Bundle;

public final class StandardMetaDataFileRegistry {
    private Map<String, List<IMetaDataSourceModelProvider>> mdFilesMap = new HashMap<String, List<IMetaDataSourceModelProvider>>(1);
    private List<IMetaDataSourceModelProvider> EMPTY_LIST = new ArrayList<IMetaDataSourceModelProvider>(0);
    private static StandardMetaDataFileRegistry reg;

    public static synchronized StandardMetaDataFileRegistry getInstance() {
        if (reg == null) {
            reg = new StandardMetaDataFileRegistry();
        }
        return reg;
    }

    private StandardMetaDataFileRegistry() {
        new StandardMetaDataFileRegistryReader(this).readRegistry();
    }

    public synchronized List<IMetaDataSourceModelProvider> getStandardMetaDataModelProviders(String uri) {
        List<IMetaDataSourceModelProvider> theList = this.mdFilesMap.get(uri);
        return theList != null ? theList : this.EMPTY_LIST;
    }

    public synchronized void addStandardMetaDataFileInfo(String uri, IStandardMetaDataSourceInfo fileInfo) {
        List<IMetaDataSourceModelProvider> providers = this.mdFilesMap.get(uri);
        if (providers == null) {
            providers = new ArrayList<IMetaDataSourceModelProvider>();
            this.mdFilesMap.put(uri, providers);
        }
        providers.add(new StandardMetaDataFilesProvider(fileInfo));
    }

    static class StandardMetaDataFilesProvider
    implements IMetaDataSourceModelProvider {
        private IStandardMetaDataSourceInfo info;
        private Object model;
        private IMetaDataLocator locator;
        private StandardMetaDataSourceFileLocator fileLocator = null;

        StandardMetaDataFilesProvider(IStandardMetaDataSourceInfo info) {
            this.info = info;
        }

        private StandardMetaDataSourceFileLocator getFileLocator() {
            if (this.fileLocator == null) {
                if (this.info.getLocatorClassname() == null) {
                    this.fileLocator = new PluginRelativeStandardMetaDataSourceFileLocator();
                } else {
                    Class<?> klass = JSFCommonPlugin.loadClass(this.info.getLocatorClassname(), this.info.getBundleId());
                    try {
                        this.fileLocator = (StandardMetaDataSourceFileLocator)klass.newInstance();
                    }
                    catch (InstantiationException e) {
                        JSFCommonPlugin.log(4, "InstantiationException: StandardMetaDataFilesProvider.getFileLocator()", e);
                    }
                    catch (IllegalAccessException e) {
                        JSFCommonPlugin.log(4, "IllegalAccessException: StandardMetaDataFilesProvider.getFileLocator()", e);
                    }
                }
                if (this.fileLocator != null) {
                    this.fileLocator.setFileInfo(this.info);
                }
            }
            return this.fileLocator;
        }

        private InputStream getInputStream() throws IOException {
            if (this.getFileLocator() != null) {
                return this.getFileLocator().getInputStream();
            }
            return null;
        }

        private URI getMDFileURI() {
            block3: {
                URL url;
                block4: {
                    StandardMetaDataSourceFileLocator fileLocator2 = this.getFileLocator();
                    if (fileLocator2 == null) break block3;
                    url = fileLocator2.getURL();
                    if (url != null) break block4;
                    JSFCommonPlugin.log(new RuntimeException(), "Couldn't locate meta-data file for " + fileLocator2.getFileInfo().getLocation());
                    return null;
                }
                try {
                    java.net.URI uri = url.toURI();
                    return URI.createURI((String)uri.toString());
                }
                catch (URISyntaxException e) {
                    JSFCommonPlugin.log(4, "Metadata File Load Error: " + this.getFileLocator().getFileInfo().toString() + ": URISyntaxException: " + e.getMessage());
                }
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object getSourceModel() {
            if (this.model != null) {
                return this.model;
            }
            InputStream inputStream = null;
            try {
                try {
                    EList contents;
                    URI uri = this.getMDFileURI();
                    inputStream = this.getInputStream();
                    if (inputStream == null || uri == null || (contents = StandardModelFactory.getInstance().loadStandardFileResource(inputStream, this, uri)) == null || contents.isEmpty() || !(contents.get(0) instanceof Model)) return this.model;
                    this.model = contents.get(0);
                    ((Model)this.model).setSourceModelProvider(this);
                    return this.model;
                }
                catch (FileNotFoundException e) {
                    JSFCommonPlugin.log(4, e.getLocalizedMessage());
                    if (inputStream == null) return this.model;
                    try {
                        inputStream.close();
                        return this.model;
                    }
                    catch (IOException e2) {
                        JSFCommonPlugin.log(4, "IOException (2): StandardMetaDataFilesProvider.getSourceModel():" + this.getModelName(), e2);
                    }
                    return this.model;
                }
                catch (IOException e) {
                    JSFCommonPlugin.log(4, "IOException(1): StandardMetaDataFilesProvider.getSourceModel():" + this.getModelName(), e);
                    if (inputStream == null) return this.model;
                    try {
                        inputStream.close();
                        return this.model;
                    }
                    catch (IOException e3) {
                        JSFCommonPlugin.log(4, "IOException (2): StandardMetaDataFilesProvider.getSourceModel():" + this.getModelName(), e3);
                    }
                    return this.model;
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        JSFCommonPlugin.log(4, "IOException (2): StandardMetaDataFilesProvider.getSourceModel():" + this.getModelName(), e);
                    }
                }
            }
        }

        private String getModelName() {
            return this.info.toString();
        }

        @Override
        public IMetaDataLocator getLocator() {
            return this.locator;
        }

        @Override
        public void setLocator(IMetaDataLocator locator) {
            this.locator = locator;
        }

        private ResourceBundle internalGetResourceBundle() {
            if (this.getFileLocator() != null) {
                try {
                    return this.fileLocator.getResourceBundle();
                }
                catch (MissingResourceException e) {
                    JSFCommonPlugin.log(4, "InternalGetResourceBundle1", e);
                }
                catch (IOException e) {
                    JSFCommonPlugin.log(4, "InternalGetResourceBundle2", e);
                }
            }
            return null;
        }

        public Object getAdapter(Class klass) {
            final StandardMetaDataFilesProvider mdp = this;
            if (klass == IImageDescriptorProvider.class) {
                return new IImageDescriptorProvider(){
                    String imageBase;

                    @Override
                    public ImageDescriptor getImageDescriptor(String imagePath) {
                        imagePath = this.appendImageBase(imagePath);
                        String bundleID = mdp.getFileLocator().getFileInfo().getBundleId();
                        URL url = FileLocator.find((Bundle)Platform.getBundle((String)bundleID), (IPath)new Path(imagePath), null);
                        return ImageDescriptor.createFromURL((URL)url);
                    }

                    private String appendImageBase(String imagePath) {
                        return String.valueOf(this.getImageBase()) + imagePath;
                    }

                    private String getImageBase() {
                        if (this.imageBase == null) {
                            Model aModel = (Model)this.getSourceModel();
                            Trait t = this.getImageBasePath(aModel);
                            if (t == null) {
                                this.imageBase = "";
                            } else {
                                this.imageBase = TraitValueHelper.getValueAsString(t);
                                if (this.imageBase != null && this.imageBase.length() > 0) {
                                    this.imageBase = String.valueOf(this.imageBase) + "/";
                                }
                            }
                        }
                        return this.imageBase;
                    }

                    private Trait getImageBasePath(Model aModel) {
                        for (Trait t : aModel.getTraits()) {
                            if (!t.getId().equals("images-base-path")) continue;
                            return t;
                        }
                        return null;
                    }
                };
            }
            if (klass == IResourceBundleProvider.class) {
                return new IResourceBundleProvider(){

                    @Override
                    public ResourceBundle getResourceBundle() {
                        return mdp.internalGetResourceBundle();
                    }
                };
            }
            if (klass == IClassLoaderProvider.class) {
                return new IClassLoaderProvider(){

                    @Override
                    public Class loadClass(String className) {
                        String bundleID = mdp.getFileLocator().getFileInfo().getBundleId();
                        try {
                            return Platform.getBundle((String)bundleID).loadClass(className);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            return null;
                        }
                    }
                };
            }
            if (klass == IResourceURLProvider.class) {
                return new IResourceURLProvider(){

                    @Override
                    public URL getResourceURL(String resourcePath) {
                        URL resourceURL = null;
                        String bundleID = mdp.getFileLocator().getFileInfo().getBundleId();
                        try {
                            resourceURL = FileLocator.resolve((URL)Platform.getBundle((String)bundleID).getResource(resourcePath));
                        }
                        catch (IOException iOException) {}
                        return resourceURL;
                    }
                };
            }
            return null;
        }
    }
}

