/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.model.IModelProviderEvent;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.jst.javaee.core.EjbLocalRef;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.core.Listener;
import org.eclipse.jst.javaee.core.ResourceRef;
import org.eclipse.jst.javaee.core.SecurityRole;
import org.eclipse.jst.javaee.core.SecurityRoleRef;
import org.eclipse.jst.javaee.ejb.SecurityIdentityType;
import org.eclipse.jst.javaee.web.Filter;
import org.eclipse.jst.javaee.web.FilterMapping;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.jst.jee.model.internal.WebAnnotationFactory;
import org.eclipse.jst.jee.model.internal.common.AbstractAnnotationModelProvider;
import org.eclipse.jst.jee.model.internal.common.ManyToOneRelation;
import org.eclipse.jst.jee.model.internal.common.Result;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;

public class WebAnnotationReader
extends AbstractAnnotationModelProvider<WebApp> {
    private static final String WEB_SERVLET = "WebServlet";
    private static final String WEB_SERVLET_FQ = "javax.servlet.annotation.WebServlet";
    private static final String WEB_LISTENER = "WebListener";
    private static final String WEB_LISTENER_FQ = "javax.servlet.annotation.WebListener";
    private static final String WEB_FILTER = "WebFilter";
    private static final String WEB_FILTER_FQ = "javax.servlet.annotation.WebFilter";
    private ManyToOneRelation<JavaEEObject, ICompilationUnit> modelToUnit;
    private ManyToOneRelation<JavaEEObject, ICompilationUnit> modelToInterfaceUnit;
    private WebAnnotationFactory annotationFactory;
    private WebApp ddApp;

    public WebAnnotationReader(IFacetedProject facetedProject, WebApp ddApp) {
        super(facetedProject);
        if (ddApp == null) {
            throw new IllegalArgumentException("The deployment descriptor model can not be null!");
        }
        this.ddApp = ddApp;
    }

    protected void preLoad() {
        this.modelObject = WebFactory.eINSTANCE.createWebApp();
        this.annotationFactory = WebAnnotationFactory.createFactory();
    }

    protected void loadModel() throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)this.facetedProject.getProject());
        HashSet javaUnits = new HashSet();
        IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getAllPackageFragmentRoots();
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            this.visitJavaFiles(javaUnits, root);
            ++n2;
        }
        this.annotationFactory = WebAnnotationFactory.createFactory();
        this.modelToInterfaceUnit = new ManyToOneRelation();
        this.modelToUnit = new ManyToOneRelation();
        for (ICompilationUnit unit : javaUnits) {
            Result result = this.analyzeCompilationUnit(unit);
            if (result == null) continue;
            this.processResult(unit, result);
        }
    }

    private Result analyzeCompilationUnit(ICompilationUnit unit) throws JavaModelException {
        IType rootType = unit.findPrimaryType();
        if (rootType == null || !rootType.isClass()) {
            return null;
        }
        for (Servlet servlet : this.ddApp.getServlets()) {
            if (!rootType.getFullyQualifiedName().equals(servlet.getServletClass())) continue;
            return this.annotationFactory.createServlet(rootType, servlet.getServletName());
        }
        for (Listener listener : this.ddApp.getListeners()) {
            if (!rootType.getFullyQualifiedName().equals(listener.getListenerClass())) continue;
            return this.annotationFactory.createListener(rootType);
        }
        for (Filter filter : this.ddApp.getFilters()) {
            if (!rootType.getFullyQualifiedName().equals(filter.getFilterClass())) continue;
            return this.annotationFactory.createFilter(rootType, filter.getFilterName());
        }
        if (this.facetedProject.hasProjectFacet(WebFacetUtils.WEB_FACET) && (double)Float.parseFloat(this.facetedProject.getProjectFacetVersion(WebFacetUtils.WEB_FACET).getVersionString()) > 2.5) {
            return this.createJavaeeObject(rootType);
        }
        return null;
    }

    public Result createJavaeeObject(IType type) throws JavaModelException {
        Result result = null;
        IAnnotation[] iAnnotationArray = type.getAnnotations();
        int n = iAnnotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            String annotationName = annotation.getElementName();
            if (WEB_SERVLET.equals(annotationName) || WEB_SERVLET_FQ.equals(annotationName)) {
                result = this.annotationFactory.createServlet(type, null);
                break;
            }
            if (WEB_FILTER.equals(annotationName) || WEB_FILTER_FQ.equals(annotationName)) {
                result = this.annotationFactory.createFilter(type, null);
                break;
            }
            if (WEB_LISTENER.equals(annotationName) || WEB_LISTENER_FQ.equals(annotationName)) {
                result = this.annotationFactory.createListener(type);
                break;
            }
            ++n2;
        }
        return result;
    }

    private void processResult(ICompilationUnit unit, Result result) throws JavaModelException {
        JavaEEObject mainObject = result.getMainObject();
        if (Servlet.class.isInstance(mainObject)) {
            this.servletFound(unit, (Servlet)result.getMainObject(), result.getDependedTypes());
        }
        if (Listener.class.isInstance(mainObject)) {
            this.listenerFound(unit, (Listener)result.getMainObject(), result.getDependedTypes());
        }
        if (Filter.class.isInstance(mainObject)) {
            this.filterFound(unit, (Filter)result.getMainObject(), result.getDependedTypes());
        }
        for (JavaEEObject additional : result.getAdditional()) {
            if (EjbLocalRef.class.isInstance(additional)) {
                this.ejbLocalRefFound(unit, (EjbLocalRef)additional, result.getDependedTypes());
                continue;
            }
            if (ResourceRef.class.isInstance(additional)) {
                this.resourceRefFound(unit, (ResourceRef)additional, result.getDependedTypes());
                continue;
            }
            if (SecurityRole.class.isInstance(additional)) {
                this.securityRoleFound(result.getMainObject(), (SecurityRole)additional);
                continue;
            }
            if (SecurityIdentityType.class.isInstance(additional)) {
                this.securityIdentityTypeFound(unit, (SecurityIdentityType)additional);
                continue;
            }
            if (ServletMapping.class.isInstance(additional)) {
                this.servletMappingFound(unit, (ServletMapping)additional, result.getDependedTypes());
                continue;
            }
            if (!FilterMapping.class.isInstance(additional)) continue;
            this.filterMappingFound(unit, (FilterMapping)additional, result.getDependedTypes());
        }
    }

    private void filterMappingFound(ICompilationUnit unit, FilterMapping additional, Collection<IType> dependedTypes) throws JavaModelException {
        ((WebApp)this.modelObject).getFilterMappings().add(additional);
        this.connectObjectWithFile(unit, (JavaEEObject)additional, dependedTypes);
    }

    private void servletMappingFound(ICompilationUnit unit, ServletMapping additional, Collection<IType> dependedTypes) throws JavaModelException {
        ((WebApp)this.modelObject).getServletMappings().add(additional);
        this.connectObjectWithFile(unit, (JavaEEObject)additional, dependedTypes);
    }

    private void servletFound(ICompilationUnit unit, Servlet servlet, Collection<IType> dependedTypes) throws JavaModelException {
        ((WebApp)this.modelObject).getServlets().add(servlet);
        this.connectObjectWithFile(unit, (JavaEEObject)servlet, dependedTypes);
    }

    private void listenerFound(ICompilationUnit unit, Listener listener, Collection<IType> dependedTypes) throws JavaModelException {
        ((WebApp)this.modelObject).getListeners().add(listener);
        this.connectObjectWithFile(unit, (JavaEEObject)listener, dependedTypes);
    }

    private void filterFound(ICompilationUnit unit, Filter filter, Collection<IType> dependedTypes) throws JavaModelException {
        ((WebApp)this.modelObject).getFilters().add(filter);
        this.connectObjectWithFile(unit, (JavaEEObject)filter, dependedTypes);
    }

    private void securityIdentityTypeFound(ICompilationUnit file, SecurityIdentityType additional) {
    }

    private void resourceRefFound(ICompilationUnit unit, ResourceRef resourceRef, Collection<IType> dependedTypes) throws JavaModelException {
        ((WebApp)this.modelObject).getResourceRefs().add(resourceRef);
        this.connectObjectWithFile(unit, (JavaEEObject)resourceRef, dependedTypes);
    }

    private void ejbLocalRefFound(ICompilationUnit unit, EjbLocalRef localRef, Collection<IType> dependedTypes) throws JavaModelException {
        ((WebApp)this.modelObject).getEjbLocalRefs().add(localRef);
        this.connectObjectWithFile(unit, (JavaEEObject)localRef, dependedTypes);
    }

    private void connectObjectWithFile(ICompilationUnit unit, JavaEEObject localRef, Collection<IType> dependedTypes) throws JavaModelException {
        this.modelToUnit.connect((Object)localRef, (Object)unit);
        for (IType type : dependedTypes) {
            if (type.isBinary() || !type.isInterface()) continue;
            this.modelToInterfaceUnit.connect((Object)localRef, (Object)type.getCompilationUnit());
        }
    }

    protected void processAddedCompilationUnit(IModelProviderEvent modelEvent, ICompilationUnit unit) throws CoreException {
        Result result = this.analyzeCompilationUnit(unit);
        if (result == null || result.isEmpty()) {
            return;
        }
        this.processResult(unit, result);
        modelEvent.addResource((Object)unit);
    }

    protected void processChangedCompilationUnit(IModelProviderEvent modelEvent, ICompilationUnit unit) throws CoreException {
        if (this.modelToUnit.containsTarget((Object)unit)) {
            this.processChangedModelUnit(modelEvent, unit);
        } else {
            this.processAddedCompilationUnit(modelEvent, unit);
        }
    }

    private void processChangedModelUnit(IModelProviderEvent modelEvent, ICompilationUnit unit) throws CoreException {
        this.processRemovedCompilationUnit(modelEvent, unit);
        this.processAddedCompilationUnit(modelEvent, unit);
    }

    protected void processRemovedCompilationUnit(IModelProviderEvent modelEvent, ICompilationUnit unit) throws CoreException {
        if (this.modelToUnit.containsTarget((Object)unit)) {
            this.processRemovedModelResource(modelEvent, unit);
        } else if (this.modelToInterfaceUnit.containsTarget((Object)unit)) {
            this.processRemoveInterface(modelEvent, unit);
        }
    }

    private void processRemoveInterface(IModelProviderEvent event, ICompilationUnit unit) {
    }

    protected void processRemovedPackage(IModelProviderEvent modelEvent, IJavaElementDelta delta) throws CoreException {
        Collection<ICompilationUnit> clonedCollection = this.cloneCollection(this.modelToUnit.getTargets());
        for (ICompilationUnit unit : clonedCollection) {
            if (!unit.getParent().getElementName().equals(delta.getElement().getElementName())) continue;
            this.processRemovedCompilationUnit(modelEvent, unit);
        }
    }

    private Collection<ICompilationUnit> cloneCollection(Collection<ICompilationUnit> targets) {
        ArrayList<ICompilationUnit> result = new ArrayList<ICompilationUnit>();
        for (ICompilationUnit iCompilationUnit : targets) {
            result.add(iCompilationUnit);
        }
        return result;
    }

    private void processRemovedModelResource(IModelProviderEvent event, ICompilationUnit file) {
        Collection modelObjects = this.modelToUnit.getSources((Object)file);
        for (JavaEEObject o : modelObjects) {
            if (Servlet.class.isInstance(o)) {
                this.disconnectFromRoles(o);
            }
            EcoreUtil.remove((EObject)((EObject)o));
        }
        this.modelToUnit.disconnect((Object)file);
        event.setEventCode(event.getEventCode() | 4);
        event.addResource((Object)file);
    }

    public void modify(Runnable runnable, IPath modelPath) {
    }

    public IStatus validateEdit(IPath modelPath, Object context) {
        return null;
    }

    protected Collection<SecurityRoleRef> getSecurityRoleRefs(JavaEEObject target) {
        if (Servlet.class.isInstance(target)) {
            return ((Servlet)target).getSecurityRoleRefs();
        }
        return null;
    }

    protected Collection<SecurityRole> getSecurityRoles() {
        return ((WebApp)this.modelObject).getSecurityRoles();
    }
}

