/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.wizards.gen;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.wizards.EclipseLinkSelectMappingFileDialog;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.wizards.gen.EclipseLinkDynamicTableGenPanel;
import org.eclipse.jpt.jpa.eclipselink.ui.wizards.gen.JptJpaEclipseLinkUiDynamicEntityGenMessages;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.jpt.jpa.ui.internal.jface.XmlMappingFileViewerFilter;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.DefaultTableGenerationWizardPage;
import org.eclipse.jpt.jpa.ui.wizards.entity.JptJpaUiWizardsEntityMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class EclipseLinkDynamicDefaultTableGenerationWizardPage
extends DefaultTableGenerationWizardPage {
    private Label xmlMappingFileLabel;
    private Text xmlMappingFileText;
    private Button xmlMappingFileBrowseButton;

    public EclipseLinkDynamicDefaultTableGenerationWizardPage(JpaProject jpaProject) {
        super(jpaProject);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        WorkbenchTools.setHelp((Control)composite, (String)JpaHelpContextIds.GENERATE_ENTITIES_WIZARD_CUSTOMIZE_DEFAULT_ENTITY_GENERATION);
        this.createXmlMappingFileGroup(composite);
        this.createDomainJavaClassesPropertiesGroup(composite, 4);
        this.defaultTableGenPanel = new EclipseLinkDynamicTableGenPanel(composite, 4, true, (WizardPage)this);
        this.setControl((Control)composite);
        this.setPageComplete(true);
    }

    protected void createDomainJavaClassesPropertiesGroup(Composite composite, int columns) {
        Group parent = new Group(composite, 0);
        parent.setText(JptJpaEclipseLinkUiDynamicEntityGenMessages.GENERATE_DYNAMIC_ENTITIES_WIZARD__DEFAULT_TABLE_PAGE__DOMAIN_JAVA_CLASS);
        parent.setLayout((Layout)new GridLayout(columns, false));
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = columns;
        layoutData.verticalAlignment = 4;
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = false;
        parent.setLayoutData((Object)layoutData);
        this.createPackageControls((Composite)parent, columns);
    }

    private void createXmlMappingFileGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        this.xmlMappingFileLabel = new Label(composite, 16384);
        this.xmlMappingFileLabel.setText(JptJpaEclipseLinkUiDynamicEntityGenMessages.GENERATE_DYNAMIC_ENTITIES_WIZARD__DEFAULT_TABLE_PAGE__XML_MAPPING_FILE);
        this.xmlMappingFileLabel.setLayoutData((Object)new GridData(32));
        this.xmlMappingFileText = new Text(composite, 2052);
        this.xmlMappingFileText.setLayoutData((Object)new GridData(768));
        this.xmlMappingFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EclipseLinkDynamicDefaultTableGenerationWizardPage.this.handleXmlMappingFileTextModified();
            }
        });
        this.xmlMappingFileBrowseButton = new Button(composite, 8);
        this.xmlMappingFileBrowseButton.setText(JptJpaUiWizardsEntityMessages.BROWSE_BUTTON_LABEL);
        GridData browseButtonData = new GridData(256);
        browseButtonData.horizontalSpan = 1;
        this.xmlMappingFileBrowseButton.setLayoutData((Object)browseButtonData);
        this.xmlMappingFileBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EclipseLinkDynamicDefaultTableGenerationWizardPage.this.handleXmlMappingFileButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void handleXmlMappingFileTextModified() {
        this.getCustomizer().setXmlMappingFile(this.xmlMappingFileText.getText());
    }

    private void handleXmlMappingFileButtonPressed() {
        ViewerFilter filter = this.getDialogViewerFilter(this.jpaProject);
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        EclipseLinkSelectMappingFileDialog dialog = new EclipseLinkSelectMappingFileDialog(this.getShell(), this.jpaProject.getProject(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setTitle(JptJpaUiMessages.SELECT_MAPPING_FILE_DIALOG_TITLE);
        dialog.setMessage(JptJpaUiMessages.SELECT_MAPPING_FILE_DIALOG_MESSAGE);
        dialog.addFilter(filter);
        String ormFileName = this.xmlMappingFileText.getText();
        JptXmlResource resource = this.jpaProject.getMappingFileXmlResource((IPath)new Path(ormFileName));
        IFile initialSelection = resource != null ? resource.getFile() : null;
        dialog.setInput(this.jpaProject.getProject());
        if (initialSelection != null) {
            dialog.setInitialSelection(initialSelection);
        }
        if (dialog.open() == 0) {
            String chosenName = dialog.getChosenName();
            this.xmlMappingFileText.setText(chosenName);
            this.getCustomizer().setXmlMappingFile(chosenName);
        }
    }

    protected ViewerFilter getDialogViewerFilter(JpaProject jpaProject) {
        return new XmlMappingFileViewerFilter(jpaProject, XmlEntityMappings.CONTENT_TYPE);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.xmlMappingFileText.setText(this.getCustomizer().getXmlMappingFile());
        }
    }

    protected JptXmlResource getOrmXmlResource() {
        return this.jpaProject.getMappingFileXmlResource((IPath)new Path(this.xmlMappingFileText.getText()));
    }
}

