/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.details;

import java.util.Collection;
import java.util.List;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.node.AbstractNode;
import org.eclipse.jpt.common.utility.node.Node;
import org.eclipse.jpt.jpa.eclipselink.ui.details.JptJpaEclipseLinkUiDetailsMessages;

final class EclipseLinkConversionValueStateObject
extends AbstractNode {
    private String dataValue;
    private Collection<String> dataValues;
    private String objectValue;
    private Node.Validator validator;
    static final String DATA_VALUE_PROPERTY = "dataValue";
    static final String OBJECT_VALUE_PROPERTY = "objectValue";

    EclipseLinkConversionValueStateObject(String dataValue, String objectValue, Collection<String> dataValues) {
        super(null);
        this.dataValue = dataValue;
        this.objectValue = objectValue;
        this.dataValues = dataValues;
    }

    private void addDataValueProblemsTo(List<Node.Problem> currentProblems) {
        if (StringTools.isBlank((String)this.dataValue)) {
            currentProblems.add(this.buildProblem(JptJpaEclipseLinkUiDetailsMessages.ECLIPSELINK_CONVERSION_VALUE_STATE_OBJECT_DATA_VALUE_MUST_BE_SPECIFIED, 3));
        } else if (this.dataValues.contains(this.dataValue)) {
            currentProblems.add(this.buildProblem(JptJpaEclipseLinkUiDetailsMessages.ECLIPSELINK_CONVERSION_VALUE_STATE_OBJECT_DATA_VALUE_ALREADY_EXISTS, 3));
        }
    }

    private void addObjectValueProblemsTo(List<Node.Problem> currentProblems) {
        if (StringTools.isBlank((String)this.objectValue)) {
            currentProblems.add(this.buildProblem(JptJpaEclipseLinkUiDetailsMessages.ECLIPSELINK_CONVERSION_VALUE_STATE_OBJECT_OBJECT_VALUE_MUST_BE_SPECIFIED, 3));
        }
    }

    protected void addProblemsTo(List<Node.Problem> currentProblems) {
        super.addProblemsTo(currentProblems);
        this.addDataValueProblemsTo(currentProblems);
        this.addObjectValueProblemsTo(currentProblems);
    }

    protected void checkParent(Node parentNode) {
    }

    public String displayString() {
        return null;
    }

    String getDataValue() {
        return this.dataValue;
    }

    String getObjectValue() {
        return this.objectValue;
    }

    public void setDataValue(String dataValue) {
        String oldDataValue = this.dataValue;
        this.dataValue = dataValue;
        this.firePropertyChanged(DATA_VALUE_PROPERTY, oldDataValue, dataValue);
    }

    public void setObjectValue(String objectValue) {
        String oldObjectValue = this.objectValue;
        this.objectValue = objectValue;
        this.firePropertyChanged(OBJECT_VALUE_PROPERTY, oldObjectValue, objectValue);
    }

    public void setValidator(Node.Validator validator) {
        this.validator = validator;
    }

    public Node.Validator getValidator() {
        return this.validator;
    }
}

