/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.runtime.tests.model;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.jst.jsf.common.runtime.internal.model.ViewObject;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.Decorator;
import org.eclipse.jst.jsf.common.runtime.tests.model.RuntimeTestUtil;

public class TestViewObject
extends TestCase {
    private MockAdapter _adapter1;
    private MockAdapter _adapter2;
    private MockDecorator _decorator1;
    private MockDecorator _decorator2;
    private ViewObject _viewObject1;

    protected void setUp() throws Exception {
        super.setUp();
        this._decorator1 = new MockDecorator();
        this._decorator2 = new MockDecorator();
        this._adapter1 = new MockAdapter();
        this._adapter2 = new MockAdapter();
        this._viewObject1 = new MockViewObject();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetAllDecorators() {
        List allDecorators = this._viewObject1.getAllDecorators();
        this.assertSizeAndImmutable(allDecorators, 0);
        this._viewObject1.addDecorator((Decorator)this._decorator1, Decorator.class);
        this._viewObject1.addDecorator((Decorator)this._decorator2, String.class);
        allDecorators = this._viewObject1.getAllDecorators();
        this.assertSizeAndImmutable(allDecorators, 2);
        TestViewObject.assertTrue((boolean)allDecorators.contains((Object)this._decorator1));
        TestViewObject.assertTrue((boolean)allDecorators.contains((Object)this._decorator2));
    }

    public void testGetAllAdapters() {
        Map allAdapters = this._viewObject1.getAllAdapters();
        this.assertSizeAndImmutable(allAdapters, 0);
        this._viewObject1.addAdapter(MockAdapter.class, (Object)this._adapter2);
        allAdapters = this._viewObject1.getAllAdapters();
        this.assertSizeAndImmutable(allAdapters, 1);
        TestViewObject.assertEquals((Object)this._adapter2, allAdapters.get(MockAdapter.class));
    }

    public void testGetDecorators() {
        this.assertSizeAndImmutable(this._viewObject1.getDecorators(Decorator.class), 0);
        this.assertSizeAndImmutable(this._viewObject1.getDecorators(MockDecorator.class), 0);
        this.assertSizeAndImmutable(this._viewObject1.getDecorators(String.class), 0);
        this._viewObject1.addDecorator((Decorator)this._decorator1);
        this._viewObject1.addDecorator((Decorator)this._decorator2);
        List decorators = this._viewObject1.getDecorators(((Object)((Object)this._decorator1)).getClass());
        this.assertSizeAndImmutable(decorators, 2);
        TestViewObject.assertTrue((boolean)decorators.contains((Object)this._decorator1));
        TestViewObject.assertTrue((boolean)decorators.contains((Object)this._decorator2));
        TestViewObject.assertFalse((boolean)this._viewObject1.removeDecorator((Decorator)this._decorator1, Decorator.class));
        this.assertSizeAndImmutable(decorators, 2);
        TestViewObject.assertTrue((boolean)this._viewObject1.removeDecorator((Decorator)this._decorator1, ((Object)((Object)this._decorator1)).getClass()));
        TestViewObject.assertTrue((boolean)this._viewObject1.removeDecorator((Decorator)this._decorator2, ((Object)((Object)this._decorator1)).getClass()));
        this.assertSizeAndImmutable(decorators, 0);
        this._viewObject1 = new MockViewObject();
        this._viewObject1.addDecorator((Decorator)this._decorator1, MockDecorator.class);
        this._viewObject1.addDecorator((Decorator)this._decorator2, MockDecorator.class);
        decorators = this._viewObject1.getDecorators(((Object)((Object)this._decorator1)).getClass());
        this.assertSizeAndImmutable(decorators, 2);
        TestViewObject.assertTrue((boolean)decorators.contains((Object)this._decorator1));
        TestViewObject.assertTrue((boolean)decorators.contains((Object)this._decorator2));
        TestViewObject.assertTrue((boolean)this._viewObject1.removeDecorator((Decorator)this._decorator1, ((Object)((Object)this._decorator1)).getClass()));
        TestViewObject.assertTrue((boolean)this._viewObject1.removeDecorator((Decorator)this._decorator2, ((Object)((Object)this._decorator1)).getClass()));
        this.assertSizeAndImmutable(decorators, 0);
        this._viewObject1 = new MockViewObject();
        this._viewObject1.addDecorator((Decorator)this._decorator1, Decorator.class);
        this._viewObject1.addDecorator((Decorator)this._decorator2);
        decorators = this._viewObject1.getDecorators(Decorator.class);
        this.assertSizeAndImmutable(decorators, 1);
        TestViewObject.assertTrue((boolean)decorators.contains((Object)this._decorator1));
        decorators = this._viewObject1.getDecorators(MockDecorator.class);
        this.assertSizeAndImmutable(decorators, 1);
        TestViewObject.assertTrue((boolean)decorators.contains((Object)this._decorator2));
    }

    public void testNullDecoratorArgs() {
        boolean isOk = false;
        try {
            this._viewObject1.addDecorator(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            isOk = true;
        }
        TestViewObject.assertTrue((boolean)isOk);
        TestViewObject.assertTrue((boolean)this._viewObject1.getDecorators(null).isEmpty());
        isOk = false;
        try {
            this._viewObject1.addDecorator((Decorator)this._decorator1, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            isOk = true;
        }
        TestViewObject.assertTrue((boolean)isOk);
        TestViewObject.assertTrue((boolean)this._viewObject1.getDecorators(null).isEmpty());
        isOk = false;
        try {
            this._viewObject1.removeDecorator(null, Decorator.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            isOk = true;
        }
        TestViewObject.assertTrue((boolean)isOk);
        isOk = false;
        try {
            this._viewObject1.removeDecorator((Decorator)this._decorator1, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            isOk = true;
        }
        TestViewObject.assertTrue((boolean)isOk);
    }

    public void testGetAdapter() {
        TestViewObject.assertNull((Object)this._viewObject1.getAdapter(MockAdapter.class));
        TestViewObject.assertNull((Object)this._viewObject1.getAdapter(String.class));
        TestViewObject.assertNull((Object)this._viewObject1.getAdapter(MockDecorator.class));
        this._viewObject1.addAdapter(MockAdapter.class, (Object)this._adapter1);
        TestViewObject.assertEquals((Object)this._adapter1, (Object)this._viewObject1.getAdapter(MockAdapter.class));
        this._viewObject1.addAdapter(MockAdapter.class, (Object)this._adapter2);
        TestViewObject.assertEquals((Object)this._adapter2, (Object)this._viewObject1.getAdapter(MockAdapter.class));
        this._viewObject1.addAdapter(MockDecorator.class, (Object)this._decorator1);
        TestViewObject.assertEquals((Object)((Object)this._decorator1), (Object)this._viewObject1.getAdapter(MockDecorator.class));
        TestViewObject.assertNull((Object)this._viewObject1.getAdapter(Decorator.class));
        TestViewObject.assertEquals((Object)((Object)this._decorator1), (Object)this._viewObject1.removeAdapter(MockDecorator.class));
        this._viewObject1.addAdapter(Decorator.class, (Object)this._decorator1);
        TestViewObject.assertEquals((Object)((Object)this._decorator1), (Object)this._viewObject1.getAdapter(Decorator.class));
        TestViewObject.assertNull((Object)this._viewObject1.getAdapter(MockDecorator.class));
        TestViewObject.assertEquals((Object)((Object)this._decorator1), (Object)this._viewObject1.removeAdapter(Decorator.class));
        boolean assertionOk = false;
        try {
            this._viewObject1.addAdapter(null, (Object)this._decorator1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            assertionOk = true;
        }
        TestViewObject.assertTrue((boolean)assertionOk);
        TestViewObject.assertNull((Object)this._viewObject1.getAdapter(null));
        assertionOk = false;
        try {
            this._viewObject1.addAdapter(Decorator.class, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            assertionOk = true;
        }
        TestViewObject.assertTrue((boolean)assertionOk);
        assertionOk = false;
        try {
            this._viewObject1.addAdapter(Decorator.class, (Object)this._adapter1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            assertionOk = true;
        }
        TestViewObject.assertTrue((boolean)assertionOk);
    }

    public void testDefaultAdapterBehaviour() {
        MockViewObject viewObject1 = new MockViewObject();
        MockViewObjectImplementsList listViewObject1 = new MockViewObjectImplementsList();
        ArrayList listAdapter = new ArrayList();
        TestViewObject.assertNull((Object)viewObject1.getAdapter(List.class));
        viewObject1.addAdapter(List.class, listAdapter);
        TestViewObject.assertEquals(listAdapter, (Object)viewObject1.getAdapter(List.class));
        TestViewObject.assertEquals(listAdapter, (Object)viewObject1.removeAdapter(List.class));
        TestViewObject.assertNull((Object)viewObject1.getAdapter(List.class));
        TestViewObject.assertEquals((Object)listViewObject1, (Object)listViewObject1.getAdapter(List.class));
        boolean caughtException = false;
        try {
            listViewObject1.addAdapter(List.class, listAdapter);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            caughtException = true;
        }
        TestViewObject.assertTrue((boolean)caughtException);
        TestViewObject.assertEquals((Object)listViewObject1, (Object)listViewObject1.getAdapter(List.class));
    }

    public void testGetDecoratorMap() {
        Map<?, ?> map = ((MockViewObject)this._viewObject1).getDecoratorMap();
        TestViewObject.assertNotNull(map);
        TestViewObject.assertEquals(map, ((MockViewObject)this._viewObject1).getDecoratorMap());
        TestViewObject.assertEquals(map, ((MockViewObject)this._viewObject1).getDecoratorMap());
        TestViewObject.assertEquals(map, ((MockViewObject)this._viewObject1).getDecoratorMap());
    }

    public void testGetAdapterMap() {
        Map<?, ?> map = ((MockViewObject)this._viewObject1).getAdapterMap();
        TestViewObject.assertNotNull(map);
        TestViewObject.assertEquals(map, ((MockViewObject)this._viewObject1).getAdapterMap());
        TestViewObject.assertEquals(map, ((MockViewObject)this._viewObject1).getAdapterMap());
        TestViewObject.assertEquals(map, ((MockViewObject)this._viewObject1).getAdapterMap());
    }

    public void testSerializable() throws Exception {
        this._viewObject1.addDecorator((Decorator)this._decorator1);
        this._viewObject1.addDecorator((Decorator)this._decorator2, Decorator.class);
        this._viewObject1.addAdapter(MockAdapter.class, (Object)this._adapter1);
        ViewObject deserialized = RuntimeTestUtil.serializeDeserialize(this._viewObject1);
        RuntimeTestUtil.verifySame(this._viewObject1, deserialized);
    }

    private void assertSizeAndImmutable(List list, int size) {
        TestViewObject.assertEquals((int)size, (int)list.size());
        boolean isListImmutable = false;
        try {
            list.add(new MockDecorator());
        }
        catch (Exception exception) {
            isListImmutable = true;
        }
        TestViewObject.assertTrue((boolean)isListImmutable);
        TestViewObject.assertEquals((int)size, (int)list.size());
    }

    private void assertSizeAndImmutable(Map map, int size) {
        TestViewObject.assertEquals((int)size, (int)map.size());
        boolean isMapImmutable = false;
        try {
            map.put(new Object(), new MockDecorator());
        }
        catch (Exception exception) {
            isMapImmutable = true;
        }
        TestViewObject.assertTrue((boolean)isMapImmutable);
        TestViewObject.assertEquals((int)size, (int)map.size());
    }

    public static class MockAdapter
    implements Serializable {
        private static final long serialVersionUID = 424297135847238931L;
    }

    public static class MockAdapterImplementsList
    extends AbstractList<Object> {
        @Override
        public Object get(int index) {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }
    }

    public static class MockDecorator
    extends Decorator {
        private static final long serialVersionUID = 456684865942628607L;
    }

    public static class MockViewObject
    extends ViewObject {
        private static final long serialVersionUID = 5839704536769825171L;

        public Map<?, ?> getAdapterMap() {
            return super.getAdapterMap();
        }

        public Map<?, ?> getDecoratorMap() {
            return super.getDecoratorMap();
        }
    }

    public static class MockViewObjectImplementsList
    extends ViewObject
    implements List<Object> {
        private static final long serialVersionUID = -6379202834709723049L;

        @Override
        public boolean add(Object o) {
            return false;
        }

        @Override
        public void add(int index, Object element) {
        }

        @Override
        public boolean addAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean addAll(int index, Collection<?> c) {
            return false;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return false;
        }

        @Override
        public Object get(int index) {
            return null;
        }

        @Override
        public int indexOf(Object o) {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator iterator() {
            return null;
        }

        @Override
        public int lastIndexOf(Object o) {
            return 0;
        }

        @Override
        public ListIterator listIterator() {
            return null;
        }

        @Override
        public ListIterator listIterator(int index) {
            return null;
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        @Override
        public Object remove(int index) {
            return null;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return false;
        }

        @Override
        public Object set(int index, Object element) {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public List subList(int fromIndex, int toIndex) {
            return null;
        }

        @Override
        public Object[] toArray() {
            return null;
        }

        @Override
        public Object[] toArray(Object[] a) {
            return null;
        }
    }
}

