/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.validation;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.WorkbenchContext;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xsl.ui.internal.validation.DelegatingSourceValidatorForXSL;
import org.eclipse.wst.xsl.ui.tests.AbstractXSLUITest;
import org.junit.Assert;
import org.junit.Test;

public class TestDelegatingSourceValidatorForXSL
extends AbstractXSLUITest {
    DelegatingSourceValidatorForXSL sourceValidator = new DelegatingSourceValidatorForXSL();

    private String getxslTestFilesProjectName() {
        return "xsltestfiles";
    }

    @Test
    public void testXSLT2XPathPasses() throws Exception {
        String fileName1 = "ChangeRequestsByResponsibility.xsl";
        WorkbenchContext context = this.setupFile(this.getxslTestFilesProjectName(), fileName1);
        TestReporter reporter = new TestReporter();
        this.sourceValidator.validate((IValidationContext)context, (IReporter)reporter);
        Assert.assertFalse((String)"Messages were reported on file with valid XPath 2.0", (boolean)reporter.isMessageReported());
    }

    @Test
    public void testXSLT2_2Passes() throws Exception {
        String fileName1 = "ChangeRequestsByStatus.xsl";
        WorkbenchContext context = this.setupFile(this.getxslTestFilesProjectName(), fileName1);
        TestReporter reporter = new TestReporter();
        this.sourceValidator.validate((IValidationContext)context, (IReporter)reporter);
        Assert.assertFalse((String)"Messages were reported on file with valid XSLT 2.0", (boolean)reporter.isMessageReported());
    }

    @Test
    public void testValidXSLT() throws Exception {
        String fileName1 = "ListAllChangeRequests.xsl";
        WorkbenchContext context = this.setupFile(this.getxslTestFilesProjectName(), fileName1);
        TestReporter reporter = new TestReporter();
        this.sourceValidator.validate((IValidationContext)context, (IReporter)reporter);
        Assert.assertFalse((String)("Messages were reported on " + fileName1 + "."), (boolean)reporter.isMessageReported());
    }

    @Test
    public void testXSLFunctionsWithParms() throws Exception {
        String fileName = "bug290286.xsl";
        WorkbenchContext context = this.setupFile(this.getxslTestFilesProjectName(), fileName);
        TestReporter reporter = new TestReporter();
        this.sourceValidator.validate((IValidationContext)context, (IReporter)reporter);
        Assert.assertFalse((String)("Errors reported with XSLT 2.0 with Functions: " + fileName + "."), (boolean)reporter.isMessageReported());
    }

    @Test
    public void testXSL20Transform() throws Exception {
        String fileName = "XSLT20Transform.xsl";
        WorkbenchContext context = this.setupFile(this.getxslTestFilesProjectName(), fileName);
        TestReporter reporter = new TestReporter();
        this.sourceValidator.validate((IValidationContext)context, (IReporter)reporter);
        Assert.assertFalse((String)("Errors reported with XSLT 2.0 with Transform statement: " + fileName + "."), (boolean)reporter.isMessageReported());
    }

    @Test
    public void testDelegatingSourceValidatorNPEwithNoAttributeValue() throws Exception {
        WorkbenchContext context = this.setupFile(this.getxslTestFilesProjectName(), "bug272760.xsl");
        TestReporter reporter = new TestReporter();
        try {
            this.sourceValidator.validate((IValidationContext)context, (IReporter)reporter);
        }
        catch (ValidationException validationException) {
        }
        catch (NullPointerException e) {
            StringWriter out = new StringWriter();
            e.printStackTrace(new PrintWriter(out));
            Assert.fail((String)out.toString());
        }
    }

    protected WorkbenchContext setupFile(String projName, String fileName1) {
        String validateFilePath = String.valueOf(projName) + File.separator + fileName1;
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(validateFilePath));
        if (file != null && !file.exists()) {
            Assert.fail((String)("Unable to locate " + fileName1 + " stylesheet."));
        }
        WorkbenchContext context = new WorkbenchContext();
        ArrayList<String> fileList = new ArrayList<String>();
        fileList.add(String.valueOf(File.separator) + validateFilePath);
        context.setValidationFileURIs(fileList);
        return context;
    }

    private class TestReporter
    implements IReporter {
        protected boolean messageReported = false;

        public void addMessage(IValidator origin, IMessage message) {
            if (message.getSeverity() == 1) {
                this.messageReported = true;
            }
        }

        public boolean isMessageReported() {
            return this.messageReported;
        }

        public void displaySubtask(IValidator validator, IMessage message) {
        }

        public List getMessages() {
            return null;
        }

        public boolean isCancelled() {
            return false;
        }

        public void removeAllMessages(IValidator origin, Object object) {
        }

        public void removeAllMessages(IValidator origin) {
        }

        public void removeMessageSubset(IValidator validator, Object obj, String groupName) {
        }
    }
}

